/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import mpi.annex.data.ShoeboxTiers;
import mpi.annex.data.TierType;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoeboxRecord {
    private static Logger _logger = Logger.getLogger(ShoeboxRecord.class.getName());
    private Hashtable<String, Vector<String>> record = new Hashtable();
    private ShoeboxTiers tiers;
    private boolean knownTiers;
    private long startTime;
    private long endTime;
    private String recordInfo;
    private String lastTag;
    private boolean lineBreaksCleaned;
    private int longestAlignedTier;
    private boolean virtualTime;

    public ShoeboxRecord(String line, ShoeboxTiers tiers, boolean knownTiers) {
        this.recordInfo = ShoeboxRecord.getTierContent(line);
        this.knownTiers = knownTiers;
        if (tiers == null) {
            tiers = new ShoeboxTiers();
            knownTiers = false;
            _logger.warn("Warning: tiers were null");
        }
        this.tiers = tiers;
        this.startTime = -1L;
        this.endTime = -1L;
        this.virtualTime = false;
        this.lastTag = null;
        this.lineBreaksCleaned = false;
        this.longestAlignedTier = -1;
        Vector<String> refLabel = new Vector<String>();
        refLabel.add(this.recordInfo);
        this.record.put("ref", refLabel);
        tiers.put("ref", TierType.REF);
    }

    public void put(String line) {
        Vector<String> lines;
        String tag;
        if (this.knownTiers && this.tiers.getType(ShoeboxRecord.getTierTag(line)) == TierType.TIME && !this.parseTime(ShoeboxRecord.getTierTag(line), ShoeboxRecord.getTierContent(line))) {
            _logger.warn("Warning: illegal time in: " + line);
        }
        if ((tag = ShoeboxRecord.getTierTag(line)) == null) {
            tag = this.lastTag;
        }
        this.lastTag = tag;
        if (tag == null) {
            if (line.trim().length() > 0) {
                _logger.warn("Warning: no tag in line " + line);
            }
            return;
        }
        if (this.knownTiers && this.tiers.getType(tag) == null) {
            _logger.warn("Warning: ignoring unspecified tag: " + tag);
        }
        if (!this.knownTiers && this.parseTime(tag, ShoeboxRecord.getTierContent(line))) {
            this.tiers.put(tag, TierType.TIME);
        }
        if ((lines = this.record.get(tag)) == null) {
            lines = new Vector();
            this.record.put(tag, lines);
        }
        lines.add(ShoeboxRecord.getTierContent(line));
        if (!this.knownTiers && this.tiers.getType(tag) != TierType.TIME || this.tiers.getType(tag) == TierType.UNKNOWN) {
            if (ShoeboxRecord.isProbablyAligned(tag, ShoeboxRecord.getTierContent(line))) {
                this.tiers.put(tag, TierType.ALIGNED);
            } else {
                this.tiers.put(tag, TierType.BLOCK);
            }
        }
    }

    public void provideAlternativeTime(ShoeboxRecord successor, int virtualIndex) {
        if (this.startTime == -1L || this.endTime == -1L) {
            this.virtualTime = true;
        }
        if (this.startTime == -1L) {
            this.startTime = (long)virtualIndex * 10000L;
        }
        if (this.endTime == -1L && successor != null) {
            this.endTime = successor.startTime;
        }
        if (this.endTime == -1L) {
            this.endTime = (long)(virtualIndex + 1) * 10000L;
        }
    }

    private void cleanLineBreaks() {
        this.longestAlignedTier = 0;
        boolean more = true;
        int i = 0;
        while (more) {
            more = false;
            this.findNewLongestAlignedTier();
            for (String tag : this.tags()) {
                Vector<String> lines = this.record.get(tag);
                if (lines == null) continue;
                if (lines.size() > 1) {
                    if (TierType.ALIGNED.equals((Object)this.tiers.getType(tag))) {
                        while (lines.elementAt(0).length() < this.longestAlignedTier + 1) {
                            lines.set(0, lines.elementAt(0) + " ");
                        }
                    }
                    lines.set(0, lines.elementAt(0) + lines.elementAt(1));
                    lines.remove(1);
                }
                if (lines.size() <= 1) continue;
                more = true;
            }
            ++i;
        }
        this.findNewLongestAlignedTier();
        this.lineBreaksCleaned = true;
    }

    private void findNewLongestAlignedTier() {
        for (String tag : this.tags()) {
            if (!TierType.ALIGNED.equals((Object)this.getTierType(tag)) || this.record.get(tag) == null || this.record.get(tag).firstElement().length() <= this.longestAlignedTier) continue;
            this.longestAlignedTier = this.record.get(tag).firstElement().length();
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Collection<String> tags() {
        return this.tiers.names(true);
    }

    public ShoeboxTiers tiers() {
        return this.tiers;
    }

    public String getContent(String tag) {
        if (!this.lineBreaksCleaned) {
            this.cleanLineBreaks();
        }
        if (this.record.get(tag) == null) {
            return null;
        }
        return this.record.get(tag).firstElement();
    }

    public TierType getTierType(String tag) {
        return this.tiers.getType(tag);
    }

    public int getLongestAlignedTier() {
        if (!this.lineBreaksCleaned) {
            this.cleanLineBreaks();
        }
        return this.longestAlignedTier;
    }

    public String toString() {
        return this.record.toString() + this.tiers.toString();
    }

    private boolean parseTime(String tag, String content) {
        if (content == null) {
            return false;
        }
        long time = ShoeboxRecord.parseTimeString(content);
        if (!(time == -1L || tag != null && tag.startsWith("E"))) {
            this.startTime = time;
        } else if ("EUDICOt0".equals(tag) || "ELANBegin".equals(tag)) {
            this.startTime = time;
        } else if ("EUDICOt1".equals(tag) || "ELANEnd".equals(tag)) {
            this.endTime = time;
        } else {
            if ("EUDICOp".equals(tag) || "ELANParticipant".equals(tag) || tag != null && tag.startsWith("ELANMedia")) {
                return false;
            }
            if (time != -1L) {
                this.startTime = time;
            }
        }
        return time != -1L;
    }

    public static long parseTimeString(String time) {
        try {
            double d = Double.parseDouble(time);
            return (long)(d * 1000.0);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static String getTierTag(String line) {
        if (!line.startsWith("\\")) {
            return null;
        }
        if (line.indexOf(" ") == -1) {
            return line.substring(1).trim();
        }
        return line.substring(1, line.indexOf(" "));
    }

    public static String getTierContent(String line) {
        if (line.endsWith("\r")) {
            line = line.substring(0, line.length() - 1);
        }
        if (!line.startsWith("\\")) {
            return line;
        }
        if (line.indexOf(" ") == -1) {
            return "";
        }
        return line.substring(line.indexOf(" ") + 1, line.length());
    }

    private static boolean isProbablyAligned(String tag, String content) {
        return content.trim().indexOf("  ") != -1;
    }
}

