/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.util.Collection;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import mpi.annex.data.TierType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoeboxTiers {
    private Hashtable<String, Tier> byName;
    private TreeSet<Tier> byOrder = new TreeSet();
    private int count = 0;

    public ShoeboxTiers() {
        this.byName = new Hashtable();
    }

    public void put(String name, TierType type, String encoding) {
        Tier tier = this.byName.get(name);
        if (tier == null) {
            tier = new Tier(name, this.count++, type, encoding);
            this.byOrder.add(tier);
            this.byName.put(name, tier);
        } else {
            tier.type = type;
            tier.encoding = encoding;
        }
    }

    public void put(String name, TierType type) {
        this.put(name, type, "ISO-8859-1");
    }

    public TierType getType(String name) {
        if (this.byName.get(name) == null) {
            return null;
        }
        return this.byName.get((Object)name).type;
    }

    public String getEncoding(String name) {
        if (this.byName.get(name) == null) {
            return null;
        }
        return this.byName.get((Object)name).encoding;
    }

    public Collection<String> names(boolean includeTime) {
        Vector<String> result = new Vector<String>();
        for (Tier next : this.byOrder) {
            if (!includeTime && next.type == TierType.TIME) continue;
            result.add(next.name);
        }
        return result;
    }

    public String getParent(String name) {
        if (this.byName.get(name) == null) {
            return null;
        }
        return this.byName.get((Object)name).parent;
    }

    public void setParent(String child, String parent) {
        if (this.byName.get(child) == null) {
            throw new IllegalArgumentException("unknown tier name: " + child);
        }
        this.byName.get((Object)child).parent = parent;
    }

    public Hashtable<String, String> getEncodingHash() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        for (String name : this.names(true)) {
            result.put(name, this.byName.get((Object)name).encoding);
        }
        return result;
    }

    public int size() {
        return this.byName.size();
    }

    public String toString() {
        return this.byOrder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Tier
    implements Comparable<Tier> {
        public String name;
        public int order;
        public TierType type;
        public String encoding;
        public String parent;

        public Tier(String name, int order, TierType type, String encoding) {
            this.name = name;
            this.order = order;
            this.type = type;
            this.encoding = encoding;
            this.parent = "ref".equals(name) ? null : "ref";
        }

        @Override
        public int compareTo(Tier t) {
            if (this.order < t.order) {
                return -1;
            }
            if (this.order > t.order) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof Tier && this.order == ((Tier)o).order;
        }

        public String toString() {
            return this.name + "/" + (Object)((Object)this.type);
        }
    }
}

