/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.util.UnicodeNormalizer;
import org.apache.log4j.Logger;

public class SearchHSQLDB
implements Runnable {
    private static Logger _logger = Logger.getLogger(SearchHSQLDB.class.getName());
    private String schemaName;
    private SearchHSQLDB cloneIngester;
    private ArrayList eafFiles;
    private ArrayList problemFiles = new ArrayList();
    private ArrayList tierNames;
    private ArrayList tierTypes;
    private ArrayList participants;
    private float domainInitializationProgress;

    public SearchHSQLDB(String dbSchemaName) {
        this.schemaName = dbSchemaName;
    }

    public long ingestCounting(AnnexTranscription transcription, Connection con) {
        return this.ingest((AnnexTranscription)transcription, (Connection)con).nAnnotations;
    }

    private FileStats ingest(AnnexTranscription transcription, Connection con) {
        FileStats stats = new FileStats();
        Statement st = null;
        try {
            st = con.createStatement();
            st.executeUpdate("DELETE FROM " + this.schemaName + ".tiers");
            st.executeUpdate("DELETE FROM " + this.schemaName + ".annotations");
            HashMap<Serializable, Integer> ids = new HashMap<Serializable, Integer>();
            int nTiers = transcription.getTiers().size();
            int tierId = 0;
            int annotationId = 0;
            stats.nTiers = nTiers;
            for (int i = 0; i < nTiers; ++i) {
                AnnexTier tier = (AnnexTier)transcription.getTiers().get(i);
                ids.put(tier, new Integer(tierId++));
                int nAnnotations = tier.annotations.size();
                stats.nAnnotations += (long)nAnnotations;
                for (int j = 0; j < nAnnotations; ++j) {
                    AnnexAnnotation annotation = (AnnexAnnotation)tier.annotations.get(j);
                    ids.put(annotation, new Integer(annotationId++));
                    stats.annotationsSize += (long)annotation.value.length();
                }
            }
            PreparedStatement stAnnotation = con.prepareStatement("INSERT INTO " + this.schemaName + ".annotations VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
            PreparedStatement stTier = con.prepareStatement("INSERT INTO " + this.schemaName + ".tiers VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)");
            tierId = 0;
            annotationId = 0;
            for (int i = 0; i < nTiers; ++i) {
                AnnexTier tier = (AnnexTier)transcription.getTiers().get(i);
                int ref_tier_id = -1;
                if (tier.parentTier != null) {
                    ref_tier_id = (Integer)ids.get(tier.parentTier);
                }
                int nAnnotations = tier.annotations.size();
                stTier.setInt(1, tierId);
                stTier.setString(2, tier.name);
                stTier.setString(3, tier.type);
                stTier.setString(4, tier.defaultLocale);
                stTier.setString(5, tier.participant);
                stTier.setInt(6, nAnnotations);
                stTier.setInt(7, ref_tier_id);
                stTier.setInt(8, transcription.getType());
                stTier.setString(9, transcription.getNodeId());
                stTier.executeUpdate();
                for (int j = 0; j < nAnnotations; ++j) {
                    String normalized;
                    String denormal;
                    AnnexAnnotation annotation = (AnnexAnnotation)tier.annotations.get(j);
                    int ref_ann_id = -1;
                    if (annotation.refAnnotation != null) {
                        ref_ann_id = (Integer)ids.get(annotation.refAnnotation);
                    }
                    if (annotation.value.length() > 2600) {
                        _logger.warn("Info: there is an annotation longer than 2600 characters in a file");
                        annotation.value = annotation.value.substring(0, 2600) + "...";
                    }
                    if (annotation.value.indexOf(0) != -1) {
                        _logger.warn("Info: there is an annotation which contains NUL chars in a file");
                        annotation.value = annotation.value.replaceAll("\\000", "*");
                    }
                    if ((denormal = UnicodeNormalizer.checkNFC(normalized = UnicodeNormalizer.normalizeToNFC(annotation.value))) != null || !normalized.equals(annotation.value)) {
                        if (denormal != null) {
                            _logger.warn("Annotation cannot be normalized to NFC: " + denormal);
                        }
                        annotation.value = normalized;
                    }
                    stAnnotation.setInt(1, annotationId++);
                    stAnnotation.setString(2, annotation.value);
                    stAnnotation.setInt(3, j);
                    stAnnotation.setLong(4, annotation.beginTime);
                    stAnnotation.setLong(5, annotation.endTime);
                    stAnnotation.setInt(6, ref_ann_id);
                    stAnnotation.setBoolean(7, annotation.isTimeAligned);
                    stAnnotation.setInt(8, tierId);
                    stAnnotation.executeUpdate();
                }
                ++tierId;
            }
        }
        catch (SQLException e) {
            _logger.error("SQLException in ingest: " + e, e);
        }
        catch (RuntimeException re) {
            _logger.error("RuntimeException in ingest: " + re, re);
        }
        return stats;
    }

    public void setDomain(ArrayList eafFiles) {
        this.eafFiles = (ArrayList)eafFiles.clone();
        this.problemFiles.clear();
        this.domainInitializationProgress = 0.0f;
        new Thread(this).start();
    }

    public void setDomain(SearchHSQLDB otherIngester) {
        this.problemFiles.clear();
        this.cloneIngester = otherIngester;
        this.domainInitializationProgress = 0.0f;
        new Thread(this).start();
    }

    public float getDomainInitializationProgress() {
        return this.domainInitializationProgress;
    }

    public ArrayList getDomain() {
        return this.eafFiles;
    }

    public ArrayList getProblemFiles() {
        return this.problemFiles;
    }

    public ArrayList getTierNames() {
        return this.tierNames;
    }

    public ArrayList getTierTypes() {
        return this.tierTypes;
    }

    public ArrayList getParticipants() {
        return this.participants;
    }

    public void run() {
        if (this.cloneIngester != null) {
            while (this.cloneIngester.getDomainInitializationProgress() < 1.0f) {
                try {
                    this.domainInitializationProgress = this.cloneIngester.getDomainInitializationProgress() - 0.01f;
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {}
            }
            this.eafFiles = (ArrayList)this.cloneIngester.getDomain().clone();
            this.tierNames = (ArrayList)this.cloneIngester.getTierNames().clone();
            this.tierTypes = (ArrayList)this.cloneIngester.getTierTypes().clone();
            this.participants = (ArrayList)this.cloneIngester.getParticipants().clone();
            this.domainInitializationProgress = 1.0f;
            this.cloneIngester = null;
        } else {
            int i;
            AnnexTranscription transcription = null;
            TreeSet<String> tierNamesSet = new TreeSet<String>();
            TreeSet<String> tierTypesSet = new TreeSet<String>();
            TreeSet<String> participantsSet = new TreeSet<String>();
            this.problemFiles = new ArrayList();
            for (i = 0; i < this.eafFiles.size(); ++i) {
                File file = (File)this.eafFiles.get(i);
                if (file.exists()) {
                    transcription = new AnnexTranscription(file.getName(), 0, file);
                    if (transcription.isValid()) {
                        ArrayList tiers = transcription.getTiers();
                        for (int j = 0; j < tiers.size(); ++j) {
                            AnnexTier tier = (AnnexTier)tiers.get(j);
                            if (tier.name != null && tier.name.trim().length() > 0) {
                                tierNamesSet.add(tier.name);
                            }
                            if (tier.type != null && tier.type.trim().length() > 0) {
                                tierTypesSet.add(tier.type);
                            }
                            if (tier.participant == null || tier.participant.trim().length() <= 0) continue;
                            participantsSet.add(tier.participant);
                        }
                    } else {
                        this.problemFiles.add(this.eafFiles.get(i));
                    }
                }
                this.domainInitializationProgress = (float)((double)this.domainInitializationProgress + 1.0 / (double)(this.eafFiles.size() + 1));
            }
            this.tierNames = new ArrayList(tierNamesSet);
            this.tierTypes = new ArrayList(tierTypesSet);
            this.participants = new ArrayList(participantsSet);
            if (this.problemFiles.size() > 0) {
                for (i = 0; i < this.problemFiles.size(); ++i) {
                    this.eafFiles.remove(this.problemFiles.get(i));
                }
            }
            this.domainInitializationProgress = 1.0f;
        }
    }

    private class FileStats {
        public int nTiers;
        public long nAnnotations;
        public long annotationsSize;

        private FileStats() {
        }
    }
}

