/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mpi.annex.search.Constants;
import mpi.annex.search.FrequencyInfo;
import mpi.annex.search.SearchLayer;
import mpi.annex.search.SearchStatistics;
import mpi.annex.util.UnicodeNormalizer;
import org.apache.log4j.Logger;

public abstract class SearchQuery {
    private static Logger _logger = Logger.getLogger("ANNEX.SearchQuery");
    protected String schemaName;
    protected HashMap frequencyMap;
    protected TreeSet frequencyInfoTree;
    protected ArrayList orderedFrequencyInfo;
    protected SearchStatistics statistics = new SearchStatistics();
    protected boolean patternNeedsFullStatistics;
    protected int firstNonEmptyLayerIndex;
    protected int firstNonEmptyPatternIndex;
    protected boolean isSimpleQuery;
    protected boolean isMultipleLayerQuery;
    protected boolean isExecuting;
    protected boolean keepExecuting;
    protected int nGramSizeLeftFromHit;
    protected int nGramSizeRightFromHit;
    protected int nLayers;
    protected int nPatternsPerLayer;
    protected SearchLayer[] searchLayers;
    private String globalHitSync = "SYNC";
    protected int[][] globalHitAnnId;
    protected int[][] globalHitTierId;
    protected int[][] globalHitPosition;
    protected long[][] globalHitBeginTime;
    protected long[][] globalHitEndTime;
    protected int globalHitFileId;
    private PreparedStatement prepStatComplexHitResultData;
    private PreparedStatement prepStatCheckValidDuration;
    private long minimalDuration;
    private long maximalDuration;
    private long beginAfter;
    private long endBefore;
    protected String currentNodeId;
    protected String currentTranscriptionTierDomain;
    protected String fullTranscriptionTierDomain;
    protected boolean thereIsALayerWithAnEmptyTierDomain;

    public SearchQuery() {
        this.frequencyMap = new HashMap();
    }

    public long getValue(ResultSet rs, int column) throws SQLException {
        if (rs.getMetaData().getColumnType(column) == -5) {
            return rs.getLong(column);
        }
        return rs.getInt(column);
    }

    public ArrayList getSearchModes() {
        int i;
        ArrayList<String> modes = new ArrayList<String>();
        modes.add(Integer.toString(Constants.targetModes.length));
        for (i = 0; i < Constants.targetModes.length; ++i) {
            modes.add(Constants.targetModes[i]);
        }
        modes.add(Integer.toString(Constants.caseModes.length));
        for (i = 0; i < Constants.caseModes.length; ++i) {
            modes.add(Constants.caseModes[i]);
        }
        modes.add(Integer.toString(Constants.matchModes.length));
        for (i = 0; i < Constants.matchModes.length; ++i) {
            modes.add(Constants.matchModes[i]);
        }
        return modes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLayers(String encodedQuery) {
        String[] queryParts = encodedQuery.split("xxxSAFE_SPLITTERxxx");
        this.firstNonEmptyLayerIndex = -1;
        this.firstNonEmptyPatternIndex = -1;
        int nPatterns = 0;
        String[] header = queryParts[0].split(",");
        this.minimalDuration = Long.parseLong(header[0].trim());
        this.maximalDuration = Long.parseLong(header[1].trim());
        this.beginAfter = Long.parseLong(header[2].trim());
        this.endBefore = Long.parseLong(header[3].trim());
        String string = this.globalHitSync;
        synchronized (string) {
            this.nLayers = Integer.parseInt(header[4].trim());
            this.nPatternsPerLayer = Integer.parseInt(header[5].trim());
            this.globalHitAnnId = new int[this.nLayers][this.nPatternsPerLayer];
            this.globalHitTierId = new int[this.nLayers][this.nPatternsPerLayer];
            this.globalHitPosition = new int[this.nLayers][this.nPatternsPerLayer];
            this.globalHitBeginTime = new long[this.nLayers][this.nPatternsPerLayer];
            this.globalHitEndTime = new long[this.nLayers][this.nPatternsPerLayer];
        }
        this.searchLayers = new SearchLayer[this.nLayers];
        int partIndex = 1;
        for (int i = 0; i < this.nLayers; ++i) {
            this.searchLayers[i] = new SearchLayer();
            for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                String pattern;
                if ((pattern = queryParts[partIndex++]).length() > 0) {
                    ++nPatterns;
                }
                String mode = queryParts[partIndex++];
                String innerConstraint = queryParts[partIndex++];
                String outerConstraint = queryParts[partIndex++];
                String normalized = UnicodeNormalizer.normalizeToNFC(pattern);
                String denormalized = UnicodeNormalizer.checkNFC(normalized);
                if (denormalized != null || !normalized.equals(pattern)) {
                    if (denormalized != null) {
                        _logger.warn("Could not normalize query pattern: " + denormalized);
                    }
                    pattern = normalized;
                }
                this.searchLayers[i].addPattern(pattern, mode, innerConstraint, outerConstraint);
                if (this.firstNonEmptyPatternIndex >= 0 || pattern.length() <= 0) continue;
                this.firstNonEmptyLayerIndex = i;
                this.firstNonEmptyPatternIndex = j;
            }
            int nTiers = Integer.parseInt(header[i + 6].trim());
            for (int j = 0; j < nTiers; ++j) {
                this.searchLayers[i].addTierConstraint(queryParts[partIndex++]);
            }
        }
        this.isSimpleQuery = nPatterns <= 1;
        int nNonEmptyLayers = 0;
        for (int i = 0; i < this.nLayers; ++i) {
            if (this.searchLayers[i].isEmpty()) continue;
            ++nNonEmptyLayers;
        }
        this.isMultipleLayerQuery = nNonEmptyLayers > 1;
        this.prepStatComplexHitResultData = null;
        this.prepStatCheckValidDuration = null;
    }

    private void displayLayerInfo() {
        _logger.debug("nLayers: " + this.nLayers);
        for (int i = 0; i < this.nLayers; ++i) {
            _logger.debug("\nLayer " + i);
            _logger.debug(this.searchLayers[i].display().trim());
        }
    }

    public boolean isRunning() {
        return this.isExecuting;
    }

    public SearchStatistics getSearchStatistics() {
        this.statistics.nFrequencyInfoItems = this.frequencyMap.size();
        return this.statistics;
    }

    protected void clearFrequencyStatistics() {
        this.frequencyMap.clear();
        this.frequencyInfoTree = null;
        this.orderedFrequencyInfo = null;
    }

    protected void updateFrequencyStatistics(String annotation, int annId, int fileIndex, int layerIndex, int patternIndex) {
        FrequencyInfo info = (FrequencyInfo)this.frequencyMap.get(annotation);
        if (info != null) {
            ++info.numberOfHits;
        } else if (this.frequencyMap.size() < 100000) {
            info = new FrequencyInfo();
            info.annId = annId;
            info.fileIndex = fileIndex;
            info.layerIndex = layerIndex;
            info.patternIndex = patternIndex;
            info.numberOfHits = 1;
            this.frequencyMap.put(annotation, info);
        }
    }

    public ArrayList getFrequencyInfo(int from, int to) {
        ArrayList<FrequencyInfo> info = new ArrayList<FrequencyInfo>();
        if (this.frequencyMap.size() >= 100000) {
            FrequencyInfo freqInfo = new FrequencyInfo();
            freqInfo.annotation = "No frequency statistics available, there were more than 100000 different hit patterns";
            freqInfo.numberOfHits = -1;
            info.add(freqInfo);
        } else {
            if (this.orderedFrequencyInfo == null) {
                this.frequencyInfoTree = new TreeSet(new FreqInfoComparator());
                for (String annotation : this.frequencyMap.keySet()) {
                    FrequencyInfo freqInfo = (FrequencyInfo)this.frequencyMap.get(annotation);
                    freqInfo.annotation = annotation;
                    this.frequencyInfoTree.add(freqInfo);
                }
                this.orderedFrequencyInfo = new ArrayList();
                Iterator<Object> iter = this.frequencyInfoTree.iterator();
                while (iter.hasNext()) {
                    this.orderedFrequencyInfo.add(0, iter.next());
                }
            }
            for (int i = from; i < to; ++i) {
                if (i >= this.orderedFrequencyInfo.size()) continue;
                FrequencyInfo freqInfo = (FrequencyInfo)this.orderedFrequencyInfo.get(i);
                freqInfo.nOccurences = this.frequencyMap.size();
                if (freqInfo.hitPositionInAnnotation == 0 && freqInfo.hitLength == 0) {
                    String[] queryModes = this.searchLayers[freqInfo.layerIndex].getMode(freqInfo.patternIndex);
                    String pattern = this.searchLayers[freqInfo.layerIndex].getPattern(freqInfo.patternIndex);
                    boolean patternNOTMode = this.searchLayers[freqInfo.layerIndex].getPatternNOTMode(freqInfo.patternIndex);
                    Pattern regExpPattern = this.searchLayers[freqInfo.layerIndex].getRegExpPattern(freqInfo.patternIndex);
                    if (queryModes[0].equals(" Annotation") && this.isSimpleQuery) {
                        freqInfo.hitPositionInAnnotation = this.getHitPosition(freqInfo.annotation, 1, queryModes, pattern, regExpPattern, patternNOTMode);
                        freqInfo.hitLength = this.getHitLength(freqInfo.annotation, 1, queryModes, pattern, regExpPattern, patternNOTMode);
                    } else {
                        freqInfo.hitPositionInAnnotation = 0;
                        freqInfo.hitLength = 0;
                    }
                }
                info.add(freqInfo);
            }
        }
        return info;
    }

    protected void investigateComplexPattern(int layerIndex, int patternIndex, Connection con) {
        try {
            Statement statement = con.createStatement();
            do {
                if (patternIndex + 1 < this.nPatternsPerLayer) {
                    ++patternIndex;
                } else {
                    ++layerIndex;
                    patternIndex = 0;
                }
                if (layerIndex < this.nLayers) continue;
                if (!this.isDurationInRange(this.getGlobalHitDuration())) {
                    return;
                }
                if (this.statistics.nHits < 100000) {
                    this.rememberHitData(this.statistics.nHits);
                }
                String complexHitResultString = this.constructComplexHitResultString((Connection)con, (Statement)statement, (int[][])this.globalHitAnnId, (boolean)false).hitString.replaceAll("xxxSAFE_SPLITTERxxx", " ");
                int annId = this.globalHitAnnId[this.firstNonEmptyLayerIndex][this.firstNonEmptyPatternIndex];
                int fileId = this.globalHitFileId;
                this.updateFrequencyStatistics(complexHitResultString.replaceAll("xxxLAYER_SPLITTERxxx", "  #"), annId, fileId, this.firstNonEmptyLayerIndex, this.firstNonEmptyPatternIndex);
                ++this.statistics.nHits;
                ++this.statistics.nAnnotationsWithHit;
                return;
            } while (this.searchLayers[layerIndex].getPattern(patternIndex).length() == 0);
            String pattern = this.searchLayers[layerIndex].getPattern(patternIndex);
            boolean patternNOTMode = this.searchLayers[layerIndex].getPatternNOTMode(patternIndex);
            Pattern regExpPattern = this.searchLayers[layerIndex].getRegExpPattern(patternIndex);
            String[] queryModes = this.searchLayers[layerIndex].getMode(patternIndex);
            String queryString = "SELECT ann_id, ann_tier_id, ann_position, begin_time, end_time FROM " + this.schemaName + ".annotations WHERE ";
            queryString = queryString + this.createQueryPatternPart(pattern, queryModes, regExpPattern, patternNOTMode);
            if (patternIndex > 0 && this.searchLayers[layerIndex].getPattern(patternIndex - 1).length() > 0) {
                queryString = queryString + this.createHorizontalConstraintPart(layerIndex, patternIndex, statement);
            }
            if (layerIndex > 0 && this.searchLayers[layerIndex - 1].getPattern(patternIndex).length() > 0) {
                queryString = queryString + this.createVerticalConstraintPart(layerIndex, patternIndex, statement);
            }
            queryString = queryString + this.createTierConstraintPart(layerIndex, patternIndex);
            queryString = queryString + this.createGlobalTimeConstraintPart();
            queryString = this.convertRegexpPatternsIfNeeded(queryString);
            String hint = "[" + (layerIndex + 1) + "/" + this.nLayers + "][" + (patternIndex + 1) + "/" + this.nPatternsPerLayer + "] ";
            _logger.info("layerq: " + hint + queryString);
            ResultSet rs = statement.executeQuery(queryString);
            while (rs.next()) {
                int annId = rs.getInt(1);
                int tierId = rs.getInt(2);
                this.globalHitAnnId[layerIndex][patternIndex] = annId;
                this.globalHitTierId[layerIndex][patternIndex] = tierId;
                this.globalHitPosition[layerIndex][patternIndex] = rs.getInt(3);
                this.globalHitBeginTime[layerIndex][patternIndex] = this.getValue(rs, 4);
                this.globalHitEndTime[layerIndex][patternIndex] = this.getValue(rs, 5);
                this.investigateComplexPattern(layerIndex, patternIndex, con);
            }
        }
        catch (SQLException sqle) {
            _logger.error("investigateComplexPattern: SQLException: " + sqle, sqle);
        }
    }

    protected abstract String createQueryPatternPart(String var1, String[] var2, Pattern var3, boolean var4);

    protected abstract String convertRegexpPatternsIfNeeded(String var1);

    private int constraintParseInt(String constraint) {
        String[] parts = constraint.split(":");
        if (parts.length != 2) {
            return -1;
        }
        try {
            return Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    protected String createHorizontalConstraintPart(int layerIndex, int patternIndex, Statement statement) {
        String queryPart = "";
        try {
            if (patternIndex <= 0 || this.globalHitAnnId[layerIndex][patternIndex - 1] == -1) {
                return "";
            }
            int relativePosition = this.globalHitPosition[layerIndex][patternIndex - 1];
            long relativeEndTime = this.globalHitEndTime[layerIndex][patternIndex - 1];
            String constraint = this.searchLayers[layerIndex].getInnerConstraint(patternIndex - 1);
            if (constraint.equals("cns none")) {
                queryPart = " AND ann_position > " + relativePosition;
            } else if (constraint.indexOf("cns an=:") >= 0) {
                int nAnnotations = this.constraintParseInt(constraint) + 1;
                queryPart = " AND ann_position = " + (relativePosition + nAnnotations);
            } else if (constraint.indexOf("cns an-:") >= 0) {
                int nAnnotations = this.constraintParseInt(constraint) + 1;
                queryPart = " AND ann_position < " + (relativePosition + nAnnotations) + " AND ann_position > " + relativePosition;
            } else if (constraint.indexOf("cns an+:") >= 0) {
                int nAnnotations = this.constraintParseInt(constraint) + 1;
                queryPart = " AND ann_position > " + (relativePosition + nAnnotations);
            } else if (constraint.indexOf("cns ms=:") >= 0) {
                int nMilliSeconds = this.constraintParseInt(constraint);
                queryPart = " AND begin_time = " + (relativeEndTime + (long)nMilliSeconds);
            } else if (constraint.indexOf("cns ms-:") >= 0) {
                int nMilliSeconds = this.constraintParseInt(constraint);
                queryPart = " AND begin_time < " + (relativeEndTime + (long)nMilliSeconds) + " AND begin_time >= " + relativeEndTime;
            } else if (constraint.indexOf("cns ms+:") >= 0) {
                int nMilliSeconds = this.constraintParseInt(constraint);
                queryPart = " AND begin_time > " + (relativeEndTime + (long)nMilliSeconds);
            } else {
                _logger.warn("createHorizontalConstraintPart: Unknown constraint ignored: " + constraint);
            }
        }
        catch (RuntimeException re) {
            _logger.error("createHorizontalConstraintPart: RuntimeException: " + re, re);
        }
        return queryPart;
    }

    protected String createVerticalConstraintPart(int layerIndex, int patternIndex, Statement statement) {
        String queryPart = "";
        try {
            if (layerIndex <= 0 || this.globalHitAnnId[layerIndex - 1][patternIndex] == -1) {
                return "";
            }
            String constraint = this.searchLayers[layerIndex - 1].getOuterConstraint(patternIndex);
            if (constraint.equals("cns none")) {
                return "";
            }
            long relativeBeginTime = this.globalHitBeginTime[layerIndex - 1][patternIndex];
            long relativeEndTime = this.globalHitEndTime[layerIndex - 1][patternIndex];
            if (!constraint.equals("cns none")) {
                if (constraint.equals("cns aligned")) {
                    queryPart = " AND begin_time = " + relativeBeginTime + " AND end_time = " + relativeEndTime;
                } else if (constraint.equals("cns overlap")) {
                    queryPart = " AND end_time > " + relativeBeginTime + " AND begin_time < " + relativeEndTime;
                } else if (constraint.equals("cns l overlap")) {
                    queryPart = " AND begin_time <= " + relativeBeginTime + " AND end_time > " + relativeBeginTime + " AND end_time <= " + relativeEndTime;
                } else if (constraint.equals("cns r overlap")) {
                    queryPart = " AND begin_time < " + relativeEndTime + " AND end_time >= " + relativeEndTime + " AND begin_time >= " + relativeBeginTime;
                } else if (constraint.equals("cns surrounding")) {
                    queryPart = " AND begin_time <= " + relativeBeginTime + " AND end_time >= " + relativeEndTime;
                } else if (constraint.equals("cns within")) {
                    queryPart = " AND begin_time >= " + relativeBeginTime + " AND end_time <= " + relativeEndTime;
                } else if (constraint.equals("cns no overlap")) {
                    queryPart = " AND (end_time <= " + relativeBeginTime + " OR begin_time >= " + relativeEndTime + ")";
                } else if (constraint.indexOf("cns bb=:") >= 0) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time = " + (relativeBeginTime + (long)nMilliSeconds);
                } else if (constraint.indexOf("cns bb-:") >= 0) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time < " + (relativeBeginTime + (long)nMilliSeconds) + " AND begin_time >= " + relativeBeginTime;
                } else if (constraint.indexOf("cns bb+:") >= 0) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time > " + (relativeBeginTime + (long)nMilliSeconds);
                } else if (constraint.indexOf("cns be=:") >= 0) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time = " + (relativeEndTime + (long)nMilliSeconds);
                } else if (constraint.indexOf("cns be-:") >= 0) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time < " + (relativeEndTime + (long)nMilliSeconds) + " AND begin_time >= " + relativeEndTime;
                } else if (constraint.indexOf("cns be+:") >= 0) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time > " + (relativeEndTime + (long)nMilliSeconds);
                } else if (constraint.indexOf("cns eb=:") >= 0) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time = " + (relativeBeginTime + (long)nMilliSeconds);
                } else if (constraint.indexOf("cns eb-:") >= 0) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time < " + (relativeBeginTime + (long)nMilliSeconds) + " AND end_time >= " + relativeBeginTime;
                } else if (constraint.indexOf("cns eb+:") >= 0) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time > " + (relativeBeginTime + (long)nMilliSeconds);
                } else if (constraint.indexOf("cns ee=:") >= 0) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time = " + (relativeEndTime + (long)nMilliSeconds);
                } else if (constraint.indexOf("cns ee-:") >= 0) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time < " + (relativeEndTime + (long)nMilliSeconds) + " AND end_time >= " + relativeEndTime;
                } else if (constraint.indexOf("cns ee+:") >= 0) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time > " + (relativeEndTime + (long)nMilliSeconds);
                } else {
                    _logger.warn("createVerticalConstraintPart: Unknown constraint ignored: " + constraint);
                }
            }
        }
        catch (RuntimeException re) {
            _logger.error("createVerticalConstraintPart: RuntimeException: " + re, re);
        }
        return queryPart;
    }

    protected String createTierConstraintPart(int layerIndex, int patternIndex) {
        String queryPart = "";
        if (patternIndex > 0 && this.globalHitTierId[layerIndex][patternIndex - 1] != -1) {
            queryPart = " AND ann_tier_id = " + this.globalHitTierId[layerIndex][patternIndex - 1];
        } else {
            String layerDomain = this.searchLayers[layerIndex].getTierIdsInLayerDomain();
            if (layerDomain != null) {
                queryPart = queryPart + layerDomain;
            }
            --layerIndex;
            while (layerIndex >= 0) {
                for (int i = 0; i < this.nPatternsPerLayer; ++i) {
                    int forbiddenTierId = this.globalHitTierId[layerIndex][patternIndex];
                    if (forbiddenTierId == -1) continue;
                    queryPart = queryPart + " AND ann_tier_id != " + forbiddenTierId;
                }
                --layerIndex;
            }
        }
        return queryPart;
    }

    protected boolean setTierDomainForLayers(boolean defineFullTranscriptionTierDomain, Statement statement) {
        HashMap<String, TreeSet<Integer>> domainTierNames = new HashMap<String, TreeSet<Integer>>();
        HashMap<String, TreeSet<Integer>> domainTierTypes = new HashMap<String, TreeSet<Integer>>();
        HashMap<String, TreeSet<Integer>> domainTierParticipants = new HashMap<String, TreeSet<Integer>>();
        TreeSet<Integer> allTiers = new TreeSet<Integer>();
        this.fullTranscriptionTierDomain = "";
        this.thereIsALayerWithAnEmptyTierDomain = false;
        try {
            String queryString = "SELECT tier_id, tier_name, tier_type, participant FROM " + this.schemaName + ".tiers WHERE node_id = '" + this.currentNodeId + "'";
            ResultSet rst = statement.executeQuery(queryString);
            while (rst.next()) {
                String tierParticipant;
                String tierType;
                int domainTierId = rst.getInt(1);
                allTiers.add(new Integer(domainTierId));
                String tierName = rst.getString(2);
                if (tierName != null) {
                    TreeSet<Integer> tnSet = (TreeSet<Integer>)domainTierNames.get(tierName = tierName.trim());
                    if (tnSet == null) {
                        tnSet = new TreeSet<Integer>();
                    }
                    tnSet.add(new Integer(domainTierId));
                    domainTierNames.put(tierName, tnSet);
                }
                if ((tierType = rst.getString(3)) != null) {
                    TreeSet<Integer> ttSet = (TreeSet<Integer>)domainTierTypes.get(tierType = tierType.trim());
                    if (ttSet == null) {
                        ttSet = new TreeSet<Integer>();
                    }
                    ttSet.add(new Integer(domainTierId));
                    domainTierTypes.put(tierType, ttSet);
                }
                if ((tierParticipant = rst.getString(4)) == null) continue;
                TreeSet<Integer> tpSet = (TreeSet<Integer>)domainTierParticipants.get(tierParticipant = tierParticipant.trim());
                if (tpSet == null) {
                    tpSet = new TreeSet<Integer>();
                }
                tpSet.add(new Integer(domainTierId));
                domainTierParticipants.put(tierParticipant, tpSet);
            }
        }
        catch (SQLException sqle) {
            _logger.error("setTierDomainForLayers: SQLException: " + sqle, sqle);
            return true;
        }
        if (allTiers.isEmpty()) {
            this.fullTranscriptionTierDomain = null;
            this.thereIsALayerWithAnEmptyTierDomain = true;
        } else {
            this.fullTranscriptionTierDomain = defineFullTranscriptionTierDomain ? this.makeInTierQuery(allTiers) : "";
        }
        for (int l = 0; l < this.nLayers; ++l) {
            if (this.searchLayers[l].isEmpty()) continue;
            TreeSet layerTiers = new TreeSet();
            boolean searchInAllTiers = false;
            ArrayList tierConstraints = this.searchLayers[l].getTierConstraints();
            for (int c = 0; c < tierConstraints.size(); ++c) {
                String constraint = (String)tierConstraints.get(c);
                if (constraint.startsWith(" All Tiers ")) {
                    searchInAllTiers = true;
                    break;
                }
                if (constraint.startsWith(" Tier Name: ")) {
                    if (domainTierNames.get(constraint = constraint.substring(" Tier Name: ".length())) == null) continue;
                    layerTiers.addAll((TreeSet)domainTierNames.get(constraint));
                    continue;
                }
                if (constraint.startsWith(" Tier Type: ")) {
                    if (domainTierTypes.get(constraint = constraint.substring(" Tier Type: ".length())) == null) continue;
                    layerTiers.addAll((TreeSet)domainTierTypes.get(constraint));
                    continue;
                }
                if (!constraint.startsWith(" Participant: ") || domainTierParticipants.get(constraint = constraint.substring(" Participant: ".length())) == null) continue;
                layerTiers.addAll((TreeSet)domainTierParticipants.get(constraint));
            }
            if (searchInAllTiers) {
                this.searchLayers[l].setTierIdsInLayerDomain(this.fullTranscriptionTierDomain);
                continue;
            }
            if (layerTiers.isEmpty()) {
                this.searchLayers[l].setTierIdsInLayerDomain(null);
                this.thereIsALayerWithAnEmptyTierDomain = true;
                continue;
            }
            this.searchLayers[l].setTierIdsInLayerDomain(this.makeInTierQuery(layerTiers));
        }
        return this.thereIsALayerWithAnEmptyTierDomain;
    }

    private String makeInTierQuery(TreeSet tiers) {
        if (tiers == null || tiers.isEmpty()) {
            return "";
        }
        if (tiers.size() == 1) {
            return " AND ( ann_tier_id = " + tiers.first() + " ) ";
        }
        StringBuffer inSet = new StringBuffer(" AND ann_tier_id IN ( " + (Integer)tiers.first());
        Iterator iter = tiers.iterator();
        while (iter.hasNext()) {
            inSet.append(", " + (Integer)iter.next());
        }
        inSet.append(" ) ");
        return inSet.toString();
    }

    protected ComplexHitData constructComplexHitResultString(Connection con, Statement st, int[][] annIds, boolean addPositionAndTime) {
        StringBuffer hitString = new StringBuffer();
        long complexPatternBeginTime = Long.MAX_VALUE;
        long complexPatternEndTime = 0L;
        try {
            if (con != null && this.prepStatComplexHitResultData == null) {
                String queryString = "SELECT annotation, ann_position, begin_time, end_time  FROM " + this.schemaName + ".annotations WHERE ann_id = ?";
                this.prepStatComplexHitResultData = con.prepareStatement(queryString, 1004, 1007);
            }
            for (int i = 0; i < this.nLayers; ++i) {
                hitString.append("xxxLAYER_SPLITTERxxx").append(i + 1);
                for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                    ResultSet rs;
                    if (annIds[i][j] < 0) {
                        hitString.append("xxxSAFE_SPLITTERxxx").append("||");
                        continue;
                    }
                    if (con != null) {
                        this.prepStatComplexHitResultData.setInt(1, annIds[i][j]);
                        rs = this.prepStatComplexHitResultData.executeQuery();
                    } else {
                        String queryString = "SELECT annotation, ann_position, begin_time, end_time  FROM " + this.schemaName + ".annotations WHERE ann_id = " + annIds[i][j];
                        rs = st.executeQuery(queryString);
                    }
                    rs.next();
                    String annotation = rs.getString(1);
                    int position = rs.getInt(2);
                    long beginTime = this.getValue(rs, 3);
                    long endTime = this.getValue(rs, 4);
                    if (annotation.indexOf("xxxNUMBER_SPLITTERxxx") != -1 || annotation.indexOf("xxxLAYER_SPLITTERxxx") != -1 || annotation.indexOf("xxxSAFE_SPLITTERxxx") != -1) {
                        annotation = "[UNPRINTABLE]";
                    }
                    if (annotation.startsWith("|")) {
                        annotation = " " + annotation;
                    }
                    hitString.append("xxxSAFE_SPLITTERxxx").append("|").append(annotation).append("|");
                    if (addPositionAndTime) {
                        hitString.append("xxxNUMBER_SPLITTERxxx").append(position);
                        hitString.append("xxxNUMBER_SPLITTERxxx").append(beginTime);
                        hitString.append("xxxNUMBER_SPLITTERxxx").append(endTime);
                    }
                    if (beginTime < complexPatternBeginTime) {
                        complexPatternBeginTime = beginTime;
                    }
                    if (endTime <= complexPatternEndTime) continue;
                    complexPatternEndTime = endTime;
                }
            }
        }
        catch (SQLException sqle) {
            _logger.error("constructComplexHitResultString: SQLException: " + sqle, sqle);
        }
        ComplexHitData result = new ComplexHitData();
        result.hitString = hitString.toString();
        result.beginTime = complexPatternBeginTime;
        result.endTime = complexPatternEndTime;
        return result;
    }

    protected String[] constructNGramsWithinAnnotation(String annotation, String nGramPattern, String[] queryModes) {
        int nResults;
        String nGram;
        Matcher matcher;
        String[] result = null;
        String[] annotationParts = annotation.split(" +");
        String LongestNonWildcardPart = this.getLongestNonWildcardPart(nGramPattern);
        boolean notMode = false;
        while (SearchLayer.isNOTPattern(LongestNonWildcardPart)) {
            notMode = !notMode;
            LongestNonWildcardPart = SearchLayer.stripNOTPattern(LongestNonWildcardPart);
        }
        ArrayList<String> resultList = new ArrayList<String>();
        if (queryModes[1].equals(" case sensitive")) {
            if (queryModes[2].equals(" exact match")) {
                for (int i = 0; i < annotationParts.length; ++i) {
                    String nGram2;
                    if (notMode == annotationParts[i].equals(LongestNonWildcardPart) || (nGram2 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                    resultList.add(nGram2);
                }
            } else if (queryModes[2].equals(" substring match")) {
                for (int i = 0; i < annotationParts.length; ++i) {
                    String nGram3;
                    if (notMode == annotationParts[i].indexOf(LongestNonWildcardPart) >= 0 || (nGram3 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                    resultList.add(nGram3);
                }
            } else if (queryModes[2].equals(" regular expression")) {
                Pattern regExpPattern = Pattern.compile(LongestNonWildcardPart);
                for (int i = 0; i < annotationParts.length; ++i) {
                    matcher = regExpPattern.matcher(annotationParts[i]);
                    if (notMode == matcher.find() || (nGram = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                    resultList.add(nGram);
                }
            }
        } else if (queryModes[2].equals(" exact match")) {
            for (int i = 0; i < annotationParts.length; ++i) {
                String nGram4;
                if (notMode == annotationParts[i].toLowerCase().equals(LongestNonWildcardPart.toLowerCase()) || (nGram4 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                resultList.add(nGram4);
            }
        } else if (queryModes[2].equals(" substring match")) {
            for (int i = 0; i < annotationParts.length; ++i) {
                String nGram5;
                if (notMode == annotationParts[i].toLowerCase().indexOf(LongestNonWildcardPart.toLowerCase()) >= 0 || (nGram5 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                resultList.add(nGram5);
            }
        } else if (queryModes[2].equals(" regular expression")) {
            Pattern regExpPattern = Pattern.compile(LongestNonWildcardPart, 2);
            for (int i = 0; i < annotationParts.length; ++i) {
                matcher = regExpPattern.matcher(annotationParts[i].toLowerCase());
                if (notMode == matcher.find() || (nGram = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                resultList.add(nGram);
            }
        }
        if ((nResults = resultList.size()) > 0) {
            result = new String[nResults];
            for (int i = 0; i < nResults; ++i) {
                result[i] = ((String)resultList.get(i)).trim();
            }
            return result;
        }
        return null;
    }

    protected String[] constructNGrams(int annId, Statement st, String schemaName, String nGramPattern, String[] queryModes) {
        String[] result = null;
        try {
            if (queryModes[0].equals(" N-gram within annotation")) {
                String queryString = "SELECT annotation FROM " + schemaName + ".annotations WHERE ann_id = " + annId;
                ResultSet rs = st.executeQuery(queryString);
                rs.next();
                String annotation = rs.getString(1);
                return this.constructNGramsWithinAnnotation(annotation, nGramPattern, queryModes);
            }
            String queryString = "SELECT ann_position, ann_tier_id FROM " + schemaName + ".annotations WHERE ann_id = " + annId;
            ResultSet rs = st.executeQuery(queryString);
            rs.next();
            int annPosition = rs.getInt(1);
            int annTierId = rs.getInt(2);
            int firstPos = annPosition - this.getLongestNonWildcardPartPosition(nGramPattern);
            if (firstPos < 0) {
                return null;
            }
            String nGram = "";
            int lastPos = firstPos + this.getNGramLength(nGramPattern);
            String inString = "";
            for (int annPos = firstPos; annPos < lastPos; ++annPos) {
                inString = inString + ", " + annPos;
            }
            inString = inString.substring(2);
            queryString = "SELECT annotation, ann_position FROM " + schemaName + ".annotations WHERE ann_tier_id = " + annTierId + " AND ann_position IN (" + inString + ") ORDER BY ann_position";
            rs = st.executeQuery(queryString);
            int nParts = 0;
            while (rs.next()) {
                ++nParts;
                String nGramWord = rs.getString(1);
                if ("xxxSAFE_SPLITTERxxx".equals(nGramWord)) {
                    nGramWord = "[UNPRINTABLE]";
                }
                nGram = nGram + nGramWord + "xxxSAFE_SPLITTERxxx";
            }
            if (nParts != lastPos - firstPos) {
                return null;
            }
            result = new String[]{nGram.trim()};
            return result;
        }
        catch (SQLException sqle) {
            _logger.error("constructNGrams: SQLException: " + sqle, sqle);
            return null;
        }
    }

    private String constructNGram(String nGramPattern, String[] annotationParts, int hitIndex, String[] queryModes) {
        int firstPos = hitIndex - this.getLongestNonWildcardPartPosition(nGramPattern);
        if (firstPos < 0) {
            return null;
        }
        int lastPos = firstPos + this.getNGramLength(nGramPattern);
        if (lastPos > annotationParts.length) {
            return null;
        }
        String nGram = "";
        for (int j = firstPos; j < lastPos; ++j) {
            if ("xxxSAFE_SPLITTERxxx".equals(annotationParts[j])) {
                annotationParts[j] = "[UNPRINTABLE]";
            }
            nGram = queryModes[0].equals(" N-gram over annotations") ? nGram + annotationParts[j] + "xxxSAFE_SPLITTERxxx" : nGram + annotationParts[j] + " ";
        }
        if (queryModes[0].equals(" N-gram over annotations")) {
            return nGram.substring(0, nGram.length() - "xxxSAFE_SPLITTERxxx".length());
        }
        return nGram.trim();
    }

    protected boolean isNGramMatch(String nGram, String nGramPattern, String[] queryModes) {
        String[] nGramPatternParts;
        String[] nGramParts = null;
        nGramParts = queryModes[0].equals(" N-gram over annotations") ? nGram.split("xxxSAFE_SPLITTERxxx") : nGram.split(" +");
        if (nGramParts.length != (nGramPatternParts = nGramPattern.split(" +")).length) {
            return false;
        }
        for (int i = 0; i < nGramParts.length; ++i) {
            Pattern regExpPattern;
            Matcher matcher;
            String patternPart = nGramPatternParts[i];
            if (patternPart.equals("#")) continue;
            boolean notMode = false;
            while (SearchLayer.isNOTPattern(patternPart)) {
                notMode = !notMode;
                patternPart = SearchLayer.stripNOTPattern(patternPart);
            }
            if (!(queryModes[1].equals(" case sensitive") ? (queryModes[2].equals(" exact match") ? notMode == nGramParts[i].equals(patternPart) : (queryModes[2].equals(" substring match") ? notMode == nGramParts[i].indexOf(patternPart) >= 0 : queryModes[2].equals(" regular expression") && notMode == (matcher = (regExpPattern = Pattern.compile(patternPart)).matcher(nGramParts[i])).find())) : (queryModes[2].equals(" exact match") ? notMode == nGramParts[i].toLowerCase().equals(patternPart.toLowerCase()) : (queryModes[2].equals(" substring match") ? notMode == nGramParts[i].toLowerCase().indexOf(patternPart.toLowerCase()) >= 0 : queryModes[2].equals(" regular expression") && notMode == (matcher = (regExpPattern = Pattern.compile(patternPart, 2)).matcher(nGramParts[i].toLowerCase())).find())))) continue;
            return false;
        }
        return true;
    }

    protected String getLongestNonWildcardPart(String nGramPattern) {
        String[] nGramPatternParts = nGramPattern.split(" +");
        int position = this.getLongestNonWildcardPartPosition(nGramPattern);
        return nGramPatternParts[position];
    }

    protected int getLongestNonWildcardPartPosition(String nGramPattern) {
        String part;
        int i;
        String[] nGramPatternParts = nGramPattern.split(" +");
        int position = -1;
        int maxLength = 0;
        for (i = 0; i < nGramPatternParts.length; ++i) {
            part = nGramPatternParts[i];
            if (part.equals("#") || SearchLayer.isNOTPattern(part) || part.length() <= maxLength) continue;
            maxLength = part.length();
            position = i;
        }
        if (position >= 0) {
            return position;
        }
        for (i = 0; i < nGramPatternParts.length; ++i) {
            part = nGramPatternParts[i];
            if (part.equals("#")) continue;
            return i;
        }
        return 0;
    }

    protected int getNGramLength(String nGramPattern) {
        return nGramPattern.split(" +").length;
    }

    protected int countHitsInAnnotation(String annotation, String[] queryModes, String pattern, Pattern regExpPattern, boolean patternNOTMode) {
        int nHits = 0;
        int patternLength = pattern.length();
        if (patternNOTMode) {
            nHits = 1;
        } else if (queryModes[0].equals(" Annotation")) {
            if (queryModes[1].equals(" case sensitive")) {
                if (queryModes[2].equals(" substring match")) {
                    int p = annotation.indexOf(pattern);
                    while (p >= 0) {
                        ++nHits;
                        p = annotation.indexOf(pattern, p + patternLength);
                    }
                } else if (queryModes[2].equals(" regular expression")) {
                    Matcher matcher = regExpPattern.matcher(annotation);
                    if (matcher.find()) {
                        ++nHits;
                        while (matcher.find()) {
                            ++nHits;
                        }
                    }
                } else {
                    nHits = 1;
                }
            } else if (queryModes[2].equals(" substring match")) {
                pattern = pattern.toLowerCase();
                annotation = annotation.toLowerCase();
                int p = annotation.indexOf(pattern);
                while (p >= 0) {
                    ++nHits;
                    p = annotation.indexOf(pattern, p + patternLength);
                }
            } else if (queryModes[2].equals(" regular expression")) {
                Matcher matcher = regExpPattern.matcher(annotation.toLowerCase());
                if (matcher.find()) {
                    ++nHits;
                    while (matcher.find()) {
                        ++nHits;
                    }
                }
            } else {
                nHits = 1;
            }
        } else {
            nHits = 1;
        }
        return nHits;
    }

    protected int getHitPosition(String annotation, int nthHit, String[] queryModes, String pattern, Pattern regExpPattern, boolean patternNOTMode) {
        Matcher matcher;
        if (patternNOTMode) {
            return 0;
        }
        if (queryModes[0].equals(" N-gram over annotations")) {
            pattern = this.getLongestNonWildcardPart(pattern);
            regExpPattern = queryModes[1].equals(" case sensitive") ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
        }
        int position = 0;
        if (queryModes[0].equals(" N-gram within annotation")) {
            int hitNumber = nthHit;
            String[] nGrams = this.constructNGramsWithinAnnotation(annotation, pattern, queryModes);
            if (nGrams == null) {
                return 0;
            }
            for (int i = 0; i < nGrams.length; ++i) {
                if (!this.isNGramMatch(nGrams[i], pattern, queryModes) || --hitNumber > 0) continue;
                String singleSpaceAnnotation = annotation.replaceAll(" +", " ");
                position = singleSpaceAnnotation.indexOf(nGrams[i]);
                int nSame = 0;
                for (int j = 0; j < i; ++j) {
                    if (!nGrams[i].equals(nGrams[j])) continue;
                    ++nSame;
                }
                while (nSame > 0) {
                    position = singleSpaceAnnotation.indexOf(nGrams[i], position + 1);
                    --nSame;
                }
                break;
            }
            return position;
        }
        if (!queryModes[1].equals(" case sensitive")) {
            pattern = pattern.toLowerCase();
            annotation = annotation.toLowerCase();
        }
        if (queryModes[2].equals(" substring match") || queryModes[2].equals(" exact match")) {
            int patternLength = pattern.length();
            int p = annotation.indexOf(pattern);
            --nthHit;
            while (nthHit > 0) {
                p = annotation.indexOf(pattern, p + patternLength);
                --nthHit;
            }
            position = p;
        } else if (queryModes[2].equals(" regular expression") && (matcher = regExpPattern.matcher(annotation)).find()) {
            --nthHit;
            while (nthHit > 0) {
                matcher.find();
                --nthHit;
            }
            position = matcher.start();
        }
        return position;
    }

    private int getTokenNumberForPosition(String annotation, int p) {
        int pos = 0;
        int tokenNr = 0;
        while (pos < p) {
            pos = annotation.indexOf(32, pos) + 1;
            ++tokenNr;
        }
        return tokenNr;
    }

    protected int getHitLength(String annotation, int nthHit, String[] queryModes, String pattern, Pattern regExpPattern, boolean patternNOTMode) {
        if (queryModes[0].equals(" N-gram over annotations")) {
            pattern = this.getLongestNonWildcardPart(pattern);
            regExpPattern = queryModes[1].equals(" case sensitive") ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
        }
        int length = pattern.length();
        if (patternNOTMode) {
            length = annotation.length();
        } else if (queryModes[0].equals(" N-gram within annotation")) {
            String[] nGrams = this.constructNGramsWithinAnnotation(annotation, pattern, queryModes);
            for (int i = 0; i < nGrams.length; ++i) {
                if (!this.isNGramMatch(nGrams[i], pattern, queryModes) || --nthHit > 0) continue;
                length = nGrams[i].length();
                break;
            }
        } else if (queryModes[2].equals(" regular expression")) {
            Matcher matcher = null;
            matcher = queryModes[1].equals(" case sensitive") ? regExpPattern.matcher(annotation) : regExpPattern.matcher(annotation.toLowerCase());
            if (matcher.find()) {
                --nthHit;
                while (nthHit > 0) {
                    matcher.find();
                    --nthHit;
                }
                length = matcher.end() - matcher.start();
            }
        }
        return length;
    }

    protected String createGlobalTimeConstraintPart() {
        String queryPart = "";
        if (this.beginAfter > 0L) {
            queryPart = " AND begin_time > " + this.beginAfter;
        }
        if (this.endBefore > 0L) {
            queryPart = queryPart + " AND end_time < " + this.endBefore;
        }
        return queryPart;
    }

    protected boolean isDurationInRange(long duration) {
        boolean retval = true;
        if (this.minimalDuration > 0L && duration < this.minimalDuration) {
            retval = false;
        }
        if (this.maximalDuration > 0L && duration > this.maximalDuration) {
            retval = false;
        }
        return retval;
    }

    protected long getGlobalHitDuration() {
        long smallestBeginTime = Long.MAX_VALUE;
        long biggestEndTime = Long.MIN_VALUE;
        for (int i = 0; i < this.nLayers; ++i) {
            for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                long endTime;
                if (this.globalHitAnnId[i][j] == -1) continue;
                long beginTime = this.globalHitBeginTime[i][j];
                if (beginTime < smallestBeginTime) {
                    smallestBeginTime = beginTime;
                }
                if ((endTime = this.globalHitEndTime[i][j]) <= biggestEndTime) continue;
                biggestEndTime = endTime;
            }
        }
        if (smallestBeginTime == Long.MAX_VALUE || biggestEndTime == Long.MIN_VALUE) {
            return 0L;
        }
        return biggestEndTime - smallestBeginTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearHitData(int fileId) {
        int[][] nArray = this.globalHitAnnId;
        synchronized (this.globalHitAnnId) {
            this.globalHitFileId = fileId;
            for (int i = 0; i < this.nLayers; ++i) {
                for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                    this.globalHitAnnId[i][j] = -1;
                    this.globalHitTierId[i][j] = -1;
                }
            }
            this.prepStatCheckValidDuration = null;
            this.prepStatCheckValidDuration = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void rememberHitData(int index) {
        for (int i = 0; i < this.nLayers; ++i) {
            for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                if (this.globalHitAnnId[i][j] == -1) continue;
                this.searchLayers[i].getHitAnnIdsForPattern((int)j)[index] = this.globalHitAnnId[i][j];
                this.searchLayers[i].getHitFileIds()[index] = this.globalHitFileId;
            }
        }
    }

    protected class ComplexHitData {
        String hitString;
        long beginTime;
        long endTime;

        protected ComplexHitData() {
        }
    }

    protected class FreqInfoComparator
    implements Comparator {
        protected FreqInfoComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            FrequencyInfo info1 = (FrequencyInfo)arg0;
            FrequencyInfo info2 = (FrequencyInfo)arg1;
            if (info1.numberOfHits < info2.numberOfHits) {
                return -1;
            }
            if (info1.numberOfHits > info2.numberOfHits) {
                return 1;
            }
            if (info1.annotation.compareTo(info2.annotation) < 0) {
                return -1;
            }
            return 1;
        }
    }
}

