/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import mpi.annex.data.UTF8Validator;
import mpi.annex.search.Constants;
import mpi.annex.search.FrequencyInfo;
import mpi.annex.search.PostgresQuery;
import mpi.annex.search.SearchClient;
import mpi.annex.search.SearchHit;
import mpi.annex.search.SearchStatistics;
import mpi.annex.util.AnnexUtil;
import nl.mpi.corpusstructure.CorpusStructureDB;
import nl.mpi.corpusstructure.UnknownNodeException;
import org.apache.log4j.Logger;

public class SearchServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger("ANNEX.SearchServlet");
    private static int queryIdCounter;
    private HashMap busySavingHits = new HashMap();
    private static SearchClient searchClient;

    public void init() {
        try {
            searchClient = new SearchClient(this.getServletContext().getInitParameter("annex_searchDbURL"), this.getServletContext().getInitParameter("annex_searchDbUser"), this.getServletContext().getInitParameter("annex_searchDbPassword"));
        }
        catch (SQLException sqle) {
            logger.error("Cannot open connection to Annex / Trova search DB: " + sqle, sqle);
            throw new IllegalStateException();
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.setCharacterEncoding("UTF-8");
        this.doGetFlexRequest(req, res);
    }

    public void doGetFlexRequest(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.setCharacterEncoding("UTF-8");
        HttpSession session = req.getSession();
        String domainId = req.getParameter("domainId");
        String queryId = req.getParameter("queryId");
        String command = req.getParameter("command");
        if (!"getStatisticsCMD".equals(command) && !"getHitsCMD".equals(command)) {
            logger.debug("com = " + command + "  qid = " + queryId + " domId = " + domainId + "  sesId = " + (session == null ? "n/a" : session.getId()));
        }
        if (command.equals("saveHitsUTF16CMD") || command.equals("saveFrequencyInfoUTF16CMD")) {
            res.setCharacterEncoding("UTF-16");
        } else {
            res.setCharacterEncoding("UTF-8");
            if (!command.equals("saveHitsCMD") && !command.equals("saveFrequencyInfoCMD")) {
                res.setContentType("text/xml; charset=UTF-8");
            }
        }
        ServletOutputStream toFlexClient = res.getOutputStream();
        if (command.equals("getConstantsCMD")) {
            toFlexClient.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            toFlexClient.print(this.constructConstantsXML().replaceAll(" ", "&#32;"));
        } else if (command.equals("initCMD")) {
            toFlexClient.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.initFlexSearch(req, res, domainId, toFlexClient);
        } else if (command.equals("createQueryCMD")) {
            queryId = Integer.toString(queryIdCounter++);
            PostgresQuery query = searchClient.createQuery();
            this.setSessionAttribute(session, queryId, domainId, query);
            toFlexClient.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?><queryId value='" + queryId + "'/>");
        } else if (command.equals("doQueryCMD")) {
            logger.debug("do query");
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            String domainTypes = req.getParameter("domainTypes");
            ArrayList nodeIds = new ArrayList();
            if (domainTypes.toLowerCase().indexOf("eaf") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "eafNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("chat") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "chatNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("shoebox") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "shoeboxNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("plaintext") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "plainTextNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("xmltext") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "xmlTextNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("htmltext") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "htmlTextNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("csvtext") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "csvTextNodes", domainId));
            }
            String encodedQuery = req.getParameter("encodedQuery");
            if (query != null) {
                byte[] asBytes = new byte[encodedQuery.length()];
                int code = 0;
                for (int i = 0; i < encodedQuery.length(); ++i) {
                    if (encodedQuery.charAt(i) < '\u0100') {
                        asBytes[i] = (byte)encodedQuery.charAt(i);
                        if ((asBytes[i] & 0x80) == 0) continue;
                        code |= 1;
                        continue;
                    }
                    code |= 2;
                }
                if (code == 1 && UTF8Validator.validateUTF8(asBytes, asBytes.length, false) < 0) {
                    code = 2;
                } else if (code == 1) {
                    encodedQuery = new String(asBytes, "UTF-8");
                    logger.warn("DOUBLE UNICODE query decoded to: " + encodedQuery);
                } else if (code > 1) {
                    logger.debug("UNICODE query: " + encodedQuery);
                }
                query.doQuery(nodeIds, encodedQuery);
            } else {
                logger.warn("DO QUERY: Cannot start query, no query found with ID: " + queryId + "/" + domainId);
            }
        } else if (command.equals("getStatisticsCMD")) {
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            SearchStatistics stats = null;
            if (query == null) {
                logger.warn("GET STATISTICS: No such query: " + queryId + "/" + domainId);
                stats = new SearchStatistics();
                stats.reset();
                stats.progress = 1.0f;
            } else {
                stats = query.getSearchStatistics();
            }
            toFlexClient.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?><statistics nHits='" + stats.nHits + "' " + "nAnnotationsWithHit='" + stats.nAnnotationsWithHit + "' " + "nAnnotationsSearched='" + stats.nAnnotationsSearched + "' " + "progress='" + stats.progress + "' " + "nFrequencyInfoItems='" + stats.nFrequencyInfoItems + "'/>");
        } else if (command.equals("getViewParametersCMD")) {
            int annId = Integer.parseInt(req.getParameter("annId"));
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            ArrayList<Object> parameters = null;
            if (query == null) {
                logger.warn("GET VIEW PARAM: No such query, no viewer parameters: " + queryId + "/" + domainId);
                parameters = new ArrayList<Object>();
                parameters.add("MPI999999#");
                parameters.add("n/a");
                parameters.add(new Long(42L));
                parameters.add(new Long(84L));
            } else {
                parameters = query.getViewerParametersFor(annId, 0);
            }
            toFlexClient.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?><parameters nodeId='" + (String)parameters.get(0) + "' " + "tierName='" + (String)parameters.get(1) + "' " + "beginTime='" + (Long)parameters.get(2) + "' " + "endTime='" + (Long)parameters.get(3) + "'/>");
        } else if (command.equals("getHitsCMD")) {
            int from = Integer.parseInt(req.getParameter("from"));
            int to = Integer.parseInt(req.getParameter("to"));
            int contextSize = Integer.parseInt(req.getParameter("contextSize"));
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            ArrayList hits = new ArrayList();
            if (query == null) {
                logger.warn("GET HITS: No such query: " + queryId + "/" + domainId);
            } else {
                hits = query.getHits(from, to, contextSize);
            }
            StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?><hits>");
            result.ensureCapacity(256 * hits.size());
            for (int i = 0; i < hits.size(); ++i) {
                SearchHit hit = (SearchHit)hits.get(i);
                result.append(this.getHitAsXML(hit));
            }
            result.append("</hits>");
            toFlexClient.print(result.toString());
        } else if (command.equals("getFreqInfoCMD")) {
            int from = Integer.parseInt(req.getParameter("from"));
            int to = Integer.parseInt(req.getParameter("to"));
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            ArrayList info = new ArrayList();
            if (query == null) {
                logger.warn("GET FREQUENCY INFO: No such query: " + queryId + "/" + domainId);
            } else {
                info = query.getFrequencyInfo(from, to);
            }
            StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?><freqInfo>");
            result.ensureCapacity(128 * info.size());
            for (int i = 0; i < info.size(); ++i) {
                FrequencyInfo freqInfo = (FrequencyInfo)info.get(i);
                result.append(this.getFreqInfoAsXML(freqInfo));
            }
            result.append("</freqInfo>");
            toFlexClient.print(result.toString());
        } else if (command.equals("cancelQueryCMD")) {
            logger.debug("cancel");
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            if (query != null) {
                query.cancelQuery();
            }
        } else if (command.equals("checkRegularExpressionCMD")) {
            String regexp = req.getParameter("regexp");
            String mode = req.getParameter("mode");
            String[] queryParts = new String[]{regexp};
            if (mode.equals("split")) {
                queryParts = regexp.split(" ");
            }
            String response = "";
            for (int i = 0; i < queryParts.length; ++i) {
                try {
                    Pattern.compile(queryParts[i]);
                    continue;
                }
                catch (RuntimeException re) {
                    response = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><regexptest valid='false' problem='" + queryParts[i] + "' />";
                }
            }
            if (response.length() < 1) {
                response = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><regexptest valid='true'/>";
            }
            toFlexClient.print(response);
        } else if (command.equals("saveHitsCMD") || command.equals("saveHitsUTF16CMD")) {
            this.busySavingHits.put("" + queryId, "");
            String fileName = req.getParameter("fileName");
            if (fileName == null || fileName.length() < 1) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                Date date = new Date();
                fileName = "Hits-" + dateFormat.format(date) + ".txt";
            }
            res.setHeader("content-disposition", "attachment; filename=" + fileName);
            if (command.equals("saveHitsUTF16CMD")) {
                toFlexClient.write(254);
                toFlexClient.write(255);
            } else {
                toFlexClient.write(239);
                toFlexClient.write(187);
                toFlexClient.write(191);
            }
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            if (query == null) {
                logger.warn("SAVE HITS: No such query: " + queryId + "/" + domainId);
            } else {
                SearchStatistics stats = query.getSearchStatistics();
                int nHits = stats.nHits < 100000 ? stats.nHits : 100000;
                ArrayList hitList = query.getHits(0, nHits, 8);
                for (int i = 0; i < hitList.size(); ++i) {
                    toFlexClient.print(this.getHitAsTabDelimited((SearchHit)hitList.get(i), i == 0));
                    toFlexClient.flush();
                }
            }
            this.busySavingHits.put("" + queryId, null);
        } else if (command.equals("saveFrequencyInfoCMD") || command.equals("saveFrequencyInfoUTF16CMD")) {
            this.busySavingHits.put("" + queryId, "");
            String fileName = req.getParameter("fileName");
            if (fileName == null || fileName.length() < 1) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                Date date = new Date();
                fileName = "Frequency-" + dateFormat.format(date) + ".txt";
            }
            res.setHeader("content-disposition", "attachment; filename=" + fileName);
            if (command.equals("saveFrequencyInfoUTF16CMD")) {
                toFlexClient.write(254);
                toFlexClient.write(255);
            } else {
                toFlexClient.write(239);
                toFlexClient.write(187);
                toFlexClient.write(191);
            }
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            if (query == null) {
                logger.warn("SAVE FREQUENCY: No such query: " + queryId + "/" + domainId);
            } else {
                SearchStatistics stats = query.getSearchStatistics();
                ArrayList infoList = query.getFrequencyInfo(0, stats.nFrequencyInfoItems);
                for (int i = 0; i < infoList.size(); ++i) {
                    toFlexClient.print(this.getInfoAsTabDelimited((FrequencyInfo)infoList.get(i), i == 0, stats));
                    toFlexClient.flush();
                }
            }
            this.busySavingHits.put("" + queryId, null);
        } else if (command.equals("busySavingHitsCMD")) {
            do {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while (this.busySavingHits.get("" + queryId) != null);
        }
        toFlexClient.flush();
        toFlexClient.close();
    }

    private String getInfoAsTabDelimited(FrequencyInfo freqInfo, boolean includeHeader, SearchStatistics stats) {
        StringBuffer result = new StringBuffer("");
        String delimiter = "\t";
        if (includeHeader) {
            result.append("\"Annotation\"").append(delimiter).append("\"Percentage\"").append(delimiter).append("\"Count\"").append(delimiter).append("\"HitPositionInAnnotation\"").append(delimiter).append("\"HitLength\"\n");
        }
        double percentage = 100.0 * (double)freqInfo.numberOfHits / (double)stats.nAnnotationsWithHit;
        String fmt = "##0.00";
        DecimalFormat df = new DecimalFormat(fmt);
        String percentageString = df.format(percentage);
        result.append("\"").append(freqInfo.annotation.replaceAll("\"", "\"\"")).append("\"").append(delimiter);
        result.append(percentageString).append(delimiter);
        result.append(freqInfo.numberOfHits).append(delimiter);
        result.append(freqInfo.hitPositionInAnnotation).append(delimiter);
        result.append(freqInfo.hitLength).append("\n");
        return result.toString();
    }

    private String getHitAsTabDelimited(SearchHit hit, boolean includeHeader) {
        StringBuffer result = new StringBuffer("");
        String delimiter = "\t";
        if (hit.tierType.equals("xxxCOMPLEX_QUERY_INDICATORxxx")) {
            String part;
            int n;
            int k;
            StringBuffer headerString = new StringBuffer("");
            String[] layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
            String[] layerParts = null;
            if (includeHeader) {
                for (k = 1; k < layerStrings.length; ++k) {
                    layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                    for (n = 1; n < layerParts.length; ++n) {
                        part = layerParts[n];
                        if (part.charAt(1) == '|') continue;
                        headerString.append("\"Annotation" + k + "-" + n + "\"").append(delimiter).append("\"Position\"").append(delimiter).append("\"Begin Time\"").append(delimiter).append("\"End Time\"").append(delimiter);
                    }
                }
                headerString.append("\"TranscriptionName\"");
                result.append(headerString.toString()).append("\n\n");
            }
            layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
            for (k = 1; k < layerStrings.length; ++k) {
                layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                for (n = 1; n < layerParts.length; ++n) {
                    part = layerParts[n];
                    if (part.charAt(1) == '|') continue;
                    String[] patternParts = part.split("xxxNUMBER_SPLITTERxxx");
                    String annotation = patternParts[0].substring(1, patternParts[0].length() - 1);
                    int position = Integer.parseInt(patternParts[1]);
                    long beginTime = Long.parseLong(patternParts[2]);
                    long endTime = Long.parseLong(patternParts[3]);
                    result.append(annotation).append(delimiter);
                    result.append(position).append(delimiter);
                    result.append(beginTime).append(delimiter);
                    result.append(endTime).append(delimiter);
                }
            }
            result.append(hit.transcriptionName).append("\n");
        } else {
            int k;
            if (includeHeader) {
                result.append("\"Annotation\"").append(delimiter).append("\"HitPositionInAnnotation\"").append(delimiter).append("\"HitLength\"").append(delimiter).append("\"HitNumberInAnnotation\"").append(delimiter).append("\"AnnotationBeginTime\"").append(delimiter).append("\"AnnotationEndTime\"").append(delimiter).append("\"HitPositionInTier\"").append(delimiter).append("\"TierName\"").append(delimiter).append("\"TierType\"").append(delimiter).append("\"LeftContext\"").append(delimiter).append("\"RightContext\"").append(delimiter).append("\"TranscriptionName\"\n\n");
            }
            result.append("\"").append(hit.annotation.replaceAll("\"", "\"\"")).append("\"").append(delimiter);
            result.append(hit.hitPositionInAnnotation + 1).append(delimiter);
            result.append(hit.hitLength).append(delimiter);
            result.append(hit.hitNumberInAnnotation).append(delimiter);
            result.append(hit.beginTime).append(delimiter);
            result.append(hit.endTime).append(delimiter);
            result.append(hit.positionInTier).append(delimiter);
            result.append("\"").append(hit.tierName.replaceAll("\"", "\"\"")).append("\"").append(delimiter);
            result.append("\"").append(hit.tierType.replaceAll("\"", "\"\"")).append("\"").append(delimiter);
            if (hit.leftContext.size() > 0) {
                String leftContext = (String)hit.leftContext.get(0);
                for (k = 1; k < hit.leftContext.size(); ++k) {
                    leftContext = (String)hit.leftContext.get(k) + "  " + leftContext;
                }
                result.append("\"").append(leftContext.replaceAll("\"", "\"\"")).append("\"").append(delimiter);
            } else {
                result.append("\"\"").append(delimiter);
            }
            if (hit.rightContext.size() > 0) {
                String rightContext = (String)hit.rightContext.get(0);
                for (k = 1; k < hit.rightContext.size(); ++k) {
                    rightContext = rightContext + "  " + (String)hit.rightContext.get(k);
                }
                result.append("\"").append(rightContext.replaceAll("\"", "\"\"")).append("\"").append(delimiter);
            } else {
                result.append("\"\"").append(delimiter);
            }
            result.append(hit.transcriptionName).append("\n");
        }
        return result.toString();
    }

    private String getHitAsXML(SearchHit hit) {
        int i;
        StringBuffer xml = new StringBuffer("\n<hit>");
        xml.ensureCapacity(256);
        xml.append("<annotation>").append(this.escapeXML(hit.annotation)).append("</annotation>\n");
        xml.append("<aligned>").append(hit.aligned).append("</aligned>\n");
        xml.append("<beginTime>").append(hit.beginTime).append("</beginTime>\n");
        xml.append("<endTime>").append(hit.endTime).append("</endTime>\n");
        xml.append("<hitLength>").append(hit.hitLength).append("</hitLength>\n");
        xml.append("<hitNumberInAnnotation>").append(hit.hitNumberInAnnotation).append("</hitNumberInAnnotation>\n");
        xml.append("<hitPositionInAnnotation>").append(hit.hitPositionInAnnotation).append("</hitPositionInAnnotation>\n");
        xml.append("<positionInTier>").append(hit.positionInTier).append("</positionInTier>\n");
        xml.append("<tierName>").append(this.escapeXML(hit.tierName)).append("</tierName>\n");
        xml.append("<tierType>").append(this.escapeXML(hit.tierType)).append("</tierType>\n");
        xml.append("<participant>").append(this.escapeXML(hit.participant)).append("</participant>\n");
        xml.append("<transcriptionNodeId>").append(hit.transcriptionNodeId).append("</transcriptionNodeId>\n");
        xml.append("<transcriptionName>").append(this.escapeXML(hit.transcriptionName)).append("</transcriptionName>\n");
        xml.append("<leftContext>");
        String beforeString = "";
        for (i = 0; i < hit.leftContext.size(); ++i) {
            beforeString = (String)hit.leftContext.get(i) + "  " + beforeString;
        }
        xml.append(this.escapeXML(beforeString.trim())).append("</leftContext>\n");
        xml.append("<rightContext>");
        for (i = 0; i < hit.rightContext.size(); ++i) {
            xml.append(this.escapeXML((String)hit.rightContext.get(i))).append(" ");
        }
        xml.append("</rightContext>\n");
        xml.append("</hit>\n");
        return xml.toString();
    }

    private String getFreqInfoAsXML(FrequencyInfo info) {
        StringBuffer xml = new StringBuffer("<hit>");
        xml.ensureCapacity(128);
        xml.append("<annotation>").append(this.escapeXML(info.annotation)).append("</annotation>");
        xml.append("<occurences>").append(info.nOccurences).append("</occurences>");
        xml.append("<numberOfHits>").append(info.numberOfHits).append("</numberOfHits>");
        xml.append("<hitPositionInAnnotation>").append(info.hitPositionInAnnotation).append("</hitPositionInAnnotation>");
        xml.append("<hitLength>").append(info.hitLength).append("</hitLength>");
        xml.append("<annId>").append(info.annId).append("</annId>");
        xml.append("<fileIndex>").append(info.fileIndex).append("</fileIndex>");
        return xml.append("</hit>\n").toString();
    }

    private String escapeXML(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("\n", "").replaceAll("\r", "").replaceAll("&", "&amp;").replaceAll("<", "&lt;");
    }

    private void initFlexSearch(HttpServletRequest req, HttpServletResponse res, String domainId, ServletOutputStream toFlexClient) throws IOException, ServletException {
        try {
            HttpSession session = req.getSession();
            String remoteUser = req.getRemoteUser();
            if (remoteUser != null && remoteUser.length() > 0 && !remoteUser.equals("anonymous") && !remoteUser.equals((String)session.getAttribute("userid"))) {
                session.setAttribute("userid", (Object)remoteUser);
                logger.info("Set userid to value from request.getRemoteUser: " + remoteUser);
            } else if ("anonymous".equals(remoteUser)) {
                session.removeAttribute("userid");
                logger.info("Removed userid because request.getRemoteUser is anonymous");
            }
            String userId = (String)session.getAttribute("userid");
            PostgresQuery query = searchClient.createQuery();
            this.setSessionAttribute(session, "query", domainId, query);
            ArrayList topNodes = null;
            HashSet<String> uniqueTopNodeNames = new HashSet<String>();
            String topNodeNames = "";
            int maxVisibleNodeNames = 7;
            topNodes = this.getSessionAttribute(session, "domainTopNodes", domainId) instanceof ArrayList ? (ArrayList)this.getSessionAttribute(session, "domainTopNodes", domainId) : new ArrayList();
            for (int i = 0; i < topNodes.size() && uniqueTopNodeNames.size() < maxVisibleNodeNames; ++i) {
                String nodeName = "n/a";
                try {
                    nodeName = AnnexUtil.getNameFor((String)topNodes.get(i));
                }
                catch (UnknownNodeException une) {
                    nodeName = "[BAD NODE: " + topNodes.get(i) + "]";
                }
                catch (RuntimeException re) {
                    nodeName = "[BAD NODE NUMBER: " + topNodes.get(i) + "]";
                }
                if (uniqueTopNodeNames.contains(nodeName)) continue;
                topNodeNames = topNodeNames + ", " + nodeName;
                uniqueTopNodeNames.add(nodeName);
            }
            if (topNodeNames.length() > 2) {
                topNodeNames = topNodeNames.substring(2);
            }
            if (topNodes.size() > maxVisibleNodeNames) {
                topNodeNames = topNodeNames + ", ...";
            }
            ArrayList domainNodes = this.getUserDomain(topNodes, userId);
            this.setSessionAttribute(session, "domainNodes", domainId, domainNodes);
            ArrayList eafNodes = this.keepIndexedNodes(domainNodes, 0);
            this.setSessionAttribute(session, "eafNodes", domainId, eafNodes);
            ArrayList chatNodes = this.keepIndexedNodes(domainNodes, 1);
            this.setSessionAttribute(session, "chatNodes", domainId, chatNodes);
            ArrayList shoeboxNodes = this.keepIndexedNodes(domainNodes, 2);
            this.setSessionAttribute(session, "shoeboxNodes", domainId, shoeboxNodes);
            ArrayList plainTextNodes = this.keepIndexedNodes(domainNodes, 3);
            this.setSessionAttribute(session, "plainTextNodes", domainId, plainTextNodes);
            ArrayList xmlTextNodes = this.keepIndexedNodes(domainNodes, 5);
            this.setSessionAttribute(session, "xmlTextNodes", domainId, xmlTextNodes);
            ArrayList htmlTextNodes = this.keepIndexedNodes(domainNodes, 4);
            this.setSessionAttribute(session, "htmlTextNodes", domainId, htmlTextNodes);
            ArrayList csvTextNodes = this.keepIndexedNodes(domainNodes, 6);
            this.setSessionAttribute(session, "csvTextNodes", domainId, csvTextNodes);
            toFlexClient.print("<topNodeNames>" + topNodeNames + "</topNodeNames>");
            ResultSet rs = searchClient.executeSQLQuery("select node_id, tier_name, tier_type, participant, n_annotations from search.tiers");
            HashSet eafTierNames = new HashSet();
            HashSet eafTierTypes = new HashSet();
            HashSet eafParticipants = new HashSet();
            toFlexClient.print("<eafSize>" + eafNodes.size() + "</eafSize><eafInfo>" + this.getNameAndTypeInfoFor(rs, eafNodes, eafTierNames, eafTierTypes, eafParticipants) + "</eafInfo>");
            this.sendXMLArray("eafTierNames", eafTierNames, toFlexClient);
            this.sendXMLArray("eafTierTypes", eafTierTypes, toFlexClient);
            this.sendXMLArray("eafParticipants", eafParticipants, toFlexClient);
            HashSet chatTierNames = new HashSet();
            HashSet chatTierTypes = new HashSet();
            HashSet chatParticipants = new HashSet();
            toFlexClient.print("<chatSize>" + chatNodes.size() + "</chatSize><chatInfo>" + this.getNameAndTypeInfoFor(rs, chatNodes, chatTierNames, chatTierTypes, chatParticipants) + "</chatInfo>");
            this.sendXMLArray("chatTierNames", chatTierNames, toFlexClient);
            this.sendXMLArray("chatTierTypes", chatTierTypes, toFlexClient);
            this.sendXMLArray("chatParticipants", chatParticipants, toFlexClient);
            HashSet shoeboxTierNames = new HashSet();
            HashSet shoeboxTierTypes = new HashSet();
            HashSet shoeboxParticipants = new HashSet();
            toFlexClient.print("<shoeboxSize>" + shoeboxNodes.size() + "</shoeboxSize><shoeboxInfo>" + this.getNameAndTypeInfoFor(rs, shoeboxNodes, shoeboxTierNames, shoeboxTierTypes, shoeboxParticipants) + "</shoeboxInfo>");
            this.sendXMLArray("shoeboxTierNames", shoeboxTierNames, toFlexClient);
            this.sendXMLArray("shoeboxTierTypes", shoeboxTierTypes, toFlexClient);
            this.sendXMLArray("shoeboxParticipants", shoeboxParticipants, toFlexClient);
            HashSet plainTextTierNames = new HashSet();
            HashSet plainTextTierTypes = new HashSet();
            HashSet plainTextParticipants = new HashSet();
            toFlexClient.print("<plainTextSize>" + plainTextNodes.size() + "</plainTextSize><plainTextInfo>" + this.getNameAndTypeInfoFor(rs, plainTextNodes, plainTextTierNames, plainTextTierTypes, plainTextParticipants) + "</plainTextInfo>");
            this.sendXMLArray("plainTextTierNames", plainTextTierNames, toFlexClient);
            this.sendXMLArray("plainTextTierTypes", plainTextTierTypes, toFlexClient);
            this.sendXMLArray("plainTextParticipants", plainTextParticipants, toFlexClient);
            HashSet xmlTextTierNames = new HashSet();
            HashSet xmlTextTierTypes = new HashSet();
            HashSet xmlTextParticipants = new HashSet();
            toFlexClient.print("<xmlTextSize>" + xmlTextNodes.size() + "</xmlTextSize><xmlTextInfo>" + this.getNameAndTypeInfoFor(rs, xmlTextNodes, xmlTextTierNames, xmlTextTierTypes, xmlTextParticipants) + "</xmlTextInfo>");
            this.sendXMLArray("xmlTextTierNames", xmlTextTierNames, toFlexClient);
            this.sendXMLArray("xmlTextTierTypes", xmlTextTierTypes, toFlexClient);
            this.sendXMLArray("xmlTextParticipants", xmlTextParticipants, toFlexClient);
            HashSet htmlTextTierNames = new HashSet();
            HashSet htmlTextTierTypes = new HashSet();
            HashSet htmlTextParticipants = new HashSet();
            toFlexClient.print("<htmlTextSize>" + htmlTextNodes.size() + "</htmlTextSize><htmlTextInfo>" + this.getNameAndTypeInfoFor(rs, htmlTextNodes, htmlTextTierNames, htmlTextTierTypes, htmlTextParticipants) + "</htmlTextInfo>");
            this.sendXMLArray("htmlTextTierNames", htmlTextTierNames, toFlexClient);
            this.sendXMLArray("htmlTextTierTypes", htmlTextTierTypes, toFlexClient);
            this.sendXMLArray("htmlTextParticipants", htmlTextParticipants, toFlexClient);
            HashSet csvTextTierNames = new HashSet();
            HashSet csvTextTierTypes = new HashSet();
            HashSet csvTextParticipants = new HashSet();
            toFlexClient.print("<csvTextSize>" + csvTextNodes.size() + "</csvTextSize><csvTextInfo>" + this.getNameAndTypeInfoFor(rs, csvTextNodes, csvTextTierNames, csvTextTierTypes, csvTextParticipants) + "</csvTextInfo>");
            this.sendXMLArray("csvTextTierNames", csvTextTierNames, toFlexClient);
            this.sendXMLArray("csvTextTierTypes", csvTextTierTypes, toFlexClient);
            this.sendXMLArray("csvTextParticipants", csvTextParticipants, toFlexClient);
            StringBuffer targetModes = new StringBuffer("<targetModes>");
            for (int i = 0; i < Constants.targetModes.length; ++i) {
                targetModes.append("<item>").append(Constants.targetModes[i]).append("</item>");
            }
            targetModes.append("</targetModes>");
            toFlexClient.print(targetModes.toString().replaceAll(" ", "&#32;"));
            StringBuffer caseModes = new StringBuffer("<caseModes>");
            for (int i = 0; i < Constants.caseModes.length; ++i) {
                caseModes.append("<item>").append(Constants.caseModes[i]).append("</item>");
            }
            caseModes.append("</caseModes>");
            toFlexClient.print(caseModes.toString().replaceAll(" ", "&#32;"));
            StringBuffer matchModes = new StringBuffer("<matchModes>");
            for (int i = 0; i < Constants.matchModes.length; ++i) {
                matchModes.append("<item>").append(Constants.matchModes[i]).append("</item>");
            }
            matchModes.append("</matchModes>");
            toFlexClient.print(matchModes.toString().replaceAll(" ", "&#32;"));
            toFlexClient.flush();
            toFlexClient.close();
        }
        catch (RuntimeException re) {
            logger.error("initFlexSearch: RuntimeException: " + re, re);
        }
        catch (SQLException sqle) {
            logger.error("initFlexSearch: SQLException: " + sqle, sqle);
        }
    }

    private void sendXMLArray(String resultTag, HashSet items, ServletOutputStream toFlexClient) throws IOException {
        StringBuffer result = new StringBuffer("<" + resultTag + ">");
        result.ensureCapacity(128);
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            result.append("<item>").append(this.escapeXML((String)iter.next())).append("</item>");
        }
        result.append("</" + resultTag + ">");
        toFlexClient.print(result.toString().replaceAll(" ", "&#32;"));
    }

    private String constructConstantsXML() {
        return "<INIT_CMD>initCMD</INIT_CMD><CREATE_QUERY_CMD>createQueryCMD</CREATE_QUERY_CMD><GET_HITS_CMD>getHitsCMD</GET_HITS_CMD><GET_FREQ_INFO_CMD>getFreqInfoCMD</GET_FREQ_INFO_CMD><GET_VIEW_PARAMETERS_CMD>getViewParametersCMD</GET_VIEW_PARAMETERS_CMD><GET_STATISTICS_CMD>getStatisticsCMD</GET_STATISTICS_CMD><SET_DOMAIN_CMD>setDomainCMD</SET_DOMAIN_CMD><DO_QUERY_CMD>doQueryCMD</DO_QUERY_CMD><CANCEL_QUERY_CMD>cancelQueryCMD</CANCEL_QUERY_CMD><PUT_PERSISTENT_CMD>putPersistentCMD</PUT_PERSISTENT_CMD><GET_PERSISTENT_CMD>getPersistentMD</GET_PERSISTENT_CMD><DELETE_PERSISTENT_CMD>deletePersistentCMD</DELETE_PERSISTENT_CMD><SAVE_HITS_UTF16_CMD>saveHitsUTF16CMD</SAVE_HITS_UTF16_CMD><SAVE_HITS_CMD>saveHitsCMD</SAVE_HITS_CMD><BUSY_SAVING_HITS_CMD>busySavingHitsCMD</BUSY_SAVING_HITS_CMD><SAVE_FREQUENCY_INFO_UTF16_CMD>saveFrequencyInfoUTF16CMD</SAVE_FREQUENCY_INFO_UTF16_CMD><SAVE_FREQUENCY_INFO_CMD>saveFrequencyInfoCMD</SAVE_FREQUENCY_INFO_CMD><CHECK_REGEXP_CMD>checkRegularExpressionCMD</CHECK_REGEXP_CMD><MAX_HITS_TO_BE_VIEWED_OR_SAVED>100000</MAX_HITS_TO_BE_VIEWED_OR_SAVED><MAX_FREQUENCY_ITEMS>100000</MAX_FREQUENCY_ITEMS><SAFE_SPLITTER>xxxSAFE_SPLITTERxxx</SAFE_SPLITTER><MODE_SPLITTER>xxxMODE_SPLITTERxxx</MODE_SPLITTER><LAYER_SPLITTER>xxxLAYER_SPLITTERxxx</LAYER_SPLITTER><NUMBER_SPLITTER>xxxNUMBER_SPLITTERxxx</NUMBER_SPLITTER><ANNOTATIONS> Annotation</ANNOTATIONS><CASE_INSENSITIVE> case insensitive</CASE_INSENSITIVE><SUBSTRING_MATCH> substring match</SUBSTRING_MATCH><SINGLE_TIER_HISTORY_KEY>singleTierHistory</SINGLE_TIER_HISTORY_KEY><MULTIPLE_TIER_HISTORY_KEY>multipleTierHistory</MULTIPLE_TIER_HISTORY_KEY><MAX_TIER_NAMES>300</MAX_TIER_NAMES><MAX_TIER_TYPES>300</MAX_TIER_TYPES><MAX_PARTICIPANTS>300</MAX_PARTICIPANTS><N_GRAMS_OVER_ANNOTATIONS> N-gram over annotations</N_GRAMS_OVER_ANNOTATIONS><N_GRAMS_WITHIN_ANNOTATIONS> N-gram within annotation</N_GRAMS_WITHIN_ANNOTATIONS><CASE_SENSITIVE> case sensitive</CASE_SENSITIVE><EXACT_MATCH> exact match</EXACT_MATCH><REGEXP_MATCH> regular expression</REGEXP_MATCH><ALL_TIERS_LABEL> All Tiers </ALL_TIERS_LABEL><TIER_TYPE_LABEL> Tier Type: </TIER_TYPE_LABEL><TIER_NAME_LABEL> Tier Name: </TIER_NAME_LABEL><TIER_PARTICIPANT_LABEL> Participant: </TIER_PARTICIPANT_LABEL><NULL_STRING>xxxNULL_STRINGxxx</NULL_STRING><N_GRAM_WILDCARD>#</N_GRAM_WILDCARD><CONSTRAINT_SPLITTER>:</CONSTRAINT_SPLITTER><UNDEFINED_CONSTRAINT>XXXX</UNDEFINED_CONSTRAINT><CONSTRAINT_NONE>cns none</CONSTRAINT_NONE><CONSTRAINT_POSITION_EQUAL>cns an=:</CONSTRAINT_POSITION_EQUAL><CONSTRAINT_POSITION_MORE>cns an+:</CONSTRAINT_POSITION_MORE><CONSTRAINT_POSITION_LESS>cns an-:</CONSTRAINT_POSITION_LESS><CONSTRAINT_TIME_EQUAL>cns ms=:</CONSTRAINT_TIME_EQUAL><CONSTRAINT_TIME_MORE>cns ms+:</CONSTRAINT_TIME_MORE><CONSTRAINT_TIME_LESS>cns ms-:</CONSTRAINT_TIME_LESS><CONSTRAINT_ALIGNED>cns aligned</CONSTRAINT_ALIGNED><CONSTRAINT_OVERLAP>cns overlap</CONSTRAINT_OVERLAP><CONSTRAINT_LEFT_OVERLAP>cns l overlap</CONSTRAINT_LEFT_OVERLAP><CONSTRAINT_RIGHT_OVERLAP>cns r overlap</CONSTRAINT_RIGHT_OVERLAP><CONSTRAINT_SURROUNDING>cns surrounding</CONSTRAINT_SURROUNDING><CONSTRAINT_WITHIN>cns within</CONSTRAINT_WITHIN><CONSTRAINT_NO_OVERLAP>cns no overlap</CONSTRAINT_NO_OVERLAP><CONSTRAINT_BEGIN_BEGIN_EQUAL>cns bb=:</CONSTRAINT_BEGIN_BEGIN_EQUAL><CONSTRAINT_BEGIN_BEGIN_MORE>cns bb+:</CONSTRAINT_BEGIN_BEGIN_MORE><CONSTRAINT_BEGIN_BEGIN_LESS>cns bb-:</CONSTRAINT_BEGIN_BEGIN_LESS><CONSTRAINT_BEGIN_END_EQUAL>cns be=:</CONSTRAINT_BEGIN_END_EQUAL><CONSTRAINT_BEGIN_END_MORE>cns be+:</CONSTRAINT_BEGIN_END_MORE><CONSTRAINT_BEGIN_END_LESS>cns be-:</CONSTRAINT_BEGIN_END_LESS><CONSTRAINT_END_BEGIN_EQUAL>cns eb=:</CONSTRAINT_END_BEGIN_EQUAL><CONSTRAINT_END_BEGIN_MORE>cns eb+:</CONSTRAINT_END_BEGIN_MORE><CONSTRAINT_END_BEGIN_LESS>cns eb-:</CONSTRAINT_END_BEGIN_LESS><CONSTRAINT_END_END_EQUAL>cns ee=:</CONSTRAINT_END_END_EQUAL><CONSTRAINT_END_END_MORE>cns ee+:</CONSTRAINT_END_END_MORE><CONSTRAINT_END_END_LESS>cns ee-:</CONSTRAINT_END_END_LESS><COMPLEX_QUERY_INDICATOR>xxxCOMPLEX_QUERY_INDICATORxxx</COMPLEX_QUERY_INDICATOR>";
    }

    private ArrayList getUserDomain(ArrayList domainNodes, String userId) {
        String[] types = SearchClient.getSearchableFormats();
        CorpusStructureDB csdb = AnnexUtil.getCorpusStructureDB();
        HashSet<String> nodeIds = new HashSet<String>();
        if (userId == null || "anonymous".equals(userId) || userId.trim().length() == 0) {
            userId = "everybody";
        }
        for (int i = 0; i < domainNodes.size(); ++i) {
            String nodeId = (String)domainNodes.get(i);
            try {
                if (csdb.getNode(nodeId).getNodeType() == 8) {
                    if (!AnnexUtil.hasAccessTo(userId, nodeId)) continue;
                    nodeIds.add(nodeId);
                    continue;
                }
                String[] desc = csdb.getDescendants(nodeId, 8, types, userId, false);
                nodeIds.addAll(Arrays.asList(desc));
                continue;
            }
            catch (UnknownNodeException une) {
                logger.warn("Skipped bad (unlinked, nameless or non-existing) top node: " + nodeId);
                continue;
            }
            catch (RuntimeException re) {
                logger.warn("Skipped top node with bad node ID: " + nodeId);
            }
        }
        return new ArrayList(nodeIds);
    }

    private ArrayList keepIndexedNodes(ArrayList nodeIds, int type) {
        ArrayList filteredNodes = new ArrayList();
        try {
            HashSet<String> ingestedNodes = new HashSet<String>();
            String query = "select node_id from search.tiers where transcription_type = " + type;
            ResultSet rs = searchClient.executeSQLQuery(query);
            while (rs.next()) {
                String nodeId = rs.getString(1);
                ingestedNodes.add(nodeId);
            }
            for (int i = 0; i < nodeIds.size(); ++i) {
                if (!ingestedNodes.contains(nodeIds.get(i))) continue;
                filteredNodes.add(nodeIds.get(i));
            }
        }
        catch (RuntimeException re) {
            logger.error("keepIndexedNodes: " + re, re);
        }
        catch (SQLException sqle) {
            logger.error("keepIndexedNodes: " + sqle, sqle);
        }
        return filteredNodes;
    }

    private String getNameAndTypeInfoFor(ResultSet rs, ArrayList nodeIds, HashSet tierNames, HashSet tierTypes, HashSet participants) {
        HashSet nodeIdSet = new HashSet(nodeIds);
        tierNames.clear();
        tierTypes.clear();
        participants.clear();
        long sumAnnotations = 0L;
        String retval = "No data!";
        if (rs == null) {
            return retval;
        }
        try {
            boolean n = false;
            rs.beforeFirst();
            while (rs.next()) {
                String participant;
                String tierType;
                String nodeId = rs.getString(1);
                if (!nodeIdSet.contains(nodeId)) continue;
                String tierName = rs.getString(2);
                if (tierName != null && tierName.length() > 0) {
                    tierNames.add(tierName);
                }
                if ((tierType = rs.getString(3)) != null && tierType.length() > 0) {
                    tierTypes.add(tierType);
                }
                if ((participant = rs.getString(4)) != null && participant.length() > 0) {
                    participants.add(participant);
                }
                int n_annotations = rs.getInt(5);
                sumAnnotations += (long)n_annotations;
            }
            retval = "" + nodeIdSet.size() + " nodes, " + sumAnnotations + " annotations, " + participants.size() + " participants, " + tierNames.size() + " tier names, " + tierTypes.size() + " tier types";
            if (tierNames.size() > 300) {
                tierNames.clear();
            }
            if (tierTypes.size() > 300) {
                tierTypes.clear();
            }
            if (participants.size() > 300) {
                participants.clear();
            }
        }
        catch (RuntimeException re) {
            logger.error("getNameAndTypeInfoFor: RuntimeException: " + re, re);
        }
        catch (SQLException sqle) {
            logger.error("getNameAndTypeInfoFor: SQLException: " + sqle, sqle);
        }
        return retval;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    private void setSessionAttribute(HttpSession session, String attributeName, String domainId, Object attribute) {
        session.setAttribute(attributeName + domainId, attribute);
    }

    private Object getSessionAttribute(HttpSession session, String attributeName, String domainId) {
        return session.getAttribute(attributeName + domainId);
    }

    static {
        searchClient = null;
    }
}

