/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.swingsearch;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import mpi.annex.search.Constants;
import mpi.annex.swingsearch.SearchDomainPanel;
import mpi.annex.swingsearch.SearchHistoryPanel;
import mpi.annex.swingsearch.SearchListener;
import mpi.annex.swingsearch.SearchMediator;
import mpi.annex.swingsearch.SearchResultPanel;
import mpi.annex.swingsearch.SearchUtil;

public class MultipleLayerSearchPanel
extends JPanel
implements SearchListener,
ActionListener {
    private SearchMediator mediator;
    private Color backgroundColor;
    private String queryId;
    private SearchDomainPanel domainPanel;
    private SearchResultPanel resultPanel;
    private JButton findButton;
    private JButton clearButton;
    private String[] targetModes;
    private String[] caseModes;
    private String[] matchModes;
    private JComboBox targetModeChooser;
    private JComboBox caseModeChooser;
    private JComboBox matchModeChooser;
    private JTextField patternField_1;
    private JTextField patternField_2;
    private JTextField patternField_3;
    private JTextField patternField_4;
    private JTextField patternField_5;
    private JTextField patternField_6;
    private JTextField patternField_7;
    private JTextField patternField_8;
    private JTextField patternField_9;
    private ConstraintLabel relation_1_2;
    private ConstraintLabel relation_1_4;
    private ConstraintLabel relation_2_3;
    private ConstraintLabel relation_2_5;
    private ConstraintLabel relation_3_6;
    private ConstraintLabel relation_4_5;
    private ConstraintLabel relation_4_7;
    private ConstraintLabel relation_5_6;
    private ConstraintLabel relation_5_8;
    private ConstraintLabel relation_6_9;
    private ConstraintLabel relation_7_8;
    private ConstraintLabel relation_8_9;
    private JComboBox layer1Tiers;
    private JComboBox layer2Tiers;
    private JComboBox layer3Tiers;
    private JLabel popupSource;
    private JPopupMenu horizontalRelations;
    private JPopupMenu verticalRelations;
    private JMenuItem hAnnEqual;
    private JMenuItem hAnnMore;
    private JMenuItem hAnnLess;
    private JMenuItem hMilEqual;
    private JMenuItem hMilMore;
    private JMenuItem hMilLess;
    private JMenuItem hNoConstraint;
    private JMenuItem hClear;
    private JMenuItem vFullyAligned;
    private JMenuItem vOverlap;
    private JMenuItem vLeftOverlap;
    private JMenuItem vRightOverlap;
    private JMenuItem vSurrounding;
    private JMenuItem vWithin;
    private JMenuItem vNoOverlap;
    private JMenuItem vBeginBeginEqual;
    private JMenuItem vBeginBeginLess;
    private JMenuItem vBeginBeginMore;
    private JMenuItem vBeginEndEqual;
    private JMenuItem vBeginEndLess;
    private JMenuItem vBeginEndMore;
    private JMenuItem vEndBeginEqual;
    private JMenuItem vEndBeginLess;
    private JMenuItem vEndBeginMore;
    private JMenuItem vEndEndEqual;
    private JMenuItem vEndEndLess;
    private JMenuItem vEndEndMore;
    private JMenuItem vNoConstraint;
    private JMenuItem vClear;
    private SearchHistoryPanel historyPanel;
    private JButton minDurationButton;
    private JButton maxDurationButton;
    private JButton beginAfterButton;
    private JButton endBeforeButton;
    private long minimalDuration;
    private long maximalDuration;
    private long beginAfter;
    private long endBefore;

    public MultipleLayerSearchPanel(SearchMediator mediator) {
        int j;
        this.mediator = mediator;
        this.backgroundColor = mediator.getBackgroundColor();
        this.setBackground(this.backgroundColor);
        this.queryId = mediator.createQuery();
        this.setLayout(new BorderLayout());
        JPanel definitionPanel = new JPanel();
        definitionPanel.setLayout(new BoxLayout(definitionPanel, 1));
        definitionPanel.setBackground(this.backgroundColor);
        this.add((Component)definitionPanel, "North");
        this.domainPanel = new SearchDomainPanel(mediator, this.queryId, this);
        definitionPanel.add(this.domainPanel);
        definitionPanel.add(Box.createVerticalStrut(20));
        this.historyPanel = new SearchHistoryPanel(this, this.backgroundColor);
        this.historyPanel.setHistory(mediator.getPersistent("multipleTierHistory"));
        definitionPanel.add(this.historyPanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        JPanel modePanel = new JPanel();
        modePanel.setBackground(this.backgroundColor);
        modePanel.setLayout(new BoxLayout(modePanel, 0));
        JLabel modeLabel = new JLabel("Mode:");
        modeLabel.setFont(Constants.bigBoldFont);
        modePanel.add(Box.createHorizontalStrut(5));
        modePanel.add(modeLabel);
        modePanel.add(Box.createHorizontalStrut(10));
        ArrayList searchModes = mediator.getSearchModes(this.queryId);
        int i = 0;
        int nTargetModes = Integer.parseInt((String)searchModes.get(i));
        this.targetModes = new String[nTargetModes];
        for (int j2 = 0; j2 < nTargetModes; ++j2) {
            this.targetModes[j2] = (String)searchModes.get(++i);
        }
        this.targetModeChooser = new JComboBox<String>(this.targetModes);
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.targetModeChooser.setBackground(this.backgroundColor);
        }
        modePanel.add(Box.createHorizontalStrut(5));
        int nCaseModes = Integer.parseInt((String)searchModes.get(++i));
        this.caseModes = new String[nCaseModes];
        for (int j3 = 0; j3 < nCaseModes; ++j3) {
            this.caseModes[j3] = (String)searchModes.get(++i);
        }
        this.caseModeChooser = new JComboBox<String>(this.caseModes);
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.caseModeChooser.setBackground(this.backgroundColor);
        }
        modePanel.add(this.caseModeChooser);
        modePanel.add(Box.createHorizontalStrut(5));
        int nMatchModes = Integer.parseInt((String)searchModes.get(++i));
        this.matchModes = new String[nMatchModes];
        for (j = 0; j < nMatchModes; ++j) {
            this.matchModes[j] = (String)searchModes.get(++i);
        }
        this.matchModeChooser = new JComboBox();
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.matchModeChooser.setBackground(this.backgroundColor);
        }
        for (j = 0; j < this.matchModes.length; ++j) {
            this.matchModeChooser.addItem(this.matchModes[j]);
        }
        modePanel.add(this.matchModeChooser);
        this.clearButton = new JButton("Clear");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.clearButton.setBackground(this.backgroundColor);
        }
        this.clearButton.addActionListener(this);
        modePanel.add(Box.createHorizontalGlue());
        modePanel.add(this.clearButton);
        modePanel.add(Box.createHorizontalStrut(30));
        definitionPanel.add(modePanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        JPanel timeButtonPanel = new JPanel();
        timeButtonPanel.setBackground(this.backgroundColor);
        timeButtonPanel.setLayout(new BoxLayout(timeButtonPanel, 0));
        timeButtonPanel.add(Box.createHorizontalStrut(30));
        this.minDurationButton = new JButton("Minimal Duration");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.minDurationButton.setBackground(this.backgroundColor);
        }
        this.minDurationButton.addActionListener(this);
        timeButtonPanel.add(this.minDurationButton);
        timeButtonPanel.add(Box.createHorizontalStrut(15));
        this.maxDurationButton = new JButton("Maximal Duration");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.maxDurationButton.setBackground(this.backgroundColor);
        }
        this.maxDurationButton.addActionListener(this);
        timeButtonPanel.add(this.maxDurationButton);
        timeButtonPanel.add(Box.createHorizontalStrut(15));
        this.beginAfterButton = new JButton("Begin After");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.beginAfterButton.setBackground(this.backgroundColor);
        }
        this.beginAfterButton.addActionListener(this);
        timeButtonPanel.add(this.beginAfterButton);
        timeButtonPanel.add(Box.createHorizontalStrut(15));
        this.endBeforeButton = new JButton("End Before");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.endBeforeButton.setBackground(this.backgroundColor);
        }
        this.endBeforeButton.addActionListener(this);
        timeButtonPanel.add(this.endBeforeButton);
        timeButtonPanel.add(Box.createHorizontalGlue());
        definitionPanel.add(timeButtonPanel);
        definitionPanel.add(Box.createVerticalStrut(20));
        JPanel patternPanel = new JPanel();
        patternPanel.setLayout(new BoxLayout(patternPanel, 0));
        patternPanel.setBackground(this.backgroundColor);
        definitionPanel.add(patternPanel);
        patternPanel.add(Box.createHorizontalStrut(30));
        JPanel column1 = new JPanel();
        column1.setLayout(new GridLayout(0, 1, 0, 6));
        column1.setBackground(this.backgroundColor);
        patternPanel.add(column1);
        patternPanel.add(Box.createHorizontalStrut(5));
        JPanel column2 = new JPanel();
        column2.setLayout(new GridLayout(0, 1, 0, 6));
        column2.setBackground(this.backgroundColor);
        patternPanel.add(column2);
        patternPanel.add(Box.createHorizontalStrut(5));
        JPanel column3 = new JPanel();
        column3.setLayout(new GridLayout(0, 1, 0, 6));
        column3.setBackground(this.backgroundColor);
        patternPanel.add(column3);
        patternPanel.add(Box.createHorizontalStrut(5));
        JPanel column4 = new JPanel();
        column4.setLayout(new GridLayout(0, 1, 0, 6));
        column4.setBackground(this.backgroundColor);
        patternPanel.add(column4);
        patternPanel.add(Box.createHorizontalStrut(5));
        JPanel column5 = new JPanel();
        column5.setLayout(new GridLayout(0, 1, 0, 6));
        column5.setBackground(this.backgroundColor);
        patternPanel.add(column5);
        patternPanel.add(Box.createHorizontalStrut(20));
        JPanel column6 = new JPanel();
        column6.setLayout(new GridLayout(0, 1, 0, 6));
        column6.setBackground(this.backgroundColor);
        patternPanel.add(column6);
        patternPanel.add(Box.createHorizontalStrut(30));
        Border border = BorderFactory.createEtchedBorder(1);
        MouseHandler mouseHandler = new MouseHandler();
        this.patternField_1 = new JTextField(10);
        this.patternField_1.setFont(Constants.normalFont);
        this.patternField_1.setHorizontalAlignment(0);
        column1.add(this.patternField_1);
        this.relation_1_4 = new ConstraintLabel();
        this.relation_1_4.setHorizontalAlignment(0);
        this.relation_1_4.setBorder(border);
        this.relation_1_4.addMouseListener(mouseHandler);
        column1.add(this.relation_1_4);
        this.patternField_4 = new JTextField(10);
        this.patternField_4.setFont(Constants.normalFont);
        this.patternField_4.setHorizontalAlignment(0);
        column1.add(this.patternField_4);
        this.relation_4_7 = new ConstraintLabel();
        this.relation_4_7.setHorizontalAlignment(0);
        this.relation_4_7.setBorder(border);
        this.relation_4_7.addMouseListener(mouseHandler);
        column1.add(this.relation_4_7);
        this.patternField_7 = new JTextField(10);
        this.patternField_7.setFont(Constants.normalFont);
        this.patternField_7.setHorizontalAlignment(0);
        column1.add(this.patternField_7);
        column1.add(Box.createHorizontalStrut(120));
        this.relation_1_2 = new ConstraintLabel();
        this.relation_1_2.setHorizontalAlignment(0);
        this.relation_1_2.setBorder(border);
        this.relation_1_2.addMouseListener(mouseHandler);
        column2.add(this.relation_1_2);
        column2.add(Box.createHorizontalStrut(1));
        this.relation_4_5 = new ConstraintLabel();
        this.relation_4_5.addMouseListener(mouseHandler);
        this.relation_4_5.setHorizontalAlignment(0);
        this.relation_4_5.setBorder(border);
        column2.add(this.relation_4_5);
        column2.add(Box.createHorizontalStrut(1));
        this.relation_7_8 = new ConstraintLabel();
        this.relation_7_8.addMouseListener(mouseHandler);
        this.relation_7_8.setHorizontalAlignment(0);
        this.relation_7_8.setBorder(border);
        column2.add(this.relation_7_8);
        column2.add(Box.createHorizontalStrut(30));
        this.patternField_2 = new JTextField(10);
        this.patternField_2.setFont(Constants.normalFont);
        this.patternField_2.setHorizontalAlignment(0);
        column3.add(this.patternField_2);
        this.relation_2_5 = new ConstraintLabel();
        this.relation_2_5.setHorizontalAlignment(0);
        this.relation_2_5.setBorder(border);
        this.relation_2_5.addMouseListener(mouseHandler);
        column3.add(this.relation_2_5);
        this.patternField_5 = new JTextField(10);
        this.patternField_5.setFont(Constants.normalFont);
        this.patternField_5.setHorizontalAlignment(0);
        column3.add(this.patternField_5);
        this.relation_5_8 = new ConstraintLabel();
        this.relation_5_8.setHorizontalAlignment(0);
        this.relation_5_8.setBorder(border);
        this.relation_5_8.addMouseListener(mouseHandler);
        column3.add(this.relation_5_8);
        this.patternField_8 = new JTextField(10);
        this.patternField_8.setFont(Constants.normalFont);
        this.patternField_8.setHorizontalAlignment(0);
        column3.add(this.patternField_8);
        column3.add(Box.createHorizontalStrut(120));
        this.relation_2_3 = new ConstraintLabel();
        this.relation_2_3.addMouseListener(mouseHandler);
        this.relation_2_3.setHorizontalAlignment(0);
        this.relation_2_3.setBorder(border);
        column4.add(this.relation_2_3);
        column4.add(Box.createHorizontalStrut(1));
        this.relation_5_6 = new ConstraintLabel();
        this.relation_5_6.addMouseListener(mouseHandler);
        this.relation_5_6.setHorizontalAlignment(0);
        this.relation_5_6.setBorder(border);
        column4.add(this.relation_5_6);
        column4.add(Box.createHorizontalStrut(1));
        this.relation_8_9 = new ConstraintLabel();
        this.relation_8_9.addMouseListener(mouseHandler);
        this.relation_8_9.setHorizontalAlignment(0);
        this.relation_8_9.setBorder(border);
        column4.add(this.relation_8_9);
        column4.add(Box.createHorizontalStrut(30));
        this.patternField_3 = new JTextField(10);
        this.patternField_3.setFont(Constants.normalFont);
        this.patternField_3.setHorizontalAlignment(0);
        column5.add(this.patternField_3);
        this.relation_3_6 = new ConstraintLabel();
        this.relation_3_6.setHorizontalAlignment(0);
        this.relation_3_6.setBorder(border);
        this.relation_3_6.addMouseListener(mouseHandler);
        column5.add(this.relation_3_6);
        this.patternField_6 = new JTextField(10);
        this.patternField_6.setFont(Constants.normalFont);
        this.patternField_6.setHorizontalAlignment(0);
        column5.add(this.patternField_6);
        this.relation_6_9 = new ConstraintLabel();
        this.relation_6_9.setHorizontalAlignment(0);
        this.relation_6_9.setBorder(border);
        this.relation_6_9.addMouseListener(mouseHandler);
        column5.add(this.relation_6_9);
        this.patternField_9 = new JTextField(10);
        this.patternField_9.setFont(Constants.normalFont);
        this.patternField_9.setHorizontalAlignment(0);
        column5.add(this.patternField_9);
        column5.add(Box.createHorizontalStrut(120));
        Dimension comboSize = new Dimension(200, 28);
        this.layer1Tiers = new JComboBox();
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.layer1Tiers.setBackground(this.backgroundColor);
        }
        this.layer1Tiers.setMaximumRowCount(20);
        this.layer1Tiers.setPreferredSize(comboSize);
        this.layer2Tiers = new JComboBox();
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.layer2Tiers.setBackground(this.backgroundColor);
        }
        this.layer2Tiers.setMaximumRowCount(20);
        this.layer2Tiers.setPreferredSize(comboSize);
        this.layer3Tiers = new JComboBox();
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.layer3Tiers.setBackground(this.backgroundColor);
        }
        this.layer3Tiers.setMaximumRowCount(20);
        this.layer3Tiers.setPreferredSize(comboSize);
        column6.add(this.layer1Tiers);
        column6.add(Box.createVerticalStrut(32));
        column6.add(this.layer2Tiers);
        column6.add(Box.createVerticalStrut(32));
        column6.add(this.layer3Tiers);
        column6.add(Box.createHorizontalStrut(150));
        JPanel findPanel = new JPanel();
        findPanel.setLayout(new BoxLayout(findPanel, 0));
        findPanel.setBackground(this.backgroundColor);
        this.findButton = new JButton("Find");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.findButton.setBackground(this.backgroundColor);
        }
        this.findButton.addActionListener(this);
        findPanel.add(Box.createHorizontalStrut(30));
        findPanel.add(this.findButton);
        findPanel.add(Box.createHorizontalGlue());
        findPanel.add(Box.createHorizontalStrut(30));
        definitionPanel.add(findPanel);
        definitionPanel.add(Box.createVerticalStrut(10));
        this.resultPanel = new SearchResultPanel(mediator, this.queryId);
        this.add((Component)this.resultPanel, "Center");
        this.horizontalRelations = new JPopupMenu();
        this.hAnnEqual = new JMenuItem("= N annotations");
        this.hAnnEqual.addActionListener(this);
        this.horizontalRelations.add(this.hAnnEqual);
        this.hAnnMore = new JMenuItem("> N annotations");
        this.hAnnMore.addActionListener(this);
        this.horizontalRelations.add(this.hAnnMore);
        this.hAnnLess = new JMenuItem("< N annotations");
        this.hAnnLess.addActionListener(this);
        this.horizontalRelations.add(this.hAnnLess);
        this.horizontalRelations.addSeparator();
        this.hMilEqual = new JMenuItem("= X milliseconds");
        this.hMilEqual.addActionListener(this);
        this.horizontalRelations.add(this.hMilEqual);
        this.hMilMore = new JMenuItem("> X milliseconds");
        this.hMilMore.addActionListener(this);
        this.horizontalRelations.add(this.hMilMore);
        this.hMilLess = new JMenuItem("< X milliseconds");
        this.hMilLess.addActionListener(this);
        this.horizontalRelations.add(this.hMilLess);
        this.horizontalRelations.addSeparator();
        this.hNoConstraint = new JMenuItem("No constraint");
        this.hNoConstraint.addActionListener(this);
        this.horizontalRelations.add(this.hNoConstraint);
        this.hClear = new JMenuItem("Clear");
        this.hClear.addActionListener(this);
        this.horizontalRelations.add(this.hClear);
        this.verticalRelations = new JPopupMenu();
        this.vFullyAligned = new JMenuItem("Fully aligned");
        this.vFullyAligned.addActionListener(this);
        this.verticalRelations.add(this.vFullyAligned);
        this.vOverlap = new JMenuItem("Overlap");
        this.vOverlap.addActionListener(this);
        this.verticalRelations.add(this.vOverlap);
        this.vLeftOverlap = new JMenuItem("Left overlap");
        this.vLeftOverlap.addActionListener(this);
        this.verticalRelations.add(this.vLeftOverlap);
        this.vRightOverlap = new JMenuItem("Right overlap");
        this.vRightOverlap.addActionListener(this);
        this.verticalRelations.add(this.vRightOverlap);
        this.vSurrounding = new JMenuItem("Surrounding");
        this.vSurrounding.addActionListener(this);
        this.verticalRelations.add(this.vSurrounding);
        this.vWithin = new JMenuItem("Within");
        this.vWithin.addActionListener(this);
        this.verticalRelations.add(this.vWithin);
        this.vNoOverlap = new JMenuItem("No overlap");
        this.vNoOverlap.addActionListener(this);
        this.verticalRelations.add(this.vNoOverlap);
        this.verticalRelations.addSeparator();
        this.vBeginBeginEqual = new JMenuItem("begin time - begin time = X msec");
        this.vBeginBeginEqual.addActionListener(this);
        this.verticalRelations.add(this.vBeginBeginEqual);
        this.vBeginBeginLess = new JMenuItem("begin time - begin time < X msec");
        this.vBeginBeginLess.addActionListener(this);
        this.verticalRelations.add(this.vBeginBeginLess);
        this.vBeginBeginMore = new JMenuItem("begin time - begin time > X msec");
        this.vBeginBeginMore.addActionListener(this);
        this.verticalRelations.add(this.vBeginBeginMore);
        this.verticalRelations.addSeparator();
        this.vBeginEndEqual = new JMenuItem("begin time - end time = X msec");
        this.vBeginEndEqual.addActionListener(this);
        this.verticalRelations.add(this.vBeginEndEqual);
        this.vBeginEndLess = new JMenuItem("begin time - end time < X msec");
        this.vBeginEndLess.addActionListener(this);
        this.verticalRelations.add(this.vBeginEndLess);
        this.vBeginEndMore = new JMenuItem("begin time - end time > X msec");
        this.vBeginEndMore.addActionListener(this);
        this.verticalRelations.add(this.vBeginEndMore);
        this.verticalRelations.addSeparator();
        this.vEndBeginEqual = new JMenuItem("end time - begin time = X msec");
        this.vEndBeginEqual.addActionListener(this);
        this.verticalRelations.add(this.vEndBeginEqual);
        this.vEndBeginLess = new JMenuItem("end time - begin time < X msec");
        this.vEndBeginLess.addActionListener(this);
        this.verticalRelations.add(this.vEndBeginLess);
        this.vEndBeginMore = new JMenuItem("end time - begin time > X msec");
        this.vEndBeginMore.addActionListener(this);
        this.verticalRelations.add(this.vEndBeginMore);
        this.verticalRelations.addSeparator();
        this.vEndEndEqual = new JMenuItem("end time - end time = X msec");
        this.vEndEndEqual.addActionListener(this);
        this.verticalRelations.add(this.vEndEndEqual);
        this.vEndEndLess = new JMenuItem("end time - end time < X msec");
        this.vEndEndLess.addActionListener(this);
        this.verticalRelations.add(this.vEndEndLess);
        this.vEndEndMore = new JMenuItem("end time - end time > X msec");
        this.vEndEndMore.addActionListener(this);
        this.verticalRelations.add(this.vEndEndMore);
        this.verticalRelations.addSeparator();
        this.vNoConstraint = new JMenuItem("No constraint");
        this.vNoConstraint.addActionListener(this);
        this.verticalRelations.add(this.vNoConstraint);
        this.vClear = new JMenuItem("Clear");
        this.vClear.addActionListener(this);
        this.verticalRelations.add(this.vClear);
        Vector<JTextField> order = new Vector<JTextField>();
        order.add(this.patternField_1);
        order.add(this.patternField_2);
        order.add(this.patternField_3);
        order.add(this.patternField_4);
        order.add(this.patternField_5);
        order.add(this.patternField_6);
        order.add(this.patternField_7);
        order.add(this.patternField_8);
        order.add(this.patternField_9);
        try {
            Method sftppMethod = Container.class.getDeclaredMethod("setFocusTraversalPolicyProvider", Boolean.TYPE);
            if (sftppMethod != null) {
                sftppMethod.invoke((Object)this, new Boolean(true));
            }
        }
        catch (InvocationTargetException ite) {
            System.out.println("Cannot set traversal policy: InvocationTargetException " + ite);
        }
        catch (NoSuchMethodException nsme) {
            System.out.println("Cannot set traversal policy: NoSuchMethodException " + nsme);
        }
        catch (IllegalAccessException iae) {
            System.out.println("Cannot set traversal policy: IllegalAccessException " + iae);
        }
        this.setFocusTraversalPolicy(new MyOwnFocusTraversalPolicy(order));
    }

    public void fillTierConstraintsCombos() {
        while (this.layer1Tiers == null || this.layer2Tiers == null || this.layer3Tiers == null) {
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {}
        }
        this.layer1Tiers.removeAllItems();
        this.layer1Tiers.addItem(" All Tiers ");
        this.layer2Tiers.removeAllItems();
        this.layer2Tiers.addItem(" All Tiers ");
        this.layer3Tiers.removeAllItems();
        this.layer3Tiers.addItem(" All Tiers ");
        ArrayList tierTypes = this.mediator.getTierTypes(this.queryId);
        for (int i = 0; i < tierTypes.size(); ++i) {
            this.layer1Tiers.addItem(" Tier Type: " + tierTypes.get(i));
            this.layer2Tiers.addItem(" Tier Type: " + tierTypes.get(i));
            this.layer3Tiers.addItem(" Tier Type: " + tierTypes.get(i));
        }
        ArrayList participants = this.mediator.getParticipants(this.queryId);
        for (int i = 0; i < participants.size(); ++i) {
            this.layer1Tiers.addItem(" Participant: " + participants.get(i));
            this.layer2Tiers.addItem(" Participant: " + participants.get(i));
            this.layer3Tiers.addItem(" Participant: " + participants.get(i));
        }
        ArrayList tierNames = this.mediator.getTierNames(this.queryId);
        for (int i = 0; i < tierNames.size(); ++i) {
            this.layer1Tiers.addItem(" Tier Name: " + tierNames.get(i));
            this.layer2Tiers.addItem(" Tier Name: " + tierNames.get(i));
            this.layer3Tiers.addItem(" Tier Name: " + tierNames.get(i));
        }
    }

    public void domainChanged() {
        this.resetPatterns();
        this.resetRelations();
        this.fillTierConstraintsCombos();
        this.validate();
    }

    public void queryStopped() {
    }

    public void setQuery(String savedQuery) {
        String[] q = savedQuery.split("xxxSAFE_SPLITTERxxx");
        this.caseModeChooser.setSelectedItem(q[1]);
        this.matchModeChooser.setSelectedItem(q[2]);
        this.patternField_1.setText(q[3]);
        this.patternField_2.setText(q[4]);
        this.patternField_3.setText(q[5]);
        this.patternField_4.setText(q[6]);
        this.patternField_5.setText(q[7]);
        this.patternField_6.setText(q[8]);
        this.patternField_7.setText(q[9]);
        this.patternField_8.setText(q[10]);
        this.patternField_9.setText(q[11]);
        this.relation_1_2.setText(q[12]);
        this.relation_1_2.constraint = q[13];
        this.relation_2_3.setText(q[14]);
        this.relation_2_3.constraint = q[15];
        this.relation_4_5.setText(q[16]);
        this.relation_4_5.constraint = q[17];
        this.relation_5_6.setText(q[18]);
        this.relation_5_6.constraint = q[19];
        this.relation_7_8.setText(q[20]);
        this.relation_7_8.constraint = q[21];
        this.relation_8_9.setText(q[22]);
        this.relation_8_9.constraint = q[23];
        this.relation_1_4.setText(q[24]);
        this.relation_1_4.constraint = q[25];
        this.relation_2_5.setText(q[26]);
        this.relation_2_5.constraint = q[27];
        this.relation_3_6.setText(q[28]);
        this.relation_3_6.constraint = q[29];
        this.relation_4_7.setText(q[30]);
        this.relation_4_7.constraint = q[31];
        this.relation_5_8.setText(q[32]);
        this.relation_5_8.constraint = q[33];
        this.relation_6_9.setText(q[34]);
        this.relation_6_9.constraint = q[35];
        this.layer1Tiers.setSelectedItem(q[36]);
        this.layer2Tiers.setSelectedItem(q[37]);
        this.layer3Tiers.setSelectedItem(q[38]);
        String[] times = q[39].split(":");
        this.minimalDuration = Long.parseLong(times[0]);
        if (this.minimalDuration <= 0L) {
            this.minDurationButton.setText("Minimal Duration");
            this.minimalDuration = 0L;
        } else if (this.minimalDuration > 0L) {
            this.minDurationButton.setText("Minimal Duration: " + SearchUtil.formatShortTimeString(this.minimalDuration));
        }
        this.maximalDuration = Long.parseLong(times[1]);
        if (this.maximalDuration <= 0L) {
            this.maxDurationButton.setText("Maximal Duration");
            this.maximalDuration = 0L;
        } else if (this.maximalDuration > 0L) {
            this.maxDurationButton.setText("Maximal Duration: " + SearchUtil.formatShortTimeString(this.maximalDuration));
        }
        this.beginAfter = Long.parseLong(times[2]);
        if (this.beginAfter <= 0L) {
            this.beginAfterButton.setText("Begin After");
            this.beginAfter = 0L;
        } else if (this.beginAfter > 0L) {
            this.beginAfterButton.setText("Begin After: " + SearchUtil.formatShortTimeString(this.beginAfter));
        }
        this.endBefore = Long.parseLong(times[3]);
        if (this.endBefore <= 0L) {
            this.endBeforeButton.setText("End Before");
            this.endBefore = 0L;
        } else if (this.endBefore > 0L) {
            this.endBeforeButton.setText("End Before: " + SearchUtil.formatShortTimeString(this.endBefore));
        }
    }

    public String makeSaveableQuery() {
        return "xxxSAFE_SPLITTERxxx" + (String)this.caseModeChooser.getSelectedItem() + "xxxSAFE_SPLITTERxxx" + (String)this.matchModeChooser.getSelectedItem() + "xxxSAFE_SPLITTERxxx" + this.patternField_1.getText() + "xxxSAFE_SPLITTERxxx" + this.patternField_2.getText() + "xxxSAFE_SPLITTERxxx" + this.patternField_3.getText() + "xxxSAFE_SPLITTERxxx" + this.patternField_4.getText() + "xxxSAFE_SPLITTERxxx" + this.patternField_5.getText() + "xxxSAFE_SPLITTERxxx" + this.patternField_6.getText() + "xxxSAFE_SPLITTERxxx" + this.patternField_7.getText() + "xxxSAFE_SPLITTERxxx" + this.patternField_8.getText() + "xxxSAFE_SPLITTERxxx" + this.patternField_9.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_1_2.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_1_2.constraint + "xxxSAFE_SPLITTERxxx" + this.relation_2_3.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_2_3.constraint + "xxxSAFE_SPLITTERxxx" + this.relation_4_5.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_4_5.constraint + "xxxSAFE_SPLITTERxxx" + this.relation_5_6.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_5_6.constraint + "xxxSAFE_SPLITTERxxx" + this.relation_7_8.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_7_8.constraint + "xxxSAFE_SPLITTERxxx" + this.relation_8_9.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_8_9.constraint + "xxxSAFE_SPLITTERxxx" + this.relation_1_4.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_1_4.constraint + "xxxSAFE_SPLITTERxxx" + this.relation_2_5.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_2_5.constraint + "xxxSAFE_SPLITTERxxx" + this.relation_3_6.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_3_6.constraint + "xxxSAFE_SPLITTERxxx" + this.relation_4_7.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_4_7.constraint + "xxxSAFE_SPLITTERxxx" + this.relation_5_8.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_5_8.constraint + "xxxSAFE_SPLITTERxxx" + this.relation_6_9.getText() + "xxxSAFE_SPLITTERxxx" + this.relation_6_9.constraint + "xxxSAFE_SPLITTERxxx" + this.layer1Tiers.getSelectedItem() + "xxxSAFE_SPLITTERxxx" + this.layer2Tiers.getSelectedItem() + "xxxSAFE_SPLITTERxxx" + this.layer3Tiers.getSelectedItem() + "xxxSAFE_SPLITTERxxx" + this.minimalDuration + ":" + this.maximalDuration + ":" + this.beginAfter + ":" + this.endBefore;
    }

    private String encodeQuery() {
        String mode = " AnnotationxxxMODE_SPLITTERxxx" + (String)this.caseModeChooser.getSelectedItem() + "xxxMODE_SPLITTERxxx" + (String)this.matchModeChooser.getSelectedItem();
        String query = this.minimalDuration + "," + this.maximalDuration + "," + this.beginAfter + "," + this.endBefore + "," + "3, 3, 1, 1, 1" + "xxxSAFE_SPLITTERxxx";
        query = query + this.patternField_1.getText() + "xxxSAFE_SPLITTERxxx" + mode + "xxxSAFE_SPLITTERxxx";
        query = query + this.relation_1_2.constraint + "xxxSAFE_SPLITTERxxx";
        query = query + this.relation_1_4.constraint + "xxxSAFE_SPLITTERxxx";
        query = query + this.patternField_2.getText() + "xxxSAFE_SPLITTERxxx" + mode + "xxxSAFE_SPLITTERxxx";
        query = query + this.relation_2_3.constraint + "xxxSAFE_SPLITTERxxx";
        query = query + this.relation_2_5.constraint + "xxxSAFE_SPLITTERxxx";
        query = query + this.patternField_3.getText() + "xxxSAFE_SPLITTERxxx" + mode + "xxxSAFE_SPLITTERxxx";
        query = query + "cns nonexxxSAFE_SPLITTERxxx";
        query = query + this.relation_3_6.constraint + "xxxSAFE_SPLITTERxxx";
        query = query + this.layer1Tiers.getSelectedItem() + "xxxSAFE_SPLITTERxxx";
        query = query + this.patternField_4.getText() + "xxxSAFE_SPLITTERxxx" + mode + "xxxSAFE_SPLITTERxxx";
        query = query + this.relation_4_5.constraint + "xxxSAFE_SPLITTERxxx";
        query = query + this.relation_4_7.constraint + "xxxSAFE_SPLITTERxxx";
        query = query + this.patternField_5.getText() + "xxxSAFE_SPLITTERxxx" + mode + "xxxSAFE_SPLITTERxxx";
        query = query + this.relation_5_6.constraint + "xxxSAFE_SPLITTERxxx";
        query = query + this.relation_5_8.constraint + "xxxSAFE_SPLITTERxxx";
        query = query + this.patternField_6.getText() + "xxxSAFE_SPLITTERxxx" + mode + "xxxSAFE_SPLITTERxxx";
        query = query + "cns nonexxxSAFE_SPLITTERxxx";
        query = query + this.relation_6_9.constraint + "xxxSAFE_SPLITTERxxx";
        query = query + this.layer2Tiers.getSelectedItem() + "xxxSAFE_SPLITTERxxx";
        query = query + this.patternField_7.getText() + "xxxSAFE_SPLITTERxxx" + mode + "xxxSAFE_SPLITTERxxx";
        query = query + this.relation_7_8.constraint + "xxxSAFE_SPLITTERxxx";
        query = query + "cns nonexxxSAFE_SPLITTERxxx";
        query = query + this.patternField_8.getText() + "xxxSAFE_SPLITTERxxx" + mode + "xxxSAFE_SPLITTERxxx";
        query = query + this.relation_8_9.constraint + "xxxSAFE_SPLITTERxxx";
        query = query + "cns nonexxxSAFE_SPLITTERxxx";
        query = query + this.patternField_9.getText() + "xxxSAFE_SPLITTERxxx" + mode + "xxxSAFE_SPLITTERxxx";
        query = query + "cns nonexxxSAFE_SPLITTERxxx";
        query = query + "cns nonexxxSAFE_SPLITTERxxx";
        query = query + this.layer3Tiers.getSelectedItem();
        return query;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.findButton) {
            if (this.checkQueryValidity()) {
                this.mediator.doQuery(this.encodeQuery(), this.queryId);
                this.mediator.setMatrixUsage(this.getMatrixUse(), this.queryId);
                this.resultPanel.startUpdating();
                this.historyPanel.remember(this.makeSaveableQuery());
                this.mediator.putPersistent("multipleTierHistory", this.historyPanel.getHistory());
            }
        } else if (source == this.clearButton) {
            this.resetPatterns();
            this.resetRelations();
            this.layer1Tiers.setSelectedIndex(0);
            this.layer2Tiers.setSelectedIndex(0);
            this.layer3Tiers.setSelectedIndex(0);
            this.minDurationButton.setText("Minimal Duration");
            this.minimalDuration = 0L;
            this.maxDurationButton.setText("Maximal Duration");
            this.maximalDuration = 0L;
            this.beginAfterButton.setText("Begin After");
            this.beginAfter = 0L;
            this.endBeforeButton.setText("End Before");
            this.endBefore = 0L;
            this.historyPanel.reset();
        } else if (source == this.minDurationButton) {
            String currentValue = SearchUtil.HHMMSSmmmFormat(this.minimalDuration);
            String value = JOptionPane.showInputDialog(this, "<html> Enter a Minimal Duration for the complete pattern as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the Minimal Duration</html>", currentValue);
            if (value != null) {
                this.minimalDuration = SearchUtil.parseTimeString(value);
                if (this.minimalDuration == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + value, "Illegal number format", 0);
                    this.minimalDuration = 0L;
                } else if (this.minimalDuration <= 0L) {
                    this.minDurationButton.setText("Minimal Duration");
                    this.minimalDuration = 0L;
                } else if (this.maximalDuration != 0L && this.minimalDuration > this.maximalDuration) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than the Maximal Duration", "Impossible value", 0);
                    this.minimalDuration = 0L;
                } else if (this.beginAfter > 0L && this.endBefore > 0L && this.minimalDuration > this.beginAfter - this.endBefore) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than (begin after - end before)", "Impossible value", 0);
                    this.minimalDuration = 0L;
                } else if (this.minimalDuration > 0L) {
                    this.minDurationButton.setText("Minimal Duration: " + SearchUtil.HHMMSSmmmFormat(this.minimalDuration));
                }
            }
        } else if (source == this.maxDurationButton) {
            String currentValue = SearchUtil.HHMMSSmmmFormat(this.maximalDuration);
            String value = JOptionPane.showInputDialog(this, "<html> Enter a Maximal Duration for the complete pattern as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the Minimal Duration</html>", currentValue);
            if (value != null) {
                this.maximalDuration = SearchUtil.parseTimeString(value);
                if (this.maximalDuration == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + value, "Illegal number format", 0);
                    this.maximalDuration = 0L;
                } else if (this.maximalDuration <= 0L) {
                    this.maxDurationButton.setText("Maximal Duration");
                    this.maximalDuration = 0L;
                } else if (this.maximalDuration < this.minimalDuration) {
                    JOptionPane.showMessageDialog(null, "The Maximal Duration must be bigger than the Minimal Duration", "Impossible value", 0);
                    this.maximalDuration = 0L;
                } else if (this.maximalDuration > 0L) {
                    this.maxDurationButton.setText("Maximal Duration: " + SearchUtil.HHMMSSmmmFormat(this.maximalDuration));
                }
            }
        } else if (source == this.beginAfterButton) {
            String currentValue = SearchUtil.HHMMSSmmmFormat(this.beginAfter);
            String value = JOptionPane.showInputDialog(this, "<html> Enter a time after which the pattern must begin as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the Minimal Duration</html>", currentValue);
            if (value != null) {
                this.beginAfter = SearchUtil.parseTimeString(value);
                if (this.beginAfter == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + value, "Illegal number format", 0);
                    this.beginAfter = 0L;
                } else if (this.beginAfter <= 0L) {
                    this.beginAfterButton.setText("Begin After");
                    this.beginAfter = 0L;
                } else if (this.endBefore != 0L && this.beginAfter > this.endBefore) {
                    JOptionPane.showMessageDialog(null, "The Begin After time must be smaller than the End Before time", "Impossible value", 0);
                    this.beginAfter = 0L;
                } else if (this.minimalDuration > 0L && this.endBefore > 0L && this.minimalDuration > this.beginAfter - this.endBefore) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than (begin after - end before)", "Impossible value", 0);
                    this.beginAfter = 0L;
                } else if (this.beginAfter > 0L) {
                    this.beginAfterButton.setText("Begin After: " + SearchUtil.HHMMSSmmmFormat(this.beginAfter));
                }
            }
        } else if (source == this.endBeforeButton) {
            String currentValue = SearchUtil.HHMMSSmmmFormat(this.endBefore);
            String value = JOptionPane.showInputDialog(this, "<html> Enter a time before which the pattern must end as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the Minimal Duration</html>", currentValue);
            if (value != null) {
                this.endBefore = SearchUtil.parseTimeString(value);
                if (this.endBefore == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + value, "Illegal number format", 0);
                    this.endBefore = 0L;
                } else if (this.endBefore <= 0L) {
                    this.endBeforeButton.setText("End Before");
                    this.endBefore = 0L;
                } else if (this.endBefore < this.beginAfter) {
                    JOptionPane.showMessageDialog(null, "The End Before time must be bigger than the Begin After time", "Impossible value", 0);
                    this.endBefore = 0L;
                } else if (this.minimalDuration > 0L && this.beginAfter > 0L && this.minimalDuration > this.beginAfter - this.endBefore) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than (begin after - end before)", "Impossible value", 0);
                    this.endBefore = 0L;
                } else if (this.endBefore > 0L) {
                    this.endBeforeButton.setText("End Before: " + SearchUtil.HHMMSSmmmFormat(this.endBefore));
                }
            }
        } else {
            if (source == this.hAnnEqual) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" = " + n + " " + "annotation ");
                    } else {
                        this.popupSource.setText(" = " + n + " " + "annot. ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns an=:" + n;
                }
            } else if (source == this.hAnnMore) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" > " + n + " " + "annotation ");
                    } else {
                        this.popupSource.setText(" > " + n + " " + "annot. ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns an+:" + n;
                }
            } else if (source == this.hAnnLess) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" < " + n + " " + "annotation ");
                    } else {
                        this.popupSource.setText(" < " + n + " " + "annot. ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns an-:" + n;
                }
            } else if (source == this.hMilEqual) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" = " + n + " " + "millisecond ");
                    } else {
                        this.popupSource.setText(" = " + n + " " + "milliseconds ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns ms=:" + n;
                }
            } else if (source == this.hMilMore) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" > " + n + " " + "millisecond ");
                    } else {
                        this.popupSource.setText(" > " + n + " " + "milliseconds ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns ms+:" + n;
                }
            } else if (source == this.hMilLess) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" < " + n + " " + "millisecond ");
                    } else {
                        this.popupSource.setText(" < " + n + " " + "milliseconds ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns ms-:" + n;
                }
            } else if (source == this.hNoConstraint) {
                this.popupSource.setText(" " + ((JMenuItem)source).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns none";
            } else if (source == this.hClear) {
                this.popupSource.setText("");
                ((ConstraintLabel)this.popupSource).constraint = "cns none";
            } else if (source == this.vFullyAligned) {
                this.popupSource.setText(" " + ((JMenuItem)source).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns aligned";
            } else if (source == this.vOverlap) {
                this.popupSource.setText(" " + ((JMenuItem)source).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns overlap";
            } else if (source == this.vLeftOverlap) {
                this.popupSource.setText(" " + ((JMenuItem)source).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns l overlap";
            } else if (source == this.vRightOverlap) {
                this.popupSource.setText(" " + ((JMenuItem)source).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns r overlap";
            } else if (source == this.vSurrounding) {
                this.popupSource.setText(" " + ((JMenuItem)source).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns surrounding";
            } else if (source == this.vWithin) {
                this.popupSource.setText(" " + ((JMenuItem)source).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns within";
            } else if (source == this.vNoOverlap) {
                this.popupSource.setText(" " + ((JMenuItem)source).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns no overlap";
            } else if (source == this.vBeginBeginEqual) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" begin time - begin time = " + n + " " + "msec" + " ");
                    } else {
                        this.popupSource.setText(" begin time - begin time = " + n + " " + "msec" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns bb=:" + n;
                }
            } else if (source == this.vBeginBeginLess) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" begin time - begin time < " + n + " " + "msec" + " ");
                    } else {
                        this.popupSource.setText(" begin time - begin time < " + n + " " + "msec" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns bb-:" + n;
                }
            } else if (source == this.vBeginBeginMore) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" begin time - begin time > " + n + " " + "msec" + " ");
                    } else {
                        this.popupSource.setText(" begin time - begin time > " + n + " " + "msec" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns bb+:" + n;
                }
            } else if (source == this.vBeginEndEqual) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" begin time - end time = " + n + " " + "msec" + " ");
                    } else {
                        this.popupSource.setText(" begin time - end time = " + n + " " + "msec" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns be=:" + n;
                }
            } else if (source == this.vBeginEndLess) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" begin time - end time < " + n + " " + "msec" + " ");
                    } else {
                        this.popupSource.setText(" begin time - end time < " + n + " " + "msec" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns be-:" + n;
                }
            } else if (source == this.vBeginEndMore) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" begin time - end time > " + n + " " + "msec" + " ");
                    } else {
                        this.popupSource.setText(" begin time - end time > " + n + " " + "msec" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns be+:" + n;
                }
            } else if (source == this.vEndBeginEqual) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" end time - begin time = " + n + " " + "msec" + " ");
                    } else {
                        this.popupSource.setText(" end time - begin time = " + n + " " + "msec" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns eb=:" + n;
                }
            } else if (source == this.vEndBeginLess) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" end time - begin time < " + n + " " + "msec" + " ");
                    } else {
                        this.popupSource.setText(" end time - begin time < " + n + " " + "msec" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns eb-:" + n;
                }
            } else if (source == this.vEndBeginMore) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" end time - begin time > " + n + " " + "msec" + " ");
                    } else {
                        this.popupSource.setText(" end time - begin time > " + n + " " + "msec" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns eb+:" + n;
                }
            } else if (source == this.vEndEndEqual) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" end time - end time = " + n + " " + "msec" + " ");
                    } else {
                        this.popupSource.setText(" end time - end time = " + n + " " + "msec" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns ee=:" + n;
                }
            } else if (source == this.vEndEndLess) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" end time - end time < " + n + " " + "msec" + " ");
                    } else {
                        this.popupSource.setText(" end time - end time < " + n + " " + "msec" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns ee-:" + n;
                }
            } else if (source == this.vEndEndMore) {
                int n = this.getConstraintValue(((JMenuItem)source).getText());
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText(" end time - end time > " + n + " " + "msec" + " ");
                    } else {
                        this.popupSource.setText(" end time - end time > " + n + " " + "msec" + " ");
                    }
                    ((ConstraintLabel)this.popupSource).constraint = "cns ee+:" + n;
                }
            } else if (source == this.vNoConstraint) {
                this.popupSource.setText(" " + ((JMenuItem)source).getText() + " ");
                ((ConstraintLabel)this.popupSource).constraint = "cns none";
            } else if (source == this.vClear) {
                this.popupSource.setText("");
                ((ConstraintLabel)this.popupSource).constraint = "cns none";
            }
            this.popupSource.requestFocus();
        }
        this.invalidate();
    }

    private boolean checkQueryValidity() {
        boolean valid = true;
        if (this.relation_1_2.getText().equals("XXXX")) {
            this.relation_1_2.setText("");
        }
        if (this.relation_2_3.getText().equals("XXXX")) {
            this.relation_2_3.setText("");
        }
        if (this.relation_1_4.getText().equals("XXXX")) {
            this.relation_1_4.setText("");
        }
        if (this.relation_2_5.getText().equals("XXXX")) {
            this.relation_2_5.setText("");
        }
        if (this.relation_3_6.getText().equals("XXXX")) {
            this.relation_3_6.setText("");
        }
        if (this.relation_4_5.getText().equals("XXXX")) {
            this.relation_4_5.setText("");
        }
        if (this.relation_5_6.getText().equals("XXXX")) {
            this.relation_5_6.setText("");
        }
        if (this.relation_4_7.getText().equals("XXXX")) {
            this.relation_4_7.setText("");
        }
        if (this.relation_5_8.getText().equals("XXXX")) {
            this.relation_5_8.setText("");
        }
        if (this.relation_6_9.getText().equals("XXXX")) {
            this.relation_6_9.setText("");
        }
        if (this.relation_7_8.getText().equals("XXXX")) {
            this.relation_7_8.setText("");
        }
        if (this.relation_8_9.getText().equals("XXXX")) {
            this.relation_8_9.setText("");
        }
        if (this.patternField_1.getText().equals("XXXX")) {
            this.patternField_1.setText("");
        }
        if (this.patternField_2.getText().equals("XXXX")) {
            this.patternField_2.setText("");
        }
        if (this.patternField_3.getText().equals("XXXX")) {
            this.patternField_3.setText("");
        }
        if (this.patternField_4.getText().equals("XXXX")) {
            this.patternField_4.setText("");
        }
        if (this.patternField_5.getText().equals("XXXX")) {
            this.patternField_5.setText("");
        }
        if (this.patternField_6.getText().equals("XXXX")) {
            this.patternField_6.setText("");
        }
        if (this.patternField_7.getText().equals("XXXX")) {
            this.patternField_7.setText("");
        }
        if (this.patternField_8.getText().equals("XXXX")) {
            this.patternField_8.setText("");
        }
        if (this.patternField_9.getText().equals("XXXX")) {
            this.patternField_9.setText("");
        }
        int nPatterns = 0;
        if (this.patternField_1.getText().trim().length() > 0) {
            ++nPatterns;
        }
        if (this.patternField_2.getText().trim().length() > 0) {
            ++nPatterns;
        }
        if (this.patternField_3.getText().trim().length() > 0) {
            ++nPatterns;
        }
        if (this.patternField_4.getText().trim().length() > 0) {
            ++nPatterns;
        }
        if (this.patternField_5.getText().trim().length() > 0) {
            ++nPatterns;
        }
        if (this.patternField_6.getText().trim().length() > 0) {
            ++nPatterns;
        }
        if (this.patternField_7.getText().trim().length() > 0) {
            ++nPatterns;
        }
        if (this.patternField_8.getText().trim().length() > 0) {
            ++nPatterns;
        }
        if (this.patternField_9.getText().trim().length() > 0) {
            ++nPatterns;
        }
        if (nPatterns > 1) {
            if (this.patternField_1.getText().trim().length() > 0 && this.patternField_2.getText().trim().length() == 0 && this.patternField_4.getText().trim().length() == 0) {
                valid = false;
            }
            if (this.patternField_2.getText().trim().length() > 0 && this.patternField_1.getText().trim().length() == 0 && this.patternField_3.getText().trim().length() == 0 && this.patternField_5.getText().trim().length() == 0) {
                valid = false;
            }
            if (this.patternField_3.getText().trim().length() > 0 && this.patternField_2.getText().trim().length() == 0 && this.patternField_6.getText().trim().length() == 0) {
                valid = false;
            }
            if (this.patternField_4.getText().trim().length() > 0 && this.patternField_1.getText().trim().length() == 0 && this.patternField_5.getText().trim().length() == 0 && this.patternField_7.getText().trim().length() == 0) {
                valid = false;
            }
            if (this.patternField_5.getText().trim().length() > 0 && this.patternField_2.getText().trim().length() == 0 && this.patternField_4.getText().trim().length() == 0 && this.patternField_6.getText().trim().length() == 0 && this.patternField_8.getText().trim().length() == 0) {
                valid = false;
            }
            if (this.patternField_6.getText().trim().length() > 0 && this.patternField_5.getText().trim().length() == 0 && this.patternField_2.getText().trim().length() == 0 && this.patternField_9.getText().trim().length() == 0) {
                valid = false;
            }
            if (this.patternField_7.getText().trim().length() > 0 && this.patternField_4.getText().trim().length() == 0 && this.patternField_8.getText().trim().length() == 0) {
                valid = false;
            }
            if (this.patternField_8.getText().trim().length() > 0 && this.patternField_7.getText().trim().length() == 0 && this.patternField_5.getText().trim().length() == 0 && this.patternField_9.getText().trim().length() == 0) {
                valid = false;
            }
            if (this.patternField_9.getText().trim().length() > 0 && this.patternField_8.getText().trim().length() == 0 && this.patternField_6.getText().trim().length() == 0) {
                valid = false;
            }
        }
        if (!valid) {
            JOptionPane.showMessageDialog(null, "Please make sure that all non empty patterns are connected with constraints", "Illegal query", 0);
            return valid;
        }
        if (nPatterns > 1) {
            if (this.patternField_1.getText().trim().equals("NOT()")) {
                this.patternField_1.requestFocus();
                valid = false;
            }
            if (this.patternField_2.getText().trim().equals("NOT()")) {
                this.patternField_2.requestFocus();
                valid = false;
            }
            if (this.patternField_3.getText().trim().equals("NOT()")) {
                this.patternField_3.requestFocus();
                valid = false;
            }
            if (this.patternField_4.getText().trim().equals("NOT()")) {
                this.patternField_4.requestFocus();
                valid = false;
            }
            if (this.patternField_5.getText().trim().equals("NOT()")) {
                this.patternField_5.requestFocus();
                valid = false;
            }
            if (this.patternField_6.getText().trim().equals("NOT()")) {
                this.patternField_6.requestFocus();
                valid = false;
            }
            if (this.patternField_7.getText().trim().equals("NOT()")) {
                this.patternField_7.requestFocus();
                valid = false;
            }
            if (this.patternField_8.getText().trim().equals("NOT()")) {
                this.patternField_8.requestFocus();
                valid = false;
            }
            if (this.patternField_9.getText().trim().equals("NOT()")) {
                this.patternField_9.requestFocus();
                valid = false;
            }
        }
        if (!valid) {
            JOptionPane.showMessageDialog(null, "A NOT() must have a value between ( and ) ", "Illegal NOT() pattern", 0);
            return valid;
        }
        if (this.relation_1_2.getText().trim().length() > 0) {
            if (this.patternField_1.getText().trim().length() == 0) {
                this.patternField_1.setText("XXXX");
                valid = false;
            }
            if (this.patternField_2.getText().trim().length() == 0) {
                this.patternField_2.setText("XXXX");
                valid = false;
            }
        }
        if (this.relation_2_3.getText().trim().length() > 0) {
            if (this.patternField_2.getText().trim().length() == 0) {
                this.patternField_2.setText("XXXX");
                valid = false;
            }
            if (this.patternField_3.getText().trim().length() == 0) {
                this.patternField_3.setText("XXXX");
                valid = false;
            }
        }
        if (this.relation_1_4.getText().trim().length() > 0) {
            if (this.patternField_1.getText().trim().length() == 0) {
                this.patternField_1.setText("XXXX");
                valid = false;
            }
            if (this.patternField_4.getText().trim().length() == 0) {
                this.patternField_4.setText("XXXX");
                valid = false;
            }
        }
        if (this.relation_2_5.getText().trim().length() > 0) {
            if (this.patternField_2.getText().trim().length() == 0) {
                this.patternField_2.setText("XXXX");
                valid = false;
            }
            if (this.patternField_5.getText().trim().length() == 0) {
                this.patternField_5.setText("XXXX");
                valid = false;
            }
        }
        if (this.relation_3_6.getText().trim().length() > 0) {
            if (this.patternField_3.getText().trim().length() == 0) {
                this.patternField_3.setText("XXXX");
                valid = false;
            }
            if (this.patternField_6.getText().trim().length() == 0) {
                this.patternField_6.setText("XXXX");
                valid = false;
            }
        }
        if (this.relation_4_5.getText().trim().length() > 0) {
            if (this.patternField_4.getText().trim().length() == 0) {
                this.patternField_4.setText("XXXX");
                valid = false;
            }
            if (this.patternField_5.getText().trim().length() == 0) {
                this.patternField_5.setText("XXXX");
                valid = false;
            }
        }
        if (this.relation_5_6.getText().trim().length() > 0) {
            if (this.patternField_5.getText().trim().length() == 0) {
                this.patternField_5.setText("XXXX");
                valid = false;
            }
            if (this.patternField_6.getText().trim().length() == 0) {
                this.patternField_6.setText("XXXX");
                valid = false;
            }
        }
        if (this.relation_4_7.getText().trim().length() > 0) {
            if (this.patternField_4.getText().trim().length() == 0) {
                this.patternField_4.setText("XXXX");
                valid = false;
            }
            if (this.patternField_7.getText().trim().length() == 0) {
                this.patternField_7.setText("XXXX");
                valid = false;
            }
        }
        if (this.relation_5_8.getText().trim().length() > 0) {
            if (this.patternField_5.getText().trim().length() == 0) {
                this.patternField_5.setText("XXXX");
                valid = false;
            }
            if (this.patternField_8.getText().trim().length() == 0) {
                this.patternField_8.setText("XXXX");
                valid = false;
            }
        }
        if (this.relation_6_9.getText().trim().length() > 0) {
            if (this.patternField_6.getText().trim().length() == 0) {
                this.patternField_6.setText("XXXX");
                valid = false;
            }
            if (this.patternField_9.getText().trim().length() == 0) {
                this.patternField_9.setText("XXXX");
                valid = false;
            }
        }
        if (this.relation_7_8.getText().trim().length() > 0) {
            if (this.patternField_7.getText().trim().length() == 0) {
                this.patternField_7.setText("XXXX");
                valid = false;
            }
            if (this.patternField_8.getText().trim().length() == 0) {
                this.patternField_8.setText("XXXX");
                valid = false;
            }
        }
        if (this.relation_8_9.getText().trim().length() > 0) {
            if (this.patternField_8.getText().trim().length() == 0) {
                this.patternField_8.setText("XXXX");
                valid = false;
            }
            if (this.patternField_9.getText().trim().length() == 0) {
                this.patternField_9.setText("XXXX");
                valid = false;
            }
        }
        if (!valid) {
            JOptionPane.showMessageDialog(null, "Please define the patterns marked with XXXX", "Illegal query", 0);
            return valid;
        }
        if (this.patternField_1.getText().trim().length() > 0) {
            if (this.patternField_2.getText().trim().length() > 0 && this.relation_1_2.getText().trim().length() == 0) {
                this.relation_1_2.setText("XXXX");
                valid = false;
            }
            if (this.patternField_4.getText().trim().length() > 0 && this.relation_1_4.getText().trim().length() == 0) {
                this.relation_1_4.setText("XXXX");
                valid = false;
            }
        }
        if (this.patternField_2.getText().trim().length() > 0) {
            if (this.patternField_3.getText().trim().length() > 0 && this.relation_2_3.getText().trim().length() == 0) {
                this.relation_2_3.setText("XXXX");
                valid = false;
            }
            if (this.patternField_5.getText().trim().length() > 0 && this.relation_2_5.getText().trim().length() == 0) {
                this.relation_2_5.setText("XXXX");
                valid = false;
            }
        }
        if (this.patternField_3.getText().trim().length() > 0 && this.patternField_6.getText().trim().length() > 0 && this.relation_3_6.getText().trim().length() == 0) {
            this.relation_3_6.setText("XXXX");
            valid = false;
        }
        if (this.patternField_4.getText().trim().length() > 0) {
            if (this.patternField_7.getText().trim().length() > 0 && this.relation_4_7.getText().trim().length() == 0) {
                this.relation_4_7.setText("XXXX");
                valid = false;
            }
            if (this.patternField_5.getText().trim().length() > 0 && this.relation_4_5.getText().trim().length() == 0) {
                this.relation_4_5.setText("XXXX");
                valid = false;
            }
        }
        if (this.patternField_5.getText().trim().length() > 0) {
            if (this.patternField_6.getText().trim().length() > 0 && this.relation_5_6.getText().trim().length() == 0) {
                this.relation_5_6.setText("XXXX");
                valid = false;
            }
            if (this.patternField_8.getText().trim().length() > 0 && this.relation_5_8.getText().trim().length() == 0) {
                this.relation_5_8.setText("XXXX");
                valid = false;
            }
        }
        if (this.patternField_6.getText().trim().length() > 0 && this.patternField_9.getText().trim().length() > 0 && this.relation_6_9.getText().trim().length() == 0) {
            this.relation_6_9.setText("XXXX");
            valid = false;
        }
        if (!valid) {
            JOptionPane.showMessageDialog(null, "Please define the constraints marked with XXXX", "Not all constraints are defined", 0);
            return valid;
        }
        String matchMode = (String)this.matchModeChooser.getSelectedItem();
        if (matchMode.equals(" regular expression")) {
            if (!this.checkRegexp(this.patternField_1)) {
                this.patternField_1.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_2)) {
                this.patternField_2.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_3)) {
                this.patternField_3.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_4)) {
                this.patternField_4.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_5)) {
                this.patternField_5.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_6)) {
                this.patternField_6.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_7)) {
                this.patternField_7.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_8)) {
                this.patternField_8.requestFocus();
                return false;
            }
            if (!this.checkRegexp(this.patternField_9)) {
                this.patternField_9.requestFocus();
                return false;
            }
        }
        return true;
    }

    private boolean[][] getMatrixUse() {
        boolean[][] cells = new boolean[3][3];
        cells[0][0] = this.patternField_1.getText().trim().length() > 0;
        cells[0][1] = this.patternField_2.getText().trim().length() > 0;
        cells[0][2] = this.patternField_3.getText().trim().length() > 0;
        cells[1][0] = this.patternField_4.getText().trim().length() > 0;
        cells[1][1] = this.patternField_5.getText().trim().length() > 0;
        cells[1][2] = this.patternField_6.getText().trim().length() > 0;
        cells[2][0] = this.patternField_7.getText().trim().length() > 0;
        cells[2][1] = this.patternField_8.getText().trim().length() > 0;
        cells[2][2] = this.patternField_9.getText().trim().length() > 0;
        return cells;
    }

    private boolean checkRegexp(JTextField patternField) {
        String[] queryParts = new String[]{patternField.getText()};
        for (int i = 0; i < queryParts.length; ++i) {
            try {
                Pattern.compile(queryParts[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(null, "Not a valid regular expression:\n\n     " + queryParts[i], "Error", 0);
                patternField.requestFocus();
                return false;
            }
        }
        return true;
    }

    private boolean checkNGram(JTextField patternField) {
        String queryString = patternField.getText();
        if (queryString.trim().length() > 0) {
            String[] parts = queryString.split(" +");
            boolean onlyWildcards = true;
            for (int i = 0; i < parts.length; ++i) {
                System.out.println("prt " + parts[i]);
                if (parts[i].equals("#")) continue;
                onlyWildcards = false;
            }
            if (onlyWildcards) {
                JOptionPane.showMessageDialog(null, "An n-gram pattern must contain at least one character other than #", "Only wildcards in pattern", 0);
                return false;
            }
        }
        return true;
    }

    private void resetPatterns() {
        if (this.patternField_1 != null) {
            this.patternField_1.setText("");
            this.patternField_2.setText("");
            this.patternField_3.setText("");
            this.patternField_4.setText("");
            this.patternField_5.setText("");
            this.patternField_6.setText("");
            this.patternField_7.setText("");
            this.patternField_8.setText("");
            this.patternField_9.setText("");
        }
    }

    private void resetRelations() {
        if (this.relation_1_2 != null) {
            this.relation_1_2.setText("");
            this.relation_1_2.constraint = "cns none";
            this.relation_2_3.setText("");
            this.relation_2_3.constraint = "cns none";
            this.relation_1_4.setText("");
            this.relation_1_4.constraint = "cns none";
            this.relation_2_5.setText("");
            this.relation_2_5.constraint = "cns none";
            this.relation_3_6.setText("");
            this.relation_3_6.constraint = "cns none";
            this.relation_4_5.setText("");
            this.relation_4_5.constraint = "cns none";
            this.relation_5_6.setText("");
            this.relation_5_6.constraint = "cns none";
            this.relation_4_7.setText("");
            this.relation_4_7.constraint = "cns none";
            this.relation_5_8.setText("");
            this.relation_5_8.constraint = "cns none";
            this.relation_6_9.setText("");
            this.relation_6_9.constraint = "cns none";
            this.relation_7_8.setText("");
            this.relation_7_8.constraint = "cns none";
            this.relation_8_9.setText("");
            this.relation_8_9.constraint = "cns none";
        }
    }

    private int getConstraintValue(String constraint) {
        String selectedValue = "";
        String question = "";
        question = constraint.indexOf("milli") >= 0 || constraint.indexOf("msec") >= 0 ? "Please enter the time in milliseconds" : "Please enter the number of annotations";
        selectedValue = (String)JOptionPane.showInputDialog(null, question, constraint, 1, null, null, "");
        int i = -1;
        if (selectedValue != null) {
            try {
                i = Integer.parseInt(selectedValue);
                if (i < 0) {
                    JOptionPane.showMessageDialog(this, "A negative value is not allowed", constraint, 0);
                } else if (i == 0 && constraint.indexOf("<") >= 0) {
                    JOptionPane.showMessageDialog(this, "The value 0 is not allowed for this constraint", constraint, 0);
                    i = -1;
                }
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(null, selectedValue + " " + "is not a valid integer number", "Error", 0);
            }
        }
        return i;
    }

    private static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector order;

        public MyOwnFocusTraversalPolicy(Vector order) {
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return (Component)this.order.get(idx);
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            return (Component)this.order.get(idx);
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return (Component)this.order.get(0);
        }

        public Component getLastComponent(Container focusCycleRoot) {
            return (Component)this.order.lastElement();
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return (Component)this.order.get(0);
        }
    }

    private class ConstraintLabel
    extends JLabel {
        public String constraint = "cns none";

        public ConstraintLabel() {
            this.setOpaque(true);
            this.setBackground(Constants.CONSTRAINT_LABEL_COLOR);
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            Object source;
            if ((e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) && (source = e.getSource()) instanceof JLabel) {
                MultipleLayerSearchPanel.this.popupSource = (JLabel)source;
                if (source == MultipleLayerSearchPanel.this.relation_1_4 || source == MultipleLayerSearchPanel.this.relation_4_7 || source == MultipleLayerSearchPanel.this.relation_2_5 || source == MultipleLayerSearchPanel.this.relation_5_8 || source == MultipleLayerSearchPanel.this.relation_3_6 || source == MultipleLayerSearchPanel.this.relation_6_9) {
                    MultipleLayerSearchPanel.this.verticalRelations.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    MultipleLayerSearchPanel.this.horizontalRelations.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                // empty if block
            }
        }
    }
}

