/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.swingsearch;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mpi.annex.search.Constants;
import mpi.annex.search.FrequencyInfo;
import mpi.annex.search.HSQLDBQuery;
import mpi.annex.search.SearchHit;
import mpi.annex.search.SearchStatistics;
import mpi.annex.swingsearch.SearchApplication;
import mpi.annex.swingsearch.SearchDomainPanel;
import mpi.annex.swingsearch.SearchMediator;
import mpi.annex.swingsearch.SearchPane;
import mpi.annex.swingsearch.SearchResultPanel;

public class SearchApplicationMediator
implements SearchMediator {
    private static int queryIdCounter;
    private HSQLDBQuery lastCreatedQuery;
    private SearchApplication application;
    private SearchPane searchPane;
    private HashMap queryForId;
    private HashMap domainPanelForId;
    private HashMap resultPanelForId;
    private HashMap bufferedHitsForQuery;
    private HashMap matrixForId;
    private ArrayList domainInfo;
    private ArrayList initialDomain;
    private JPanel dummyPanel;

    public SearchApplicationMediator(SearchApplication application, ArrayList initialDomain) {
        this.application = application;
        this.initialDomain = initialDomain;
        new Constants();
        this.queryForId = new HashMap();
        this.domainPanelForId = new HashMap();
        this.resultPanelForId = new HashMap();
        this.bufferedHitsForQuery = new HashMap();
        this.matrixForId = new HashMap(6);
        this.dummyPanel = new JPanel();
        this.domainInfo = new ArrayList();
    }

    public void init() {
    }

    public JComponent getSearchComponent() {
        if (this.searchPane == null) {
            this.searchPane = new SearchPane(this);
        }
        return this.searchPane;
    }

    public String createQuery() {
        String queryId = Integer.toString(queryIdCounter++);
        HSQLDBQuery query = new HSQLDBQuery(queryId);
        if (this.lastCreatedQuery == null) {
            query.setDomain(this.initialDomain);
            this.domainInfo.clear();
            this.domainInfo.add(new ArrayList(query.getDomain()));
        } else {
            query.setDomain(this.lastCreatedQuery);
        }
        this.lastCreatedQuery = query;
        this.queryForId.put(queryId, query);
        this.bufferedHitsForQuery.put(queryId, new ArrayList());
        return queryId;
    }

    public void doQuery(String encodedQuery, String queryId) {
        if (this.queryRunning()) {
            JOptionPane.showMessageDialog(null, "A new query can not start while another query is running", "Running query on other panel", 2);
            return;
        }
        ArrayList bufferedHits = (ArrayList)this.bufferedHitsForQuery.get(queryId);
        bufferedHits.clear();
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        query.doQuery(encodedQuery);
    }

    public void cancelQuery(String queryId) {
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        query.cancelQuery();
    }

    public void showInViewer(Object hit, String queryId) {
        if (hit == null) {
            return;
        }
        if (hit instanceof SearchHit) {
            this.showSearchHitInViewer((SearchHit)hit);
        } else if (hit instanceof FrequencyInfo) {
            this.showFrequencyHitInViewer((FrequencyInfo)hit, queryId);
        }
    }

    public void showSearchHitInViewer(SearchHit hit) {
        String filePath = hit.transcriptionName;
        String tierName = hit.tierName;
        long beginTime = hit.beginTime;
        long endTime = hit.endTime;
        this.application.showInViewer(filePath, tierName, beginTime, endTime);
    }

    public void showFrequencyHitInViewer(FrequencyInfo freqInfo, String queryId) {
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        ArrayList parameters = query.getViewerParametersFor(freqInfo.annId, freqInfo.fileIndex);
        String filePath = (String)parameters.get(0);
        String tierName = (String)parameters.get(1);
        long beginTime = (Long)parameters.get(2);
        long endTime = (Long)parameters.get(3);
        this.application.showInViewer(filePath, tierName, beginTime, endTime);
    }

    public void showInCorpusStructure(Object hit, String queryId) {
    }

    public SearchStatistics getSearchStatistics(String queryId) {
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        return query.getSearchStatistics();
    }

    public ArrayList getHitsFromDatabase(int from, int to, int contextSize, String queryId) {
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        return query.getHits(from, to, contextSize);
    }

    public List getHits(int from, int to, int contextSize, String queryId) {
        ArrayList bufferedHits = (ArrayList)this.bufferedHitsForQuery.get(queryId);
        if (this.getSearchStatistics((String)queryId).nHits <= from) {
            return bufferedHits.subList(0, 0);
        }
        int lastBufferedIndex = bufferedHits.size();
        if (to > lastBufferedIndex) {
            ArrayList hits = this.getHitsFromDatabase(lastBufferedIndex, to, contextSize, queryId);
            for (int i = 0; i < hits.size(); ++i) {
                bufferedHits.add(hits.get(i));
            }
        }
        to = to < bufferedHits.size() ? to : bufferedHits.size();
        return bufferedHits.subList(from, to);
    }

    public ArrayList getFrequencyInfo(int from, int to, String queryId) {
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        return query.getFrequencyInfo(from, to);
    }

    private boolean queryRunning() {
        boolean running = false;
        for (HSQLDBQuery query : this.queryForId.values()) {
            if (!query.isRunning()) continue;
            return true;
        }
        return running;
    }

    public void addDomainPanel(String queryId, SearchDomainPanel panel) {
        this.domainPanelForId.put(queryId, panel);
    }

    public void addResultPanel(String queryId, SearchResultPanel panel) {
        this.resultPanelForId.put(queryId, panel);
    }

    public void setQueryDomain(String domainTypes, String queryId) {
        if (this.queryRunning()) {
            JOptionPane.showMessageDialog(null, "The domain can not be changed while another query is running", "Running query on other panel", 2);
            return;
        }
        ArrayList newDomain = this.application.getDomain();
        if (newDomain != null) {
            HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
            query.setDomain(newDomain);
            for (String otherQueryId : this.queryForId.keySet()) {
                HSQLDBQuery otherQuery = (HSQLDBQuery)this.queryForId.get(otherQueryId);
                if (otherQuery != query) {
                    otherQuery.setDomain(query);
                    SearchDomainPanel domainPanel = (SearchDomainPanel)this.domainPanelForId.get(otherQueryId);
                    domainPanel.newDomainFromOtherPanel();
                }
                SearchResultPanel resultPanel = (SearchResultPanel)this.resultPanelForId.get(otherQueryId);
                resultPanel.clear();
            }
            this.domainInfo.clear();
            this.domainInfo.add(new ArrayList(query.getDomain()));
        }
    }

    public void checkForDomainErrors(String queryId) {
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        ArrayList problemFiles = query.getProblemFiles();
        if (problemFiles.size() > 0) {
            String errorFilePaths = "";
            for (int i = 0; i < problemFiles.size(); ++i) {
                errorFilePaths = errorFilePaths + ((File)problemFiles.get(i)).getAbsolutePath() + "\n";
            }
            String explanation = "The following files could not be parsed and are therefore removed from the search domain:\n";
            JOptionPane.showMessageDialog(null, explanation + errorFilePaths, "Not Searchable Files", 0);
        }
    }

    public float getDomainInitializationProgress(String queryId) {
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        return query.getDomainInitializationProgress();
    }

    public int getDomainSize(String queryId) {
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        return query.getDomain().size();
    }

    public ArrayList getSearchModes(String queryId) {
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        return query.getSearchModes();
    }

    public ArrayList getParticipants(String queryId) {
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        return query.getParticipants();
    }

    public ArrayList getTierNames(String queryId) {
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        return query.getTierNames();
    }

    public ArrayList getTierTypes(String queryId) {
        HSQLDBQuery query = (HSQLDBQuery)this.queryForId.get(queryId);
        return query.getTierTypes();
    }

    public Color getBackgroundColor() {
        return this.dummyPanel.getBackground();
    }

    public ArrayList getDomainInfo() {
        return this.domainInfo;
    }

    public void putPersistent(String key, String value) {
        this.application.putPersistent(key, value);
    }

    public String getPersistent(String key) {
        return this.application.getPersistent(key);
    }

    public void deletePersistent(String key) {
        this.application.deletePersistent(key);
    }

    public void setMatrixUsage(boolean[][] matrix, String queryId) {
        this.matrixForId.put(queryId, matrix);
    }

    public boolean[][] getMatrixUsage(String queryId) {
        return (boolean[][])this.matrixForId.get(queryId);
    }
}

