/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.swingsearch;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import mpi.annex.search.Constants;
import mpi.annex.search.FrequencyInfo;
import mpi.annex.search.SearchHit;
import mpi.annex.search.SearchStatistics;
import mpi.annex.swingsearch.ExportResultStatsDialog;
import mpi.annex.swingsearch.ExportResultsComplexOptionsDialog;
import mpi.annex.swingsearch.ExportResultsOptionsDialog;
import mpi.annex.swingsearch.HitStats;
import mpi.annex.swingsearch.SearchMediator;
import mpi.annex.swingsearch.SearchUtil;
import mpi.eudico.client.annotator.gui.JFontChooser;

public class SearchResultPanel
extends JPanel
implements ActionListener {
    private SearchMediator mediator;
    private String queryId;
    private Timer pollTimer;
    private MouseListener mouseListener;
    private Dimension dimension;
    private JButton cancelButton;
    private JButton nextButton;
    private JButton prevButton;
    private JProgressBar progressBar;
    private JLabel nHitsLabel;
    private JLabel nAnnotationsWithHitLabel;
    private JLabel nAnnotationsSearchedLabel;
    private JPopupMenu concordancePopup;
    private JPopupMenu frequencyPopup;
    private JMenuItem chooseFontMenuItem;
    private JMenuItem infoBalloonToggleMenuItem;
    private JMenuItem showHitMenuItem;
    private JMenuItem showHitInCorpusTreeMenuItem;
    private JMenuItem concordanceDisplayModeItem;
    private JMenuItem frequencyDisplayModeItem;
    private JMenuItem saveHitsMenuItem;
    private JMenuItem saveHitsStatisticsMenuItem;
    private JMenuItem saveFrequencyInfoMenuItem;
    private JMenuItem showSampleHitMenuItem;
    private JMenuItem showFreqSampleHitInCorpusTreeMenuItem;
    private JPanel hitPanel;
    private final int MAX_VISIBLE_HITS_PER_SCREEN = 100;
    private final int HIT_DISPLAY_Y = 80;
    private int HIT_HEIGHT;
    private JLabel[] hitLabels;
    private JLabel[] prefixLabels;
    private JLabel[] postfixLabels;
    private JLabel[] hitLabelsLeftContext;
    private JLabel[] hitLabelsRightContext;
    private JLabel[] headerLabel;
    private JLabel hitNrLabel;
    private HashMap labelToHit;
    private int hitContextSize;
    private int firstVisibleHitIndex;
    private int lastVisibleHitIndex;
    private int nrOfVisibleHits;
    private int nHits;
    private int nHitsPrev;
    private int nAnnotationsWithHit;
    private int nAnnotationsSearched;
    private boolean tooltipVisible;
    private float progress;
    private File saveFile;
    private boolean saving;
    private File lastSavedFile;
    private Object activeHit;
    private DelayedNewLayout delayedNewLayout;
    private int resultMode;
    private int firstVisibleFrequencyInfoIndex;
    private int lastVisibleFrequencyInfoIndex;
    private int nFrequencyInfoItems;
    private boolean simpleQueryMode = false;

    public SearchResultPanel(SearchMediator mediator, String queryId) {
        String ff;
        int i;
        this.mediator = mediator;
        this.queryId = queryId;
        mediator.addResultPanel(queryId, this);
        this.setLayout(null);
        this.setBackground(mediator.getBackgroundColor());
        this.mouseListener = new MouseHandler();
        JLabel hitsLabel = new JLabel("#hits");
        hitsLabel.setFont(Constants.normalFont);
        hitsLabel.setBounds(25, 10, 200, 20);
        this.add(hitsLabel);
        this.nHitsLabel = new JLabel(":");
        this.nHitsLabel.setFont(Constants.monoFont);
        this.nHitsLabel.setBounds(200, 10, 200, 20);
        this.add(this.nHitsLabel);
        JLabel annotationsWithHitLabel = new JLabel("#annotations with a hit");
        annotationsWithHitLabel.setFont(Constants.normalFont);
        annotationsWithHitLabel.setBounds(25, 30, 200, 20);
        this.add(annotationsWithHitLabel);
        this.nAnnotationsWithHitLabel = new JLabel(":");
        this.nAnnotationsWithHitLabel.setFont(Constants.monoFont);
        this.nAnnotationsWithHitLabel.setBounds(200, 30, 200, 20);
        this.add(this.nAnnotationsWithHitLabel);
        JLabel annotationsSearchedLabel = new JLabel("#annotations investigated");
        annotationsSearchedLabel.setFont(Constants.normalFont);
        annotationsSearchedLabel.setBounds(25, 50, 200, 20);
        this.add(annotationsSearchedLabel);
        this.nAnnotationsSearchedLabel = new JLabel(":");
        this.nAnnotationsSearchedLabel.setFont(Constants.monoFont);
        this.nAnnotationsSearchedLabel.setBounds(200, 50, 200, 20);
        this.add(this.nAnnotationsSearchedLabel);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        this.progressBar.setBounds(360, 50, 150, 20);
        this.progressBar.setVisible(true);
        this.add(this.progressBar);
        this.cancelButton = new JButton("Cancel");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.cancelButton.setBackground(mediator.getBackgroundColor());
        }
        this.cancelButton.setBounds(520, 43, 90, 30);
        this.cancelButton.addActionListener(this);
        this.add(this.cancelButton);
        this.cancelButton.setVisible(false);
        this.hitPanel = new JPanel();
        this.hitPanel.setBackground(mediator.getBackgroundColor());
        this.hitPanel.setLayout(null);
        this.hitPanel.addMouseListener(this.mouseListener);
        this.add(this.hitPanel);
        this.prevButton = new JButton("<");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.prevButton.setBackground(mediator.getBackgroundColor());
        }
        this.prevButton.setBounds(0, 0, 0, 0);
        this.prevButton.addActionListener(this);
        this.prevButton.setVisible(false);
        this.hitPanel.add(this.prevButton);
        this.nextButton = new JButton(">");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.nextButton.setBackground(mediator.getBackgroundColor());
        }
        this.nextButton.setBounds(0, 0, 0, 0);
        this.nextButton.addActionListener(this);
        this.nextButton.setVisible(false);
        this.hitPanel.add(this.nextButton);
        this.labelToHit = new HashMap();
        this.hitLabels = new JLabel[100];
        this.hitLabelsLeftContext = new JLabel[100];
        this.hitLabelsRightContext = new JLabel[100];
        this.prefixLabels = new JLabel[100];
        this.postfixLabels = new JLabel[100];
        for (i = 0; i < 100; ++i) {
            JLabel hitLabel = new JLabel();
            hitLabel.setFont(Constants.hitFont);
            hitLabel.setVisible(true);
            hitLabel.addMouseListener(this.mouseListener);
            this.hitPanel.add(hitLabel);
            this.hitLabels[i] = hitLabel;
            JLabel prefix = new JLabel();
            prefix.setFont(Constants.normalFont);
            prefix.setVisible(true);
            prefix.addMouseListener(this.mouseListener);
            this.hitPanel.add(prefix);
            this.prefixLabels[i] = prefix;
            JLabel postfix = new JLabel();
            postfix.setFont(Constants.normalFont);
            postfix.setVisible(true);
            postfix.addMouseListener(this.mouseListener);
            this.hitPanel.add(postfix);
            this.postfixLabels[i] = postfix;
            JLabel hitLabelBefore = new JLabel();
            hitLabelBefore.setFont(Constants.italicFont);
            hitLabelBefore.setVisible(true);
            hitLabelBefore.addMouseListener(this.mouseListener);
            this.hitPanel.add(hitLabelBefore);
            this.hitLabelsLeftContext[i] = hitLabelBefore;
            JLabel hitLabelAfter = new JLabel();
            hitLabelAfter.setFont(Constants.italicFont);
            hitLabelAfter.setVisible(true);
            hitLabelAfter.addMouseListener(this.mouseListener);
            this.hitPanel.add(hitLabelAfter);
            this.hitLabelsRightContext[i] = hitLabelAfter;
        }
        this.headerLabel = new JLabel[20];
        for (i = 0; i < this.headerLabel.length; ++i) {
            this.headerLabel[i] = new JLabel();
            this.headerLabel[i].setFont(Constants.bigBoldFont);
            this.headerLabel[i].setVisible(true);
            this.hitPanel.add(this.headerLabel[i]);
        }
        this.hitNrLabel = new JLabel();
        this.hitNrLabel.setFont(Constants.smallFont);
        this.hitNrLabel.setVisible(true);
        this.hitPanel.add(this.hitNrLabel);
        this.concordancePopup = new JPopupMenu();
        this.frequencyDisplayModeItem = new JMenuItem("  Show Frequency view");
        this.frequencyDisplayModeItem.addActionListener(this);
        this.concordancePopup.add(this.frequencyDisplayModeItem);
        this.concordancePopup.addSeparator();
        this.showHitMenuItem = new JMenuItem("  Show hit in transcription");
        this.showHitMenuItem.addActionListener(this);
        this.concordancePopup.add(this.showHitMenuItem);
        this.tooltipVisible = Boolean.parseBoolean(mediator.getPersistent("MFS.ToolTipVisible"));
        this.infoBalloonToggleMenuItem = new JMenuItem("  Show info balloons");
        if (this.tooltipVisible) {
            this.infoBalloonToggleMenuItem.setText("  Hide info balloons");
        }
        this.infoBalloonToggleMenuItem.addActionListener(this);
        this.concordancePopup.add(this.infoBalloonToggleMenuItem);
        this.hitContextSize = 3;
        String csPref = mediator.getPersistent("MFS.ContextSize");
        if (csPref != null) {
            try {
                this.hitContextSize = Integer.parseInt(csPref);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        JMenu contextSizeMenu = new JMenu("  Context Size");
        contextSizeMenu.setBackground(mediator.getBackgroundColor());
        ButtonGroup sizeGroup = new ButtonGroup();
        for (int size = 0; size <= 8; ++size) {
            JRadioButtonMenuItem sizeItem = new JRadioButtonMenuItem(Integer.toString(size));
            if (size == this.hitContextSize) {
                sizeItem.setSelected(true);
            }
            sizeGroup.add(sizeItem);
            contextSizeMenu.add(sizeItem);
            sizeItem.addActionListener(this);
        }
        this.concordancePopup.add(contextSizeMenu);
        this.concordancePopup.addSeparator();
        this.chooseFontMenuItem = new JMenuItem("  Font");
        this.chooseFontMenuItem.addActionListener(this);
        this.concordancePopup.add(this.chooseFontMenuItem);
        this.concordancePopup.addSeparator();
        this.saveHitsMenuItem = new JMenuItem("  Save hits");
        this.saveHitsMenuItem.addActionListener(this);
        this.concordancePopup.add(this.saveHitsMenuItem);
        this.saveHitsStatisticsMenuItem = new JMenuItem("  Save hit statistics");
        this.saveHitsStatisticsMenuItem.addActionListener(this);
        this.concordancePopup.add(this.saveHitsStatisticsMenuItem);
        this.frequencyPopup = new JPopupMenu();
        this.concordanceDisplayModeItem = new JMenuItem("  Show Concordance view");
        this.concordanceDisplayModeItem.addActionListener(this);
        this.frequencyPopup.add(this.concordanceDisplayModeItem);
        this.frequencyPopup.addSeparator();
        this.showSampleHitMenuItem = new JMenuItem("  Show hit in transcription");
        this.showSampleHitMenuItem.addActionListener(this);
        this.frequencyPopup.add(this.showSampleHitMenuItem);
        this.frequencyPopup.addSeparator();
        this.saveFrequencyInfoMenuItem = new JMenuItem("  Save frequency info");
        this.saveFrequencyInfoMenuItem.addActionListener(this);
        this.frequencyPopup.add(this.saveFrequencyInfoMenuItem);
        this.resultMode = 0;
        String rModePref = mediator.getPersistent("MFS.ResultMode");
        if (rModePref != null) {
            try {
                this.resultMode = Integer.parseInt(rModePref);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setReshowDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(1000000);
        ToolTipManager.sharedInstance().setEnabled(false);
        if (this.resultMode == 0 && this.tooltipVisible) {
            ToolTipManager.sharedInstance().setEnabled(true);
        }
        if ((ff = mediator.getPersistent("MFS.FontFamily")) != null) {
            String fs = mediator.getPersistent("MFS.FontSize");
            try {
                int size = Integer.parseInt(fs);
                this.setHitFont(ff, size);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this.addComponentListener(new ComponentHandler());
        this.dimension = new Dimension(690, 300);
        this.setSize(this.dimension);
    }

    public void clear() {
        this.nHits = 0;
        this.nHitsPrev = 0;
        this.firstVisibleHitIndex = 0;
        this.hitNrLabel.setBounds(0, 0, 0, 0);
        this.prevButton.setVisible(false);
        this.nextButton.setVisible(false);
        this.saveHitsMenuItem.setEnabled(false);
        this.resultMode = 0;
        this.updateStatistics();
        this.newLayout();
    }

    public void startUpdating() {
        if (this.pollTimer != null) {
            this.pollTimer.stop();
        }
        this.nHits = 0;
        this.nHitsPrev = 0;
        this.firstVisibleHitIndex = 0;
        this.firstVisibleFrequencyInfoIndex = 0;
        this.hitNrLabel.setBounds(0, 0, 0, 0);
        this.prevButton.setVisible(false);
        this.nextButton.setVisible(false);
        this.saveHitsMenuItem.setEnabled(false);
        this.resultMode = 0;
        this.frequencyDisplayModeItem.setEnabled(false);
        this.updateStatistics();
        this.newLayout();
        this.pollTimer = new Timer(500, this);
        this.pollTimer.start();
        this.cancelButton.setVisible(true);
        this.progressBar.setValue(0);
        this.progressBar.setString("Progress");
    }

    public void stopUpdating() {
        this.pollTimer.stop();
        this.cancelButton.setVisible(false);
        this.frequencyDisplayModeItem.setEnabled(true);
        this.saveFrequencyInfoMenuItem.setEnabled(true);
        this.newLayout();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source instanceof JRadioButtonMenuItem) {
            try {
                this.hitContextSize = Integer.parseInt(event.getActionCommand());
                this.mediator.putPersistent("MFS.ContextSize", String.valueOf(this.hitContextSize));
                this.newLayout();
            }
            catch (NumberFormatException e) {}
        } else if (source == this.chooseFontMenuItem) {
            Font currentFont = this.hitLabels[0].getFont();
            JFontChooser chooser = new JFontChooser(JFontChooser.FONT_SIZE);
            JPopupMenu popupMenu = (JPopupMenu)((JMenuItem)source).getParent();
            Component invoker = popupMenu.getInvoker();
            JComponent invokerAsJComponent = (JComponent)invoker;
            Container topLevel = invokerAsJComponent.getTopLevelAncestor();
            Font font = chooser.showDialog((JFrame)topLevel, true, currentFont);
            if (font != null) {
                this.mediator.putPersistent("MFS.FontFamily", font.getFamily());
                this.mediator.putPersistent("MFS.FontSize", String.valueOf(font.getSize()));
                this.setHitFont(font.getFamily(), font.getSize());
            }
        } else if (source == this.concordanceDisplayModeItem) {
            this.resultMode = 0;
            this.mediator.putPersistent("MFS.ResultMode", String.valueOf(this.resultMode));
            if (this.tooltipVisible) {
                ToolTipManager.sharedInstance().setEnabled(true);
                this.infoBalloonToggleMenuItem.setText("  Hide info balloons");
            }
            this.newLayout();
        } else if (source == this.frequencyDisplayModeItem) {
            this.resultMode = 1;
            this.mediator.putPersistent("MFS.ResultMode", String.valueOf(this.resultMode));
            ToolTipManager.sharedInstance().setEnabled(false);
            this.infoBalloonToggleMenuItem.setText("  Show info balloons");
            this.newLayout();
        } else if (source == this.infoBalloonToggleMenuItem) {
            if (this.infoBalloonToggleMenuItem.getText().equals("  Show info balloons")) {
                ToolTipManager.sharedInstance().setEnabled(true);
                this.tooltipVisible = true;
                this.infoBalloonToggleMenuItem.setText("  Hide info balloons");
            } else {
                ToolTipManager.sharedInstance().setEnabled(false);
                this.tooltipVisible = false;
                this.infoBalloonToggleMenuItem.setText("  Show info balloons");
            }
            this.mediator.putPersistent("MFS.ToolTipVisible", String.valueOf(this.tooltipVisible));
        } else if (source == this.showHitInCorpusTreeMenuItem || source == this.showFreqSampleHitInCorpusTreeMenuItem) {
            if (this.activeHit != null) {
                this.mediator.showInCorpusStructure(this.activeHit, this.queryId);
            }
        } else if (source == this.showHitMenuItem || source == this.showSampleHitMenuItem) {
            if (this.activeHit != null) {
                this.mediator.showInViewer(this.activeHit, this.queryId);
            }
        } else if (source == this.cancelButton) {
            if (this.saving) {
                this.saving = false;
                this.stopUpdating();
                JOptionPane.showMessageDialog(null, "Stopped saving hits", "Save Hits", 1);
                return;
            }
            this.mediator.cancelQuery(this.queryId);
            this.stopUpdating();
            if (this.nHits > 0) {
                this.saveHitsMenuItem.setEnabled(true);
            }
            this.updateStatistics();
            this.progressBar.setString("Canceled");
        } else if (source == this.saveHitsMenuItem) {
            JFileChooser chooser;
            int returnVal;
            Window w;
            if (this.saving) {
                JOptionPane.showMessageDialog(null, "Already saving, press Cancel button to interrupt", "Save Hits", 1);
                return;
            }
            if (this.simpleQueryMode) {
                w = SwingUtilities.getWindowAncestor(this);
                ExportResultsOptionsDialog opDialog = w instanceof Frame ? new ExportResultsOptionsDialog((Frame)w, (ResourceBundle)null, this.mediator) : (w instanceof Dialog ? new ExportResultsOptionsDialog((Dialog)w, (ResourceBundle)null, this.mediator) : new ExportResultsOptionsDialog());
                opDialog.setVisible(true);
            } else {
                w = SwingUtilities.getWindowAncestor(this);
                ExportResultsComplexOptionsDialog opcDialog = w instanceof Frame ? new ExportResultsComplexOptionsDialog((Frame)w, (ResourceBundle)null, this.mediator) : (w instanceof Dialog ? new ExportResultsComplexOptionsDialog((Dialog)w, (ResourceBundle)null, this.mediator) : new ExportResultsComplexOptionsDialog());
                opcDialog.setVisible(true);
            }
            String lastDir = this.mediator.getPersistent("LastMFSaveDir");
            if (lastDir != null) {
                this.lastSavedFile = new File(lastDir);
            }
            if ((returnVal = (chooser = new JFileChooser(this.lastSavedFile)).showSaveDialog(this)) == 0) {
                this.saveFile = chooser.getSelectedFile();
                if (this.saveFile.exists() && (returnVal = JOptionPane.showConfirmDialog(null, this.saveFile.getName() + " already exists, overwrite?", "Save Hits", 0)) != 0) {
                    return;
                }
                this.cancelButton.setVisible(true);
                this.saving = true;
                this.lastSavedFile = this.saveFile;
                this.mediator.putPersistent("LastMFSaveDir", chooser.getCurrentDirectory().getAbsolutePath());
                new Thread(new HitSaver()).start();
                this.pollTimer = new Timer(500, this);
                this.pollTimer.start();
            }
        } else if (source == this.saveHitsStatisticsMenuItem) {
            JFileChooser chooser;
            int returnVal;
            if (this.saving) {
                JOptionPane.showMessageDialog(null, "Already saving, press Cancel button to interrupt", "Save Hits", 1);
                return;
            }
            ExportResultStatsDialog exDialog = null;
            Window w = SwingUtilities.getWindowAncestor(this);
            exDialog = w instanceof Frame ? new ExportResultStatsDialog((Frame)w) : (w instanceof Dialog ? new ExportResultStatsDialog((Dialog)w) : new ExportResultStatsDialog());
            exDialog.setVisible(true);
            String lastDir = this.mediator.getPersistent("LastMFSaveDir");
            if (lastDir != null) {
                this.lastSavedFile = new File(lastDir);
            }
            if ((returnVal = (chooser = new JFileChooser(this.lastSavedFile)).showSaveDialog(this)) == 0) {
                this.saveFile = chooser.getSelectedFile();
                if (this.saveFile.exists() && (returnVal = JOptionPane.showConfirmDialog(null, this.saveFile.getName() + " already exists, overwrite?", "Save Hits", 0)) != 0) {
                    return;
                }
                this.cancelButton.setVisible(true);
                this.saving = true;
                this.lastSavedFile = this.saveFile;
                this.mediator.putPersistent("LastMFSaveDir", chooser.getCurrentDirectory().getAbsolutePath());
                HitStatisticsSaver saver = new HitStatisticsSaver();
                saver.distinguishHitValues = exDialog.distinguishHits;
                saver.includeFileName = exDialog.includeFileName;
                saver.includeFilePath = exDialog.includeFilePath;
                saver.msFormat = exDialog.msFormat;
                new Thread(saver).start();
                this.pollTimer = new Timer(500, this);
                this.pollTimer.start();
            }
        } else if (source == this.saveFrequencyInfoMenuItem) {
            if (this.saving) {
                JOptionPane.showMessageDialog(null, "Already saving, press Cancel button to interrupt", "Save Hits", 1);
                return;
            }
            JFileChooser chooser = new JFileChooser(this.lastSavedFile);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                this.saveFile = chooser.getSelectedFile();
                if (this.saveFile.exists() && (returnVal = JOptionPane.showConfirmDialog(null, this.saveFile.getName() + " already exists, overwrite?", "Save Frequency Info", 0)) != 0) {
                    return;
                }
                this.cancelButton.setVisible(true);
                this.saving = true;
                this.lastSavedFile = this.saveFile;
                new Thread(new FrequencyInfoSaver()).start();
                this.pollTimer = new Timer(500, this);
                this.pollTimer.start();
            }
        } else if (source == this.prevButton) {
            if (this.saving) {
                return;
            }
            if (this.resultMode == 0) {
                this.firstVisibleHitIndex -= this.nrOfVisibleHits;
            } else if (this.resultMode == 1) {
                this.firstVisibleFrequencyInfoIndex -= this.nrOfVisibleHits;
            }
            this.newLayout();
        } else if (source == this.nextButton) {
            if (this.saving) {
                return;
            }
            if (this.resultMode == 0) {
                this.firstVisibleHitIndex += this.nrOfVisibleHits;
            } else if (this.resultMode == 1) {
                this.firstVisibleFrequencyInfoIndex += this.nrOfVisibleHits;
            }
            this.newLayout();
        } else if (source == this.pollTimer) {
            if (this.saving) {
                int pBarValue = (int)(this.progress * (float)this.progressBar.getMaximum());
                this.progressBar.setValue(pBarValue);
                return;
            }
            this.updateStatistics();
            if (this.progress >= 1.0f) {
                this.stopUpdating();
                this.progressBar.setString("Ready");
                if (this.nHits > 0) {
                    this.saveHitsMenuItem.setEnabled(true);
                }
            }
            if (this.nHits > this.lastVisibleHitIndex) {
                this.nextButton.setVisible(true);
            }
            if (this.nHits > this.nHitsPrev) {
                if (this.lastVisibleHitIndex > this.nHitsPrev) {
                    this.newLayout();
                }
                this.nHitsPrev = this.nHits;
            }
        }
    }

    private void updateStatistics() {
        SearchStatistics stat = this.mediator.getSearchStatistics(this.queryId);
        this.progress = stat.progress;
        this.nHits = stat.nHits;
        this.nAnnotationsWithHit = stat.nAnnotationsWithHit;
        this.nAnnotationsSearched = stat.nAnnotationsSearched;
        this.nFrequencyInfoItems = stat.nFrequencyInfoItems;
        int max = stat.nAnnotationsSearched > this.nHits ? stat.nAnnotationsSearched : this.nHits;
        int nDigits = (int)(0.1 + Math.log(max) / Math.log(10.0)) + 2;
        if (nDigits < 2) {
            nDigits = 2;
        }
        String fmt = ": %" + nDigits + "d";
        this.nHitsLabel.setText(": " + this.formatInt(this.nHits, nDigits));
        this.nAnnotationsWithHitLabel.setText(": " + this.formatInt(stat.nAnnotationsWithHit, nDigits));
        this.nAnnotationsSearchedLabel.setText(": " + this.formatInt(stat.nAnnotationsSearched, nDigits));
        int pBarValue = (int)(this.progress * (float)this.progressBar.getMaximum());
        this.progressBar.setValue(pBarValue);
        if (this.progress == 0.0f) {
            this.progressBar.setString("");
        } else if (this.progress == 1.0f) {
            this.progressBar.setString("READY");
        }
        this.newLayout();
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }

    private String formatInt(int n, int nDigits) {
        String s = Integer.toString(n);
        int nSpaces = nDigits - s.length();
        if (nSpaces > 0) {
            for (int i = 0; i < nSpaces; ++i) {
                s = " " + s;
            }
        }
        return s;
    }

    private void setHitFont(String fontFamily, int fontSize) {
        Font bFont = new Font(fontFamily, 1, fontSize);
        Font pFont = new Font(fontFamily, 0, fontSize);
        Font iFont = new Font(fontFamily, 2, fontSize);
        for (int i = 0; i < 100; ++i) {
            this.hitLabels[i].setFont(bFont);
            this.prefixLabels[i].setFont(pFont);
            this.postfixLabels[i].setFont(pFont);
            this.hitLabelsLeftContext[i].setFont(iFont);
            this.hitLabelsRightContext[i].setFont(iFont);
        }
        this.newLayout();
    }

    private void newLayout() {
        if (this.resultMode == 0) {
            this.newConcordanceLayout();
        } else if (this.resultMode == 1) {
            this.newFrequencyLayout();
        }
        this.validate();
    }

    private void newFrequencyLayout() {
        JLabel countLabel;
        JLabel percentageLabel;
        JLabel postfixLabel;
        JLabel prefixLabel;
        JLabel hitLabel;
        int i;
        this.hitPanel.setBounds(10, 80, this.getWidth() - 20, this.getHeight() - 80);
        int panelMiddle = this.hitPanel.getWidth() / 2;
        this.prevButton.setBounds(panelMiddle - 60, 0, 55, 23);
        this.nextButton.setBounds(panelMiddle + 5, 0, 55, 23);
        int yMargin = 60;
        this.HIT_HEIGHT = this.getStringHeight("knoep", this.hitLabels[0].getFont()) + 5;
        this.labelToHit.clear();
        SearchStatistics searchStatistics = this.mediator.getSearchStatistics(this.queryId);
        this.hitNrLabel.setText("");
        this.nrOfVisibleHits = (this.hitPanel.getHeight() - yMargin) / this.HIT_HEIGHT - 1;
        this.lastVisibleFrequencyInfoIndex = this.firstVisibleFrequencyInfoIndex + this.nrOfVisibleHits;
        if (this.firstVisibleFrequencyInfoIndex <= 0) {
            this.firstVisibleFrequencyInfoIndex = 0;
            this.prevButton.setVisible(false);
            this.prevButton.setEnabled(false);
        } else {
            this.prevButton.setVisible(true);
            this.prevButton.setEnabled(true);
        }
        if (this.nFrequencyInfoItems <= this.lastVisibleFrequencyInfoIndex) {
            this.nextButton.setVisible(false);
        } else {
            this.nextButton.setVisible(true);
        }
        ArrayList frequencyStatistics = this.mediator.getFrequencyInfo(this.firstVisibleFrequencyInfoIndex, this.lastVisibleFrequencyInfoIndex, this.queryId);
        FrequencyInfo freqInfo = null;
        if (frequencyStatistics.size() > 0) {
            freqInfo = (FrequencyInfo)frequencyStatistics.get(0);
        }
        if (freqInfo != null && freqInfo.numberOfHits < 0) {
            for (int i2 = 0; i2 < this.nrOfVisibleHits + 1 + 1; ++i2) {
                JLabel hitLabel2 = this.hitLabels[i2];
                JLabel prefixLabel2 = this.prefixLabels[i2];
                JLabel postfixLabel2 = this.postfixLabels[i2];
                JLabel percentageLabel2 = this.hitLabelsLeftContext[i2];
                JLabel countLabel2 = this.hitLabelsRightContext[i2];
                hitLabel2.setText("");
                hitLabel2.setBounds(0, 0, 0, 0);
                prefixLabel2.setText("");
                prefixLabel2.setBounds(0, 0, 0, 0);
                postfixLabel2.setText("");
                postfixLabel2.setBounds(0, 0, 0, 0);
                percentageLabel2.setText("");
                percentageLabel2.setBounds(0, 0, 0, 0);
                countLabel2.setText("");
                countLabel2.setBounds(0, 0, 0, 0);
            }
            this.headerLabel[0].setText("");
            this.headerLabel[1].setText("");
            this.headerLabel[2].setText("");
            this.saveFrequencyInfoMenuItem.setEnabled(false);
            this.hitLabels[0].setText(freqInfo.annotation);
            this.hitLabels[0].setBounds(50, 100, 1000, this.HIT_HEIGHT);
            this.nextButton.setVisible(false);
            return;
        }
        this.headerLabel[0].setText("Annotation");
        int annotationLabelWidth = this.getStringWidth(this.headerLabel[0].getText(), this.headerLabel[0].getFont());
        this.headerLabel[0].setBounds(panelMiddle / 2 - annotationLabelWidth / 2, 55, annotationLabelWidth + 20, this.HIT_HEIGHT);
        this.headerLabel[1].setText("Percentage");
        int percentageLabelWidth = this.getStringWidth(this.headerLabel[1].getText(), this.headerLabel[1].getFont());
        this.headerLabel[1].setBounds(panelMiddle - percentageLabelWidth / 2, 55, percentageLabelWidth + 20, this.HIT_HEIGHT);
        this.headerLabel[2].setText("Count");
        int countLabelWidth = this.getStringWidth(this.headerLabel[2].getText(), this.headerLabel[2].getFont());
        this.headerLabel[2].setBounds(panelMiddle * 3 / 2 + 10 - countLabelWidth, 55, countLabelWidth + 20, this.HIT_HEIGHT);
        for (i = 0; i < this.nrOfVisibleHits; ++i) {
            hitLabel = this.hitLabels[i];
            prefixLabel = this.prefixLabels[i];
            postfixLabel = this.postfixLabels[i];
            percentageLabel = this.hitLabelsLeftContext[i];
            countLabel = this.hitLabelsRightContext[i];
            if (i < frequencyStatistics.size()) {
                this.hitNrLabel.setText("frequency " + (this.firstVisibleFrequencyInfoIndex + 1) + " - " + (this.firstVisibleFrequencyInfoIndex + i + 1) + " of " + freqInfo.nOccurences);
                int hitNrWidth = this.getStringWidth(this.hitNrLabel.getText(), this.hitNrLabel.getFont());
                int hitNrHeight = this.getStringHeight(this.hitNrLabel.getText(), this.hitNrLabel.getFont());
                this.hitNrLabel.setBounds(panelMiddle - hitNrWidth / 2, 30, hitNrWidth, hitNrHeight);
                freqInfo = (FrequencyInfo)frequencyStatistics.get(i);
                this.labelToHit.put(hitLabel, freqInfo);
                this.labelToHit.put(prefixLabel, freqInfo);
                this.labelToHit.put(postfixLabel, freqInfo);
                this.labelToHit.put(percentageLabel, freqInfo);
                this.labelToHit.put(countLabel, freqInfo);
                if (freqInfo.hitLength == 0) {
                    hitLabel.setBounds(0, 0, 0, 0);
                    String prefixString = freqInfo.annotation;
                    prefixLabel.setText(prefixString);
                    int prefixW = this.getStringWidth(prefixLabel.getText(), prefixLabel.getFont());
                    int prefixX = panelMiddle / 2 - prefixW / 2;
                    prefixLabel.setBounds(prefixX, yMargin + (i + 1) * this.HIT_HEIGHT, panelMiddle - prefixX - 30, this.HIT_HEIGHT);
                    postfixLabel.setBounds(0, 0, 0, 0);
                } else {
                    String hitString = freqInfo.annotation.substring(freqInfo.hitPositionInAnnotation, freqInfo.hitPositionInAnnotation + freqInfo.hitLength);
                    hitLabel.setText(hitString);
                    int hitW = this.getStringWidth(hitLabel.getText(), hitLabel.getFont());
                    int hitX = panelMiddle / 2 - hitW / 2;
                    hitLabel.setBounds(hitX, yMargin + (i + 1) * this.HIT_HEIGHT, panelMiddle - hitX - 30, this.HIT_HEIGHT);
                    String prefixString = freqInfo.annotation.substring(0, freqInfo.hitPositionInAnnotation);
                    prefixLabel.setText(prefixString);
                    int prefixW = this.getStringWidth(prefixLabel.getText(), prefixLabel.getFont());
                    int prefixX = hitX - prefixW;
                    prefixLabel.setBounds(prefixX, yMargin + (i + 1) * this.HIT_HEIGHT, prefixW, this.HIT_HEIGHT);
                    String postfixString = freqInfo.annotation.substring(freqInfo.hitPositionInAnnotation + freqInfo.hitLength);
                    postfixLabel.setText(postfixString);
                    int postfixW = this.getStringWidth(postfixLabel.getText(), postfixLabel.getFont());
                    int postfixX = hitX + hitW;
                    postfixLabel.setBounds(postfixX, yMargin + (i + 1) * this.HIT_HEIGHT, panelMiddle - postfixX - 30, this.HIT_HEIGHT);
                }
                double percentage = 100.0 * (double)freqInfo.numberOfHits / (double)searchStatistics.nAnnotationsWithHit;
                String fmt = "##0.00";
                DecimalFormat df = new DecimalFormat(fmt);
                String percentageString = df.format(percentage) + "%";
                int percentageStringWidth = this.getStringWidth(percentageString, percentageLabel.getFont());
                percentageLabel.setText(percentageString);
                percentageLabel.setBounds(panelMiddle + 20 - percentageStringWidth, yMargin + (i + 1) * this.HIT_HEIGHT, percentageStringWidth, this.HIT_HEIGHT);
                String countString = Integer.toString(freqInfo.numberOfHits);
                int countStringWidth = this.getStringWidth(countString, countLabel.getFont());
                countLabel.setText(countString);
                countLabel.setBounds(panelMiddle * 3 / 2 - countStringWidth, yMargin + (i + 1) * this.HIT_HEIGHT, countStringWidth, this.HIT_HEIGHT);
                continue;
            }
            hitLabel.setText("");
            hitLabel.setBounds(0, 0, 0, 0);
            prefixLabel.setText("");
            prefixLabel.setBounds(0, 0, 0, 0);
            postfixLabel.setText("");
            postfixLabel.setBounds(0, 0, 0, 0);
            percentageLabel.setText("");
            percentageLabel.setBounds(0, 0, 0, 0);
            countLabel.setText("");
            countLabel.setBounds(0, 0, 0, 0);
        }
        for (i = this.nrOfVisibleHits; i < this.nrOfVisibleHits + 1 + 1; ++i) {
            if (i < 0) continue;
            hitLabel = this.hitLabels[i];
            prefixLabel = this.prefixLabels[i];
            postfixLabel = this.postfixLabels[i];
            percentageLabel = this.hitLabelsLeftContext[i];
            countLabel = this.hitLabelsRightContext[i];
            hitLabel.setText("");
            hitLabel.setBounds(0, 0, 0, 0);
            prefixLabel.setText("");
            prefixLabel.setBounds(0, 0, 0, 0);
            postfixLabel.setText("");
            postfixLabel.setBounds(0, 0, 0, 0);
            percentageLabel.setText("");
            percentageLabel.setBounds(0, 0, 0, 0);
            countLabel.setText("");
            countLabel.setBounds(0, 0, 0, 0);
        }
    }

    private void newConcordanceLayout() {
        JLabel hitAfterLabel;
        JLabel hitBeforeLabel;
        JLabel postfixLabel;
        JLabel prefixLabel;
        JLabel hitLabel;
        int i;
        int i2;
        this.hitPanel.setBounds(10, 80, this.getWidth() - 20, this.getHeight() - 80);
        int panelMiddle = this.hitPanel.getWidth() / 2;
        this.prevButton.setBounds(panelMiddle - 60, 0, 55, 23);
        this.nextButton.setBounds(panelMiddle + 5, 0, 55, 23);
        int yMargin = 30;
        if (this.infoBalloonToggleMenuItem.getText().equals("  Show info balloons")) {
            ToolTipManager.sharedInstance().setEnabled(false);
        } else {
            ToolTipManager.sharedInstance().setEnabled(true);
        }
        for (i2 = 0; i2 < this.headerLabel.length; ++i2) {
            this.headerLabel[i2].setBounds(0, 0, 0, 0);
        }
        this.HIT_HEIGHT = this.getStringHeight("knoep", this.hitLabels[0].getFont()) + 5;
        this.labelToHit.clear();
        this.hitNrLabel.setText("");
        this.nrOfVisibleHits = (this.hitPanel.getHeight() - yMargin) / this.HIT_HEIGHT - 1;
        this.lastVisibleHitIndex = this.firstVisibleHitIndex + this.nrOfVisibleHits;
        if (this.firstVisibleHitIndex <= 0) {
            this.firstVisibleHitIndex = 0;
            this.prevButton.setVisible(false);
            this.prevButton.setEnabled(false);
        } else {
            this.prevButton.setVisible(true);
            this.prevButton.setEnabled(true);
        }
        if (this.nHits <= this.lastVisibleHitIndex) {
            this.nextButton.setVisible(false);
        } else {
            this.nextButton.setVisible(true);
        }
        for (i2 = 0; i2 < 100; ++i2) {
            this.hitLabels[i2].setText("");
            this.hitLabels[i2].setBounds(0, 0, 0, 0);
            this.prefixLabels[i2].setText("");
            this.prefixLabels[i2].setBounds(0, 0, 0, 0);
            this.postfixLabels[i2].setText("");
            this.postfixLabels[i2].setBounds(0, 0, 0, 0);
            this.hitLabelsLeftContext[i2].setText("");
            this.hitLabelsLeftContext[i2].setBounds(0, 0, 0, 0);
            this.hitLabelsRightContext[i2].setText("");
            this.hitLabelsRightContext[i2].setBounds(0, 0, 0, 0);
        }
        List hits = this.mediator.getHits(this.firstVisibleHitIndex, this.lastVisibleHitIndex, 8, this.queryId);
        boolean[][] cellsInUse = this.mediator.getMatrixUsage(this.queryId);
        for (i = 0; i < this.nrOfVisibleHits; ++i) {
            hitLabel = this.hitLabels[i];
            prefixLabel = this.prefixLabels[i];
            postfixLabel = this.postfixLabels[i];
            hitBeforeLabel = this.hitLabelsLeftContext[i];
            hitAfterLabel = this.hitLabelsRightContext[i];
            if (i < hits.size()) {
                String hitString;
                this.hitNrLabel.setText("hit " + (this.firstVisibleHitIndex + 1) + " - " + (this.firstVisibleHitIndex + i + 1) + " of " + this.nHits);
                int hitNrWidth = this.getStringWidth(this.hitNrLabel.getText(), this.hitNrLabel.getFont());
                int hitNrHeight = this.getStringHeight(this.hitNrLabel.getText(), this.hitNrLabel.getFont());
                this.hitNrLabel.setBounds(panelMiddle - hitNrWidth / 2, 30, hitNrWidth, hitNrHeight);
                SearchHit hit = (SearchHit)hits.get(i);
                this.labelToHit.put(hitLabel, hit);
                this.labelToHit.put(prefixLabel, hit);
                this.labelToHit.put(postfixLabel, hit);
                this.labelToHit.put(hitBeforeLabel, hit);
                this.labelToHit.put(hitAfterLabel, hit);
                if (hit.tierType.equals("xxxCOMPLEX_QUERY_INDICATORxxx")) {
                    hitString = "";
                    String htmlInfo = "";
                    String[] layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
                    for (int j = 1; j < layerStrings.length; ++j) {
                        String[] layerParts = layerStrings[j].trim().split("xxxSAFE_SPLITTERxxx");
                        hitString = hitString + " #" + layerParts[0] + " ";
                        for (int k = 1; k < layerParts.length; ++k) {
                            boolean doProcess;
                            String part = layerParts[k];
                            boolean bl = cellsInUse != null ? cellsInUse[j - 1][k - 1] : (doProcess = part.charAt(1) != '|');
                            if (doProcess) {
                                if (part.indexOf("xxxNUMBER_SPLITTERxxx") > -1) {
                                    String[] patternParts = part.split("xxxNUMBER_SPLITTERxxx");
                                    String annotation = patternParts[0].substring(1, patternParts[0].length() - 1);
                                    if (annotation.length() > 15) {
                                        annotation = annotation.substring(0, 15) + "...";
                                    } else if (annotation.length() == 0) {
                                        annotation = "|| ";
                                    }
                                    int pos = Integer.parseInt(patternParts[1]) + 1;
                                    String position = pos + "";
                                    while (position.length() < 4) {
                                        position = "0" + position;
                                    }
                                    long bt = Long.parseLong(patternParts[2]);
                                    long et = Long.parseLong(patternParts[3]);
                                    String beginTime = SearchUtil.HHMMSSmmmFormat(bt);
                                    String endTime = SearchUtil.HHMMSSmmmFormat(et);
                                    String duration = SearchUtil.HHMMSSmmmFormat(et - bt);
                                    hitString = hitString + patternParts[0] + " ";
                                    htmlInfo = htmlInfo + "<tr><td>" + annotation + "</td><td>" + "&nbsp;&nbsp;Position: " + position + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Time: " + beginTime + "&nbsp;-&nbsp;" + endTime + "&nbsp;&nbsp;&nbsp;Duration: " + duration + "</td></tr>";
                                    continue;
                                }
                                hitString = hitString + "|| ";
                                htmlInfo = htmlInfo + "<tr><td>||</td><td>&nbsp;</td></tr>";
                                continue;
                            }
                            hitString = hitString + "|| ";
                        }
                    }
                    hitLabel.setText(hitString);
                    String toolTipText = "<html><table border=\"0\"><tr><td> Transcription: </td><td>&nbsp;&nbsp;" + hit.transcriptionName + "</td></tr>" + htmlInfo + "</table></html>";
                    hitLabel.setToolTipText(toolTipText);
                    int hitW = this.getStringWidth(hitLabel.getText(), hitLabel.getFont());
                    int hitX = panelMiddle - hitW / 2;
                    hitLabel.setBounds(hitX, yMargin + (i + 1) * this.HIT_HEIGHT, hitW, this.HIT_HEIGHT);
                    prefixLabel.setText("");
                    prefixLabel.setBounds(0, 0, 0, 0);
                    postfixLabel.setText("");
                    postfixLabel.setBounds(0, 0, 0, 0);
                    hitBeforeLabel.setText("");
                    hitBeforeLabel.setBounds(0, 0, 0, 0);
                    hitAfterLabel.setText("");
                    hitAfterLabel.setBounds(0, 0, 0, 0);
                    continue;
                }
                this.simpleQueryMode = true;
                hitString = hit.annotation.substring(hit.hitPositionInAnnotation, hit.hitPositionInAnnotation + hit.hitLength);
                if (hitString.length() == 0) {
                    hitString = "...";
                }
                hitLabel.setText(hitString);
                String toolTipText = "<html><table border=\"0\"><tr><td> Transcription: </td><td>" + hit.transcriptionName + "</td></tr>" + "<tr><td> Tier name: </td><td>" + hit.tierName + "</td></tr>" + "<tr><td> Tier type: </td><td>" + hit.tierType + "</td></tr>" + "<tr><td> Participant: </td><td>" + hit.participant + "</td></tr>" + "<tr><td> Position in tier: </td><td>" + hit.positionInTier + "</td></tr>";
                toolTipText = hit.aligned ? toolTipText + "<tr><td> begin time: </td><td>" + SearchUtil.HHMMSSmmmFormat(hit.beginTime) + "</td></tr>" + "<tr><td> end time: </td><td>" + SearchUtil.HHMMSSmmmFormat(hit.endTime) + "</td></tr>" + "<tr><td> duration: </td><td>" + SearchUtil.HHMMSSmmmFormat(hit.endTime - hit.beginTime) + "</td></tr>" : toolTipText + "<tr><td> alignment: </td><td> not aligned </td></tr>";
                toolTipText = toolTipText + "</table></html>";
                hitLabel.setToolTipText(toolTipText);
                int hitW = this.getStringWidth(hitLabel.getText(), hitLabel.getFont());
                int hitX = panelMiddle - hitW / 2;
                hitLabel.setBounds(hitX, yMargin + (i + 1) * this.HIT_HEIGHT, hitW, this.HIT_HEIGHT);
                String prefixString = hit.annotation.substring(0, hit.hitPositionInAnnotation);
                prefixLabel.setText(prefixString);
                int prefixW = this.getStringWidth(prefixLabel.getText(), prefixLabel.getFont());
                int prefixX = hitX - prefixW;
                prefixLabel.setBounds(prefixX, yMargin + (i + 1) * this.HIT_HEIGHT, prefixW, this.HIT_HEIGHT);
                prefixLabel.setToolTipText(toolTipText);
                String postfixString = hit.annotation.substring(hit.hitPositionInAnnotation + hit.hitLength);
                postfixLabel.setText(postfixString);
                int postfixW = this.getStringWidth(postfixLabel.getText(), postfixLabel.getFont());
                int postfixX = hitX + hitW;
                postfixLabel.setBounds(postfixX, yMargin + (i + 1) * this.HIT_HEIGHT, postfixW, this.HIT_HEIGHT);
                postfixLabel.setToolTipText(toolTipText);
                int totalHitW = prefixW + hitW + postfixW;
                int totalHitX = prefixX;
                String beforeString = "";
                int maxLeftContext = this.hitContextSize <= hit.leftContext.size() ? this.hitContextSize : hit.leftContext.size();
                for (int j = 0; j < maxLeftContext; ++j) {
                    beforeString = (String)hit.leftContext.get(j) + "  " + beforeString;
                }
                hitBeforeLabel.setText(beforeString);
                int beforeW = this.getStringWidth(hitBeforeLabel.getText(), hitBeforeLabel.getFont());
                int beforeX = totalHitX - beforeW;
                hitBeforeLabel.setBounds(beforeX, yMargin + (i + 1) * this.HIT_HEIGHT, beforeW, this.HIT_HEIGHT);
                String afterString = "";
                int maxRightContext = this.hitContextSize <= hit.rightContext.size() ? this.hitContextSize : hit.rightContext.size();
                for (int j = 0; j < maxRightContext; ++j) {
                    afterString = afterString + "  " + (String)hit.rightContext.get(j);
                }
                hitAfterLabel.setText(afterString);
                int afterW = this.getStringWidth(hitAfterLabel.getText(), hitAfterLabel.getFont());
                hitAfterLabel.setBounds(totalHitX + totalHitW, yMargin + (i + 1) * this.HIT_HEIGHT, afterW, this.HIT_HEIGHT);
                continue;
            }
            hitLabel.setText("");
            hitLabel.setBounds(0, 0, 0, 0);
            prefixLabel.setText("");
            prefixLabel.setBounds(0, 0, 0, 0);
            postfixLabel.setText("");
            postfixLabel.setBounds(0, 0, 0, 0);
            hitBeforeLabel.setText("");
            hitBeforeLabel.setBounds(0, 0, 0, 0);
            hitAfterLabel.setText("");
            hitAfterLabel.setBounds(0, 0, 0, 0);
        }
        for (i = this.nrOfVisibleHits; i < this.nrOfVisibleHits + 1 + 1; ++i) {
            if (i < 0) continue;
            hitLabel = this.hitLabels[i];
            prefixLabel = this.prefixLabels[i];
            postfixLabel = this.postfixLabels[i];
            hitBeforeLabel = this.hitLabelsLeftContext[i];
            hitAfterLabel = this.hitLabelsRightContext[i];
            hitLabel.setText("");
            hitLabel.setBounds(0, 0, 0, 0);
            prefixLabel.setText("");
            prefixLabel.setBounds(0, 0, 0, 0);
            postfixLabel.setText("");
            postfixLabel.setBounds(0, 0, 0, 0);
            hitBeforeLabel.setText("");
            hitBeforeLabel.setBounds(0, 0, 0, 0);
            hitAfterLabel.setText("");
            hitAfterLabel.setBounds(0, 0, 0, 0);
        }
    }

    private int getStringWidth(String str, Font fnt) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rect = fnt.getStringBounds(str, frc);
        return (int)rect.getWidth();
    }

    private int getStringHeight(String str, Font fnt) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rect = fnt.getStringBounds(str, frc);
        return (int)rect.getHeight();
    }

    private class FrequencyInfoSaver
    implements Runnable {
        private FrequencyInfoSaver() {
        }

        public void run() {
            try {
                int i;
                SearchStatistics searchStatistics = SearchResultPanel.this.mediator.getSearchStatistics(SearchResultPanel.this.queryId);
                FileOutputStream fileOutStream = new FileOutputStream(SearchResultPanel.this.saveFile);
                fileOutStream.write(239);
                fileOutStream.write(187);
                fileOutStream.write(191);
                OutputStreamWriter utf8Writer = new OutputStreamWriter((OutputStream)fileOutStream, "UTF-8");
                BufferedWriter out = new BufferedWriter(utf8Writer);
                int stepSize = 100;
                int nToBeSaved = SearchResultPanel.this.nFrequencyInfoItems;
                SearchResultPanel.this.progressBar.setString("Saving");
                String delimiter = "\t";
                String dummyColumns = "";
                for (i = 0; i < 1; ++i) {
                    dummyColumns = dummyColumns + delimiter + " ";
                }
                out.write("\"Annotation\"" + delimiter + "\"Percentage\"" + delimiter + "\"Count\"");
                out.newLine();
                out.newLine();
                for (i = 0; i < SearchResultPanel.this.nFrequencyInfoItems && SearchResultPanel.this.saving; i += stepSize) {
                    SearchResultPanel.this.progress = (float)i / (float)nToBeSaved;
                    ArrayList info = SearchResultPanel.this.mediator.getFrequencyInfo(i, i + stepSize - 1, SearchResultPanel.this.queryId);
                    for (int j = 0; j < info.size(); ++j) {
                        FrequencyInfo freqInfo = (FrequencyInfo)info.get(j);
                        double percentage = 100.0 * (double)freqInfo.numberOfHits / (double)searchStatistics.nAnnotationsWithHit;
                        String fmt = "##0.00";
                        DecimalFormat df = new DecimalFormat(fmt);
                        String percentageString = df.format(percentage);
                        out.write("\"" + freqInfo.annotation.replaceAll("\"", "\"\"") + "\"" + delimiter);
                        out.write(percentageString + delimiter);
                        out.write(freqInfo.numberOfHits + "");
                        out.newLine();
                    }
                    out.flush();
                }
                out.close();
                SearchResultPanel.this.pollTimer.stop();
                SearchResultPanel.this.progressBar.setValue(0);
                SearchResultPanel.this.progressBar.setString("");
                SearchResultPanel.this.cancelButton.setVisible(false);
                if (SearchResultPanel.this.saving) {
                    JOptionPane.showMessageDialog(null, "Ready saving frequency info", "Save Frequency Info", 1);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.toString(), "Save Frequency Info", 0);
            }
            SearchResultPanel.this.saving = false;
        }
    }

    private class HitStatisticsSaver
    implements Runnable {
        private DecimalFormat format2 = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
        String delimiter = "\t";
        boolean distinguishHitValues = false;
        boolean includeFileName = true;
        boolean includeFilePath = true;
        boolean msFormat = true;

        private HitStatisticsSaver() {
        }

        public void run() {
            try {
                FileOutputStream fileOutStream = new FileOutputStream(SearchResultPanel.this.saveFile);
                fileOutStream.write(239);
                fileOutStream.write(187);
                fileOutStream.write(191);
                OutputStreamWriter utf8Writer = new OutputStreamWriter((OutputStream)fileOutStream, "UTF-8");
                BufferedWriter out = new BufferedWriter(utf8Writer);
                int stepSize = 10;
                int nToBeSaved = SearchResultPanel.this.nHits < 100000 ? SearchResultPanel.this.nHits : 100000;
                SearchResultPanel.this.progressBar.setString("Saving");
                if (this.includeFileName) {
                    out.write("\"TranscriptionName\"" + this.delimiter);
                }
                if (this.distinguishHitValues) {
                    out.write("\"Hit\"" + this.delimiter);
                }
                out.write("\"Occurrences\"" + this.delimiter + "\"TotalDuration\"" + this.delimiter + "\"MinDuration\"" + this.delimiter + "\"MaxDuration\"" + this.delimiter + "\"AverageDuration\"" + this.delimiter + "\"MedianDuration\"");
                if (this.includeFilePath) {
                    out.write(this.delimiter + "\"TranscriptionPath\"");
                }
                out.newLine();
                out.newLine();
                ArrayList hits = SearchResultPanel.this.mediator.getHitsFromDatabase(0, 1, 0, SearchResultPanel.this.queryId);
                SearchHit hit = (SearchHit)hits.get(0);
                Object hit2 = null;
                ArrayList<SearchHit> hitsPerFile = new ArrayList<SearchHit>();
                ArrayList<String> filesWithHits = new ArrayList<String>();
                String curFilePath = null;
                for (int i = 0; i < SearchResultPanel.this.nHits && SearchResultPanel.this.saving; i += stepSize) {
                    SearchResultPanel.this.progress = (float)i / (float)nToBeSaved;
                    hits = SearchResultPanel.this.mediator.getHitsFromDatabase(i, i + stepSize, 0, SearchResultPanel.this.queryId);
                    for (int j = 0; j < hits.size(); ++j) {
                        SearchResultPanel.this.progress = (float)(i + j) / (float)nToBeSaved;
                        hit = (SearchHit)hits.get(j);
                        if (!hit.transcriptionName.equals(curFilePath)) {
                            this.writeHits(hitsPerFile, out);
                            hitsPerFile.clear();
                            hitsPerFile.add(hit);
                            filesWithHits.add(hit.transcriptionName);
                            curFilePath = hit.transcriptionName;
                        } else {
                            hitsPerFile.add(hit);
                        }
                        if (j != hits.size() - 1 || i + j != SearchResultPanel.this.nHits - 1) continue;
                        this.writeHits(hitsPerFile, out);
                    }
                }
                if (SearchResultPanel.this.mediator.getDomainInfo() != null && SearchResultPanel.this.mediator.getDomainInfo().size() > 0) {
                    ArrayList allFiles = (ArrayList)SearchResultPanel.this.mediator.getDomainInfo().get(0);
                    for (int i = 0; i < allFiles.size(); ++i) {
                        File file = (File)allFiles.get(i);
                        String filepath = file.getAbsolutePath();
                        if (filesWithHits.contains(filepath)) continue;
                        String fileName = filepath.replace('\\', '/');
                        int lastSep = fileName.lastIndexOf(47);
                        if (lastSep > -1 && lastSep < fileName.length() - 1) {
                            fileName = fileName.substring(lastSep + 1);
                        }
                        if (this.includeFileName) {
                            out.write(fileName);
                            out.write(this.delimiter);
                        }
                        if (this.distinguishHitValues) {
                            out.write("");
                            out.write(this.delimiter);
                        }
                        out.write("0");
                        out.write(this.delimiter);
                        out.write("0");
                        out.write(this.delimiter);
                        out.write("0");
                        out.write(this.delimiter);
                        out.write("0");
                        out.write(this.delimiter);
                        out.write("0");
                        out.write(this.delimiter);
                        out.write("0");
                        if (this.includeFilePath) {
                            out.write(this.delimiter);
                            out.write(filepath);
                        }
                        out.newLine();
                    }
                }
                out.flush();
                out.close();
                SearchResultPanel.this.pollTimer.stop();
                SearchResultPanel.this.progressBar.setValue(0);
                SearchResultPanel.this.progressBar.setString("");
                SearchResultPanel.this.cancelButton.setVisible(false);
                if (SearchResultPanel.this.saving) {
                    JOptionPane.showMessageDialog(null, "Ready saving hits", "Save Hits", 1);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.toString(), "Save Hits", 0);
            }
            SearchResultPanel.this.saving = false;
        }

        private void writeHits(List hitsPerFile, BufferedWriter out) throws IOException {
            HitStats stats;
            if (hitsPerFile == null || hitsPerFile.size() == 0) {
                return;
            }
            SearchHit hit2 = null;
            HashMap<String, HitStats> hitMap = new HashMap<String, HitStats>();
            long b = 0L;
            long e = 0L;
            long d = 0L;
            long divFactor = this.msFormat ? 1L : 1000L;
            for (int m = 0; m < hitsPerFile.size(); ++m) {
                hit2 = (SearchHit)hitsPerFile.get(m);
                String hitRepres = "";
                if (hit2.tierType.equals("xxxCOMPLEX_QUERY_INDICATORxxx")) {
                    String[] layerStrings = hit2.annotation.trim().split("xxxLAYER_SPLITTERxxx");
                    String[] layerParts = null;
                    boolean[][] cellsInUse = SearchResultPanel.this.mediator.getMatrixUsage(SearchResultPanel.this.queryId);
                    boolean firstNonEmptyFound = false;
                    for (int k = 1; k < layerStrings.length; ++k) {
                        layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                        for (int n = 1; n < layerParts.length; ++n) {
                            boolean doProcess;
                            String part = layerParts[n];
                            boolean bl = cellsInUse != null ? cellsInUse[k - 1][n - 1] : (doProcess = part.charAt(1) != '|');
                            if (!doProcess) continue;
                            String[] patternParts = part.split("xxxNUMBER_SPLITTERxxx");
                            if (this.distinguishHitValues) {
                                String annotation = patternParts[0].substring(1, patternParts[0].length() - 1);
                                hitRepres = !firstNonEmptyFound ? annotation : hitRepres + "|" + annotation;
                            }
                            if (!firstNonEmptyFound) {
                                if (patternParts.length > 1) {
                                    b = Long.parseLong(patternParts[2]);
                                    e = Long.parseLong(patternParts[3]);
                                } else {
                                    b = 0L;
                                    e = 0L;
                                }
                            }
                            firstNonEmptyFound = true;
                        }
                    }
                } else {
                    if (this.distinguishHitValues) {
                        hitRepres = hit2.annotation;
                    }
                    b = hit2.beginTime;
                    e = hit2.endTime;
                }
                if ((stats = (HitStats)hitMap.get(hitRepres)) == null) {
                    stats = new HitStats();
                    hitMap.put(hitRepres, stats);
                }
                d = e - b;
                ++stats.numOcc;
                stats.minDur = d < stats.minDur ? d : stats.minDur;
                stats.maxDur = d > stats.maxDur ? d : stats.maxDur;
                stats.totalDur += d;
                stats.firstOcc = b < stats.firstOcc ? b : stats.firstOcc;
                stats.durList.add(new Long(d));
            }
            for (String hitRepres : hitMap.keySet()) {
                stats = (HitStats)hitMap.get(hitRepres);
                float averageDur = 0.0f;
                if (stats.numOcc > 0) {
                    averageDur = (float)stats.totalDur / (float)stats.numOcc;
                }
                Collections.sort(stats.durList);
                int numDurs = stats.durList.size();
                if (numDurs == 1) {
                    stats.medianDur = (Long)stats.durList.get(0);
                } else if (numDurs % 2 != 0) {
                    stats.medianDur = (Long)stats.durList.get(numDurs / 2);
                } else {
                    long h = (Long)stats.durList.get(numDurs / 2);
                    long l = (Long)stats.durList.get(numDurs / 2 - 1);
                    stats.medianDur = (h + l) / 2L;
                }
                String filepath = hit2.transcriptionName;
                filepath = filepath.replace('\\', '/');
                int lastSep = filepath.lastIndexOf(47);
                if (lastSep > -1 && lastSep < filepath.length() - 1) {
                    filepath = filepath.substring(lastSep + 1);
                }
                if (this.includeFileName) {
                    out.write(filepath);
                    out.write(this.delimiter);
                }
                if (this.distinguishHitValues) {
                    out.write(hitRepres);
                    out.write(this.delimiter);
                }
                out.write(String.valueOf(stats.numOcc));
                out.write(this.delimiter);
                out.write(this.format2.format((float)stats.totalDur / (float)divFactor));
                out.write(this.delimiter);
                out.write(this.format2.format((float)stats.minDur / (float)divFactor));
                out.write(this.delimiter);
                out.write(this.format2.format((float)stats.maxDur / (float)divFactor));
                out.write(this.delimiter);
                out.write(this.format2.format((float)stats.totalDur / (float)stats.numOcc / (float)divFactor));
                out.write(this.delimiter);
                out.write(this.format2.format((float)stats.medianDur / (float)divFactor));
                if (this.includeFilePath) {
                    out.write(this.delimiter);
                    out.write(hit2.transcriptionName);
                }
                out.newLine();
            }
        }
    }

    private class HitSaver
    implements Runnable {
        private HitSaver() {
        }

        private String nameFromPath(String path) {
            if (path == null) {
                return path;
            }
            String fileName = path.replace('\\', '/');
            int lastSep = fileName.lastIndexOf(47);
            if (lastSep > -1 && lastSep < fileName.length() - 1) {
                fileName = fileName.substring(lastSep + 1);
            }
            return fileName;
        }

        public void run() {
            try {
                FileOutputStream fileOutStream = new FileOutputStream(SearchResultPanel.this.saveFile);
                fileOutStream.write(239);
                fileOutStream.write(187);
                fileOutStream.write(191);
                OutputStreamWriter utf8Writer = new OutputStreamWriter((OutputStream)fileOutStream, "UTF-8");
                BufferedWriter out = new BufferedWriter(utf8Writer);
                int stepSize = 10;
                int nToBeSaved = SearchResultPanel.this.nHits < 100000 ? SearchResultPanel.this.nHits : 100000;
                SearchResultPanel.this.progressBar.setString("Saving");
                String delimiter = "\t";
                ArrayList hits = SearchResultPanel.this.mediator.getHitsFromDatabase(0, 1, SearchResultPanel.this.hitContextSize, SearchResultPanel.this.queryId);
                SearchHit hit = (SearchHit)hits.get(0);
                boolean includeFilePath = true;
                boolean includeFileName = false;
                boolean msFormat = true;
                String[] headers = null;
                String val = null;
                String[] vals = null;
                val = SearchResultPanel.this.mediator.getPersistent("MFSearchResult.ExportIncludeFileName");
                if (val != null) {
                    includeFileName = Boolean.parseBoolean(val);
                }
                if ((val = SearchResultPanel.this.mediator.getPersistent("MFSearchResult.ExportIncludeFilePath")) != null) {
                    includeFilePath = Boolean.parseBoolean(val);
                }
                if ((val = SearchResultPanel.this.mediator.getPersistent("MFSearchResult.ExportTimeFormat")) != null) {
                    boolean bl = msFormat = !val.equals("sec.ms");
                }
                if (hit.tierType.equals("xxxCOMPLEX_QUERY_INDICATORxxx")) {
                    int j;
                    int i;
                    boolean multipleRowsPerHit = false;
                    boolean transcriptionInFirstColumn = false;
                    boolean transcriptionHeaderIncluded = false;
                    val = SearchResultPanel.this.mediator.getPersistent("MFSearchResultComplex.ExportColumnOrder");
                    if (val != null) {
                        vals = val.split(",");
                    }
                    if (vals == null || vals.length == 0) {
                        headers = Constants.EXPORT_HEADERS_COMPLEX;
                    } else {
                        val = SearchResultPanel.this.mediator.getPersistent("MFSearchResultComplex.ExportColumnIncluded");
                        if (val != null) {
                            int i2;
                            String[] colInd = val.split(",");
                            int[] incCols = new int[colInd.length];
                            for (i2 = 0; i2 < colInd.length; ++i2) {
                                try {
                                    incCols[i2] = Integer.parseInt(colInd[i2]);
                                    continue;
                                }
                                catch (NumberFormatException nfe) {
                                    incCols[i2] = -1;
                                }
                            }
                            headers = new String[incCols.length];
                            for (i2 = 0; i2 < incCols.length; ++i2) {
                                headers[i2] = incCols[i2] >= 0 && incCols[i2] < vals.length ? vals[incCols[i2]] : "";
                            }
                        } else {
                            headers = vals;
                        }
                    }
                    val = SearchResultPanel.this.mediator.getPersistent("MFSearchResultComplex.ExportMultipleRowsPerHit");
                    if (val != null) {
                        multipleRowsPerHit = Boolean.parseBoolean(val);
                    }
                    boolean[][] cellsInUse = SearchResultPanel.this.mediator.getMatrixUsage(SearchResultPanel.this.queryId);
                    String[] layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
                    String[] layerParts = null;
                    if (cellsInUse == null) {
                        cellsInUse = new boolean[Constants.COMPLEX_SEARCH_MATRIX_SIZE[0]][Constants.COMPLEX_SEARCH_MATRIX_SIZE[1]];
                        for (int k = 1; k < layerStrings.length; ++k) {
                            layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                            for (int n = 1; n < layerParts.length; ++n) {
                                String part = layerParts[n];
                                if (part.charAt(1) == '|') continue;
                                cellsInUse[k - 1][n - 1] = true;
                            }
                        }
                    }
                    if (headers[0].equals("TranscriptionName")) {
                        if (includeFilePath || !includeFilePath && !includeFileName) {
                            out.write("\"" + headers[0] + "\"");
                        }
                        if (includeFileName) {
                            if (includeFilePath) {
                                out.write(delimiter);
                            }
                            out.write("\"" + headers[0] + "\"");
                        }
                        transcriptionInFirstColumn = true;
                        transcriptionHeaderIncluded = true;
                        out.write(delimiter);
                    }
                    if (multipleRowsPerHit) {
                        block10: for (i = 0; i < Constants.COMPLEX_SEARCH_MATRIX_SIZE[1]; ++i) {
                            for (j = 0; j < cellsInUse.length; ++j) {
                                if (!cellsInUse[j][i]) continue;
                                for (int k = 0; k < headers.length; ++k) {
                                    if (headers[k].equals("TranscriptionName")) continue;
                                    if (headers[k].equals("Annotation")) {
                                        out.write("\"" + headers[k] + "x-" + (i + 1) + "\"");
                                        out.write(delimiter);
                                        continue;
                                    }
                                    out.write("\"" + headers[k] + "\"");
                                    out.write(delimiter);
                                }
                                continue block10;
                            }
                        }
                    } else {
                        for (i = 0; i < cellsInUse.length; ++i) {
                            for (j = 0; j < cellsInUse[i].length; ++j) {
                                if (!cellsInUse[i][j]) continue;
                                for (int k = 0; k < headers.length; ++k) {
                                    if (headers[k].equals("TranscriptionName")) continue;
                                    if (headers[k].equals("Annotation")) {
                                        out.write("\"" + headers[k] + (i + 1) + "-" + (j + 1) + "\"");
                                        out.write(delimiter);
                                        continue;
                                    }
                                    out.write("\"" + headers[k] + "\"");
                                    out.write(delimiter);
                                }
                            }
                        }
                    }
                    if (!transcriptionInFirstColumn) {
                        for (i = 0; i < headers.length; ++i) {
                            if (!Constants.EXPORT_HEADERS_COMPLEX[5].equals(headers[i])) continue;
                            transcriptionHeaderIncluded = true;
                        }
                        if (transcriptionHeaderIncluded) {
                            if (includeFilePath || !includeFilePath && !includeFileName) {
                                out.write("\"" + Constants.EXPORT_HEADERS_COMPLEX[5] + "\"");
                            }
                            if (includeFileName) {
                                if (includeFilePath) {
                                    out.write(delimiter);
                                }
                                out.write("\"" + Constants.EXPORT_HEADERS_COMPLEX[5] + "\"");
                            }
                        }
                    }
                    out.newLine();
                    out.newLine();
                    for (i = 0; i < SearchResultPanel.this.nHits && SearchResultPanel.this.saving; i += stepSize) {
                        SearchResultPanel.this.progress = (float)i / (float)nToBeSaved;
                        hits = SearchResultPanel.this.mediator.getHitsFromDatabase(i, i + stepSize, SearchResultPanel.this.hitContextSize, SearchResultPanel.this.queryId);
                        for (j = 0; j < hits.size(); ++j) {
                            int h;
                            int h2;
                            long duration;
                            long endTime;
                            long beginTime;
                            int position;
                            String annotation;
                            String[] patternParts;
                            String part;
                            int n;
                            int k;
                            hit = (SearchHit)hits.get(j);
                            layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
                            if (multipleRowsPerHit) {
                                block19: for (k = 1; k < layerStrings.length; ++k) {
                                    int z;
                                    for (z = 0; z < cellsInUse[k - 1].length && !cellsInUse[k - 1][z]; ++z) {
                                        if (z == cellsInUse[k - 1].length - 1) continue block19;
                                    }
                                    if (transcriptionInFirstColumn) {
                                        if (includeFilePath || !includeFilePath && !includeFileName) {
                                            out.write(hit.transcriptionName);
                                        }
                                        if (includeFileName) {
                                            if (includeFilePath) {
                                                out.write(delimiter);
                                            }
                                            out.write(this.nameFromPath(hit.transcriptionName));
                                        }
                                        out.write(delimiter);
                                    }
                                    layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                                    block21: for (n = 1; n < layerParts.length; ++n) {
                                        part = layerParts[n];
                                        if (cellsInUse[k - 1][n - 1]) {
                                            patternParts = part.split("xxxNUMBER_SPLITTERxxx");
                                            annotation = patternParts[0].substring(1, patternParts[0].length() - 1);
                                            if (patternParts.length > 1) {
                                                position = Integer.parseInt(patternParts[1]);
                                                beginTime = Long.parseLong(patternParts[2]);
                                                endTime = Long.parseLong(patternParts[3]);
                                                duration = endTime - beginTime;
                                                for (h2 = 0; h2 < headers.length; ++h2) {
                                                    if (headers[h2].equals(Constants.EXPORT_HEADERS_COMPLEX[0])) {
                                                        out.write(annotation);
                                                    } else if (headers[h2].equals(Constants.EXPORT_HEADERS_COMPLEX[1])) {
                                                        out.write(Integer.toString(position + 1));
                                                    } else if (headers[h2].equals(Constants.EXPORT_HEADERS_COMPLEX[2])) {
                                                        if (msFormat) {
                                                            out.write(Long.toString(beginTime));
                                                        } else {
                                                            out.write(String.valueOf((float)beginTime / 1000.0f));
                                                        }
                                                    } else if (headers[h2].equals(Constants.EXPORT_HEADERS_COMPLEX[3])) {
                                                        if (msFormat) {
                                                            out.write(Long.toString(endTime));
                                                        } else {
                                                            out.write(String.valueOf((float)endTime / 1000.0f));
                                                        }
                                                    } else if (headers[h2].equals(Constants.EXPORT_HEADERS_COMPLEX[4])) {
                                                        if (msFormat) {
                                                            out.write(Long.toString(duration));
                                                        } else {
                                                            out.write(String.valueOf((float)duration / 1000.0f));
                                                        }
                                                    } else if (headers[h2].equals(Constants.EXPORT_HEADERS_COMPLEX[5])) continue;
                                                    out.write(delimiter);
                                                }
                                                continue;
                                            }
                                            for (h = 0; h < headers.length; ++h) {
                                                if (headers[h].equals(Constants.EXPORT_HEADERS_COMPLEX[0])) {
                                                    out.write(annotation);
                                                } else if (headers[h].equals(Constants.EXPORT_HEADERS_COMPLEX[1])) {
                                                    out.write("0");
                                                } else if (headers[h].equals(Constants.EXPORT_HEADERS_COMPLEX[2])) {
                                                    if (msFormat) {
                                                        out.write("0");
                                                    } else {
                                                        out.write("0.0");
                                                    }
                                                } else if (headers[h].equals(Constants.EXPORT_HEADERS_COMPLEX[3])) {
                                                    if (msFormat) {
                                                        out.write("0");
                                                    } else {
                                                        out.write("0.0");
                                                    }
                                                } else if (headers[h].equals(Constants.EXPORT_HEADERS_COMPLEX[4])) {
                                                    if (msFormat) {
                                                        out.write("0");
                                                    } else {
                                                        out.write("0.0");
                                                    }
                                                } else if (headers[h].equals(Constants.EXPORT_HEADERS_COMPLEX[5])) continue;
                                                out.write(delimiter);
                                            }
                                            continue;
                                        }
                                        for (int g = 0; g < cellsInUse.length; ++g) {
                                            if (!cellsInUse[g][n - 1]) continue;
                                            for (int h3 = 0; h3 < headers.length; ++h3) {
                                                if (transcriptionHeaderIncluded && (!transcriptionHeaderIncluded || h3 == headers.length - 1)) continue;
                                                out.write(delimiter);
                                            }
                                            continue block21;
                                        }
                                    }
                                    if (!transcriptionInFirstColumn && transcriptionHeaderIncluded) {
                                        if (includeFilePath || !includeFilePath && !includeFileName) {
                                            out.write(hit.transcriptionName);
                                        }
                                        if (includeFileName) {
                                            if (includeFilePath) {
                                                out.write(delimiter);
                                            }
                                            out.write(this.nameFromPath(hit.transcriptionName));
                                        }
                                    }
                                    if (k == layerStrings.length - 1) continue;
                                    for (z = 0; z < cellsInUse[k].length; ++z) {
                                        if (!cellsInUse[k][z]) continue;
                                        out.newLine();
                                        continue block19;
                                    }
                                }
                            } else {
                                if (transcriptionInFirstColumn) {
                                    if (includeFilePath || !includeFilePath && !includeFileName) {
                                        out.write(hit.transcriptionName);
                                    }
                                    if (includeFileName) {
                                        if (includeFilePath) {
                                            out.write(delimiter);
                                        }
                                        out.write(this.nameFromPath(hit.transcriptionName));
                                    }
                                    out.write(delimiter);
                                }
                                for (k = 1; k < layerStrings.length; ++k) {
                                    layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                                    for (n = 1; n < layerParts.length; ++n) {
                                        part = layerParts[n];
                                        if (!cellsInUse[k - 1][n - 1]) continue;
                                        patternParts = part.split("xxxNUMBER_SPLITTERxxx");
                                        annotation = patternParts[0].substring(1, patternParts[0].length() - 1);
                                        if (patternParts.length > 1) {
                                            position = Integer.parseInt(patternParts[1]);
                                            beginTime = Long.parseLong(patternParts[2]);
                                            endTime = Long.parseLong(patternParts[3]);
                                            duration = endTime - beginTime;
                                            for (h2 = 0; h2 < headers.length; ++h2) {
                                                if (headers[h2].equals(Constants.EXPORT_HEADERS_COMPLEX[0])) {
                                                    out.write(annotation);
                                                } else if (headers[h2].equals(Constants.EXPORT_HEADERS_COMPLEX[1])) {
                                                    out.write(Integer.toString(position + 1));
                                                } else if (headers[h2].equals(Constants.EXPORT_HEADERS_COMPLEX[2])) {
                                                    if (msFormat) {
                                                        out.write(Long.toString(beginTime));
                                                    } else {
                                                        out.write(String.valueOf((float)beginTime / 1000.0f));
                                                    }
                                                } else if (headers[h2].equals(Constants.EXPORT_HEADERS_COMPLEX[3])) {
                                                    if (msFormat) {
                                                        out.write(Long.toString(endTime));
                                                    } else {
                                                        out.write(String.valueOf((float)endTime / 1000.0f));
                                                    }
                                                } else if (headers[h2].equals(Constants.EXPORT_HEADERS_COMPLEX[4])) {
                                                    if (msFormat) {
                                                        out.write(Long.toString(duration));
                                                    } else {
                                                        out.write(String.valueOf((float)duration / 1000.0f));
                                                    }
                                                } else if (headers[h2].equals(Constants.EXPORT_HEADERS_COMPLEX[5])) continue;
                                                out.write(delimiter);
                                            }
                                            continue;
                                        }
                                        for (h = 0; h < headers.length; ++h) {
                                            if (headers[h].equals(Constants.EXPORT_HEADERS_COMPLEX[0])) {
                                                out.write(annotation);
                                            } else if (headers[h].equals(Constants.EXPORT_HEADERS_COMPLEX[1])) {
                                                out.write("0");
                                            } else if (headers[h].equals(Constants.EXPORT_HEADERS_COMPLEX[2])) {
                                                if (msFormat) {
                                                    out.write("0");
                                                } else {
                                                    out.write("0.0");
                                                }
                                            } else if (headers[h].equals(Constants.EXPORT_HEADERS_COMPLEX[3])) {
                                                if (msFormat) {
                                                    out.write("0");
                                                } else {
                                                    out.write("0.0");
                                                }
                                            } else if (headers[h].equals(Constants.EXPORT_HEADERS_COMPLEX[4])) {
                                                if (msFormat) {
                                                    out.write("0");
                                                } else {
                                                    out.write("0.0");
                                                }
                                            } else if (headers[h].equals(Constants.EXPORT_HEADERS_COMPLEX[5])) continue;
                                            out.write(delimiter);
                                        }
                                    }
                                }
                                if (!transcriptionInFirstColumn && transcriptionHeaderIncluded) {
                                    if (includeFilePath || !includeFilePath && !includeFileName) {
                                        out.write(hit.transcriptionName);
                                    }
                                    if (includeFileName) {
                                        if (includeFilePath) {
                                            out.write(delimiter);
                                        }
                                        out.write(this.nameFromPath(hit.transcriptionName));
                                    }
                                }
                            }
                            out.newLine();
                        }
                    }
                } else {
                    int i;
                    val = SearchResultPanel.this.mediator.getPersistent("MFSearchResult.ExportColumnOrder");
                    if (val != null) {
                        vals = val.split(",");
                    }
                    if (vals == null || vals.length == 0) {
                        headers = Constants.EXPORT_HEADERS;
                    } else {
                        val = SearchResultPanel.this.mediator.getPersistent("MFSearchResult.ExportColumnIncluded");
                        if (val != null) {
                            int i3;
                            String[] colInd = val.split(",");
                            int[] incCols = new int[colInd.length];
                            for (i3 = 0; i3 < colInd.length; ++i3) {
                                try {
                                    incCols[i3] = Integer.parseInt(colInd[i3]);
                                    continue;
                                }
                                catch (NumberFormatException nfe) {
                                    incCols[i3] = -1;
                                }
                            }
                            headers = new String[incCols.length];
                            for (i3 = 0; i3 < incCols.length; ++i3) {
                                headers[i3] = incCols[i3] >= 0 && incCols[i3] < vals.length ? vals[incCols[i3]] : "";
                            }
                        } else {
                            headers = vals;
                        }
                    }
                    for (i = 0; i < headers.length; ++i) {
                        if (headers[i].equals("TranscriptionName")) {
                            if (includeFilePath || !includeFilePath && !includeFileName) {
                                out.write("\"" + headers[i] + "\"");
                            }
                            if (includeFileName) {
                                if (includeFilePath) {
                                    out.write(delimiter);
                                }
                                out.write("\"" + headers[i] + "\"");
                            }
                        } else {
                            out.write("\"" + headers[i] + "\"");
                        }
                        if (i == headers.length - 1) continue;
                        out.write(delimiter);
                    }
                    out.newLine();
                    out.newLine();
                    for (i = 0; i < SearchResultPanel.this.nHits && SearchResultPanel.this.saving; i += stepSize) {
                        SearchResultPanel.this.progress = (float)i / (float)nToBeSaved;
                        hits = SearchResultPanel.this.mediator.getHitsFromDatabase(i, i + stepSize, SearchResultPanel.this.hitContextSize, SearchResultPanel.this.queryId);
                        for (int j = 0; j < hits.size(); ++j) {
                            hit = (SearchHit)hits.get(j);
                            for (int k = 0; k < headers.length; ++k) {
                                int z;
                                if (headers[k].equals(Constants.EXPORT_HEADERS[0])) {
                                    out.write("\"" + hit.annotation.replaceAll("\"", "\"\"") + "\"");
                                } else if (headers[k].equals(Constants.EXPORT_HEADERS[1])) {
                                    out.write(Integer.toString(hit.hitPositionInAnnotation + 1));
                                } else if (headers[k].equals(Constants.EXPORT_HEADERS[2])) {
                                    out.write(Integer.toString(hit.hitLength));
                                } else if (headers[k].equals(Constants.EXPORT_HEADERS[3])) {
                                    out.write(Integer.toString(hit.hitNumberInAnnotation));
                                } else if (headers[k].equals(Constants.EXPORT_HEADERS[4])) {
                                    if (msFormat) {
                                        out.write(Long.toString(hit.beginTime));
                                    } else {
                                        out.write(String.valueOf((float)hit.beginTime / 1000.0f));
                                    }
                                } else if (headers[k].equals(Constants.EXPORT_HEADERS[5])) {
                                    if (msFormat) {
                                        out.write(Long.toString(hit.endTime));
                                    } else {
                                        out.write(String.valueOf((float)hit.endTime / 1000.0f));
                                    }
                                } else if (headers[k].equals(Constants.EXPORT_HEADERS[6])) {
                                    if (msFormat) {
                                        out.write(Long.toString(hit.endTime - hit.beginTime));
                                    } else {
                                        out.write(String.valueOf((float)(hit.endTime - hit.beginTime) / 1000.0f));
                                    }
                                } else if (headers[k].equals(Constants.EXPORT_HEADERS[7])) {
                                    out.write(Integer.toString(hit.positionInTier));
                                } else if (headers[k].equals(Constants.EXPORT_HEADERS[8])) {
                                    out.write("\"" + hit.tierName.replaceAll("\"", "\"\"") + "\"");
                                } else if (headers[k].equals(Constants.EXPORT_HEADERS[9])) {
                                    out.write("\"" + hit.tierType.replaceAll("\"", "\"\"") + "\"");
                                } else if (headers[k].equals(Constants.EXPORT_HEADERS[10])) {
                                    if (hit.leftContext.size() > 0) {
                                        String leftContext = (String)hit.leftContext.get(0);
                                        for (z = 1; z < hit.leftContext.size(); ++z) {
                                            leftContext = (String)hit.leftContext.get(z) + "  " + leftContext;
                                        }
                                        out.write("\"" + leftContext.replaceAll("\"", "\"\"") + "\"");
                                    } else {
                                        out.write("\"\"");
                                    }
                                } else if (headers[k].equals(Constants.EXPORT_HEADERS[11])) {
                                    if (hit.rightContext.size() > 0) {
                                        String rightContext = (String)hit.rightContext.get(0);
                                        for (z = 1; z < hit.rightContext.size(); ++z) {
                                            rightContext = rightContext + "  " + (String)hit.rightContext.get(z);
                                        }
                                        out.write("\"" + rightContext.replaceAll("\"", "\"\"") + "\"");
                                    } else {
                                        out.write("\"\"");
                                    }
                                } else if (headers[k].equals(Constants.EXPORT_HEADERS[12])) {
                                    if (includeFilePath || !includeFilePath && !includeFileName) {
                                        out.write(hit.transcriptionName);
                                    }
                                    if (includeFileName) {
                                        String filepath;
                                        int lastSep;
                                        if (includeFilePath) {
                                            out.write(delimiter);
                                        }
                                        if ((lastSep = (filepath = hit.transcriptionName.replace('\\', '/')).lastIndexOf(47)) > -1 && lastSep < filepath.length() - 1) {
                                            filepath = filepath.substring(lastSep + 1);
                                        }
                                        out.write(filepath);
                                    }
                                }
                                if (k == headers.length - 1) continue;
                                out.write(delimiter);
                            }
                            out.newLine();
                        }
                    }
                }
                out.flush();
                out.close();
                SearchResultPanel.this.pollTimer.stop();
                SearchResultPanel.this.progressBar.setValue(0);
                SearchResultPanel.this.progressBar.setString("");
                SearchResultPanel.this.cancelButton.setVisible(false);
                if (SearchResultPanel.this.saving) {
                    JOptionPane.showMessageDialog(null, "Ready saving hits", "Save Hits", 1);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.toString(), "Save Hits", 0);
            }
            SearchResultPanel.this.saving = false;
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                if (SearchResultPanel.this.resultMode == 0) {
                    SearchResultPanel.this.activeHit = SearchResultPanel.this.labelToHit.get(e.getSource());
                    if (SearchResultPanel.this.activeHit != null) {
                        SearchResultPanel.this.showHitMenuItem.setEnabled(true);
                        if (SearchResultPanel.this.showHitInCorpusTreeMenuItem != null) {
                            SearchResultPanel.this.showHitInCorpusTreeMenuItem.setEnabled(true);
                        }
                    } else {
                        SearchResultPanel.this.showHitMenuItem.setEnabled(false);
                        if (SearchResultPanel.this.showHitInCorpusTreeMenuItem != null) {
                            SearchResultPanel.this.showHitInCorpusTreeMenuItem.setEnabled(false);
                        }
                    }
                    SearchResultPanel.this.concordancePopup.show(e.getComponent(), e.getX(), e.getY());
                } else if (SearchResultPanel.this.resultMode == 1) {
                    SearchResultPanel.this.activeHit = SearchResultPanel.this.labelToHit.get(e.getSource());
                    SearchResultPanel.this.frequencyPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                SearchResultPanel.this.activeHit = SearchResultPanel.this.labelToHit.get(e.getSource());
                if (SearchResultPanel.this.activeHit != null) {
                    SearchResultPanel.this.mediator.showInViewer(SearchResultPanel.this.activeHit, SearchResultPanel.this.queryId);
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (SearchResultPanel.this.infoBalloonToggleMenuItem.getText().equals("  Show info balloons")) {
                ToolTipManager.sharedInstance().setEnabled(false);
            } else {
                ToolTipManager.sharedInstance().setEnabled(true);
            }
        }
    }

    private class DelayedNewLayout
    extends Thread {
        private DelayedNewLayout() {
        }

        public void run() {
            try {
                DelayedNewLayout.sleep(200L);
                SearchResultPanel.this.newLayout();
                SearchResultPanel.this.validate();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class ComponentHandler
    extends ComponentAdapter {
        private ComponentHandler() {
        }

        public void componentResized(ComponentEvent e) {
            SearchResultPanel.this.dimension = new Dimension(SearchResultPanel.this.getWidth(), SearchResultPanel.this.getHeight());
            if (SearchResultPanel.this.delayedNewLayout != null) {
                SearchResultPanel.this.delayedNewLayout.interrupt();
            }
            SearchResultPanel.this.delayedNewLayout = new DelayedNewLayout();
            SearchResultPanel.this.delayedNewLayout.start();
        }
    }
}

