/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.swingsearch;

import java.text.DecimalFormat;

public class SearchUtil {
    public static final long ILLEGAL_TIME_FLAG = 98373696L;
    private static final DecimalFormat twoDigits = new DecimalFormat("00");
    private static final DecimalFormat threeFracs = new DecimalFormat("00.000");

    public static String HHMMSSmmmFormat(long timeInMillis) {
        float time = (float)timeInMillis / 1000.0f;
        int hours = (int)Math.floor(time / 3600.0f);
        int minutes = (int)Math.floor((time - (float)(3600 * hours)) / 60.0f);
        float seconds = time - (float)(3600 * hours) - (float)(60 * minutes);
        return twoDigits.format(hours) + ":" + twoDigits.format(minutes) + ":" + threeFracs.format(seconds);
    }

    public static String formatShortTimeString(long timeInMillis) {
        String big = SearchUtil.HHMMSSmmmFormat(timeInMillis);
        while (big.indexOf("00:") == 0) {
            big = big.substring(3);
        }
        if (timeInMillis < 10000L) {
            big = big.substring(1);
        }
        big = big.replace(".000", "");
        return big;
    }

    public static long parseTimeString(String timeString) {
        try {
            String[] seconds;
            int colonPos = timeString.indexOf(":");
            int dotPos = timeString.indexOf(".");
            if (colonPos < 0 && dotPos < 0) {
                return Long.parseLong(timeString.trim());
            }
            String[] parts = timeString.trim().split(":");
            if (parts.length != 3) {
                return 98373696L;
            }
            if (parts[2].indexOf(".") == -1) {
                parts[2] = parts[2] + ".000";
            }
            if ((seconds = parts[2].split("\\.")).length != 2) {
                return 98373696L;
            }
            while (seconds[1].length() < 3) {
                seconds[1] = seconds[1] + "0";
            }
            long value = 3600000L * (long)Integer.parseInt(parts[0].trim());
            value += 60000L * (long)Integer.parseInt(parts[1].trim());
            value += 1000L * (long)Integer.parseInt(seconds[0].trim());
            return value += (long)Integer.parseInt(seconds[1].trim());
        }
        catch (NumberFormatException nfe) {
            return 98373696L;
        }
    }
}

