/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mpi.dcr.DCIdComparator;
import mpi.dcr.DCIdentifierComparator;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.DCTree;
import mpi.dcr.ILATDCRConnector;
import mpi.dcr.isocat.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDCSelectPanel
extends JPanel
implements ActionListener,
ItemListener,
ListSelectionListener,
TreeSelectionListener {
    protected ILATDCRConnector connector = null;
    protected JPanel profPanel;
    protected JList profList;
    protected DefaultListModel profModel;
    protected JPanel catPanel;
    protected JLabel sortModeLabel;
    protected JComboBox sortModeCombo;
    protected String[] sortModes;
    protected JScrollPane catScroll;
    protected JList catList;
    protected DefaultListModel catModel;
    protected JTree catTree;
    protected DefaultMutableTreeNode rootNode;
    protected JPanel descPanel;
    protected JTextArea descArea;
    protected JLabel identifierKeyLabel;
    protected JLabel identifierValLabel;
    protected JLabel idKeyLabel;
    protected JLabel idValLabel;
    protected JLabel profilesKeyLabel;
    protected JLabel profilesValLabel;
    protected final int BY_ALPHA = 0;
    protected final int BY_ID = 1;
    protected final int BY_CONCEPT = 2;
    protected int sortMode = 0;
    protected Profile currentProfile = null;
    protected final String EMPTY = "-";
    protected ResourceBundle resBundle;

    public AbstractDCSelectPanel(ILATDCRConnector connector) {
        this.connector = connector;
    }

    public AbstractDCSelectPanel(ILATDCRConnector connector, ResourceBundle resBundle) {
        this.connector = connector;
        this.resBundle = resBundle;
    }

    public AbstractDCSelectPanel() {
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.profPanel = new JPanel(new GridBagLayout());
        this.profModel = new DefaultListModel();
        this.profList = new JList(this.profModel);
        this.profList.getSelectionModel().setSelectionMode(0);
        this.profList.addListSelectionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.profPanel.add((Component)new JScrollPane(this.profList), gbc);
        this.catPanel = new JPanel(new GridBagLayout());
        this.sortModeLabel = new JLabel();
        this.sortModeCombo = new JComboBox();
        this.sortModeCombo.addItemListener(this);
        this.catScroll = new JScrollPane();
        this.catModel = new DefaultListModel();
        this.catList = new JList(this.catModel);
        this.catList.addListSelectionListener(this);
        this.rootNode = new DefaultMutableTreeNode();
        this.catTree = new JTree(this.rootNode);
        this.catTree.setRootVisible(false);
        ((DefaultTreeCellRenderer)this.catTree.getCellRenderer()).setLeafIcon(null);
        ((DefaultTreeCellRenderer)this.catTree.getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)this.catTree.getCellRenderer()).setClosedIcon(null);
        this.catTree.setShowsRootHandles(true);
        this.catTree.addTreeSelectionListener(this);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.catPanel.add((Component)this.sortModeLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridy = 1;
        this.catPanel.add((Component)this.sortModeCombo, gbc);
        this.catScroll.setViewportView(this.catList);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 2;
        this.catPanel.add((Component)this.catScroll, gbc);
        this.catScroll.setViewportView(this.catList);
        this.identifierKeyLabel = new JLabel();
        this.identifierValLabel = new JLabel();
        this.idKeyLabel = new JLabel();
        this.idValLabel = new JLabel();
        this.profilesKeyLabel = new JLabel();
        this.profilesValLabel = new JLabel();
        Insets spacerInsets = new Insets(2, 6, 10, 6);
        this.descPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.descPanel.add((Component)this.identifierKeyLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = spacerInsets;
        this.descPanel.add((Component)this.identifierValLabel, gbc);
        gbc.gridy = 2;
        gbc.insets = insets;
        this.descPanel.add((Component)this.idKeyLabel, gbc);
        gbc.gridy = 3;
        gbc.insets = spacerInsets;
        this.descPanel.add((Component)this.idValLabel, gbc);
        gbc.gridy = 4;
        gbc.insets = insets;
        this.descPanel.add((Component)this.profilesKeyLabel, gbc);
        gbc.gridy = 5;
        gbc.insets = spacerInsets;
        this.descPanel.add((Component)this.profilesValLabel, gbc);
        this.descArea = new JTextArea();
        this.descArea.setEditable(false);
        this.descArea.setLineWrap(true);
        this.descArea.setWrapStyleWord(true);
        Dimension dim = new Dimension(220, 300);
        gbc = new GridBagConstraints();
        gbc.gridy = 6;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.descPanel.add((Component)new JScrollPane(this.descArea), gbc);
        this.profPanel.setMinimumSize(dim);
        this.profPanel.setPreferredSize(dim);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        this.add((Component)this.profPanel, gbc);
        gbc.gridx = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        this.add((Component)this.catPanel, gbc);
        this.descPanel.setMinimumSize(dim);
        this.descPanel.setPreferredSize(dim);
        gbc.gridx = 2;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this.descPanel, gbc);
        Font valFont = this.identifierKeyLabel.getFont().deriveFont(2, 10.0f);
        this.identifierValLabel.setFont(valFont);
        this.idValLabel.setFont(valFont);
        this.profilesValLabel.setFont(valFont);
        this.updateLocale();
    }

    protected void updateLocale() {
        String selProf = "Select Profile";
        String selCat = "Select Category";
        String sortCat = "Sort Categories:";
        String alpha = "Alphabetically";
        String byId = "By Id";
        String byBC = "By Broader Concept";
        String desc = "Category Description";
        String ident = "Identifier";
        String id = "Id";
        String profs = "Profiles";
        this.sortModes = new String[3];
        if (this.resBundle != null) {
            try {
                selProf = this.resBundle.getString("DCR.Label.SelectProfile");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                selCat = this.resBundle.getString("DCR.Label.SelectCategory");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                sortCat = this.resBundle.getString("DCR.Label.SortCategories");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                alpha = this.resBundle.getString("DCR.Sort.Alphabetical");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                byId = this.resBundle.getString("DCR.Sort.ById");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                byBC = this.resBundle.getString("DCR.Sort.ByBroaderConcept");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                desc = this.resBundle.getString("DCR.Label.CategoryDescription");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                ident = this.resBundle.getString("DCR.Label.Identifier");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                id = this.resBundle.getString("DCR.Label.Id");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                profs = this.resBundle.getString("DCR.Label.Profiles");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.profPanel.setBorder(new TitledBorder(selProf));
        this.catPanel.setBorder(new TitledBorder(selCat));
        this.sortModeLabel.setText(sortCat);
        this.descPanel.setBorder(new TitledBorder(desc));
        this.identifierKeyLabel.setText(ident);
        this.idKeyLabel.setText(id);
        this.profilesKeyLabel.setText(profs);
        this.sortModes = new String[3];
        this.sortModes[0] = alpha;
        this.sortModes[1] = byId;
        this.sortModes[2] = byBC;
        this.sortModeCombo.removeItemListener(this);
        this.sortModeCombo.removeAllItems();
        for (int i = 0; i < this.sortModes.length; ++i) {
            this.sortModeCombo.addItem(this.sortModes[i]);
        }
        this.sortModeCombo.addItemListener(this);
    }

    public List getSelectedCategories() {
        ArrayList<Object> selected;
        block4: {
            block3: {
                selected = new ArrayList<Object>();
                if (this.sortMode == 2) break block3;
                if (this.catList.getSelectedIndex() <= -1) break block4;
                Object[] vals = this.catList.getSelectedValues();
                for (int i = 0; i < vals.length; ++i) {
                    selected.add(vals[i]);
                }
                break block4;
            }
            if (this.catTree.getSelectionCount() > 0) {
                TreePath[] paths = this.catTree.getSelectionPaths();
                for (int i = 0; i < paths.length; ++i) {
                    Object node = paths[i].getLastPathComponent();
                    if (!(node instanceof DefaultMutableTreeNode)) continue;
                    selected.add(((DefaultMutableTreeNode)node).getUserObject());
                }
            }
        }
        return selected;
    }

    public void addProfiles(List<Profile> profiles) {
        if (profiles != null) {
            block0: for (int i = 0; i < profiles.size(); ++i) {
                Profile profile = profiles.get(i);
                if (profile == null) continue;
                for (int j = 0; j < this.profList.getModel().getSize(); ++j) {
                    if (profile.getId().equals(((Profile)this.profList.getModel().getElementAt(j)).getId())) continue block0;
                }
                ((DefaultListModel)this.profList.getModel()).addElement(profile);
            }
        }
    }

    protected void updateCategories(List datcats) {
        if (datcats == null) {
            datcats = new ArrayList(0);
        }
        if (this.sortMode != 2) {
            this.catList.removeListSelectionListener(this);
            this.descArea.setText("");
            this.catModel.clear();
            for (int i = 0; i < datcats.size(); ++i) {
                this.catModel.addElement(datcats.get(i));
            }
            this.catList.addListSelectionListener(this);
            if (this.catScroll.getViewport().getView() != this.catList) {
                this.catScroll.setViewportView(this.catList);
            }
        } else {
            this.catTree.removeTreeSelectionListener(this);
            this.descArea.setText("");
            DCTree treeBuilder = new DCTree();
            this.rootNode = treeBuilder.getBroaderGenericConceptTree(datcats);
            this.catTree = new JTree(this.rootNode);
            ((DefaultTreeCellRenderer)this.catTree.getCellRenderer()).setLeafIcon(null);
            ((DefaultTreeCellRenderer)this.catTree.getCellRenderer()).setOpenIcon(null);
            ((DefaultTreeCellRenderer)this.catTree.getCellRenderer()).setClosedIcon(null);
            this.catTree.setRootVisible(false);
            this.catTree.setShowsRootHandles(true);
            this.catTree.addTreeSelectionListener(this);
            if (this.catScroll.getViewport().getView() != this.catTree) {
                this.catScroll.setViewportView(this.catTree);
            }
            this.catTree.revalidate();
        }
        this.catScroll.revalidate();
    }

    protected List getDataCategories(Profile profile) {
        List datCats = null;
        try {
            datCats = this.connector.getDCSmallList(profile.getId(), null);
            if (datCats.size() == 0) {
                String message = this.resBundle != null ? this.resBundle.getString("DCR.Message.NoCategories") : "No categories available in this profile";
                JOptionPane.showMessageDialog(this, message, "", 1);
            }
            if (this.sortMode == 0) {
                Collections.sort(datCats, new DCIdentifierComparator());
            } else if (this.sortMode == 1) {
                Collections.sort(datCats, new DCIdComparator());
            }
        }
        catch (DCRConnectorException dce) {
            String message = this.resBundle != null ? this.resBundle.getString("DCR.Message.NoConnection") : "Could not connect to the registry: ";
            JOptionPane.showMessageDialog(this, message + " " + dce.getMessage(), "", 0);
        }
        catch (IllegalArgumentException iae) {
            String message = this.resBundle != null ? this.resBundle.getString("DCR.Message.NoConnection") : "Could not connect to the registry: ";
            JOptionPane.showMessageDialog(this, message + " " + iae.getMessage(), "", 0);
        }
        this.currentProfile = profile;
        return datCats;
    }

    protected void reorderCategories() {
        ArrayList<Object> cats = new ArrayList<Object>();
        if (this.catScroll.getViewport().getView() == this.catList) {
            int size = this.catModel.getSize();
            cats.ensureCapacity(size);
            for (int i = 0; i < size; ++i) {
                cats.add(this.catModel.get(i));
            }
        } else {
            int size = this.rootNode.getChildCount();
            cats.ensureCapacity(size);
            Enumeration<TreeNode> en = this.rootNode.breadthFirstEnumeration();
            en.nextElement();
            while (en.hasMoreElements()) {
                cats.add(((DefaultMutableTreeNode)en.nextElement()).getUserObject());
            }
        }
        if (this.sortMode == 0) {
            Collections.sort(cats, new DCIdentifierComparator());
        } else if (this.sortMode == 1 || this.sortMode == 2) {
            Collections.sort(cats, new DCIdComparator());
        }
        this.updateCategories(cats);
    }

    protected void updateDescription(DCSmall dc) {
        if (dc != null) {
            this.identifierValLabel.setText(dc.getIdentifier());
            this.idValLabel.setText(dc.getId());
            if (dc.getProfiles().length == 1) {
                this.profilesValLabel.setText(dc.getProfiles()[0].getName());
            } else {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < dc.getProfiles().length; ++i) {
                    buf.append(dc.getProfiles()[i].getName());
                    if (i == dc.getProfiles().length - 1) continue;
                    buf.append(", ");
                }
                this.profilesValLabel.setText(buf.toString());
            }
            this.descArea.setText(dc.getDesc());
        } else {
            this.identifierValLabel.setText("-");
            this.idValLabel.setText("-");
            this.profilesValLabel.setText("-");
            this.descArea.setText("");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.sortModeCombo) {
            int oldMode = this.sortMode;
            int i = this.sortModeCombo.getSelectedIndex();
            switch (i) {
                case 0: {
                    this.sortMode = 0;
                    break;
                }
                case 1: {
                    this.sortMode = 1;
                    break;
                }
                case 2: {
                    this.sortMode = 2;
                }
            }
            if (this.sortMode != oldMode) {
                this.reorderCategories();
                this.updateDescription(null);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.profList) {
            if (!e.getValueIsAdjusting()) {
                this.updateDescription(null);
                if (this.profList.getSelectedIndex() > -1) {
                    Profile profile = (Profile)this.profList.getSelectedValue();
                    this.updateCategories(this.getDataCategories(profile));
                } else {
                    this.currentProfile = null;
                    this.updateCategories(new ArrayList());
                }
            }
        } else if (e.getSource() == this.catList) {
            if (this.catList.getSelectedIndex() > -1 && this.catList.getSelectedIndices().length == 1) {
                Object sel = this.catList.getSelectedValue();
                if (sel instanceof DCSmall) {
                    this.updateDescription((DCSmall)sel);
                } else {
                    this.updateDescription(null);
                }
            } else {
                this.updateDescription(null);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object sel;
        TreePath lead;
        if (this.catTree.getSelectionCount() == 1 && (lead = e.getNewLeadSelectionPath()) != null && (sel = lead.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            Object uo = ((DefaultMutableTreeNode)sel).getUserObject();
            if (uo instanceof DCSmall) {
                this.updateDescription((DCSmall)uo);
            } else {
                this.updateDescription(null);
            }
        }
    }
}

