/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr;

import java.util.ArrayList;
import java.util.List;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.ILATDCRConnector;
import mpi.dcr.isocat.DCSelection;
import mpi.dcr.isocat.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDCRConnector
implements ILATDCRConnector {
    protected String name = "Local DCR Connector";
    protected List<DCSmall> catList = new ArrayList<DCSmall>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List getDCSmallList(String a_profile, String a_registrationStatus) throws DCRConnectorException {
        if (a_profile == null) {
            return this.catList;
        }
        ArrayList<DCSmall> profCats = new ArrayList<DCSmall>();
        DCSmall dc = null;
        block0: for (int i = 0; i < this.catList.size(); ++i) {
            dc = this.catList.get(i);
            if (dc.getProfiles() == null || dc.getProfiles().length <= 0) continue;
            for (int j = 0; j < dc.getProfiles().length; ++j) {
                if (!dc.getProfiles()[j].getId().equals(a_profile)) continue;
                profCats.add(dc);
                continue block0;
            }
        }
        return profCats;
    }

    protected void saveDCS() {
    }

    protected void readDCS() {
    }

    public void addDataCategories(List datCats) throws DCRConnectorException {
        DCSmall small1 = null;
        DCSmall small2 = null;
        block0: for (int i = 0; i < datCats.size(); ++i) {
            small1 = (DCSmall)datCats.get(i);
            for (int j = 0; j < this.catList.size(); ++j) {
                small2 = this.catList.get(j);
                if (small1.getId().equals(small2.getId())) continue block0;
            }
            this.catList.add(small1);
        }
        this.saveDCS();
    }

    public void removeCategories(List datCats) throws DCRConnectorException {
        DCSmall small1 = null;
        DCSmall small2 = null;
        block0: for (int i = 0; i < datCats.size(); ++i) {
            small1 = (DCSmall)datCats.get(i);
            for (int j = 0; j < this.catList.size(); ++j) {
                small2 = this.catList.get(j);
                if (!small1.getId().equals(small2.getId())) continue;
                this.catList.remove(j);
                continue block0;
            }
        }
        this.saveDCS();
    }

    public DCSmall getDCSmall(String dcId) {
        if (dcId == null) {
            return null;
        }
        DCSmall small = null;
        for (int i = 0; i < this.catList.size(); ++i) {
            small = this.catList.get(i);
            if (!small.getId().equals(dcId)) continue;
            return small;
        }
        return null;
    }

    @Override
    public DCSelection getDataCategories(String profileId) throws DCRConnectorException {
        return null;
    }

    @Override
    public DCSmall getDataCategory(String a_urid) throws DCRConnectorException {
        return null;
    }

    @Override
    public List<Profile> getProfiles() throws DCRConnectorException {
        return null;
    }
}

