/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mpi.dcr.AbstractDCSelectPanel;
import mpi.dcr.DCIdComparator;
import mpi.dcr.DCIdentifierComparator;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.ILATDCRConnector;
import mpi.dcr.LocalDCRConnector;
import mpi.dcr.isocat.Profile;

public class LocalDCSelectPanel
extends AbstractDCSelectPanel {
    protected JButton addCatsButton;
    protected JButton removeCatsButton;
    private List<DCSmall> allDatCats;
    private List<Profile> locProfList;
    private boolean singleSelection = true;

    public LocalDCSelectPanel(ILATDCRConnector connector) {
        super(connector);
        if (connector instanceof LocalDCRConnector) {
            this.connector = (LocalDCRConnector)connector;
        }
        this.initComponents();
    }

    public LocalDCSelectPanel(ILATDCRConnector connector, ResourceBundle resBundle) {
        super(connector, resBundle);
        if (connector instanceof LocalDCRConnector) {
            this.connector = (LocalDCRConnector)connector;
        }
        this.initComponents();
    }

    public LocalDCSelectPanel() {
        this.initComponents();
    }

    protected void initComponents() {
        this.locProfList = new ArrayList<Profile>();
        try {
            this.allDatCats = this.connector.getDCSmallList(null, null);
            if (this.allDatCats == null) {
                this.allDatCats = new ArrayList<DCSmall>();
            }
        }
        catch (DCRConnectorException dce) {
            this.allDatCats = new ArrayList<DCSmall>();
        }
        this.addCatsButton = new JButton();
        this.removeCatsButton = new JButton();
        super.initComponents();
        Insets insets = new Insets(2, 6, 2, 6);
        this.addCatsButton.addActionListener(this);
        this.removeCatsButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 6, 2));
        buttonPanel.add(this.addCatsButton);
        buttonPanel.add(this.removeCatsButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.gridy = 3;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.catPanel.add((Component)buttonPanel, gbc);
        this.updateLocale();
        this.setSingleSelection(this.singleSelection);
        DCSmall dcsmall = null;
        Profile prof = null;
        for (int i = 0; i < this.allDatCats.size(); ++i) {
            dcsmall = this.allDatCats.get(i);
            for (int j = 0; j < dcsmall.getProfiles().length; ++j) {
                prof = dcsmall.getProfiles()[j];
                if (this.locProfList.contains(prof)) continue;
                this.locProfList.add(prof);
            }
        }
        this.addProfiles(this.locProfList);
        this.profList.setSelectedIndex(0);
    }

    protected void updateLocale() {
        super.updateLocale();
        String ap = "All Profiles";
        String addCat = "Add Categories";
        String remCat = "Remove Category";
        if (this.resBundle != null) {
            try {
                ap = this.resBundle.getString("DCR.Label.AllProfiles");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                addCat = this.resBundle.getString("DCR.Label.AddCategories");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                remCat = this.resBundle.getString("DCR.Label.RemoveCategory");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.locProfList.add(0, new Profile("0", ap));
        this.addCatsButton.setText(addCat);
        this.removeCatsButton.setText(remCat);
        this.sortModeCombo.addItemListener(this);
    }

    public boolean isSingleSelection() {
        return this.singleSelection;
    }

    public void setSingleSelection(boolean singleSelection) {
        this.singleSelection = singleSelection;
        if (this.catTree != null) {
            if (singleSelection) {
                this.catTree.getSelectionModel().setSelectionMode(1);
            } else {
                this.catTree.getSelectionModel().setSelectionMode(4);
            }
        }
        if (this.catList != null) {
            if (singleSelection) {
                this.catList.getSelectionModel().setSelectionMode(0);
            } else {
                this.catList.getSelectionModel().setSelectionMode(2);
            }
        }
    }

    protected void selectAndAddCategories() {
    }

    protected void addCategories(List dcsToAdd) {
        if (dcsToAdd != null && dcsToAdd.size() > 0) {
            int i;
            ArrayList<DCSmall> addedDcs = new ArrayList<DCSmall>(dcsToAdd.size());
            ArrayList<Profile> addedProfiles = new ArrayList<Profile>(dcsToAdd.size());
            DCSmall small1 = null;
            DCSmall small2 = null;
            block2: for (i = 0; i < dcsToAdd.size(); ++i) {
                small1 = (DCSmall)dcsToAdd.get(i);
                for (int k = 0; k < small1.getProfiles().length; ++k) {
                    if (this.locProfList.contains(small1.getProfiles()[k]) || addedProfiles.contains(small1.getProfiles()[k])) continue;
                    addedProfiles.add(small1.getProfiles()[k]);
                }
                for (int j = 0; j < this.allDatCats.size(); ++j) {
                    small2 = this.allDatCats.get(j);
                    if (small1.getIdentifier().equals(small2.getIdentifier())) continue block2;
                }
                addedDcs.add(small1);
            }
            if (addedDcs.size() > 0) {
                this.allDatCats.addAll(addedDcs);
                if (this.connector instanceof LocalDCRConnector) {
                    try {
                        ((LocalDCRConnector)this.connector).addDataCategories(addedDcs);
                    }
                    catch (DCRConnectorException dce) {
                        // empty catch block
                    }
                }
                if (this.sortMode == 0) {
                    Collections.sort(this.allDatCats, new DCIdentifierComparator());
                } else if (this.sortMode == 1) {
                    Collections.sort(this.allDatCats, new DCIdComparator());
                }
                if (this.profList.getSelectedIndex() == 0) {
                    this.updateCategories(this.allDatCats);
                } else {
                    this.updateCategories(this.getDataCategories((Profile)this.profList.getSelectedValue()));
                }
            }
            if (addedProfiles.size() > 0) {
                this.locProfList.addAll(addedProfiles);
                for (i = 0; i < addedProfiles.size(); ++i) {
                    this.profModel.addElement(addedProfiles.get(i));
                }
            }
            this.profList.setSelectedIndex(0);
        }
    }

    private void removeCategory() {
        Object sel = null;
        if (this.sortMode == 2) {
            TreePath selPath = this.catTree.getSelectionPath();
            if (selPath != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                if (node.isRoot()) {
                    return;
                }
                sel = node.getUserObject();
                int chCount = node.getChildCount();
                if (chCount > 0) {
                    ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(chCount);
                    TreeNode tn = node.getFirstChild();
                    childNodes.add(tn);
                    while ((tn = node.getChildAfter(tn)) != null) {
                        childNodes.add(tn);
                    }
                    DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
                    node.removeAllChildren();
                    chCount = parentNode.getChildCount();
                    int index = parentNode.getIndex(node);
                    parentNode.remove(node);
                    for (int i = 0; i < childNodes.size(); ++i) {
                        if (index == chCount - 1) {
                            parentNode.add((DefaultMutableTreeNode)childNodes.get(i));
                            continue;
                        }
                        parentNode.insert((DefaultMutableTreeNode)childNodes.get(i), index + i);
                    }
                    ((DefaultTreeModel)this.catTree.getModel()).reload(parentNode);
                } else {
                    ((DefaultTreeModel)this.catTree.getModel()).removeNodeFromParent(node);
                }
            }
        } else {
            sel = this.catList.getSelectedValue();
            if (sel instanceof DCSmall) {
                this.allDatCats.remove(sel);
                this.catModel.removeElement(sel);
            }
        }
        if (sel != null && this.connector instanceof LocalDCRConnector) {
            ArrayList<Object> remDatCats = new ArrayList<Object>(1);
            remDatCats.add(sel);
            try {
                ((LocalDCRConnector)this.connector).removeCategories(remDatCats);
            }
            catch (DCRConnectorException dCRConnectorException) {
                // empty catch block
            }
        }
    }

    protected void updateCategories(List datcats) {
        super.updateCategories(datcats);
        if (this.sortMode == 2) {
            if (this.singleSelection) {
                this.catTree.getSelectionModel().setSelectionMode(1);
            } else {
                this.catTree.getSelectionModel().setSelectionMode(4);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addCatsButton) {
            this.selectAndAddCategories();
        } else if (e.getSource() == this.removeCatsButton) {
            this.removeCategory();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.profList) {
            if (!e.getValueIsAdjusting()) {
                if (this.profList.getSelectedIndex() == 0) {
                    this.currentProfile = null;
                    this.updateCategories(this.allDatCats);
                } else {
                    super.valueChanged(e);
                }
            }
            this.updateDescription(null);
        } else {
            super.valueChanged(e);
        }
    }
}

