/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr.isocat;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.ILATDCRConnector;
import mpi.dcr.isocat.DCIF_DCS_Handler;
import mpi.dcr.isocat.DCIF_DC_Handler;
import mpi.dcr.isocat.DCSelection;
import mpi.dcr.isocat.Profile;
import mpi.dcr.isocat.WSHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestDCRConnector
implements ILATDCRConnector {
    private static boolean ISOCatUseFullPID = false;
    private String user = "guest";
    private String isoName = "ISOCat REST DCR Connector";
    private String DCRLocation = "http://www.isocat.org/rest/";
    private String dcrName = this.isoName;
    private List<Profile> curRemoteProfiles;
    private XMLReader wsReader;
    private Object wsLock = new Object();
    private XMLReader dcifReader;
    private Object dcifLock = new Object();
    private XMLReader dcReader;
    private Object dcLock = new Object();

    public RestDCRConnector() {
        this.curRemoteProfiles = new ArrayList<Profile>(20);
        String locProperty = System.getProperty("DCRLocation");
        if (locProperty != null) {
            this.DCRLocation = locProperty;
            String propName = System.getProperty("DCRName");
            if (propName != null) {
                this.dcrName = propName;
            }
        }
    }

    @Override
    public String getName() {
        return this.dcrName;
    }

    public String getDCRLocation() {
        return this.DCRLocation;
    }

    @Override
    public List<Profile> getProfiles() throws DCRConnectorException {
        return this.getProfiles(this.user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Profile> getProfiles(String userName) throws DCRConnectorException {
        block14: {
            URL url = null;
            try {
                url = new URL(this.DCRLocation + "user/" + userName + "/workspace");
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
                throw new DCRConnectorException("Unable to connect to DCR: " + mue.getMessage());
            }
            if (url != null) {
                HttpURLConnection conn = this.getConnection(url, false);
                try {
                    int respCode = conn.getResponseCode();
                    if (respCode != 200) {
                        throw new DCRConnectorException("Unable to connect to DCR: " + respCode + " " + conn.getResponseMessage());
                    }
                    Object cont = conn.getContent();
                    if (!(cont instanceof InputStream)) break block14;
                    InputStream is = (InputStream)cont;
                    InputSource source = new InputSource(is);
                    Object object = this.wsLock;
                    synchronized (object) {
                        try {
                            this.getWSReader().parse(source);
                            this.curRemoteProfiles.clear();
                            ArrayList<Profile> profs = ((WSHandler)this.getWSReader().getContentHandler()).getProfiles();
                            this.curRemoteProfiles.addAll(profs);
                            ArrayList<Profile> arrayList = profs;
                            return arrayList;
                        }
                        catch (Throwable throwable) {
                            try {
                                throw throwable;
                            }
                            catch (SAXException sax) {
                                throw new DCRConnectorException(sax);
                            }
                            catch (IOException ioee) {
                                throw new DCRConnectorException(ioee);
                            }
                            catch (Throwable throwable2) {
                                throw throwable2;
                            }
                        }
                    }
                }
                finally {
                    conn.disconnect();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DCSelection getDataCategories(String profileId) throws DCRConnectorException {
        block24: {
            URL url = null;
            try {
                url = new URL(this.DCRLocation + "profile/" + profileId);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
                throw new DCRConnectorException("Unable to connect to DCR: " + mue.getMessage());
            }
            if (url != null) {
                HttpURLConnection conn = this.getConnection(url, true);
                try {
                    int respCode = conn.getResponseCode();
                    if (respCode != 200) {
                        throw new DCRConnectorException("Unable to connect to DCR: " + respCode + " " + conn.getResponseMessage());
                    }
                    Object cont = conn.getContent();
                    if (!(cont instanceof InputStream)) break block24;
                    InputStream is = (InputStream)cont;
                    InputSource source = new InputSource(is);
                    Object object = this.dcifLock;
                    synchronized (object) {
                        try {
                            this.getDCIFReader().parse(source);
                            DCSelection dcs = ((DCIF_DCS_Handler)this.getDCIFReader().getContentHandler()).getDCSelection();
                            Profile mainProf = null;
                            Profile loopProf = null;
                            if (this.curRemoteProfiles.size() == 0) {
                                try {
                                    this.getProfiles();
                                }
                                catch (DCRConnectorException dce) {
                                    // empty catch block
                                }
                            }
                            for (int i = 0; i < this.curRemoteProfiles.size(); ++i) {
                                loopProf = this.curRemoteProfiles.get(i);
                                if (!loopProf.getName().equals(profileId)) continue;
                                mainProf = loopProf;
                                break;
                            }
                            if (mainProf != null) {
                                loopProf = null;
                                for (int i = 0; i < dcs.getDataCategories().size(); ++i) {
                                    DCSmall loopDC = dcs.getDataCategories().get(i);
                                    if (loopDC.getProfiles().length == 0) {
                                        loopDC.setProfiles(new Profile[]{new Profile(mainProf)});
                                        continue;
                                    }
                                    for (int j = 0; j < loopDC.getProfiles().length; ++j) {
                                        loopProf = loopDC.getProfiles()[j];
                                        if (loopProf.getId().length() != 0) continue;
                                        if (loopProf.getName().equals(mainProf.getName())) {
                                            loopProf.setId(mainProf.getId());
                                            continue;
                                        }
                                        for (int k = 0; k < this.curRemoteProfiles.size(); ++k) {
                                            Profile lp2 = this.curRemoteProfiles.get(k);
                                            if (!loopProf.getName().equals(lp2.getName())) continue;
                                            loopProf.setId(lp2.getId());
                                        }
                                    }
                                }
                            }
                            DCSelection dCSelection = dcs;
                            return dCSelection;
                        }
                        catch (Throwable throwable) {
                            try {
                                throw throwable;
                            }
                            catch (SAXException sax) {
                                throw new DCRConnectorException(sax);
                            }
                            catch (IOException ioee) {
                                throw new DCRConnectorException(ioee);
                            }
                            catch (Throwable throwable2) {
                                throw throwable2;
                            }
                        }
                    }
                }
                finally {
                    conn.disconnect();
                }
            }
        }
        return null;
    }

    @Override
    public List getDCSmallList(String profileId, String registrationStatus) throws DCRConnectorException {
        DCSelection dcSelection = this.getDataCategories(profileId);
        return dcSelection.getDataCategories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DCSmall getDataCategory(String fullPID) throws DCRConnectorException {
        block21: {
            URL url = null;
            try {
                if (!ISOCatUseFullPID) {
                    if (fullPID.startsWith("http://www.isocat.org/datcat/DC-")) {
                        String dcId = fullPID.substring("http://www.isocat.org/datcat/DC-".length());
                        url = new URL(this.DCRLocation + "dc/" + dcId);
                    } else {
                        url = new URL(this.DCRLocation + "dc/" + fullPID);
                    }
                } else {
                    url = new URL(this.DCRLocation + "dc/" + fullPID);
                }
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
                throw new DCRConnectorException("Unable to connect to DCR: " + mue.getMessage());
            }
            if (url != null) {
                HttpURLConnection conn = this.getConnection(url, true);
                try {
                    int respCode = conn.getResponseCode();
                    if (respCode != 200) {
                        throw new DCRConnectorException("Unable to connect to DCR: " + respCode + " " + conn.getResponseMessage());
                    }
                    Object cont = conn.getContent();
                    if (!(cont instanceof InputStream)) break block21;
                    InputStream is = (InputStream)cont;
                    InputSource source = new InputSource(is);
                    Object object = this.dcLock;
                    synchronized (object) {
                        try {
                            this.getDCReader().parse(source);
                            DCSmall dcSmall = ((DCIF_DC_Handler)this.getDCReader().getContentHandler()).getDC();
                            if (dcSmall.getProfiles() != null) {
                                for (int i = 0; i < dcSmall.getProfiles().length; ++i) {
                                    Profile lp1 = dcSmall.getProfiles()[i];
                                    if (lp1.getId().length() != 0) continue;
                                    for (int j = 0; j < this.curRemoteProfiles.size(); ++j) {
                                        Profile lp2 = this.curRemoteProfiles.get(j);
                                        if (!lp1.getName().equals(lp2.getName())) continue;
                                        lp1.setId(lp2.getId());
                                    }
                                }
                            }
                            DCSmall dCSmall = dcSmall;
                            return dCSmall;
                        }
                        catch (Throwable throwable) {
                            try {
                                throw throwable;
                            }
                            catch (SAXException sax) {
                                throw new DCRConnectorException(sax);
                            }
                            catch (IOException ioee) {
                                throw new DCRConnectorException(ioee);
                            }
                            catch (Throwable throwable2) {
                                throw throwable2;
                            }
                        }
                    }
                }
                finally {
                    conn.disconnect();
                }
            }
        }
        return null;
    }

    private HttpURLConnection getConnection(URL url, boolean dcifMode) throws DCRConnectorException {
        if (url == null) {
            return null;
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setDefaultUseCaches(true);
            if (dcifMode) {
                conn.setRequestProperty("Accept", "application/dcif+xml");
            } else {
                conn.setRequestProperty("Accept", "application/xml");
            }
            conn.setRequestMethod("GET");
            conn.connect();
            return conn;
        }
        catch (IOException ioe) {
            throw new DCRConnectorException("Unable to connect to DCR" + ioe.getMessage());
        }
        catch (Exception e) {
            throw new DCRConnectorException("Unable to connect to DCR" + e.getMessage());
        }
    }

    private XMLReader getWSReader() throws SAXException {
        if (this.wsReader == null) {
            this.wsReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.wsReader.setFeature("http://xml.org/sax/features/namespaces", false);
            this.wsReader.setFeature("http://xml.org/sax/features/validation", false);
            this.wsReader.setContentHandler(new WSHandler());
        }
        return this.wsReader;
    }

    private XMLReader getDCIFReader() throws SAXException {
        if (this.dcifReader == null) {
            this.dcifReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.dcifReader.setFeature("http://xml.org/sax/features/namespaces", false);
            this.dcifReader.setFeature("http://xml.org/sax/features/validation", false);
            this.dcifReader.setContentHandler(new DCIF_DCS_Handler());
        }
        return this.dcifReader;
    }

    private XMLReader getDCReader() throws SAXException {
        if (this.dcReader == null) {
            this.dcReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.dcReader.setFeature("http://xml.org/sax/features/namespaces", false);
            this.dcReader.setFeature("http://xml.org/sax/features/validation", false);
            this.dcReader.setContentHandler(new DCIF_DC_Handler());
        }
        return this.dcReader;
    }

    public static void main(String[] args) {
        RestDCRConnector connector = new RestDCRConnector();
        try {
            System.out.println(connector.getProfiles());
            connector.getDataCategory("1988");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        String val = System.getProperty("ISOCatUseFullPID");
        if (val != null && val.toLowerCase().equals("true")) {
            ISOCatUseFullPID = true;
        }
    }
}

