/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;

public class DetachedFrame
extends JDialog
implements ComponentListener,
ActionListener,
ElanLocaleListener {
    private ElanLayoutManager layoutManager;
    private Component component;
    private float aspectRatio;
    private JMenuBar menuBar;
    private JMenu menuView;
    private JMenuItem restoreItem;
    private JMenuItem minimizeItem;
    private JMenuItem maximizeItem;
    private Point restoreLocation;
    private Dimension restoreSize;
    private boolean bRestored;
    private final int margin = 2;

    public DetachedFrame(ElanLayoutManager layoutManager, Component component, String title) {
        super((Frame)layoutManager.getElanFrame(), false);
        this.layoutManager = layoutManager;
        this.component = component;
        this.bRestored = true;
        this.setTitle(title);
        this.getContentPane().setLayout(null);
        this.getContentPane().add(component);
        this.menuBar = new JMenuBar();
        this.menuBar.setInputMap(0, layoutManager.getElanFrame().getJMenuBar().getInputMap(2));
        this.menuBar.setActionMap(layoutManager.getElanFrame().getJMenuBar().getActionMap());
        this.setJMenuBar(this.menuBar);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.menuView = new JMenu();
        this.menuBar.add(this.menuView);
        this.restoreItem = new JMenuItem();
        this.restoreItem.addActionListener(this);
        this.menuView.add(this.restoreItem);
        this.minimizeItem = new JMenuItem();
        this.minimizeItem.addActionListener(this);
        this.menuView.add(this.minimizeItem);
        this.maximizeItem = new JMenuItem();
        this.maximizeItem.addActionListener(this);
        this.menuView.add(this.maximizeItem);
        this.setDefaultCloseOperation(0);
        this.addComponentListener(this);
        ElanLocale.addElanLocaleListener(layoutManager.getViewerManager().getTranscription(), this);
        this.updateLocale();
    }

    public void updateLocale() {
        this.menuView.setText(ElanLocale.getString("DetachedFrame.View"));
        this.restoreItem.setText(ElanLocale.getString("DetachedFrame.Restore"));
        this.minimizeItem.setText(ElanLocale.getString("DetachedFrame.Minimize"));
        this.minimizeItem.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.maximizeItem.setText(ElanLocale.getString("DetachedFrame.Maximize"));
        this.maximizeItem.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        String mnemonic = null;
        try {
            mnemonic = ElanLocale.getString("MNEMONIC.DetachedFrame.View");
            if (mnemonic.length() > 0) {
                this.menuView.setMnemonic(mnemonic.charAt(0));
            }
            if ((mnemonic = ElanLocale.getString("MNEMONIC.DetachedFrame.Restore")).length() > 0) {
                this.restoreItem.setMnemonic(mnemonic.charAt(0));
                this.restoreItem.setAccelerator(KeyStroke.getKeyStroke((int)mnemonic.charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
            if ((mnemonic = ElanLocale.getString("MNEMONIC.DetachedFrame.Maximize")).length() > 0) {
                this.maximizeItem.setMnemonic(mnemonic.charAt(0));
            }
            if ((mnemonic = ElanLocale.getString("MNEMONIC.DetachedFrame.Minimize")).length() > 0) {
                this.minimizeItem.setMnemonic(mnemonic.charAt(0));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.restoreItem)) {
            this.setFrameRestored();
        } else if (e.getSource().equals(this.minimizeItem)) {
            this.setFrameMinimized();
        } else if (e.getSource().equals(this.maximizeItem)) {
            this.setFrameMaximized();
        }
    }

    private void setFrameRestored() {
        if (this.restoreLocation != null && this.restoreSize != null) {
            this.setLocation((int)this.restoreLocation.getX(), (int)this.restoreLocation.getY());
            this.setSize((int)this.restoreSize.getWidth(), (int)this.restoreSize.getHeight());
        }
        this.bRestored = true;
    }

    private void setFrameMinimized() {
        if (this.bRestored) {
            this.getRestoreValues();
            this.bRestored = false;
        }
        this.setSize(100, 50);
        this.validate();
    }

    private void setFrameMaximized() {
        if (this.bRestored) {
            this.getRestoreValues();
            this.bRestored = false;
        }
        Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(0, 0);
        this.setSize((int)dimScreen.getWidth(), (int)dimScreen.getHeight());
    }

    private void getRestoreValues() {
        this.restoreLocation = this.getLocation();
        this.restoreSize = this.getSize();
    }

    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (this.aspectRatio != 0.0f) {
            int h;
            int w = this.getContentPane().getWidth() - 4;
            if ((float)w > (float)(h = this.getContentPane().getHeight() - 4) * this.aspectRatio) {
                int xMargin = (int)(((float)w - (float)h * this.aspectRatio) / 2.0f) + 2;
                this.component.setBounds(xMargin, 2, (int)((float)h * this.aspectRatio), h);
            } else if ((float)w < (float)h * this.aspectRatio) {
                this.component.setBounds(2, 2, w, (int)((float)w / this.aspectRatio));
            }
        }
    }

    public void componentShown(ComponentEvent e) {
    }
}

