/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.Constructor;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanMacApplication;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.integration.ExternalLauncher;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.annotator.util.SystemInstallationSecurity;
import mpi.eudico.client.annotator.util.SystemReporting;

public class ELAN
implements ClientLogger {
    public static int major = 4;
    public static int minor = 0;
    public static int micro = 0;

    private ELAN() {
    }

    public static void main(final String[] args) {
        LOG.info("ELAN " + ELAN.getVersionString());
        LOG.info("Java version: " + System.getProperty("java.version"));
        LOG.info("Runtime version: " + System.getProperty("java.runtime.version"));
        LOG.info("OS name: " + System.getProperty("os.name"));
        LOG.info("OS version: " + System.getProperty("os.version"));
        LOG.info("User language: " + System.getProperty("user.language"));
        LOG.info("User home: " + System.getProperty("user.home"));
        LOG.info("User dir: " + System.getProperty("user.dir"));
        LOG.info("Classpath: " + System.getProperty("java.class.path"));
        SystemInstallationSecurity.Instance().go();
        try {
            Object val;
            if (System.getProperty("os.name").indexOf("Mac OS") > -1) {
                boolean macLF;
                File dataFolder = new File(Constants.ELAN_DATA_DIR);
                if (!dataFolder.exists()) {
                    dataFolder.mkdir();
                    File oldDataFolder = new File(Constants.USERHOME + Constants.FILESEPARATOR + ".elan_data");
                    if (oldDataFolder.exists()) {
                        File[] files = oldDataFolder.listFiles();
                        File inFile = null;
                        File outFile = null;
                        for (int i = 0; i < files.length; ++i) {
                            inFile = files[i];
                            if (!inFile.isFile()) continue;
                            outFile = new File(dataFolder.getAbsolutePath() + Constants.FILESEPARATOR + inFile.getName());
                            FileUtility.copyToFile(inFile, outFile);
                        }
                    }
                }
                boolean screenBar = false;
                Object val2 = Preferences.get("OS.Mac.useScreenMenuBar", null);
                if (val2 instanceof Boolean) {
                    screenBar = (Boolean)val2;
                    System.setProperty("apple.laf.useScreenMenuBar", String.valueOf(screenBar));
                }
                if (!screenBar && (val2 = Preferences.get("UseMacLF", null)) instanceof Boolean && !(macLF = ((Boolean)val2).booleanValue())) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (System.getProperty("PreferredMediaFramework") == null && (val2 = Preferences.get("Mac.PrefMediaFramework", null)) instanceof String) {
                    System.setProperty("PreferredMediaFramework", (String)val2);
                }
            } else if (SystemReporting.isWindows() && System.getProperty("PreferredMediaFramework") == null && (val = Preferences.get("Windows.PrefMediaFramework", null)) instanceof String) {
                System.setProperty("PreferredMediaFramework", (String)val);
            }
            File dataDir = new File(Constants.ELAN_DATA_DIR);
            if (!dataDir.exists()) {
                dataDir.mkdir();
            }
            File oldCrap = new File(Constants.STRPROPERTIESFILE);
            oldCrap.delete();
            oldCrap = new File(Constants.USERHOME + Constants.FILESEPARATOR + ".elan.pfs");
            oldCrap.delete();
        }
        catch (Exception ex) {
            LOG.warning("Could not create ELAN's data directory: " + ex.getMessage());
        }
        FrameManager.getInstance().setExitAllowed(true);
        if (args != null && args.length > 0 && args[0].length() != 0) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    File argFile = new File(args[0]);
                    if (!argFile.isAbsolute()) {
                        FrameManager.getInstance().createFrame(argFile.getAbsolutePath());
                    } else {
                        FrameManager.getInstance().createFrame(args[0]);
                    }
                }
            });
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FrameManager.getInstance().createEmptyFrame();
                }
            });
        }
        ExternalLauncher.start();
        if (System.getProperty("os.name").indexOf("Mac OS") > -1) {
            try {
                Class<?> macHandler = Class.forName("mpi.eudico.client.mac.MacAppHandler");
                Class<?> macList = Class.forName("mpi.eudico.client.mac.MacApplicationListener");
                Constructor<?> con = macHandler.getConstructor(macList);
                ElanMacApplication elanMacApp = new ElanMacApplication();
                con.newInstance(elanMacApp);
            }
            catch (Exception ex) {
                System.out.println("Could not load Mac application handler.");
            }
        }
    }

    public static String getVersionString() {
        return major + "." + minor + "." + micro;
    }
}

