/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.PlayerViewerMenuManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesUser;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.BackupCA;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.PlayAroundSelectionCA;
import mpi.eudico.client.annotator.commands.PlaybackRateToggleCA;
import mpi.eudico.client.annotator.commands.PlaybackVolumeToggleCA;
import mpi.eudico.client.annotator.commands.RedoCA;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.commands.StoreCommand;
import mpi.eudico.client.annotator.commands.UndoCA;
import mpi.eudico.client.annotator.commands.global.AboutMA;
import mpi.eudico.client.annotator.commands.global.CreateAudioRecognizerMA;
import mpi.eudico.client.annotator.commands.global.CreateGridViewerMA;
import mpi.eudico.client.annotator.commands.global.CreateInterlinearViewerMA;
import mpi.eudico.client.annotator.commands.global.CreateLexiconViewerMA;
import mpi.eudico.client.annotator.commands.global.CreateMetadataViewerMA;
import mpi.eudico.client.annotator.commands.global.CreateSignalViewerMA;
import mpi.eudico.client.annotator.commands.global.CreateSubtitleViewerMA;
import mpi.eudico.client.annotator.commands.global.CreateTextViewerMA;
import mpi.eudico.client.annotator.commands.global.CreateVideoRecognizerMA;
import mpi.eudico.client.annotator.commands.global.EditPreferencesMA;
import mpi.eudico.client.annotator.commands.global.EditShortcutsMA;
import mpi.eudico.client.annotator.commands.global.ExitMA;
import mpi.eudico.client.annotator.commands.global.ExportAnnotationsMultiMA;
import mpi.eudico.client.annotator.commands.global.ExportTabMultiMA;
import mpi.eudico.client.annotator.commands.global.ExportTiersMA;
import mpi.eudico.client.annotator.commands.global.ExportWordsMultiMA;
import mpi.eudico.client.annotator.commands.global.FontBrowserMA;
import mpi.eudico.client.annotator.commands.global.HelpMA;
import mpi.eudico.client.annotator.commands.global.ImportCHATMA;
import mpi.eudico.client.annotator.commands.global.ImportDelimitedTextMA;
import mpi.eudico.client.annotator.commands.global.ImportFlexMA;
import mpi.eudico.client.annotator.commands.global.ImportPraatMA;
import mpi.eudico.client.annotator.commands.global.ImportRecognizerTiersMA;
import mpi.eudico.client.annotator.commands.global.ImportShoeboxMA;
import mpi.eudico.client.annotator.commands.global.ImportToolboxMA;
import mpi.eudico.client.annotator.commands.global.ImportTranscriberMA;
import mpi.eudico.client.annotator.commands.global.MenuAction;
import mpi.eudico.client.annotator.commands.global.MergeTranscriptionsMA;
import mpi.eudico.client.annotator.commands.global.MultiEAFScrubberMA;
import mpi.eudico.client.annotator.commands.global.MultiFindReplaceMA;
import mpi.eudico.client.annotator.commands.global.MultipleFilesEditMA;
import mpi.eudico.client.annotator.commands.global.NewMA;
import mpi.eudico.client.annotator.commands.global.NextWindowMA;
import mpi.eudico.client.annotator.commands.global.OpenMA;
import mpi.eudico.client.annotator.commands.global.PrevWindowMA;
import mpi.eudico.client.annotator.commands.global.SearchMultipleMA;
import mpi.eudico.client.annotator.commands.global.SetLocaleMA;
import mpi.eudico.client.annotator.commands.global.SetPlayAroundSelectionMA;
import mpi.eudico.client.annotator.commands.global.SetPlaybackToggleMA;
import mpi.eudico.client.annotator.commands.global.ShortcutsMA;
import mpi.eudico.client.annotator.commands.global.StructuredSearchMultipleMA;
import mpi.eudico.client.annotator.commands.global.WebMA;
import mpi.eudico.client.annotator.grid.GridViewer;
import mpi.eudico.client.annotator.gui.ElanMenuItem;
import mpi.eudico.client.annotator.integration.ExternalLauncher;
import mpi.eudico.client.annotator.linkedmedia.LinkedFileDescriptorUtil;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.player.JMFGraphicMediaPlayer;
import mpi.eudico.client.annotator.recognizer.gui.AudioRecognizerPanel;
import mpi.eudico.client.annotator.recognizer.gui.VideoRecognizerPanel;
import mpi.eudico.client.annotator.svg.SVGPrefs;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.annotator.util.FrameConstants;
import mpi.eudico.client.annotator.util.SystemInstallationSecurity;
import mpi.eudico.client.annotator.viewer.InterlinearViewer;
import mpi.eudico.client.annotator.viewer.LexiconEntryViewer;
import mpi.eudico.client.annotator.viewer.MetadataViewer;
import mpi.eudico.client.annotator.viewer.SubtitleViewer;
import mpi.eudico.client.annotator.viewer.TextViewer;
import mpi.eudico.client.annotator.viewer.TimeLineViewer;
import mpi.eudico.client.util.TranscriptionECVLoader;
import mpi.eudico.p2p.ElanP2P;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;

public class ElanFrame2
extends JFrame
implements ActionListener,
ElanLocaleListener,
FrameConstants,
PreferencesUser {
    private ArrayList menuActions = new ArrayList(20);
    private HashMap registeredActions = new HashMap();
    private boolean initialized = false;
    private Transcription transcriptionForThisFrame;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenuItem menuItemFileNew;
    private JMenuItem menuItemFileOpen;
    private JMenu menuRecentFiles;
    private JMenuItem menuItemFileExit;
    private JMenu menuBackup;
    private JMenu menuImport;
    private JMenu menuExport;
    private JMenu menuExportSMIL;
    private JMenuItem menuItemShoeboxImport;
    private JMenuItem menuItemCHATImport;
    private JMenuItem menuItemTranscriberImport;
    private JMenuItem menuItemDiscoverDoc;
    private JMenuItem menuItemPublishDoc;
    private JMenu menuEdit;
    private JMenu menuPreferences;
    private ElanMenuItem setAuthorMI;
    private JMenu menuAnnotation;
    private JMenu menuTier;
    private JMenu menuType;
    private JMenu menuWindow;
    private ButtonGroup windowsGroup;
    private JMenu menuSearch;
    private JMenu menuView;
    private JMenu menuViewer;
    private JMenu menuOptions;
    private JCheckBoxMenuItem menuItemNativeMedia;
    private JCheckBoxMenuItem menuItemPermanentDetached;
    private JCheckBoxMenuItem menuMacNativeLF;
    private JRadioButtonMenuItem menuItemAnnoMode;
    private JRadioButtonMenuItem menuItemSyncMode;
    private JCheckBoxMenuItem menuItemKioskMode;
    private JMenuItem menuItemPlayAround;
    private JMenuItem menuItemRateVol;
    private JMenu menuP2P;
    private JMenu menuHelp;
    private JMenu menuFrameLength;
    private JMenu menuAppLanguage;
    private ButtonGroup languageBG;
    private JMenu menuChangeTimePropMode;
    private JMenuItem menuItemOptionsEnglish;
    private JMenuItem menuItemOptionsDutch;
    private JMenuItem menuItemScrubTrans;
    private JMenu menuMediaPlayer;
    private ElanLayoutManager layoutManager;
    private ViewerManager2 viewerManager;
    private ElanP2P elanP2P;
    private PlayerViewerMenuManager pvMenuManager;
    private boolean fullyInitialized = false;
    private ElanMenuItem closeMI;
    private ElanMenuItem saveMI;
    private ElanMenuItem saveAsMI;
    private ElanMenuItem saveAsTemplateMI;
    private ElanMenuItem saveSelEafMI;
    private ElanMenuItem mergeTransMI;
    private ElanMenuItem pageSetUpMI;
    private ElanMenuItem printPreviewMI;
    private ElanMenuItem printMI;
    private ElanMenuItem undoMI;
    private ElanMenuItem redoMI;
    private ElanMenuItem editCVMI;
    private ElanMenuItem linkedFilesMI;
    private ElanMenuItem importPrefsMI;
    private ElanMenuItem exportPrefsMI;
    private ElanMenuItem searchMI;
    private ElanMenuItem goToMI;
    private ElanMenuItem tierDependenciesMI;
    private ElanMenuItem spreadsheetMI;
    private ElanMenuItem statisticsMI;
    private ElanMenuItem importPraatMI;
    private ElanMenuItem importRecogTiersMI;
    private ElanMenuItem editLexiconServiceMI;
    private JCheckBoxMenuItem menuItemGridViewer;
    private JCheckBoxMenuItem menuItemTextViewer;
    private JCheckBoxMenuItem menuItemSubtitleViewer;
    private JCheckBoxMenuItem menuItemLexiconViewer;
    private JCheckBoxMenuItem menuItemAudioRecognizer;
    private JCheckBoxMenuItem menuItemVideoRecognizer;
    private JCheckBoxMenuItem menuItemMetaDataViewer;
    private JCheckBoxMenuItem menuItemSignalViewer;
    private JCheckBoxMenuItem menuItemInterLinearViewer;

    public ElanFrame2() {
        this.setTitle("ELAN");
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ELAN16.png"));
        if (icon != null) {
            this.setIconImage(icon.getImage());
        } else {
            this.setIconImage(null);
        }
        this.initFrame();
    }

    public ElanFrame2(final String path) {
        this();
        if (path != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ElanFrame2.this.openEAF(path);
                }
            });
        }
    }

    public ElanFrame2(final String eafPath, final Vector mediaFiles) {
        this();
        if (eafPath != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ElanFrame2.this.openEAF(eafPath, mediaFiles);
                }
            });
        }
    }

    public ElanFrame2(Transcription transcription) {
        this();
        this.transcriptionForThisFrame = transcription;
        if (this.transcriptionForThisFrame != null) {
            try {
                this.initElan();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void openEAF(String fullPath, Vector mediaFiles) {
        File fileTemp = new File(fullPath);
        if (!fileTemp.exists() || fileTemp.isDirectory()) {
            String strMessage = ElanLocale.getString("Menu.Dialog.Message1");
            strMessage = strMessage + fullPath;
            strMessage = strMessage + ElanLocale.getString("Menu.Dialog.Message2");
            String strError = ElanLocale.getString("Message.Error");
            JOptionPane.showMessageDialog(this, strMessage, strError, 0);
            return;
        }
        String lowerPath = fileTemp.toString().toLowerCase();
        if (!lowerPath.endsWith(".eaf") && !lowerPath.endsWith(".etf")) {
            String strMessage = ElanLocale.getString("Menu.Dialog.Message1");
            strMessage = strMessage + fullPath;
            strMessage = strMessage + ElanLocale.getString("Menu.Dialog.Message3");
            String strError = ElanLocale.getString("Message.Error");
            JOptionPane.showMessageDialog(this, strMessage, strError, 0);
            return;
        }
        try {
            int answer;
            int lastSlash;
            String eafPath;
            boolean validMedia;
            String path = fileTemp.getAbsolutePath();
            path = path.replace('\\', '/');
            TranscriptionImpl transcription = new TranscriptionImpl(new File(path).getAbsolutePath());
            transcription.setUnchanged();
            if (lowerPath.endsWith(".etf")) {
                transcription.setName("aishug294879ryshfda9763afo8947a5gf");
                transcription.setPathName("aishug294879ryshfda9763afo8947a5gf");
                transcription.setChanged();
                String prefPath = path.substring(0, path.length() - 3) + "pfsx";
                try {
                    File pFile = new File(prefPath);
                    if (pFile.exists()) {
                        Preferences.importPreferences(transcription, prefPath);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (transcription.getControlledVocabularies().size() > 0) {
                new TranscriptionECVLoader().loadExternalCVs(transcription, this);
            }
            if (mediaFiles != null) {
                Vector descriptors = MediaDescriptorUtil.createMediaDescriptors(mediaFiles);
                transcription.setMediaDescriptors(descriptors);
                transcription.setChanged();
            }
            if (!(validMedia = this.checkMedia(transcription, eafPath = path.substring(0, lastSlash = path.lastIndexOf(47)))) && (answer = JOptionPane.showConfirmDialog(this, ElanLocale.getString("Frame.ElanFrame.IncompleteMediaQuestion"), ElanLocale.getString("Frame.ElanFrame.IncompleteMediaAvailable"), 0)) != 0) {
                return;
            }
            if (this.transcriptionForThisFrame != null) {
                FrameManager.getInstance().createFrame(transcription);
            } else {
                this.transcriptionForThisFrame = transcription;
                this.initElan();
                FrameManager.getInstance().updateFrameTitle(this, transcription.getFullPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openEAF(String fullPath) {
        this.openEAF(fullPath, null);
    }

    void setTranscription(Transcription transcription) {
        if (this.transcriptionForThisFrame != null || !(transcription instanceof TranscriptionImpl)) {
            return;
        }
        this.transcriptionForThisFrame = transcription;
        this.initElan();
    }

    public ViewerManager2 getViewerManager() {
        return this.viewerManager;
    }

    public ElanLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public boolean checkMedia(Transcription transcription, String eafPath) {
        boolean validMedia = true;
        boolean saveChangedMedia = true;
        Object val = Preferences.get("MediaLocation.AltLocationSetsChanged", null);
        if (val instanceof Boolean) {
            saveChangedMedia = (Boolean)val;
        }
        File currentDirectory = null;
        String fullEAFURL = FileUtility.pathToURLString(transcription.getFullPath());
        try {
            Vector mediaDescriptors = transcription.getMediaDescriptors();
            block2: for (int i = 0; i < mediaDescriptors.size(); ++i) {
                String urlhead;
                MediaDescriptor md = (MediaDescriptor)mediaDescriptors.elementAt(i);
                int colonPos = md.mediaURL.indexOf(58);
                if (colonPos > 0 && (urlhead = md.mediaURL.substring(0, colonPos)).trim().equalsIgnoreCase("rtsp")) continue;
                String fileName = md.mediaURL.substring(colonPos + 1);
                File file = new File(fileName = fileName.replace('\\', '/'));
                if (file.exists()) continue;
                int lastSlashPos = fileName.lastIndexOf(47);
                String localFileName = fileName.substring(lastSlashPos + 1);
                file = new File(eafPath + "/" + localFileName);
                if (file.exists()) {
                    this.adjustMediaDescriptors(mediaDescriptors, i, file.getAbsolutePath());
                    if (!saveChangedMedia) continue;
                    transcription.setChanged();
                    continue;
                }
                if (md.relativeMediaURL != null) {
                    String absPath;
                    String relUrl = md.relativeMediaURL;
                    if (relUrl.startsWith("file:/")) {
                        relUrl = relUrl.substring(6);
                    }
                    if ((absPath = FileUtility.getAbsolutePath(fullEAFURL, relUrl)) != null && (file = new File(absPath)).exists()) {
                        this.adjustMediaDescriptors(mediaDescriptors, i, file.getAbsolutePath());
                        if (!saveChangedMedia) continue;
                        transcription.setChanged();
                        continue;
                    }
                }
                if ((file = new File(eafPath + "/../Media/" + localFileName)).exists()) {
                    this.adjustMediaDescriptors(mediaDescriptors, i, file.getAbsolutePath());
                    if (!saveChangedMedia) continue;
                    transcription.setChanged();
                    continue;
                }
                file = new File(eafPath + "/../media/" + localFileName);
                if (file.exists()) {
                    this.adjustMediaDescriptors(mediaDescriptors, i, file.getAbsolutePath());
                    if (!saveChangedMedia) continue;
                    transcription.setChanged();
                    continue;
                }
                val = Preferences.get("DefaultMediaLocation", null);
                if (val instanceof String && (file = new File(FileUtility.urlToAbsPath((String)val) + "/" + localFileName)).exists()) {
                    this.adjustMediaDescriptors(mediaDescriptors, i, file.getAbsolutePath());
                    if (!saveChangedMedia) continue;
                    transcription.setChanged();
                    continue;
                }
                JFileChooser chooser = new JFileChooser();
                if (md.mimeType.equals("audio/x-wav")) {
                    chooser.setFileFilter(ElanFileFilter.createFileFilter(1));
                } else if (md.mimeType.equals("video/mpeg")) {
                    chooser.setFileFilter(ElanFileFilter.createFileFilter(0));
                } else {
                    FileFilter mediaFilter = ElanFileFilter.createFileFilter(2);
                    chooser.addChoosableFileFilter(mediaFilter);
                    chooser.addChoosableFileFilter(ElanFileFilter.createFileFilter(16));
                    chooser.addChoosableFileFilter(ElanFileFilter.createFileFilter(17));
                    chooser.setFileFilter(mediaFilter);
                }
                chooser.setDialogTitle(ElanLocale.getString("Frame.ElanFrame.LocateMedia") + ": " + localFileName);
                boolean found = false;
                while (!found) {
                    if (currentDirectory != null) {
                        chooser.setCurrentDirectory(currentDirectory);
                    }
                    chooser.setSelectedFile(new File(file.getName()));
                    int returnVal = chooser.showOpenDialog(this);
                    if (returnVal == 0) {
                        currentDirectory = chooser.getCurrentDirectory();
                        if (!chooser.getSelectedFile().exists()) {
                            JOptionPane.showMessageDialog(this, ElanLocale.getString("Frame.ElanFrame.LocateMedia"), ElanLocale.getString("Message.Error"), 0);
                            found = false;
                            continue;
                        }
                        this.adjustMediaDescriptors(mediaDescriptors, i, chooser.getSelectedFile().getAbsolutePath());
                        transcription.setChanged();
                        found = true;
                        continue;
                    }
                    md.isValid = false;
                    validMedia = false;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validMedia;
    }

    private void adjustMediaDescriptors(Vector mediaDescriptors, int index, String newPath) {
        String oldURL = ((MediaDescriptor)mediaDescriptors.elementAt((int)index)).mediaURL;
        String newURL = FileUtility.pathToURLString(newPath);
        String newExt = null;
        if (newURL.indexOf(46) > -1) {
            newExt = newURL.substring(newURL.lastIndexOf(46) + 1);
        }
        ((MediaDescriptor)mediaDescriptors.elementAt((int)index)).mediaURL = newURL;
        ((MediaDescriptor)mediaDescriptors.elementAt((int)index)).mimeType = MediaDescriptorUtil.mimeTypeForExtension(newExt);
        for (int i = 0; i < mediaDescriptors.size(); ++i) {
            String extractedFrom = ((MediaDescriptor)mediaDescriptors.elementAt((int)i)).extractedFrom;
            if (!oldURL.equals(extractedFrom)) continue;
            ((MediaDescriptor)mediaDescriptors.elementAt((int)i)).extractedFrom = newURL;
        }
    }

    private void initElan() {
        this.setTitle("Initializing....");
        this.loadCVPreferences();
        this.viewerManager = new ViewerManager2(this.transcriptionForThisFrame);
        this.layoutManager = new ElanLayoutManager(this, this.viewerManager);
        ELANCommandFactory.addDocument(this, this.viewerManager, this.layoutManager);
        this.pvMenuManager = new PlayerViewerMenuManager(this, this.transcriptionForThisFrame);
        MediaDescriptorUtil.createMediaPlayers((TranscriptionImpl)this.transcriptionForThisFrame, this.pvMenuManager.getStoredVisiblePlayers());
        ElanMediaPlayerController mediaController = this.viewerManager.getMediaPlayerController();
        this.layoutManager.add(mediaController);
        TimeLineViewer timeLineViewer = this.viewerManager.createTimeLineViewer();
        this.layoutManager.add(timeLineViewer);
        if (this.menuItemInterLinearViewer.isSelected()) {
            InterlinearViewer interlinearViewer = this.viewerManager.createInterlinearViewer();
            this.layoutManager.add(interlinearViewer);
        } else {
            this.viewerManager.getMultiTierControlPanel().disableShowInterlinearViewer(true);
        }
        this.layoutManager.showTimeLineViewer();
        if (this.menuItemGridViewer.isSelected()) {
            GridViewer gridViewer = this.viewerManager.createGridViewer();
            this.layoutManager.add(gridViewer);
        }
        if (this.menuItemTextViewer.isSelected()) {
            TextViewer textViewer = this.viewerManager.createTextViewer();
            this.layoutManager.add(textViewer);
        }
        if (this.menuItemSubtitleViewer.isSelected()) {
            this.createSubtitleViewer();
        }
        if (this.menuItemLexiconViewer.isSelected()) {
            LexiconEntryViewer lexiconEntryViewer = this.viewerManager.createLexiconEntryViewer();
            this.layoutManager.add(lexiconEntryViewer);
        }
        ArrayList<String> audioPaths = new ArrayList<String>(4);
        if (this.layoutManager.getSignalViewer() != null) {
            audioPaths.add(this.layoutManager.getSignalViewer().getMediaPath());
        }
        if (!this.menuItemSignalViewer.isSelected() && this.layoutManager.getSignalViewer() != null) {
            this.layoutManager.remove(this.layoutManager.getSignalViewer());
        }
        ArrayList<String> videoPaths = new ArrayList<String>(6);
        for (int i = 0; i < this.transcriptionForThisFrame.getMediaDescriptors().size(); ++i) {
            MediaDescriptor md = (MediaDescriptor)this.transcriptionForThisFrame.getMediaDescriptors().get(i);
            String path = md.mediaURL;
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
            if (!(md.mimeType.equals("audio/*") || md.mimeType.equals("audio/x-wav") || videoPaths.contains(path))) {
                videoPaths.add(path);
            }
            if (audioPaths.contains(path)) continue;
            audioPaths.add(path);
        }
        this.viewerManager.setAudioPaths(audioPaths);
        this.viewerManager.setVideoPaths(videoPaths);
        if (this.menuItemAudioRecognizer.isSelected() && audioPaths.size() > 0) {
            AudioRecognizerPanel arPanel = this.viewerManager.createAudioRecognizerPanel(audioPaths);
            this.layoutManager.add(arPanel);
        }
        if (this.menuItemVideoRecognizer.isSelected() && videoPaths.size() > 0) {
            VideoRecognizerPanel vrPanel = this.viewerManager.createVideoRecognizerPanel(videoPaths);
            this.layoutManager.add(vrPanel);
        }
        if (this.menuItemMetaDataViewer.isSelected()) {
            MetadataViewer metadataViewer = this.viewerManager.createMetadataViewer();
            this.layoutManager.add(metadataViewer);
        }
        if (this.transcriptionForThisFrame.getLinkedFileDescriptors().size() > 0) {
            LinkedFileDescriptorUtil.initLinkedFiles((TranscriptionImpl)this.transcriptionForThisFrame);
        }
        if (this.elanP2P != null) {
            this.elanP2P.setManagers(this.viewerManager, this.layoutManager);
        }
        if ((SVGPrefs.getUseSVG() || ((TranscriptionImpl)this.transcriptionForThisFrame).getSVGFile() != null) && this.viewerManager.getMasterMediaPlayer() instanceof JMFGraphicMediaPlayer) {
            this.menuItemFileOpen.setEnabled(false);
            this.menuItemFileNew.setEnabled(false);
            this.menuImport.setEnabled(false);
        }
        ElanLocale.addElanLocaleListener(this.transcriptionForThisFrame, this);
        this.setFrameTitle();
        this.initMenusAndCommands();
        this.pvMenuManager.initPlayerMenu();
        if (this.viewerManager.getMasterMediaPlayer().isFrameRateAutoDetected()) {
            this.setMenuEnabled(740, false);
        }
        Preferences.addPreferencesListener(this.transcriptionForThisFrame, this.layoutManager);
        Preferences.addPreferencesListener(this.transcriptionForThisFrame, this);
        Preferences.notifyListeners(this.transcriptionForThisFrame);
        this.loadPreferences();
        this.layoutManager.doLayout();
        this.initialized = true;
    }

    private void setFrameTitle() {
        try {
            if (this.transcriptionForThisFrame != null) {
                if (this.transcriptionForThisFrame.getName().equals("aishug294879ryshfda9763afo8947a5gf")) {
                    this.setTitle("ELAN - " + ElanLocale.getString("Frame.ElanFrame.UndefinedFileName"));
                } else {
                    this.setTitle("ELAN - " + this.transcriptionForThisFrame.getName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initFrame() {
        Locale savedLocale = (Locale)Preferences.get("Locale", null);
        if (savedLocale != null) {
            ElanLocale.setLocale(savedLocale);
        }
        this.initMenuBar();
        this.addWindowListener(new ElanFrameWindowListener());
        this.setDefaultCloseOperation(0);
        this.pack();
        Dimension d = (Dimension)Preferences.get("FrameSize", null);
        Rectangle wRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (d != null) {
            if (d.width > wRect.width) {
                d.setSize(wRect.width, d.height);
            }
            if ((double)d.height > wRect.getHeight()) {
                d.setSize(d.width, wRect.height);
            }
            this.setSize(d);
        } else {
            this.setSize(800, 600);
        }
        Point p = (Point)Preferences.get("FrameLocation", null);
        if (p != null) {
            int mph;
            int mpx = wRect.width - this.getWidth();
            if (p.x > mpx && mpx > 0) {
                p.x = mpx;
            }
            if (p.y > (mph = wRect.height - this.getHeight()) && mph > 0) {
                p.y = mph;
            }
            this.setLocation(p);
        } else {
            this.setLocation((int)(wRect.getWidth() / 2.0 - (double)(this.getWidth() / 2)), (int)(wRect.getHeight() / 2.0 - (double)(this.getHeight() / 2)));
        }
        this.setVisible(true);
    }

    private void initMenuBar() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        MenuAction ma = new MenuAction("Menu.File");
        this.menuFile = new JMenu(ma);
        this.menuActions.add(ma);
        this.menuBar.add(this.menuFile);
        ma = new NewMA("Menu.File.New", this);
        this.menuActions.add(ma);
        this.menuItemFileNew = new JMenuItem(ma);
        this.menuFile.add(this.menuItemFileNew);
        ma = new OpenMA("Menu.File.Open", this);
        this.menuActions.add(ma);
        this.menuItemFileOpen = new JMenuItem(ma);
        this.menuFile.add(this.menuItemFileOpen);
        ma = new MenuAction("Menu.File.OpenRecent");
        this.menuActions.add(ma);
        this.menuRecentFiles = new JMenu(ma);
        this.menuFile.add(this.menuRecentFiles);
        this.closeMI = new ElanMenuItem(ElanLocale.getString("Menu.File.Close"), false);
        this.menuFile.add(this.closeMI);
        this.menuFile.addSeparator();
        this.saveMI = new ElanMenuItem(ElanLocale.getString("Menu.File.Save"), false);
        this.menuFile.add(this.saveMI);
        this.saveAsMI = new ElanMenuItem(ElanLocale.getString("Menu.File.SaveAs"), false);
        this.menuFile.add(this.saveAsMI);
        this.saveAsTemplateMI = new ElanMenuItem(ElanLocale.getString("Menu.File.SaveAsTemplate"), false);
        this.menuFile.add(this.saveAsTemplateMI);
        this.saveSelEafMI = new ElanMenuItem(ElanLocale.getString("Menu.File.SaveSelectionAsEAF"), false);
        this.menuFile.add(this.saveSelEafMI);
        ma = new MergeTranscriptionsMA("Menu.File.MergeTranscriptions", this);
        this.menuActions.add(ma);
        this.mergeTransMI = new ElanMenuItem(ma);
        this.menuFile.add(this.mergeTransMI);
        ma = new MenuAction("Menu.File.Backup.Auto");
        this.menuActions.add(ma);
        this.menuBackup = new JMenu(ma);
        this.menuBackup.setEnabled(false);
        this.menuFile.add(this.menuBackup);
        this.menuFile.addSeparator();
        this.pageSetUpMI = new ElanMenuItem(ElanLocale.getString("Menu.File.PageSetup"), false);
        this.menuFile.add(this.pageSetUpMI);
        this.printPreviewMI = new ElanMenuItem(ElanLocale.getString("Menu.File.PrintPreview"), false);
        this.menuFile.add(this.printPreviewMI);
        this.printMI = new ElanMenuItem(ElanLocale.getString("Menu.File.Print"), false);
        this.menuFile.add(this.printMI);
        this.menuFile.addSeparator();
        ma = new MenuAction("Menu.File.ProcessMulti");
        this.menuActions.add(ma);
        JMenu mfProcessMenu = new JMenu(ma);
        this.menuFile.add(mfProcessMenu);
        ma = new MultipleFilesEditMA("Menu.File.Process.EditMF", this);
        this.menuActions.add(ma);
        mfProcessMenu.add(new JMenuItem(ma));
        ma = new MultiEAFScrubberMA("Menu.File.ScrubTranscriptions", this);
        this.menuActions.add(ma);
        this.menuItemScrubTrans = new JMenuItem(ma);
        mfProcessMenu.add(this.menuItemScrubTrans);
        this.menuFile.addSeparator();
        ma = new MenuAction("Menu.File.Export");
        this.menuActions.add(ma);
        this.menuExport = new JMenu(ma);
        this.menuExport.setEnabled(false);
        this.menuFile.add(this.menuExport);
        ma = new MenuAction("Menu.File.Export.MultipleFiles");
        this.menuActions.add(ma);
        JMenu exportMenuMulti = new JMenu(ma);
        this.menuFile.add(exportMenuMulti);
        ma = new ExportTabMultiMA("Menu.File.Export.Tab", this);
        this.menuActions.add(ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new ExportAnnotationsMultiMA("Menu.File.Export.AnnotationListMulti", this);
        this.menuActions.add(ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new ExportWordsMultiMA("Menu.File.Export.WordList", this);
        this.menuActions.add(ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new ExportTiersMA("Menu.File.Export.Tiers", this);
        this.menuActions.add(ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new MenuAction("Menu.File.Import");
        this.menuActions.add(ma);
        this.menuImport = new JMenu(ma);
        this.menuFile.add(this.menuImport);
        ma = new ImportShoeboxMA("Menu.File.Import.Shoebox", this);
        this.menuActions.add(ma);
        this.menuItemShoeboxImport = new JMenuItem(ma);
        this.menuImport.add(this.menuItemShoeboxImport);
        ma = new ImportToolboxMA("Menu.File.Import.Toolbox", this);
        this.menuActions.add(ma);
        JMenuItem toolboxImportMI = new JMenuItem(ma);
        this.menuImport.add(toolboxImportMI);
        ma = new ImportFlexMA("Menu.File.Import.FLEx", this);
        this.menuActions.add(ma);
        JMenuItem flexImportMI = new JMenuItem(ma);
        this.menuImport.add(flexImportMI);
        ma = new ImportCHATMA("Menu.File.Import.CHAT", this);
        this.menuActions.add(ma);
        this.menuItemCHATImport = new JMenuItem(ma);
        this.menuImport.add(this.menuItemCHATImport);
        ma = new ImportTranscriberMA("Menu.File.Import.Transcriber", this);
        this.menuActions.add(ma);
        this.menuItemTranscriberImport = new JMenuItem(ma);
        this.menuImport.add(this.menuItemTranscriberImport);
        ma = new ImportDelimitedTextMA("Menu.File.Import.Delimited", this);
        this.menuActions.add(ma);
        this.menuImport.add(new JMenuItem(ma));
        ma = new ImportPraatMA("Menu.File.Import.PraatTiers", this);
        this.importPraatMI = new ElanMenuItem(ma);
        this.menuActions.add(ma);
        this.menuImport.add(this.importPraatMI);
        ma = new ImportRecognizerTiersMA("Menu.File.Import.RecognizerTiers", this);
        this.importRecogTiersMI = new ElanMenuItem(ma);
        this.menuActions.add(ma);
        this.menuImport.add(this.importRecogTiersMI);
        this.menuFile.addSeparator();
        ma = new ExitMA("Menu.File.Exit");
        this.menuActions.add(ma);
        this.menuItemFileExit = new JMenuItem(ma);
        this.menuFile.add(this.menuItemFileExit);
        ma = new MenuAction("Menu.Edit");
        this.menuActions.add(ma);
        this.menuEdit = new JMenu(ma);
        this.menuBar.add(this.menuEdit);
        this.undoMI = new ElanMenuItem(ElanLocale.getString("Menu.Edit.Undo"), false);
        this.menuEdit.add(this.undoMI);
        this.redoMI = new ElanMenuItem(ElanLocale.getString("Menu.Edit.Redo"), false);
        this.menuEdit.add(this.redoMI);
        this.menuEdit.addSeparator();
        this.editCVMI = new ElanMenuItem(ElanLocale.getString("Menu.Edit.EditCV"), false);
        this.menuEdit.add(this.editCVMI);
        this.editLexiconServiceMI = new ElanMenuItem(ElanLocale.getString("Menu.Edit.EditLexSrvc"), false);
        this.menuEdit.add(this.editLexiconServiceMI);
        this.setAuthorMI = new ElanMenuItem(ElanLocale.getString("Menu.Edit.Author"), false);
        this.menuEdit.add(this.setAuthorMI);
        this.menuEdit.addSeparator();
        this.linkedFilesMI = new ElanMenuItem(ElanLocale.getString("Menu.Edit.LinkedFiles"), false);
        this.menuEdit.add(this.linkedFilesMI);
        this.menuEdit.addSeparator();
        ma = new MenuAction("Menu.Edit.Preferences");
        this.menuActions.add(ma);
        this.menuPreferences = new JMenu(ma);
        this.menuEdit.add(this.menuPreferences);
        ma = new EditPreferencesMA("Menu.Edit.Preferences.Edit", this);
        this.menuActions.add(ma);
        this.menuPreferences.add(new JMenuItem(ma));
        ma = new EditShortcutsMA("Menu.Edit.Preferences.Shortcut", this);
        this.menuActions.add(ma);
        this.menuPreferences.add(new JMenuItem(ma));
        this.menuPreferences.addSeparator();
        this.importPrefsMI = new ElanMenuItem(ElanLocale.getString("Menu.Edit.Preferences.Import"), false);
        this.menuPreferences.add(this.importPrefsMI);
        this.exportPrefsMI = new ElanMenuItem(ElanLocale.getString("Menu.Edit.Preferences.Export"), false);
        this.menuPreferences.add(this.exportPrefsMI);
        ma = new MenuAction("Menu.Annotation");
        this.menuActions.add(ma);
        this.menuAnnotation = new JMenu(ma);
        this.menuBar.add(this.menuAnnotation);
        this.menuAnnotation.setEnabled(false);
        ma = new MenuAction("Menu.Tier");
        this.menuActions.add(ma);
        this.menuTier = new JMenu(ma);
        this.menuBar.add(this.menuTier);
        this.menuTier.setEnabled(false);
        ma = new MenuAction("Menu.Type");
        this.menuActions.add(ma);
        this.menuType = new JMenu(ma);
        this.menuBar.add(this.menuType);
        this.menuType.setEnabled(false);
        ma = new MenuAction("Menu.Search");
        this.menuActions.add(ma);
        this.menuSearch = new JMenu(ma);
        this.menuBar.add(this.menuSearch);
        this.searchMI = new ElanMenuItem(ElanLocale.getString("Menu.Search.Find"), false);
        this.menuSearch.add(this.searchMI);
        ma = new MultiFindReplaceMA("Menu.Search.FindReplaceMulti", this);
        this.menuActions.add(ma);
        this.menuSearch.add(ma);
        ma = new SearchMultipleMA("Menu.Search.Multiple", this);
        this.menuActions.add(ma);
        this.menuSearch.add(ma);
        ma = new StructuredSearchMultipleMA("Menu.Search.StructuredMultiple", this);
        this.menuActions.add(ma);
        this.menuSearch.add(ma);
        this.goToMI = new ElanMenuItem(ElanLocale.getString("Menu.Search.GoTo"), false);
        this.menuSearch.add(this.goToMI);
        ma = new MenuAction("Menu.View");
        this.menuActions.add(ma);
        this.menuView = new JMenu(ma);
        this.menuBar.add(this.menuView);
        ma = new MenuAction("Menu.View.MediaPlayer");
        this.menuActions.add(ma);
        this.menuMediaPlayer = new JMenu(ma);
        this.menuView.add(this.menuMediaPlayer);
        ma = new MenuAction("Menu.View.Viewers");
        this.menuActions.add(ma);
        this.menuViewer = new JMenu(ma);
        this.menuView.add(this.menuViewer);
        this.menuView.addSeparator();
        this.menuItemGridViewer = new JCheckBoxMenuItem(new CreateGridViewerMA("Menu.View.Viewers.Grid", this));
        this.menuItemGridViewer.setSelected(true);
        this.menuViewer.add(this.menuItemGridViewer);
        this.menuItemTextViewer = new JCheckBoxMenuItem(new CreateTextViewerMA("Menu.View.Viewers.Text", this));
        this.menuItemTextViewer.setSelected(true);
        this.menuViewer.add(this.menuItemTextViewer);
        this.menuItemSubtitleViewer = new JCheckBoxMenuItem(new CreateSubtitleViewerMA("Menu.View.Viewers.Subtitles", this));
        this.menuItemSubtitleViewer.setSelected(true);
        this.menuViewer.add(this.menuItemSubtitleViewer);
        this.menuItemLexiconViewer = new JCheckBoxMenuItem(new CreateLexiconViewerMA("LexiconEntryViewer.Lexicon", this));
        this.menuItemLexiconViewer.setSelected(true);
        this.menuViewer.add(this.menuItemLexiconViewer);
        this.menuItemAudioRecognizer = new JCheckBoxMenuItem(new CreateAudioRecognizerMA("Menu.View.Viewers.Audio", this));
        this.menuItemAudioRecognizer.setSelected(true);
        this.menuViewer.add(this.menuItemAudioRecognizer);
        this.menuItemVideoRecognizer = new JCheckBoxMenuItem(new CreateVideoRecognizerMA("Menu.View.Viewers.Video", this));
        this.menuItemVideoRecognizer.setSelected(true);
        this.menuViewer.add(this.menuItemVideoRecognizer);
        this.menuItemMetaDataViewer = new JCheckBoxMenuItem(new CreateMetadataViewerMA("Menu.View.Viewers.MetaData", this));
        this.menuItemMetaDataViewer.setSelected(true);
        this.menuViewer.add(this.menuItemMetaDataViewer);
        this.menuItemSignalViewer = new JCheckBoxMenuItem(new CreateSignalViewerMA("Menu.View.Viewers.Signal", this));
        this.menuItemSignalViewer.setSelected(true);
        this.menuViewer.add(this.menuItemSignalViewer);
        this.menuItemInterLinearViewer = new JCheckBoxMenuItem(new CreateInterlinearViewerMA("Menu.View.Viewers.InterLinear", this));
        this.menuItemInterLinearViewer.setSelected(true);
        this.menuViewer.add(this.menuItemInterLinearViewer);
        this.loadViewerPreferences();
        this.tierDependenciesMI = new ElanMenuItem(ElanLocale.getString("Menu.View.Dependencies"), false);
        this.menuView.add(this.tierDependenciesMI);
        ma = new ShortcutsMA("Menu.View.Shortcuts");
        this.menuActions.add(ma);
        this.menuView.add(ma);
        ma = new FontBrowserMA("Menu.View.FontBrowser");
        this.menuActions.add(ma);
        this.menuView.add(ma);
        this.menuView.addSeparator();
        this.spreadsheetMI = new ElanMenuItem(ElanLocale.getString("Menu.View.SpreadSheet"), false);
        this.menuView.add(this.spreadsheetMI);
        this.statisticsMI = new ElanMenuItem(ElanLocale.getString("Menu.View.Statistics"), false);
        this.menuView.add(this.statisticsMI);
        ma = new MenuAction("Menu.Options");
        this.menuActions.add(ma);
        this.menuOptions = new JMenu(ma);
        this.menuBar.add(this.menuOptions);
        ma = new MenuAction("Menu.Options.TimeChangePropagationMode");
        this.menuActions.add(ma);
        this.menuChangeTimePropMode = new JMenu(ma);
        this.menuChangeTimePropMode.setEnabled(false);
        this.menuOptions.add(this.menuChangeTimePropMode);
        this.menuOptions.addSeparator();
        this.menuItemAnnoMode = new JRadioButtonMenuItem(ElanLocale.getString("Menu.Options.AnnotationMode"));
        this.menuItemAnnoMode.setEnabled(false);
        this.menuItemAnnoMode.setSelected(true);
        this.menuOptions.add(this.menuItemAnnoMode);
        this.menuItemSyncMode = new JRadioButtonMenuItem(ElanLocale.getString("Menu.Options.SyncMode"));
        this.menuItemSyncMode.setEnabled(false);
        this.menuOptions.add(this.menuItemSyncMode);
        this.menuOptions.addSeparator();
        ma = new SetPlayAroundSelectionMA("Menu.Options.PlayAroundSelectionDialog", this);
        this.menuActions.add(ma);
        this.menuOptions.add(new JMenuItem(ma));
        ma = new SetPlaybackToggleMA("Menu.Options.PlaybackToggleDialog", this);
        this.menuActions.add(ma);
        this.menuOptions.add(new JMenuItem(ma));
        this.menuOptions.addSeparator();
        ma = new MenuAction("Menu.Options.FrameLength");
        this.menuActions.add(ma);
        this.menuFrameLength = new JMenu(ma);
        this.menuFrameLength.setEnabled(false);
        this.menuOptions.add(this.menuFrameLength);
        this.menuOptions.addSeparator();
        ma = new MenuAction("Menu.Options.Language");
        this.menuActions.add(ma);
        this.menuAppLanguage = new JMenu(ma);
        this.languageBG = new ButtonGroup();
        ma = new SetLocaleMA("CommandActions.Catalan", this, ElanLocale.CATALAN);
        JRadioButtonMenuItem langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("CommandActions.German", this, ElanLocale.GERMAN);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("CommandActions.English", this, ElanLocale.ENGLISH);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("CommandActions.Spanish", this, ElanLocale.SPANISH);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("CommandActions.French", this, ElanLocale.FRENCH);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("CommandActions.Japanese", this, ElanLocale.JAPANESE);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("CommandActions.Dutch", this, ElanLocale.DUTCH);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("CommandActions.Portuguese", this, ElanLocale.PORTUGUESE);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("CommandActions.Swedish", this, ElanLocale.SWEDISH);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("Menu.Options.Language.Custom", this, ElanLocale.CUSTOM);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        this.menuOptions.add(this.menuAppLanguage);
        ma = new MenuAction("Menu.Window");
        this.menuActions.add(ma);
        this.menuWindow = new JMenu(ma);
        this.windowsGroup = new ButtonGroup();
        this.menuBar.add(this.menuWindow);
        ma = new MenuAction("Menu.Help");
        this.menuActions.add(ma);
        this.menuHelp = new JMenu(ma);
        this.menuBar.add(this.menuHelp);
        ma = new HelpMA("Menu.Help.Contents", this);
        this.menuActions.add(ma);
        this.menuHelp.add(new JMenuItem(ma));
        this.menuHelp.addSeparator();
        ma = new MenuAction("Menu.Help.Website");
        this.menuActions.add(ma);
        JMenu websiteMenu = new JMenu(ma);
        this.menuHelp.add(websiteMenu);
        ma = new WebMA("Menu.Help.Website.ReleaseNotes", this, "http://www.lat-mpi.eu/tools/elan/release-notes.html");
        this.menuActions.add(ma);
        websiteMenu.add(new JMenuItem(ma));
        ma = new WebMA("Menu.Help.Website.Download", this, "http://www.lat-mpi.eu/tools/elan/download");
        this.menuActions.add(ma);
        websiteMenu.add(new JMenuItem(ma));
        ma = new WebMA("Menu.Help.Website.Forum", this, "http://www.lat-mpi.eu/tools/elan/elanforum/simpleforum_view");
        this.menuActions.add(ma);
        websiteMenu.add(new JMenuItem(ma));
        websiteMenu.addSeparator();
        ma = new WebMA("Menu.Help.Website.Subscibe", this, "mailto:majordomo@mpi.nl?body=subscribe%20Elan&amp;subject=subscribe%20to%20Elan");
        this.menuActions.add(ma);
        websiteMenu.add(new JMenuItem(ma));
        ma = new AboutMA("Menu.Help.About", this);
        this.menuActions.add(ma);
        this.menuHelp.add(new JMenuItem(ma));
        if (this.elanP2P != null) {
            ma = new MenuAction("Menu.P2P");
            this.menuActions.add(ma);
            this.menuP2P = new JMenu(ma);
            this.menuBar.add(this.menuP2P);
            this.menuItemDiscoverDoc = new JMenuItem();
            this.menuItemDiscoverDoc.addActionListener(this);
            this.menuItemDiscoverDoc.setActionCommand("DiscoverDoc");
            this.menuP2P.add(this.menuItemDiscoverDoc);
        }
        this.updateLocale();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("DiscoverDoc")) {
            if (this.elanP2P != null) {
                Command c = ELANCommandFactory.createCommand(null, "Menu.P2P.DiscoverDocument");
                c.execute(this.elanP2P, new Object[]{this});
            }
        } else if (command.equals("PublishDoc")) {
            if (this.elanP2P != null) {
                Command c = ELANCommandFactory.createCommand(null, "Menu.P2P.PublishDocument");
                c.execute(this.elanP2P, new Object[]{this, this.transcriptionForThisFrame});
            }
        } else if (command.equals("Use Native Media Platform")) {
            boolean useNativeMedia = this.menuItemNativeMedia.getState();
            if (useNativeMedia) {
                System.out.println("Setting preferred media framework to Native");
                System.setProperty("PreferredMediaFramework", "NativeWindows");
            } else {
                System.out.println("Setting preferred media framework to JMF");
                System.setProperty("PreferredMediaFramework", "JMF");
            }
        }
    }

    private void initMenusAndCommands() {
        InputMap inputMap = this.menuBar.getInputMap(2);
        ActionMap actionMap = this.menuBar.getActionMap();
        if (inputMap instanceof ComponentInputMap && actionMap != null) {
            String nextId;
            KeyStroke ks;
            AbstractAction act;
            String id = "Act-";
            int index = 0;
            Map<String, KeyStroke> shortMap = ShortcutsUtil.getInstance().getCurrentShortcuts();
            Iterator<String> keyIt = shortMap.keySet().iterator();
            while (keyIt.hasNext()) {
                act = ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, keyIt.next());
                if (act == null || (ks = (KeyStroke)act.getValue("AcceleratorKey")) == null) continue;
                nextId = id + index++;
                inputMap.put(ks, nextId);
                actionMap.put(nextId, act);
            }
            act = new NextWindowMA("Menu.Window.Next");
            ks = (KeyStroke)act.getValue("AcceleratorKey");
            nextId = id + index++;
            inputMap.put(ks, nextId);
            actionMap.put(nextId, act);
            act = new PrevWindowMA("Menu.Window.Previous");
            ks = (KeyStroke)act.getValue("AcceleratorKey");
            nextId = id + index++;
            inputMap.put(ks, nextId);
            actionMap.put(nextId, act);
        }
        if (this.menuItemScrubTrans != null) {
            this.menuFile.remove(this.menuItemScrubTrans);
        }
        this.closeMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Close"), true);
        this.saveMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Save"), true);
        this.saveAsMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.SaveAs"), true);
        this.saveAsTemplateMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.SaveAsTemplate"), true);
        this.saveSelEafMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.SaveSelectionAsEAF"), true);
        this.menuActions.remove(this.mergeTransMI.getAction());
        this.mergeTransMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.MergeTranscriptions"), true);
        this.menuBackup.setEnabled(true);
        ButtonGroup backupGroup = new ButtonGroup();
        Integer buDelay = (Integer)Preferences.get("BackUpDelay", null);
        JRadioButtonMenuItem neverMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.Never"));
        if (buDelay == null || buDelay != null && buDelay.compareTo(Constants.BACKUP_NEVER) == 0) {
            neverMI.setSelected(true);
        }
        JRadioButtonMenuItem backup1MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.1"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_1) == 0) {
            backup1MI.setSelected(true);
        }
        JRadioButtonMenuItem backup5MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.5"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_5) == 0) {
            backup5MI.setSelected(true);
        }
        JRadioButtonMenuItem backup10MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.10"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_10) == 0) {
            backup10MI.setSelected(true);
        }
        JRadioButtonMenuItem backup20MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.20"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_20) == 0) {
            backup20MI.setSelected(true);
        }
        JRadioButtonMenuItem backup30MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.30"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_30) == 0) {
            backup30MI.setSelected(true);
        }
        backupGroup.add(neverMI);
        backupGroup.add(backup1MI);
        backupGroup.add(backup5MI);
        backupGroup.add(backup10MI);
        backupGroup.add(backup20MI);
        backupGroup.add(backup30MI);
        this.menuBackup.add(neverMI);
        this.menuBackup.add(backup1MI);
        this.menuBackup.add(backup5MI);
        this.menuBackup.add(backup10MI);
        this.menuBackup.add(backup20MI);
        this.menuBackup.add(backup30MI);
        this.pageSetUpMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.PageSetup"), true);
        this.printPreviewMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.PrintPreview"), true);
        this.printMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Print"), true);
        this.menuExport.setEnabled(true);
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Shoebox")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Toolbox")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.CHAT")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Tab")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Tiger")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Interlinear")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.HTML")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.TraditionalTransript")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Praat")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.WordList")));
        MenuAction ma = new MenuAction("Menu.File.Export.Smil");
        this.menuActions.add(ma);
        this.menuExportSMIL = new JMenu(ma);
        this.menuExport.add(this.menuExportSMIL);
        this.menuExportSMIL.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Smil.RealPlayer")));
        this.menuExportSMIL.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Smil.QuickTime")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.QtSub")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Subtitles")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.RecognizerTiers")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Media")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.MediaWithScript")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.ImageFromWindow")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.FilmStrip")));
        this.menuActions.remove(this.importPraatMI.getAction());
        this.importPraatMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Import.PraatTiers"), true);
        this.menuActions.remove(this.importRecogTiersMI.getAction());
        this.importRecogTiersMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Import.RecognizerTiers"), true);
        UndoCA undoCA = ELANCommandFactory.getUndoCA(this.transcriptionForThisFrame);
        this.undoMI.setAction(undoCA);
        RedoCA redoCA = ELANCommandFactory.getRedoCA(this.transcriptionForThisFrame);
        this.redoMI.setAction(redoCA);
        this.editCVMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.EditCV"), true);
        this.editLexiconServiceMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.EditLexSrvc"), true);
        this.setAuthorMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.Author"), true);
        this.linkedFilesMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.LinkedFiles"), true);
        this.importPrefsMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.Preferences.Import"), true);
        this.exportPrefsMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.Preferences.Export"), true);
        this.menuAnnotation.setEnabled(true);
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.NewAnnotation")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.NewAnnotationBefore")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.NewAnnotationAfter")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ModifyAnnotation")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "ModifyAnnotationDCDlg")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.MergeWithNext")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.MergeWithBefore")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.RemoveAnnotationValue")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.SplitAnnotation")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DeleteAnnotation")));
        ma = new MenuAction("Menu.Annotation.Delete");
        this.menuActions.add(ma);
        JMenu delMenu = new JMenu(ma);
        this.menuAnnotation.add(delMenu);
        delMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DeleteAnnotationsInSelection")));
        delMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DeleteAnnotationsLeftOf")));
        delMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DeleteAnnotationsRightOf")));
        delMenu.addSeparator();
        delMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DeleteAllLeftOf")));
        delMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DeleteAllRightOf")));
        if (SVGPrefs.getUseSVG() || ((TranscriptionImpl)this.transcriptionForThisFrame).getSVGFile() != null) {
            this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ModifyGraphicAnnotation")));
        }
        this.menuAnnotation.addSeparator();
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.CopyAnnotation")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.CopyAnnotationTree")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DuplicateAnnotation")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.PasteAnnotation")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.PasteAnnotationTree")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.PasteAnnotationHere")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.PasteAnnotationTreeHere")));
        this.menuAnnotation.addSeparator();
        ma = new MenuAction("Menu.Annotation.Shift");
        this.menuActions.add(ma);
        JMenu shiftMenu = new JMenu(ma);
        this.menuAnnotation.add(shiftMenu);
        shiftMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftActiveAnnotation")));
        shiftMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftAnnotationsInSelection")));
        shiftMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftAnnotationsLeftOf")));
        shiftMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftAnnotationsRightOf")));
        shiftMenu.addSeparator();
        shiftMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftAllLeftOf")));
        shiftMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftAllRightOf")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftAll")));
        this.menuTier.setEnabled(true);
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.AddNewTier")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.ChangeTier")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.ReparentTier")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.DeleteTier")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.ImportTiers")));
        this.menuTier.addSeparator();
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.Tokenize")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.FilterTierDlg")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.CopyTierDialog")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.MergeTiers")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.MergeTierGroup")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.AnnotationsOnDependentTiers")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.AnnotationsFromOverlaps")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.AnnotationsFromGaps")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.RegularAnnotation")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.RemoveAnnotationsOrValues")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.LabelAndNumber")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.ChangeCase")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.Segmentation")));
        this.menuTier.addSeparator();
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.CompareAnnotators")));
        this.menuType.setEnabled(true);
        this.menuType.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Type.AddNewType")));
        this.menuType.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Type.ChangeType")));
        this.menuType.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Type.DeleteType")));
        this.menuType.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Type.ImportTypes")));
        this.searchMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Search.Find"), true);
        this.goToMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Search.GoTo"), true);
        this.tierDependenciesMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.View.Dependencies"), true);
        this.spreadsheetMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.View.SpreadSheet"), true);
        this.statisticsMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.View.Statistics"), true);
        this.menuChangeTimePropMode.setEnabled(true);
        ButtonGroup timePropGroup = new ButtonGroup();
        JRadioButtonMenuItem normalModeMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.NormalPropagationMode"));
        JRadioButtonMenuItem bulldozerModeMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.BulldozerMode"));
        JRadioButtonMenuItem shiftModeMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.ShiftMode"));
        timePropGroup.add(normalModeMI);
        normalModeMI.setSelected(true);
        timePropGroup.add(bulldozerModeMI);
        timePropGroup.add(shiftModeMI);
        this.menuChangeTimePropMode.add(normalModeMI);
        this.menuChangeTimePropMode.add(bulldozerModeMI);
        this.menuChangeTimePropMode.add(shiftModeMI);
        ButtonGroup modeGroup = new ButtonGroup();
        this.menuItemAnnoMode.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.AnnotationMode"));
        this.menuItemAnnoMode.setEnabled(true);
        this.menuItemSyncMode.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.SyncMode"));
        this.menuItemSyncMode.setEnabled(true);
        modeGroup.add(this.menuItemAnnoMode);
        modeGroup.add(this.menuItemSyncMode);
        this.menuFrameLength.setEnabled(true);
        ButtonGroup videoGroup = new ButtonGroup();
        JRadioButtonMenuItem palMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.FrameLength.PAL"));
        JRadioButtonMenuItem ntscMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.FrameLength.NTSC"));
        videoGroup.add(palMI);
        palMI.setSelected(true);
        videoGroup.add(ntscMI);
        this.menuFrameLength.add(palMI);
        this.menuFrameLength.add(ntscMI);
        if (this.elanP2P != null) {
            this.menuItemPublishDoc = new JMenuItem();
            this.menuItemPublishDoc.addActionListener(this);
            this.menuItemPublishDoc.setActionCommand("PublishDoc");
            this.menuP2P.add(this.menuItemPublishDoc);
        }
        this.updateLocale();
    }

    public void updateLocale() {
        this.setFrameTitle();
        if (this.languageBG != null && this.languageBG.getButtonCount() > 0) {
            Enumeration<AbstractButton> en = this.languageBG.getElements();
            while (en.hasMoreElements()) {
                JRadioButtonMenuItem rbItem;
                AbstractButton item = en.nextElement();
                if (!(item instanceof JRadioButtonMenuItem) || !((rbItem = (JRadioButtonMenuItem)item).getAction() instanceof SetLocaleMA) || !((SetLocaleMA)rbItem.getAction()).getLocale().equals(ElanLocale.getLocale())) continue;
                rbItem.setSelected(true);
                break;
            }
        }
        if (this.menuP2P != null) {
            this.menuItemDiscoverDoc.setText(ElanLocale.getString("Menu.P2P.DiscoverDocument"));
            if (this.menuItemPublishDoc != null) {
                this.menuItemPublishDoc.setText(ElanLocale.getString("Menu.P2P.PublishDocument"));
            }
        }
        for (int i = 0; i < this.menuActions.size(); ++i) {
            MenuAction ma = (MenuAction)this.menuActions.get(i);
            ma.updateLocale();
        }
    }

    private void savePreferences() {
        if (this.viewerManager != null) {
            Preferences.set("MediaTime", this.viewerManager.getMasterMediaPlayer().getMediaTime(), this.transcriptionForThisFrame, false, false);
            Preferences.set("SelectionBeginTime", this.viewerManager.getSelection().getBeginTime(), this.transcriptionForThisFrame, false, false);
            Preferences.set("SelectionEndTime", this.viewerManager.getSelection().getEndTime(), this.transcriptionForThisFrame, false, false);
            Preferences.set("TimeScaleBeginTime", this.viewerManager.getTimeScale().getBeginTime(), this.transcriptionForThisFrame, false, true);
        }
        this.setPreference("Locale", ElanLocale.getLocale(), null);
        this.setPreference("FrameSize", this.getSize(), null);
        Preferences.set("FrameLocation", this.getLocation(), null, false, true);
    }

    private void loadViewerPreferences() {
        Object val = Preferences.get("Menu.View.Viewers.Grid", null);
        if (val instanceof Boolean) {
            this.menuItemGridViewer.setSelected((Boolean)val);
        }
        if ((val = Preferences.get("Menu.View.Viewers.Text", null)) instanceof Boolean) {
            this.menuItemTextViewer.setSelected((Boolean)val);
        }
        if ((val = Preferences.get("Menu.View.Viewers.Subtitles", null)) instanceof Boolean) {
            this.menuItemSubtitleViewer.setSelected((Boolean)val);
        }
        if ((val = Preferences.get("LexiconEntryViewer.Lexicon", null)) instanceof Boolean) {
            this.menuItemLexiconViewer.setSelected((Boolean)val);
        }
        if ((val = Preferences.get("Menu.View.Viewers.Audio", null)) instanceof Boolean) {
            this.menuItemAudioRecognizer.setSelected((Boolean)val);
        }
        if ((val = Preferences.get("Menu.View.Viewers.Video", null)) instanceof Boolean) {
            this.menuItemVideoRecognizer.setSelected((Boolean)val);
        }
        if ((val = Preferences.get("Menu.View.Viewers.MetaData", null)) instanceof Boolean) {
            this.menuItemMetaDataViewer.setSelected((Boolean)val);
        }
        if ((val = Preferences.get("Menu.View.Viewers.Signal", null)) instanceof Boolean) {
            this.menuItemSignalViewer.setSelected((Boolean)val);
        }
        if ((val = Preferences.get("Menu.View.Viewers.InterLinear", null)) instanceof Boolean) {
            this.menuItemInterLinearViewer.setSelected((Boolean)val);
        }
    }

    private void loadPreferences() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Integer backupDelay;
                Object val;
                Long timeScaleBeginTime;
                Long mediaTime;
                Long beginTime = (Long)Preferences.get("SelectionBeginTime", ElanFrame2.this.transcriptionForThisFrame);
                Long endTime = (Long)Preferences.get("SelectionEndTime", ElanFrame2.this.transcriptionForThisFrame);
                if (beginTime != null && endTime != null) {
                    ElanFrame2.this.viewerManager.getSelection().setSelection(beginTime, endTime);
                }
                if ((mediaTime = (Long)Preferences.get("MediaTime", ElanFrame2.this.transcriptionForThisFrame)) != null) {
                    ElanFrame2.this.viewerManager.getMasterMediaPlayer().setMediaTime(mediaTime);
                }
                if ((timeScaleBeginTime = (Long)Preferences.get("TimeScaleBeginTime", ElanFrame2.this.transcriptionForThisFrame)) != null) {
                    ElanFrame2.this.viewerManager.getTimeScale().setBeginTime(timeScaleBeginTime);
                }
                if ((val = Preferences.get("MediaNavigation.FrameStepToFrameBegin", null)) instanceof Boolean) {
                    ElanFrame2.this.viewerManager.setFrameStepsToBeginOfFrame((Boolean)val);
                }
                if ((backupDelay = (Integer)Preferences.get("BackUpDelay", null)) != null && backupDelay > 0) {
                    Command c = ELANCommandFactory.createCommand(ElanFrame2.this.transcriptionForThisFrame, "CommandActions.Backup");
                    c.execute(ELANCommandFactory.getCommandAction(ElanFrame2.this.transcriptionForThisFrame, "CommandActions.Backup"), new Object[]{backupDelay});
                }
                ElanFrame2.this.fullyInitialized = true;
                ElanFrame2.this.layoutManager.doLayout();
            }
        });
    }

    private void loadCVPreferences() {
        if (this.transcriptionForThisFrame == null) {
            return;
        }
        Object cvPrefs = Preferences.get("CV.Prefs", this.transcriptionForThisFrame);
        if (cvPrefs instanceof HashMap) {
            HashMap cvPrefMap = (HashMap)cvPrefs;
            Vector allCV = ((TranscriptionImpl)this.transcriptionForThisFrame).getControlledVocabularies();
            if (allCV == null) {
                return;
            }
            String color = "Color";
            String keyCode = "KeyCode";
            for (int i = 0; i < allCV.size(); ++i) {
                ControlledVocabulary cv = (ControlledVocabulary)allCV.get(i);
                Object cvMapObj = cvPrefMap.get(cv.getName());
                if (!(cvMapObj instanceof HashMap)) continue;
                HashMap cvMap = (HashMap)cvMapObj;
                CVEntry[] cve = cv.getEntries();
                for (int j = 0; j < cve.length; ++j) {
                    if (!cvMap.containsKey(cve[j].getValue())) continue;
                    HashMap cveMap = (HashMap)cvMap.get(cve[j].getValue());
                    if (cveMap.containsKey(color)) {
                        cve[j].setPrefColor((Color)cveMap.get(color));
                    }
                    if (!cveMap.containsKey(keyCode)) continue;
                    cve[j].setShortcutKeyCode((Integer)cveMap.get(keyCode));
                }
            }
        }
    }

    public void setPreference(String key, Object value, Object document) {
        if (document instanceof Transcription) {
            Preferences.set(key, value, (Transcription)document, false, false);
        } else {
            Preferences.set(key, value, null, false, false);
        }
    }

    public void preferencesChanged() {
        Object val;
        Locale savedLocale;
        Point p;
        Dimension d = (Dimension)Preferences.get("FrameSize", null);
        Rectangle wRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (d != null) {
            if (d.width > wRect.width) {
                d.setSize(wRect.width, d.height);
            }
            if ((double)d.height > wRect.getHeight()) {
                d.setSize(d.width, wRect.height);
            }
            this.setSize(d);
        }
        if ((p = (Point)Preferences.get("FrameLocation", null)) != null) {
            int mph;
            int mpx = wRect.width - this.getWidth();
            if (p.x > mpx && mpx > wRect.x) {
                p.x = mpx;
            }
            if (p.y > (mph = wRect.height - this.getHeight()) && mph > wRect.y) {
                p.y = mph;
            }
            this.setLocation(p);
        }
        if ((savedLocale = (Locale)Preferences.get("Locale", null)) != null) {
            ElanLocale.setLocale(savedLocale);
        }
        if (this.viewerManager != null && (val = Preferences.get("MediaNavigation.FrameStepToFrameBegin", null)) instanceof Boolean) {
            this.viewerManager.setFrameStepsToBeginOfFrame((Boolean)val);
        }
        val = Preferences.get("PlayAroundSelection.Mode", null);
        boolean msMode = true;
        if (val instanceof String && "frames".equals((String)val)) {
            msMode = false;
        }
        if ((val = Preferences.get("PlayAroundSelection.Value", null)) instanceof Integer && this.transcriptionForThisFrame != null) {
            int playaroundVal = (Integer)val;
            if (!msMode) {
                playaroundVal = (int)((long)playaroundVal * this.viewerManager.getMasterMediaPlayer().getMilliSecondsPerSample());
                ((PlayAroundSelectionCA)ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "CommandActions.PlayAroundSelection")).setPlayAroundSelectionValue(playaroundVal);
            }
        }
        if ((val = Preferences.get("PlaybackRateToggleValue", null)) instanceof Float && this.transcriptionForThisFrame != null) {
            float rate = ((Float)val).floatValue();
            ((PlaybackRateToggleCA)ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "CommandActions.PlaybackRateToggle")).setToggleValue(rate);
        }
        if ((val = Preferences.get("PlaybackVolumeToggleValue", null)) instanceof Float && this.transcriptionForThisFrame != null) {
            float vol = ((Float)val).floatValue();
            ((PlaybackVolumeToggleCA)ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "CommandActions.PlaybackVolumeToggle")).setToggleValue(vol);
        }
        if ((val = Preferences.get("NumberOfBackUpFiles", null)) instanceof Integer && this.transcriptionForThisFrame != null) {
            int nf = (Integer)val;
            ((BackupCA)ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "CommandActions.Backup")).setNumBuFiles(nf);
        }
    }

    public void checkSaveAndClose() {
        if (this.transcriptionForThisFrame != null) {
            if (this.transcriptionForThisFrame.isChanged()) {
                int response = JOptionPane.showConfirmDialog(null, ElanLocale.getString("Frame.ElanFrame.UnsavedData"), ElanLocale.getString("Message.Warning"), 1);
                if (response == 0) {
                    this.saveAndClose(true);
                } else {
                    if (response == 2 || response == -1) {
                        return;
                    }
                    this.doClose(true);
                }
            } else {
                this.doClose(true);
            }
        }
    }

    public void saveAndClose(boolean unregister) {
        if (unregister) {
            FrameManager.getInstance().closeFrame(this);
        }
        if (this.transcriptionForThisFrame != null && this.transcriptionForThisFrame.isChanged()) {
            boolean saveNewCopy = false;
            if (this.transcriptionForThisFrame.getName().equals("aishug294879ryshfda9763afo8947a5gf")) {
                saveNewCopy = true;
            }
            TranscriptionStore ets = ACMTranscriptionStore.getCurrentTranscriptionStore();
            StoreCommand storeComm = new StoreCommand("Commands.Store");
            storeComm.execute(this.transcriptionForThisFrame, new Object[]{ets, new Boolean(false), new Boolean(saveNewCopy), this.viewerManager.getMultiTierControlPanel().getVisibleTiers()});
            if (this.transcriptionForThisFrame.isChanged()) {
                System.out.println("Save (as) cancelled");
                return;
            }
        }
        this.doClose(unregister);
    }

    public void doClose(boolean unregister) {
        if (unregister) {
            FrameManager.getInstance().closeFrame(this);
        }
        this.savePreferences();
        if (this.transcriptionForThisFrame != null) {
            BackupCA ca = (BackupCA)ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "CommandActions.Backup");
            if (ca != null) {
                ca.stopBackUp();
            }
            ELANCommandFactory.removeDocument(this.viewerManager);
            Preferences.removeDocument(this.transcriptionForThisFrame);
            ElanLocale.removeElanLocaleListener(this.transcriptionForThisFrame);
            if (this.viewerManager != null) {
                this.viewerManager.cleanUpOnClose();
            }
            if (this.layoutManager != null) {
                this.layoutManager.cleanUpOnClose();
            }
            this.transcriptionForThisFrame = null;
            this.viewerManager = null;
            this.layoutManager = null;
        }
        this.setJMenuBar(null);
        this.menuBar = null;
        this.dispose();
        System.runFinalization();
        System.gc();
    }

    public void addActionToMenu(Action action, int menuId, int index) {
        if (action == null) {
            return;
        }
        JMenuItem mm = this.getMenuById(menuId);
        if (mm instanceof JMenu) {
            JMenu menu = (JMenu)mm;
            if (menu == this.menuWindow) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
                menu.add((Component)item, index);
                this.windowsGroup.add(item);
            } else if (menu == this.menuMediaPlayer) {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
                menu.add((Component)item, index);
            } else {
                JMenuItem item = new JMenuItem(action);
                menu.add((Component)item, index);
            }
        }
    }

    public Action removeActionFromMenu(String actionId, int menuId) {
        if (actionId == null) {
            return null;
        }
        JMenuItem mm = this.getMenuById(menuId);
        if (mm instanceof JMenu) {
            JMenu menu = (JMenu)mm;
            for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
                JMenuItem item;
                Action ac;
                Component mi = menu.getMenuComponent(i);
                if (!(mi instanceof JMenuItem) || (ac = (item = (JMenuItem)mi).getAction()) == null || !actionId.equals(ac.getValue("LongDescription"))) continue;
                menu.remove(item);
                if (menu == this.menuWindow) {
                    this.windowsGroup.remove(item);
                }
                return ac;
            }
        }
        return null;
    }

    public void setMenuSelected(String actionId, int menuId) {
        if (actionId == null) {
            return;
        }
        JMenuItem mm = this.getMenuById(menuId);
        if (mm instanceof JMenu) {
            JMenu menu = (JMenu)mm;
            for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
                JCheckBoxMenuItem chItem;
                Action ac;
                Component mi = menu.getMenuComponent(i);
                if (mi instanceof JRadioButtonMenuItem) {
                    JRadioButtonMenuItem item = (JRadioButtonMenuItem)mi;
                    ac = item.getAction();
                    if (ac == null || !actionId.equals(ac.getValue("LongDescription"))) continue;
                    item.setSelected(true);
                    continue;
                }
                if (!(mi instanceof JCheckBoxMenuItem) || (ac = (chItem = (JCheckBoxMenuItem)mi).getAction()) == null || !actionId.equals(ac.getValue("LongDescription"))) continue;
                chItem.setSelected(true);
            }
        }
    }

    public void setMenuEnabled(int menuId, boolean enabled) {
        JMenuItem menu = this.getMenuById(menuId);
        if (menu != null) {
            menu.setEnabled(enabled);
        }
    }

    public void updateMenu(int menuId) {
        if (menuId == 610) {
            this.pvMenuManager.reinitializePlayerMenu();
        }
    }

    public void enableCommands(boolean enable) {
        ActionMap menuMap = this.menuBar.getActionMap();
        if (menuMap != null) {
            for (Object key : this.registeredActions.keySet()) {
                ((Action)this.registeredActions.get(key)).setEnabled(enable);
            }
        }
    }

    private JMenuItem getMenuById(int id) {
        switch (id) {
            case 0: {
                return this.menuFile;
            }
            case 100: {
                return this.menuEdit;
            }
            case 200: {
                return this.menuAnnotation;
            }
            case 300: {
                return this.menuTier;
            }
            case 400: {
                return this.menuType;
            }
            case 500: {
                return this.menuSearch;
            }
            case 600: {
                return this.menuView;
            }
            case 700: {
                return this.menuOptions;
            }
            case 800: {
                return this.menuWindow;
            }
            case 900: {
                return this.menuHelp;
            }
            case 11: {
                return this.menuRecentFiles;
            }
            case 12: {
                return this.menuExport;
            }
            case 13: {
                return this.menuImport;
            }
            case 760: {
                return this.menuAppLanguage;
            }
            case 701: {
                return this.menuChangeTimePropMode;
            }
            case 740: {
                return this.menuFrameLength;
            }
            case 710: {
                return this.menuItemAnnoMode;
            }
            case 711: {
                return this.menuItemSyncMode;
            }
            case 712: {
                return this.menuItemKioskMode;
            }
            case 713: {
                return this.menuItemPlayAround;
            }
            case 714: {
                return this.menuItemRateVol;
            }
            case 610: {
                return this.menuMediaPlayer;
            }
        }
        return null;
    }

    public boolean isFullyInitialized() {
        return this.fullyInitialized;
    }

    public static void main(String[] arg) {
        System.out.println("Java version: " + System.getProperty("java.version"));
        System.out.println("Runtime version: " + System.getProperty("java.runtime.version"));
        SystemInstallationSecurity.Instance().go();
        FrameManager.getInstance().setExitAllowed(true);
        File dataDir = new File(Constants.ELAN_DATA_DIR);
        if (!dataDir.exists()) {
            dataDir.mkdir();
        }
        File oldCrap = new File(Constants.STRPROPERTIESFILE);
        oldCrap.delete();
        oldCrap = new File(Constants.USERHOME + Constants.FILESEPARATOR + ".elan.pfs");
        oldCrap.delete();
        if (arg != null && arg.length > 0 && arg[0].length() != 0) {
            FrameManager.getInstance().createFrame(arg[0]);
        } else {
            FrameManager.getInstance().createEmptyFrame();
        }
        ExternalLauncher.start();
    }

    private void switchMacLF() {
        if (this.menuMacNativeLF != null) {
            if (this.menuMacNativeLF.getState()) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI(this);
                    Preferences.set("UseMacLF", new Boolean(true), null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI(this);
                    Preferences.set("UseMacLF", new Boolean(false), null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void macHandleQuit() {
        FrameManager.getInstance().exit();
    }

    public void macHandleAbout() {
        if (this.menuActions != null) {
            MenuAction ma = null;
            for (int i = 0; i < this.menuActions.size(); ++i) {
                ma = (MenuAction)this.menuActions.get(i);
                if (!(ma instanceof AboutMA)) continue;
                ma.actionPerformed(null);
                break;
            }
        }
    }

    public void macHandlePreferences() {
        MenuAction ma = null;
        if (this.menuActions != null) {
            for (int i = 0; i < this.menuActions.size(); ++i) {
                ma = (MenuAction)this.menuActions.get(i);
                if (!(ma instanceof EditPreferencesMA)) continue;
                ma.actionPerformed(null);
                break;
            }
        }
        if (!(ma instanceof EditPreferencesMA)) {
            EditPreferencesMA ma2 = new EditPreferencesMA("Menu.Edit.Preferences.Edit", this);
            ((MenuAction)ma2).actionPerformed(null);
        }
    }

    public void finalize() throws Throwable {
        System.out.println("Finalize ELAN window...");
        super.finalize();
    }

    public void createSubtitleViewer() {
        int numSubtitles = 4;
        Object val = Preferences.get("NumberOfSubtitleViewers", null);
        if (val instanceof Integer) {
            numSubtitles = (Integer)val;
        }
        for (int i = 0; i < numSubtitles; ++i) {
            SubtitleViewer subtitleViewer = this.viewerManager.createSubtitleViewer();
            subtitleViewer.setViewerIndex(i + 1);
            this.layoutManager.add(subtitleViewer);
        }
    }

    public boolean isIntialized() {
        return this.initialized;
    }

    static {
        if (System.getProperty("os.name").indexOf("Mac") > -1) {
            JTextComponent.KeyBinding[] bind = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "copy-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "cut-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "paste-from-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "select-all")};
            JTextField comp = new JTextField();
            Keymap map = JTextComponent.getKeymap("default");
            JTextComponent.loadKeymap(map, bind, ((JTextComponent)comp).getActions());
        }
    }

    private class ElanFrameWindowListener
    extends WindowAdapter {
        private ElanFrameWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            if (ElanFrame2.this.transcriptionForThisFrame != null) {
                ElanFrame2.this.checkSaveAndClose();
            } else {
                ElanFrame2.this.doClose(true);
            }
        }

        public void windowActivated(WindowEvent e) {
            FrameManager.getInstance().frameActivated(ElanFrame2.this);
        }
    }
}

