/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.DetachedFrame;
import mpi.eudico.client.annotator.DetachedViewerFrame;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesUser;
import mpi.eudico.client.annotator.SyncManager;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.grid.GridViewer;
import mpi.eudico.client.annotator.gui.ResizeComponent;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.player.CocoaQTMediaPlayer;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.annotator.player.QTMediaPlayer;
import mpi.eudico.client.annotator.player.SyncPlayer;
import mpi.eudico.client.annotator.recognizer.gui.AudioRecognizerPanel;
import mpi.eudico.client.annotator.recognizer.gui.VideoRecognizerPanel;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.InterlinearViewer;
import mpi.eudico.client.annotator.viewer.LexiconEntryViewer;
import mpi.eudico.client.annotator.viewer.MetadataViewer;
import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewerPanel;
import mpi.eudico.client.annotator.viewer.SubtitleViewer;
import mpi.eudico.client.annotator.viewer.TextViewer;
import mpi.eudico.client.annotator.viewer.TimeLineViewer;
import mpi.eudico.client.annotator.viewer.TimeSeriesViewer;
import mpi.eudico.p2p.CollaborationPanel;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class ElanLayoutManager
implements ElanLocaleListener,
ChangeListener,
PreferencesUser {
    public static final int SYNC_MODE = 0;
    public static final int NORMAL_MODE = 1;
    public static final int MASTER_MEDIA_WIDTH = 352;
    public static final int MASTER_MEDIA_HEIGHT = 250;
    private final int MIN_MEDIA_HEIGHT = 40;
    public static final int CONTROL_PANEL_WIDTH = 120;
    private static final int CONTAINER_MARGIN = 3;
    private static final int DEF_SIGNAL_HEIGHT = 70;
    private ElanFrame2 elanFrame;
    private Container container;
    private ViewerManager2 viewerManager;
    private int mode;
    private int mediaAreaHeight = 250;
    private int multiTierControlPanelWidth = 120;
    private boolean showTimeLineViewer;
    private boolean showInterlinearViewer;
    private boolean permanentDetached;
    private ElanMediaPlayer masterMediaPlayer;
    private List playerList;
    private List viewerList;
    private ElanMediaPlayerController mediaPlayerController;
    private SyncManager syncManager;
    private SignalViewer signalViewer;
    private JComponent signalComponent;
    private TimeLineViewer timeLineViewer;
    private InterlinearViewer interlinearViewer;
    private TimeSeriesViewer timeseriesViewer;
    private JComponent timeseriesComponent;
    private JSplitPane wav_tsSplitPane;
    private JPanel timeLineComponent;
    private MultiTierControlPanel multiTierControlPanel;
    private JSplitPane timeLineSplitPane;
    private ResizeComponent vertMediaResizer;
    private JTabbedPane tabPane;
    private JTabbedPane leftTabPane;
    private JPanel gridPanel;
    private JPanel textPanel;
    private JPanel subtitlePanel;
    private JComponent lexiconPanel;
    private JComponent audioRecognizerPanel;
    private JComponent videoRecognizerPanel;
    private JPanel controlPanel;
    private JComponent metadataPanel;
    private boolean mediaInCentre = false;
    private boolean gridViewerLeft;
    private boolean textViewerLeft;
    private boolean subtitleViewerLeft;
    private boolean lexiconViewerLeft;
    private boolean audioRecognizerLeft;
    private boolean videoRecognizerLeft;
    private boolean metaDataLeft;
    private List<String> viewerSortOrder;
    private List<String> availableViewersList;
    private boolean oneRowForVisuals = false;
    private boolean preferenceChanged = false;
    private int minTabWidth = 150;
    private int numOfPlayers;

    public ElanLayoutManager(ElanFrame2 elanFrame, ViewerManager2 viewerManager) {
        this.elanFrame = elanFrame;
        this.container = elanFrame.getContentPane();
        this.viewerManager = viewerManager;
        this.playerList = new ArrayList(8);
        this.viewerList = new ArrayList(2);
        ElanLocale.addElanLocaleListener(viewerManager.getTranscription(), this);
        this.container.setLayout(null);
        this.container.addComponentListener(new ContainerComponentListener());
        this.mode = 1;
        this.showTimeLineViewer = true;
        this.viewerSortOrder = new ArrayList<String>();
        this.availableViewersList = new ArrayList<String>();
        this.availableViewersList.add("Menu.View.Viewers.Grid");
        this.availableViewersList.add("Menu.View.Viewers.Text");
        this.availableViewersList.add("Menu.View.Viewers.Subtitles");
        this.availableViewersList.add("LexiconEntryViewer.Lexicon");
        this.availableViewersList.add("Menu.View.Viewers.Audio");
        this.availableViewersList.add("Menu.View.Viewers.Video");
        this.availableViewersList.add("Menu.View.Viewers.MetaData");
        this.availableViewersList.add("Menu.View.Viewers.Signal");
        this.availableViewersList.add("Menu.View.Viewers.InterLinear");
        this.controlPanel = new JPanel();
        this.controlPanel.setName(ElanLocale.getString("Tab.Controls"));
        this.controlPanel.setLayout(new GridLayout(2, 1, 10, 10));
        this.controlPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.syncManager = new SyncManager(viewerManager, this);
        this.vertMediaResizer = new ResizeComponent(this, 1);
        this.container.add(this.vertMediaResizer);
        Boolean permDetached = (Boolean)Preferences.get("PreferredMediaWindow", null);
        if (permDetached == null) {
            permDetached = new Boolean(false);
        }
        this.permanentDetached = permDetached;
        if (!System.getProperty("os.name").startsWith("Mac OS")) {
            this.permanentDetached = false;
        }
    }

    public void updateLocale() {
        if (this.tabPane != null) {
            int nTabs = this.tabPane.getTabCount();
            for (int i = 0; i < nTabs; ++i) {
                Component component = this.tabPane.getComponentAt(i);
                if (component == this.gridPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Grid"));
                    continue;
                }
                if (component == this.textPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Text"));
                    continue;
                }
                if (component == this.subtitlePanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Subtitles"));
                    continue;
                }
                if (component == this.controlPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Controls"));
                    continue;
                }
                if (component == this.audioRecognizerPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.AudioRecognizer"));
                    continue;
                }
                if (component == this.videoRecognizerPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.VideoRecognizer"));
                    continue;
                }
                if (component != this.metadataPanel) continue;
                this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Metadata"));
            }
        }
        if (this.syncManager != null) {
            this.syncManager.updateLocale();
            if (this.mode == 0) {
                this.doLayout();
            }
        }
    }

    public void add(Object object) {
        if (object instanceof ElanMediaPlayer) {
            this.addMediaPlayer((ElanMediaPlayer)object);
        } else if (object instanceof ElanMediaPlayerController) {
            this.setMediaPlayerController((ElanMediaPlayerController)object);
        } else if (object instanceof SignalViewer && this.availableViewersList.contains("Menu.View.Viewers.Signal")) {
            this.setSignalViewer((SignalViewer)object);
        } else if (object instanceof TimeLineViewer) {
            this.setTimeLineViewer((TimeLineViewer)object);
        } else if (object instanceof InterlinearViewer && this.availableViewersList.contains("Menu.View.Viewers.InterLinear")) {
            this.setInterlinearViewer((InterlinearViewer)object);
        } else if (object instanceof GridViewer && this.availableViewersList.contains("Menu.View.Viewers.Grid")) {
            this.addSingleTierViewer((SingleTierViewer)object);
        } else if (object instanceof TextViewer && this.availableViewersList.contains("Menu.View.Viewers.Text")) {
            this.addSingleTierViewer((SingleTierViewer)object);
        } else if (object instanceof SubtitleViewer && this.availableViewersList.contains("Menu.View.Viewers.Subtitles")) {
            this.addSingleTierViewer((SingleTierViewer)object);
        } else if (object instanceof CollaborationPanel) {
            this.addToTabPane("P2P", (Component)object);
        } else if (object instanceof TimeSeriesViewer) {
            this.setTimeSeriesViewer((TimeSeriesViewer)object);
        } else if (object instanceof AudioRecognizerPanel && this.availableViewersList.contains("Menu.View.Viewers.Audio")) {
            this.audioRecognizerPanel = (JComponent)object;
            this.addToTabPane(ElanLocale.getString("Tab.AudioRecognizer"), this.audioRecognizerPanel);
        } else if (object instanceof VideoRecognizerPanel && this.availableViewersList.contains("Menu.View.Viewers.Video")) {
            this.videoRecognizerPanel = (JComponent)object;
            this.addToTabPane(ElanLocale.getString("Tab.VideoRecognizer"), this.videoRecognizerPanel);
        } else if (object instanceof MetadataViewer && this.availableViewersList.contains("Menu.View.Viewers.MetaData")) {
            this.metadataPanel = (JComponent)object;
            this.addToTabPane(ElanLocale.getString("Tab.Metadata"), (MetadataViewer)object);
        } else if (object instanceof LexiconEntryViewer) {
            this.lexiconPanel = (JComponent)object;
            this.addToTabPane(ElanLocale.getString("LexiconEntryViewer.Lexicon"), (Component)object);
        }
    }

    public void remove(Object object) {
        if (object instanceof ElanMediaPlayer) {
            this.removeMediaPlayer((ElanMediaPlayer)object);
        } else if (object instanceof SignalViewer) {
            this.removeSignalViewer();
        } else if (object instanceof TimeSeriesViewer) {
            this.removeTimeSeriesViewer();
        } else if (object instanceof CollaborationPanel) {
            this.removeFromTabPane((Component)object);
        } else if (object instanceof AudioRecognizerPanel) {
            this.removeFromTabPane((Component)object);
        } else if (object instanceof VideoRecognizerPanel) {
            this.removeFromTabPane((Component)object);
        } else if (object instanceof MetadataViewer) {
            this.removeFromTabPane((Component)object);
        } else if (object instanceof GridViewer) {
            this.removeFromTabPane(this.gridPanel);
        } else if (object instanceof TextViewer) {
            this.removeFromTabPane(this.textPanel);
        } else if (object instanceof SubtitleViewer) {
            this.removeFromTabPane(this.subtitlePanel);
            this.subtitlePanel = null;
        } else if (object instanceof LexiconEntryViewer) {
            this.removeFromTabPane((Component)object);
        }
    }

    public void destroyViewer(Object object) {
        this.remove(object);
        if (object instanceof AudioRecognizerPanel) {
            this.audioRecognizerPanel = null;
        } else if (object instanceof VideoRecognizerPanel) {
            this.videoRecognizerPanel = null;
        } else if (object instanceof MetadataViewer) {
            this.metadataPanel = null;
        } else if (object instanceof GridViewer) {
            this.gridPanel = null;
        } else if (object instanceof TextViewer) {
            this.textPanel = null;
        } else if (object instanceof SubtitleViewer) {
            this.subtitlePanel = null;
        } else if (object instanceof InterlinearViewer) {
            this.showTimeLineViewer();
            this.interlinearViewer = null;
        } else if (object instanceof LexiconEntryViewer) {
            this.lexiconPanel = null;
        }
    }

    public void hide(Object object) {
    }

    public ElanMediaPlayer getMasterMediaPlayer() {
        return this.masterMediaPlayer;
    }

    private void addMediaPlayer(ElanMediaPlayer player) {
        Object ar;
        if (player == null) {
            return;
        }
        if (player instanceof SyncPlayer) {
            player.setLayoutManager(this);
            PlayerLayoutModel plModel = new PlayerLayoutModel(player);
            plModel.syncOnly = true;
            this.playerList.add(plModel);
            this.syncManager.add(player);
            this.container.add(this.syncManager.getPlayerLabel(player));
            if (this.mode == 0) {
                this.doLayout();
            }
            return;
        }
        player.setLayoutManager(this);
        PlayerLayoutModel plModel = new PlayerLayoutModel(player);
        this.playerList.add(plModel);
        if (this.permanentDetached) {
            plModel.detach();
        }
        int nextIndex = this.playerList.size();
        this.syncManager.add(player);
        this.container.add(this.syncManager.getPlayerLabel(player));
        if (plModel.isVisual() && plModel.isAttached()) {
            this.container.add(plModel.visualComponent);
        }
        if (!this.containsComponent(this.syncManager.getPlayerSelectionPanel())) {
            this.container.add(this.syncManager.getPlayerSelectionPanel());
        }
        if (nextIndex == 1) {
            this.masterMediaPlayer = player;
        }
        if (player.getMediaDescriptor() != null && (ar = Preferences.get("AspectRatio(" + player.getMediaDescriptor().mediaURL + ")", this.viewerManager.getTranscription())) instanceof Float) {
            player.setAspectRatio(((Float)ar).floatValue());
        }
        if (player.getAspectRatio() == -1.0f) {
            plModel.visualComponent.setBounds(0, 0, 1, 1);
            plModel.visualComponent = null;
        }
        this.doLayout();
    }

    private void removeMediaPlayer(ElanMediaPlayer player) {
        if (player == null) {
            return;
        }
        PlayerLayoutModel plModel = null;
        int index = -1;
        for (int i = 0; i < this.playerList.size(); ++i) {
            plModel = (PlayerLayoutModel)this.playerList.get(i);
            if (plModel.player != player) continue;
            index = i;
            break;
        }
        if (plModel == null) {
            return;
        }
        if (player instanceof SyncPlayer) {
            if (this.playerList.remove(plModel)) {
                this.container.remove(this.syncManager.getPlayerLabel(plModel.player));
                if (plModel.player.getVisualComponent() != null) {
                    this.container.remove(plModel.player.getVisualComponent());
                }
                this.syncManager.remove(plModel.player);
                if (this.mode == 0) {
                    this.doLayout();
                }
            }
            return;
        }
        this.container.remove(this.syncManager.getPlayerLabel(plModel.player));
        this.syncManager.remove(plModel.player);
        if (plModel.isVisual()) {
            if (plModel.isAttached()) {
                this.container.remove(plModel.visualComponent);
            } else {
                plModel.attach();
            }
        }
        this.playerList.remove(plModel);
        if (index == 0 && this.playerList.size() > 0) {
            PlayerLayoutModel model = (PlayerLayoutModel)this.playerList.get(0);
            this.masterMediaPlayer = model.player;
        }
        if (this.playerList.size() == 0) {
            this.container.remove(this.syncManager.getPlayerSelectionPanel());
        }
        this.doLayout();
    }

    public void detach(Object object) {
        block10: {
            block9: {
                if (!(object instanceof AbstractViewer)) break block9;
                this.container.remove((Component)object);
                if (!(object instanceof TimeSeriesViewer)) break block10;
                ViewerLayoutModel vlm = null;
                for (int i = 0; i < this.viewerList.size(); ++i) {
                    vlm = (ViewerLayoutModel)this.viewerList.get(i);
                    if (vlm.viewer == object) break;
                    vlm = null;
                }
                if (vlm == null) {
                    return;
                }
                if (this.wav_tsSplitPane != null) {
                    int curHeight = this.getTimeLineSplitPane().getDividerLocation();
                    this.wav_tsSplitPane.setTopComponent(null);
                    this.wav_tsSplitPane.setBottomComponent(null);
                    this.timeseriesComponent.remove(this.timeseriesViewer);
                    this.timeseriesComponent = null;
                    this.wav_tsSplitPane = null;
                    if (this.signalComponent != null) {
                        this.getTimeLineSplitPane().setTopComponent(this.signalComponent);
                        this.getTimeLineSplitPane().setDividerLocation(curHeight);
                        this.signalComponent.setSize(this.signalComponent.getWidth(), curHeight);
                    } else {
                        this.getTimeLineSplitPane().setTopComponent(null);
                    }
                } else {
                    this.getTimeLineSplitPane().setTopComponent(null);
                    if (this.timeseriesComponent != null) {
                        this.timeseriesComponent.remove(this.timeseriesViewer);
                        this.timeseriesComponent = null;
                    }
                }
                this.doLayout();
                vlm.detach();
                break block10;
            }
            if (object instanceof Component) {
                for (int i = 0; i < this.playerList.size(); ++i) {
                    PlayerLayoutModel model = (PlayerLayoutModel)this.playerList.get(i);
                    if (model.visualComponent != object) continue;
                    if (!model.isVisual() || !model.isAttached()) break;
                    this.container.remove(model.visualComponent);
                    model.detach();
                    this.doLayout();
                    break;
                }
            }
        }
    }

    public void attach(Object object) {
        block8: {
            block7: {
                if (!(object instanceof AbstractViewer)) break block7;
                ViewerLayoutModel vlm = null;
                for (int i = 0; i < this.viewerList.size(); ++i) {
                    vlm = (ViewerLayoutModel)this.viewerList.get(i);
                    if (vlm.viewer == object) break;
                    vlm = null;
                }
                if (vlm == null) {
                    return;
                }
                vlm.attach();
                if (!(vlm.viewer instanceof TimeSeriesViewer)) break block8;
                this.setTimeSeriesViewer((TimeSeriesViewer)vlm.viewer);
                break block8;
            }
            if (object instanceof Component) {
                for (int i = 0; i < this.playerList.size(); ++i) {
                    PlayerLayoutModel model = (PlayerLayoutModel)this.playerList.get(i);
                    if (model.visualComponent != object) continue;
                    if (!model.isVisual() || model.isAttached()) break;
                    ActionMap aMap = model.detachedFrame.getJMenuBar().getActionMap();
                    InputMap iMap = model.detachedFrame.getJMenuBar().getInputMap(0);
                    model.attach();
                    this.container.add(model.visualComponent);
                    this.doLayout();
                    if (model.player instanceof QTMediaPlayer) {
                        this.getElanFrame().getJMenuBar().setInputMap(2, iMap);
                        this.getElanFrame().getJMenuBar().setActionMap(aMap);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        Rectangle rec = model.visualComponent.getBounds();
                        model.visualComponent.setBounds(new Rectangle(rec.x, rec.y, rec.width - 1, rec.height - 1));
                        this.container.validate();
                    }
                    if (!(model.player instanceof CocoaQTMediaPlayer)) break;
                    this.getElanFrame().getJMenuBar().setInputMap(2, iMap);
                    this.getElanFrame().getJMenuBar().setActionMap(aMap);
                    break;
                }
            }
        }
    }

    public void setFirstPlayer(ElanMediaPlayer player) {
        if (player == null) {
            return;
        }
        for (int i = 0; i < this.playerList.size(); ++i) {
            PlayerLayoutModel model = (PlayerLayoutModel)this.playerList.get(i);
            if (model.player == player) {
                model.setDisplayedFirst(true);
                continue;
            }
            model.setDisplayedFirst(false);
        }
        this.doLayout();
    }

    private void setMediaPlayerController(ElanMediaPlayerController mediaPlayerController) {
        this.mediaPlayerController = mediaPlayerController;
        this.container.add(mediaPlayerController.getPlayButtonsPanel());
        this.container.add(mediaPlayerController.getTimePanel());
        this.container.add(mediaPlayerController.getModePanel());
        this.container.add(mediaPlayerController.getSelectionPanel());
        this.container.add(mediaPlayerController.getSelectionButtonsPanel());
        this.container.add(mediaPlayerController.getAnnotationNavigationPanel());
        this.container.add(mediaPlayerController.getSliderPanel());
        this.container.add(mediaPlayerController.getAnnotationDensityViewer());
        mediaPlayerController.getSliderPanel().addMouseListener(mediaPlayerController.getAnnotationDensityViewer());
        this.controlPanel.add(mediaPlayerController.getVolumePanel());
        this.controlPanel.add(mediaPlayerController.getRatePanel());
        this.addToTabPane(ElanLocale.getString("Tab.Controls"), this.controlPanel);
        this.doLayout();
    }

    private void setSignalViewer(SignalViewer signalViewer) {
        this.signalViewer = signalViewer;
        if (this.timeseriesViewer == null) {
            if (this.signalComponent == null) {
                this.signalComponent = new JPanel();
                this.signalComponent.setLayout(null);
                this.signalComponent.addComponentListener(new SignalSplitPaneListener());
            }
            this.signalComponent.add(signalViewer);
            this.getTimeLineSplitPane().setTopComponent(this.signalComponent);
            int divLoc = this.signalComponent.getHeight() < 70 ? 70 : this.signalComponent.getHeight();
            this.timeLineSplitPane.setDividerLocation(divLoc);
        } else {
            int curHeight = this.timeseriesComponent.getHeight();
            this.getTimeLineSplitPane().setTopComponent(null);
            this.signalComponent = new JPanel();
            this.signalComponent.setLayout(null);
            this.signalComponent.add(signalViewer);
            this.wav_tsSplitPane = this.getWav_TSSplitPane();
            this.wav_tsSplitPane.setTopComponent(this.timeseriesComponent);
            this.wav_tsSplitPane.setBottomComponent(this.signalComponent);
            this.wav_tsSplitPane.setDividerLocation(curHeight / 2);
            this.getTimeLineSplitPane().setTopComponent(this.wav_tsSplitPane);
            this.timeLineComponent.addComponentListener(new SignalSplitPaneListener());
            this.getTimeLineSplitPane().setDividerLocation(curHeight);
            Integer divLoc = (Integer)Preferences.get("LayoutManager.TSWavSplitPaneDividerLocation", this.viewerManager.getTranscription());
            if (divLoc != null && this.wav_tsSplitPane != null) {
                this.wav_tsSplitPane.setDividerLocation(divLoc);
            }
        }
        this.doLayout();
    }

    public SignalViewer getSignalViewer() {
        return this.signalViewer;
    }

    public TimeLineViewer getTimeLineViewer() {
        return this.timeLineViewer;
    }

    public InterlinearViewer getInterlinearViewer() {
        return this.interlinearViewer;
    }

    private void removeSignalViewer() {
        if (this.signalViewer != null && this.signalComponent != null) {
            if (this.wav_tsSplitPane != null && this.wav_tsSplitPane.getBottomComponent() == this.signalComponent) {
                Component topComp = this.wav_tsSplitPane.getTopComponent();
                this.wav_tsSplitPane.setTopComponent(null);
                this.wav_tsSplitPane.setBottomComponent(null);
                this.getTimeLineSplitPane().setTopComponent(topComp);
                this.signalComponent.remove(this.signalViewer);
                this.signalViewer = null;
                this.signalComponent = null;
                this.doLayout();
            } else {
                this.signalComponent.remove(this.signalViewer);
                this.getTimeLineSplitPane().setTopComponent(null);
                this.doLayout();
                this.signalViewer = null;
                this.signalComponent = null;
            }
        }
    }

    private void removeTimeSeriesViewer() {
        if (this.timeseriesViewer != null) {
            ViewerLayoutModel vlm = null;
            for (int i = 0; i < this.viewerList.size(); ++i) {
                vlm = (ViewerLayoutModel)this.viewerList.get(i);
                if (vlm.viewer == this.timeseriesViewer) break;
                vlm = null;
            }
            if (vlm == null) {
                return;
            }
            if (vlm.isAttached()) {
                if (this.wav_tsSplitPane != null) {
                    int curHeight = this.getTimeLineSplitPane().getDividerLocation();
                    this.wav_tsSplitPane.setTopComponent(null);
                    this.wav_tsSplitPane.setBottomComponent(null);
                    this.timeseriesComponent.remove(this.timeseriesViewer);
                    this.timeseriesComponent = null;
                    this.wav_tsSplitPane = null;
                    if (this.signalComponent != null) {
                        this.getTimeLineSplitPane().setTopComponent(this.signalComponent);
                        this.getTimeLineSplitPane().setDividerLocation(curHeight);
                        this.signalComponent.setSize(this.signalComponent.getWidth(), curHeight);
                    } else {
                        this.getTimeLineSplitPane().setTopComponent(null);
                    }
                } else {
                    this.getTimeLineSplitPane().setTopComponent(null);
                    if (this.timeseriesComponent != null) {
                        this.timeseriesComponent.remove(this.timeseriesViewer);
                        this.timeseriesComponent = null;
                    }
                }
                this.timeseriesViewer = null;
                this.doLayout();
            } else {
                vlm.attach();
                this.viewerList.remove(vlm);
                if (this.timeseriesComponent != null) {
                    this.timeseriesComponent.remove(vlm.viewer);
                    this.timeseriesComponent = null;
                }
                this.timeseriesViewer = null;
            }
        }
    }

    private void setTimeLineViewer(TimeLineViewer timeLineViewer) {
        this.timeLineViewer = timeLineViewer;
        if (this.timeLineComponent == null) {
            this.timeLineComponent = new JPanel();
            this.timeLineComponent.setLayout(null);
        }
        if (this.multiTierControlPanel == null) {
            this.multiTierControlPanel = this.viewerManager.getMultiTierControlPanel();
            this.multiTierControlPanel.setSize(120, 120);
            ResizeComponent mcpResize = new ResizeComponent(this, 0, 1);
            mcpResize.setSize(8, 16);
            this.multiTierControlPanel.setResizeComponent(mcpResize);
            this.timeLineComponent.add(this.multiTierControlPanel);
        }
        if (this.interlinearViewer != null) {
            this.viewerManager.disableViewer(this.interlinearViewer);
        }
        this.timeLineComponent.add(timeLineViewer);
        this.getTimeLineSplitPane().setBottomComponent(this.timeLineComponent);
        if (this.getTimeLineSplitPane().getTopComponent() != null) {
            this.getTimeLineSplitPane().setDividerLocation(70);
        }
        this.doLayout();
    }

    private void setInterlinearViewer(InterlinearViewer interlinearViewer) {
        this.interlinearViewer = interlinearViewer;
        if (this.timeLineComponent == null) {
            this.timeLineComponent = new JPanel();
            this.timeLineComponent.setLayout(null);
        }
        if (this.multiTierControlPanel == null) {
            this.multiTierControlPanel = this.viewerManager.getMultiTierControlPanel();
            this.multiTierControlPanel.setSize(120, 120);
            ResizeComponent mcpResize = new ResizeComponent(this, 0, 1);
            mcpResize.setSize(8, 16);
            this.multiTierControlPanel.setResizeComponent(mcpResize);
            this.timeLineComponent.add(this.multiTierControlPanel);
        }
        if (this.timeLineViewer != null) {
            this.viewerManager.disableViewer(this.timeLineViewer);
        }
        this.timeLineComponent.add(interlinearViewer);
        this.getTimeLineSplitPane().setBottomComponent(this.timeLineComponent);
        this.doLayout();
    }

    private void setTimeSeriesViewer(TimeSeriesViewer timeseriesViewer) {
        if (this.timeseriesViewer == null) {
            this.timeseriesViewer = timeseriesViewer;
            ViewerLayoutModel vlm = new ViewerLayoutModel(timeseriesViewer);
            this.viewerList.add(vlm);
            boolean detached = false;
            Boolean detObj = (Boolean)Preferences.get("TimeSeriesViewer.Detached", this.viewerManager.getTranscription());
            if (detObj != null) {
                detached = detObj;
            }
            if (detached) {
                vlm.detach();
                timeseriesViewer.setAttached(false);
                return;
            }
        }
        if (this.signalViewer == null) {
            this.timeseriesComponent = new JPanel();
            this.timeseriesComponent.setLayout(null);
            this.timeseriesComponent.addComponentListener(new SignalSplitPaneListener());
            this.timeseriesComponent.add(timeseriesViewer);
            this.getTimeLineSplitPane().setTopComponent(this.timeseriesComponent);
            int divLoc = this.timeseriesComponent.getHeight() < 70 ? 70 : this.timeseriesComponent.getHeight();
            this.timeLineSplitPane.setDividerLocation(divLoc);
            timeseriesViewer.setAttached(true);
            if (this.multiTierControlPanel != null) {
                timeseriesViewer.setVerticalRulerWidth(this.multiTierControlPanel.getWidth());
            }
        } else {
            Integer divLoc;
            ComponentListener[] cListeners = this.signalComponent.getComponentListeners();
            for (int i = 0; i < cListeners.length; ++i) {
                if (!(cListeners[i] instanceof SignalSplitPaneListener)) continue;
                this.signalComponent.removeComponentListener(cListeners[i]);
            }
            int curHeight = this.getTimeLineSplitPane().getDividerLocation();
            this.timeseriesComponent = new JPanel();
            this.timeseriesComponent.setLayout(null);
            this.timeseriesComponent.add(timeseriesViewer);
            this.getTimeLineSplitPane().setTopComponent(null);
            this.wav_tsSplitPane = this.getWav_TSSplitPane();
            this.wav_tsSplitPane.setTopComponent(this.timeseriesComponent);
            this.wav_tsSplitPane.setBottomComponent(this.signalComponent);
            this.wav_tsSplitPane.setDividerLocation(curHeight / 2);
            this.getTimeLineSplitPane().setTopComponent(this.wav_tsSplitPane);
            this.getTimeLineSplitPane().setDividerLocation(curHeight);
            this.timeseriesComponent.addComponentListener(new SignalSplitPaneListener());
            this.timeLineComponent.addComponentListener(new SignalSplitPaneListener());
            timeseriesViewer.setAttached(true);
            if (this.multiTierControlPanel != null) {
                timeseriesViewer.setVerticalRulerWidth(this.multiTierControlPanel.getWidth());
                timeseriesViewer.setBounds(this.timeseriesComponent.getBounds());
            }
            if ((divLoc = (Integer)Preferences.get("LayoutManager.TSWavSplitPaneDividerLocation", this.viewerManager.getTranscription())) != null && this.wav_tsSplitPane != null && divLoc < curHeight - 20) {
                this.wav_tsSplitPane.setDividerLocation(divLoc);
            }
        }
        this.doLayout();
    }

    public TimeSeriesViewer getTimeSeriesViewer() {
        return this.timeseriesViewer;
    }

    public MultiTierControlPanel getMultiTierControlPanel() {
        return this.multiTierControlPanel;
    }

    public MultiTierViewer getVisibleMultiTierViewer() {
        if (this.showTimeLineViewer) {
            return this.timeLineViewer;
        }
        return this.interlinearViewer;
    }

    public void showTimeLineViewer() {
        this.showTimeLineViewer = true;
        this.showInterlinearViewer = false;
        this.enableDisableLogic();
        this.doLayout();
    }

    public void showInterlinearViewer() {
        this.showTimeLineViewer = false;
        this.showInterlinearViewer = true;
        this.enableDisableLogic();
        this.doLayout();
    }

    private void enableDisableLogic() {
        if (this.showTimeLineViewer) {
            if (this.timeLineViewer != null) {
                this.viewerManager.enableViewer(this.timeLineViewer);
            }
            if (this.interlinearViewer != null) {
                this.viewerManager.disableViewer(this.interlinearViewer);
            }
            this.setPreference("LayoutManager.VisibleMultiTierViewer", TimeLineViewer.class.getName(), this.viewerManager.getTranscription());
            this.timeLineViewer.preferencesChanged();
        } else if (this.showInterlinearViewer) {
            if (this.timeLineViewer != null) {
                this.viewerManager.disableViewer(this.timeLineViewer);
            }
            if (this.interlinearViewer != null) {
                this.viewerManager.enableViewer(this.interlinearViewer);
            }
            this.setPreference("LayoutManager.VisibleMultiTierViewer", InterlinearViewer.class.getName(), this.viewerManager.getTranscription());
            this.interlinearViewer.preferencesChanged();
        }
    }

    private JSplitPane getTimeLineSplitPane() {
        if (this.timeLineSplitPane == null) {
            this.timeLineSplitPane = new JSplitPane(0);
            this.timeLineSplitPane.setOneTouchExpandable(true);
            this.timeLineSplitPane.setDividerLocation(0);
            this.timeLineSplitPane.setContinuousLayout(true);
            this.container.add(this.timeLineSplitPane);
        }
        return this.timeLineSplitPane;
    }

    private JSplitPane getWav_TSSplitPane() {
        if (this.wav_tsSplitPane == null) {
            this.wav_tsSplitPane = new JSplitPane(0);
            this.wav_tsSplitPane.setOneTouchExpandable(true);
            this.wav_tsSplitPane.setBorder(null);
            this.wav_tsSplitPane.setDividerLocation(0);
            this.wav_tsSplitPane.setDividerSize(6);
            this.wav_tsSplitPane.setContinuousLayout(true);
        }
        return this.wav_tsSplitPane;
    }

    private void addSingleTierViewer(SingleTierViewer viewer) {
        SingleTierViewerPanel panel = this.viewerManager.createSingleTierViewerPanel();
        panel.setViewer(viewer);
        if (viewer instanceof GridViewer) {
            this.gridPanel = panel;
            this.addToTabPane(ElanLocale.getString("Tab.Grid"), panel);
        } else if (viewer instanceof TextViewer) {
            this.textPanel = panel;
            this.addToTabPane(ElanLocale.getString("Tab.Text"), panel);
        } else if (viewer instanceof SubtitleViewer) {
            this.getSubtitlePanel().add(panel);
        }
        this.doLayout();
    }

    private JPanel getSubtitlePanel() {
        if (this.subtitlePanel == null) {
            this.subtitlePanel = new JPanel(new GridLayout(0, 1));
            this.addToTabPane(ElanLocale.getString("Tab.Subtitles"), this.subtitlePanel);
        }
        return this.subtitlePanel;
    }

    private JTabbedPane getTabPane() {
        if (this.tabPane == null) {
            this.tabPane = new JTabbedPane();
            this.container.add(this.tabPane);
        }
        return this.tabPane;
    }

    private void reArrangeViewers() {
        if (this.mediaInCentre && this.getAttachedVisualPlayers().length > 0) {
            String tabName;
            int selectedIndexLeftPane = 0;
            int selectedIndexRightPane = 0;
            Component selectedLeftComponent = null;
            Component selectedRightComponent = null;
            if (this.getLeftTabPane().getTabCount() > 0) {
                selectedIndexLeftPane = this.getLeftTabPane().getSelectedIndex();
                selectedLeftComponent = this.getLeftTabPane().getSelectedComponent();
            }
            if (this.getTabPane().getTabCount() > 0) {
                selectedIndexRightPane = this.getTabPane().getSelectedIndex();
                selectedRightComponent = this.getTabPane().getSelectedComponent();
            }
            if (this.gridPanel != null) {
                tabName = ElanLocale.getString("Tab.Grid");
                if (this.gridViewerLeft) {
                    if (this.getTabPane().indexOfComponent(this.gridPanel) >= 0) {
                        this.getTabPane().remove(this.gridPanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.gridPanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.gridPanel));
                    } else {
                        this.getLeftTabPane().remove(this.gridPanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.gridPanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.gridPanel) >= 0) {
                        this.getLeftTabPane().remove(this.gridPanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.gridPanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.gridPanel));
                    }
                }
            }
            if (this.textPanel != null) {
                tabName = ElanLocale.getString("Tab.Text");
                if (this.textViewerLeft) {
                    if (this.getTabPane().indexOfComponent(this.textPanel) >= 0) {
                        this.getTabPane().remove(this.textPanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.textPanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.textPanel));
                    } else {
                        this.getLeftTabPane().remove(this.textPanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.textPanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.textPanel) >= 0) {
                        this.getLeftTabPane().remove(this.textPanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.textPanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.textPanel));
                    }
                }
            }
            if (this.subtitlePanel != null) {
                tabName = ElanLocale.getString("Tab.Subtitles");
                if (this.subtitleViewerLeft) {
                    if (this.getTabPane().indexOfComponent(this.subtitlePanel) >= 0) {
                        this.getTabPane().remove(this.subtitlePanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.subtitlePanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.subtitlePanel));
                    } else {
                        this.getLeftTabPane().remove(this.subtitlePanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.subtitlePanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.subtitlePanel) >= 0) {
                        this.getLeftTabPane().remove(this.subtitlePanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.subtitlePanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.subtitlePanel));
                    }
                }
            }
            if (this.lexiconPanel != null) {
                tabName = ElanLocale.getString("LexiconEntryViewer.Lexicon");
                if (this.lexiconViewerLeft) {
                    if (this.getTabPane().indexOfComponent(this.lexiconPanel) >= 0) {
                        this.getTabPane().remove(this.lexiconPanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.lexiconPanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.lexiconPanel));
                    } else {
                        this.getLeftTabPane().remove(this.lexiconPanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.lexiconPanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.lexiconPanel) >= 0) {
                        this.getLeftTabPane().remove(this.lexiconPanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.lexiconPanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.lexiconPanel));
                    }
                }
            }
            if (this.audioRecognizerPanel != null) {
                tabName = ElanLocale.getString("Tab.AudioRecognizer");
                if (this.audioRecognizerLeft) {
                    if (this.getTabPane().indexOfComponent(this.audioRecognizerPanel) >= 0) {
                        this.getTabPane().remove(this.audioRecognizerPanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.audioRecognizerPanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.audioRecognizerPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.audioRecognizerPanel));
                    } else {
                        this.getLeftTabPane().remove(this.audioRecognizerPanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.audioRecognizerPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.audioRecognizerPanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.audioRecognizerPanel) >= 0) {
                        this.getLeftTabPane().remove(this.audioRecognizerPanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.audioRecognizerPanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.audioRecognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.audioRecognizerPanel));
                    }
                }
            }
            if (this.videoRecognizerPanel != null) {
                tabName = ElanLocale.getString("Tab.VideoRecognizer");
                if (this.videoRecognizerLeft) {
                    if (this.getTabPane().indexOfComponent(this.videoRecognizerPanel) >= 0) {
                        this.getTabPane().remove(this.videoRecognizerPanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.videoRecognizerPanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.videoRecognizerPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.videoRecognizerPanel));
                    } else {
                        this.getLeftTabPane().remove(this.videoRecognizerPanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.videoRecognizerPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.videoRecognizerPanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.videoRecognizerPanel) >= 0) {
                        this.getLeftTabPane().remove(this.videoRecognizerPanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.videoRecognizerPanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.videoRecognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.videoRecognizerPanel));
                    }
                }
            }
            if (this.metadataPanel != null) {
                tabName = ElanLocale.getString("Tab.Metadata");
                if (this.metaDataLeft) {
                    if (this.getTabPane().indexOfComponent(this.metadataPanel) >= 0) {
                        this.getTabPane().remove(this.metadataPanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.metadataPanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.metadataPanel));
                    } else {
                        this.getLeftTabPane().remove(this.metadataPanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.metadataPanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.metadataPanel) >= 0) {
                        this.getLeftTabPane().remove(this.metadataPanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.metadataPanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.metadataPanel));
                    }
                }
            }
            if (this.getLeftTabPane().indexOfComponent(selectedLeftComponent) > 0) {
                this.getLeftTabPane().setSelectedComponent(selectedLeftComponent);
            } else if (this.getLeftTabPane().getTabCount() > selectedIndexLeftPane) {
                this.getLeftTabPane().setSelectedIndex(selectedIndexLeftPane);
            } else {
                this.getLeftTabPane().setSelectedIndex(this.getLeftTabPane().getTabCount() - 1);
            }
            if (this.getTabPane().indexOfComponent(selectedRightComponent) > 0) {
                this.getTabPane().setSelectedComponent(selectedRightComponent);
            } else if (this.getTabPane().getTabCount() > selectedIndexRightPane) {
                this.getTabPane().setSelectedIndex(selectedIndexRightPane);
            } else {
                this.getTabPane().setSelectedIndex(this.getTabPane().getTabCount() - 1);
            }
        } else {
            String tabName;
            int selectedIndex = 0;
            Component selectedComponent = null;
            if (this.getTabPane().getTabCount() > 0) {
                selectedIndex = this.getTabPane().getSelectedIndex();
                selectedComponent = this.getTabPane().getSelectedComponent();
            }
            if (this.gridPanel != null) {
                tabName = ElanLocale.getString("Tab.Grid");
                if (this.getTabPane().indexOfComponent(this.gridPanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.gridPanel));
                } else {
                    this.getTabPane().remove(this.gridPanel);
                    this.getTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.gridPanel));
                }
            }
            if (this.textPanel != null) {
                tabName = ElanLocale.getString("Tab.Text");
                if (this.getTabPane().indexOfComponent(this.textPanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.textPanel));
                } else {
                    this.getTabPane().remove(this.textPanel);
                    this.getTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.textPanel));
                }
            }
            if (this.subtitlePanel != null) {
                tabName = ElanLocale.getString("Tab.Subtitles");
                if (this.getTabPane().indexOfComponent(this.subtitlePanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.subtitlePanel));
                } else {
                    this.getTabPane().remove(this.subtitlePanel);
                    this.getTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.subtitlePanel));
                }
            }
            if (this.lexiconPanel != null) {
                tabName = ElanLocale.getString("LexiconEntryViewer.Lexicon");
                if (this.getTabPane().indexOfComponent(this.lexiconPanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.lexiconPanel));
                } else {
                    this.getTabPane().remove(this.lexiconPanel);
                    this.getTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.lexiconPanel));
                }
            }
            if (this.audioRecognizerPanel != null) {
                tabName = ElanLocale.getString("Tab.AudioRecognizer");
                if (this.getTabPane().indexOfComponent(this.audioRecognizerPanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.audioRecognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.audioRecognizerPanel));
                } else {
                    this.getTabPane().remove(this.audioRecognizerPanel);
                    this.getTabPane().insertTab(tabName, null, this.audioRecognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.audioRecognizerPanel));
                }
            }
            if (this.videoRecognizerPanel != null) {
                tabName = ElanLocale.getString("Tab.VideoRecognizer");
                if (this.getTabPane().indexOfComponent(this.videoRecognizerPanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.videoRecognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.videoRecognizerPanel));
                } else {
                    this.getTabPane().remove(this.videoRecognizerPanel);
                    this.getTabPane().insertTab(tabName, null, this.videoRecognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.videoRecognizerPanel));
                }
            }
            if (this.metadataPanel != null) {
                tabName = ElanLocale.getString("Tab.Metadata");
                if (this.getTabPane().indexOfComponent(this.metadataPanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.metadataPanel));
                } else {
                    this.getTabPane().remove(this.metadataPanel);
                    this.getTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.metadataPanel));
                }
            }
            if (this.getTabPane().indexOfComponent(selectedComponent) > 0) {
                this.getTabPane().setSelectedComponent(selectedComponent);
            } else if (this.getTabPane().getTabCount() > selectedIndex) {
                this.getTabPane().setSelectedIndex(selectedIndex);
            } else {
                this.getTabPane().setSelectedIndex(this.getTabPane().getTabCount() - 1);
            }
        }
    }

    private void destroyLeftPane() {
        if (this.leftTabPane != null) {
            this.container.remove(this.leftTabPane);
            this.leftTabPane = null;
        }
    }

    private JTabbedPane getLeftTabPane() {
        if (this.leftTabPane == null) {
            this.leftTabPane = new JTabbedPane();
            this.container.add(this.leftTabPane);
        }
        return this.leftTabPane;
    }

    private int getIndexOfComponent(JTabbedPane pane, Component component) {
        int index = 0;
        if (this.viewerSortOrder != null && this.viewerSortOrder.size() > 0) {
            for (int i = 0; i < this.viewerSortOrder.size(); ++i) {
                if (component == this.controlPanel) {
                    return pane.getTabCount();
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Grid"))) {
                    if (component == this.gridPanel) break;
                    if (pane.indexOfComponent(this.gridPanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Text"))) {
                    if (component == this.textPanel) break;
                    if (pane.indexOfComponent(this.textPanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Subtitles"))) {
                    if (component == this.subtitlePanel) break;
                    if (pane.indexOfComponent(this.subtitlePanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("LexiconEntryViewer.Lexicon"))) {
                    if (component == this.lexiconPanel) break;
                    if (pane.indexOfComponent(this.lexiconPanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Audio"))) {
                    if (component == this.audioRecognizerPanel) break;
                    if (pane.indexOfComponent(this.audioRecognizerPanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Video"))) {
                    if (component == this.videoRecognizerPanel) break;
                    if (pane.indexOfComponent(this.videoRecognizerPanel) >= 0) {
                        ++index;
                    }
                }
                if (!this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.MetaData"))) continue;
                if (pane.indexOfComponent(this.metadataPanel) >= 0) {
                    ++index;
                    continue;
                }
                if (component != this.metadataPanel) {
                    continue;
                }
                break;
            }
        } else {
            if (component == this.gridPanel) {
                return index;
            }
            index = pane.indexOfComponent(this.gridPanel);
            index = index != 0 ? 0 : 1;
            if (component == this.textPanel) {
                return index;
            }
            if (component == this.subtitlePanel) {
                int i = pane.indexOfComponent(this.textPanel);
                if (i >= 0) {
                    return i + 1;
                }
                return index;
            }
            if (component == this.lexiconPanel) {
                int i = pane.indexOfComponent(this.subtitlePanel);
                if (i >= 0) {
                    return i + 1;
                }
                return index;
            }
            if (component == this.audioRecognizerPanel) {
                int i = pane.indexOfComponent(this.lexiconPanel);
                if (i >= 0) {
                    return i + 1;
                }
                i = pane.indexOfComponent(this.subtitlePanel);
                if (i >= 0) {
                    return i + 1;
                }
                return index;
            }
            if (component == this.videoRecognizerPanel) {
                int i = pane.indexOfComponent(this.metadataPanel);
                if (i >= 0) {
                    return i;
                }
                i = pane.indexOfComponent(this.controlPanel);
                if (i >= 0) {
                    return i;
                }
                return pane.getTabCount();
            }
            if (component == this.metadataPanel) {
                int i = pane.indexOfComponent(this.controlPanel);
                if (i >= 0) {
                    return i;
                }
                return pane.getTabCount();
            }
            if (component == this.controlPanel) {
                return pane.getTabCount();
            }
        }
        return index;
    }

    private void addToTabPane(String tabName, Component component) {
        this.getTabPane().insertTab(tabName, null, component, tabName, this.getIndexOfComponent(this.getTabPane(), component));
        this.doLayout();
    }

    private void removeFromTabPane(Component component) {
        if (this.getTabPane().indexOfComponent(component) >= 0) {
            this.tabPane.removeChangeListener(this);
            this.getTabPane().remove(component);
            this.tabPane.addChangeListener(this);
        } else if (this.getLeftTabPane().indexOfComponent(component) >= 0) {
            this.leftTabPane.removeChangeListener(this);
            this.getLeftTabPane().remove(component);
            this.leftTabPane.addChangeListener(this);
        }
    }

    public void showNormalMode() {
        if (this.mode == 0) {
            this.checkUnequalOffsets();
            for (int i = 0; i < this.playerList.size(); ++i) {
                PlayerLayoutModel plm = (PlayerLayoutModel)this.playerList.get(i);
                if (!plm.syncOnly) continue;
                this.viewerManager.destroyMediaPlayer(plm.player);
                if (plm.player.getVisualComponent() == null) continue;
                this.container.remove(plm.player.getVisualComponent());
            }
        }
        this.mode = 1;
        this.syncManager.reconnect();
        if (this.signalViewer != null) {
            this.signalViewer.setOffset(this.viewerManager.getSignalViewerOffset());
        }
        if (!this.containsComponent(this.mediaPlayerController.getTimePanel())) {
            this.container.add(this.mediaPlayerController.getTimePanel());
        }
        if (this.masterMediaPlayer != null) {
            this.viewerManager.setMasterMediaPlayer(this.masterMediaPlayer);
        }
        this.viewerManager.enableDisabledMediaPlayers();
        if (this.timeLineViewer != null) {
            this.viewerManager.enableViewer(this.timeLineViewer);
        }
        if (this.signalViewer != null) {
            this.viewerManager.enableViewer(this.signalViewer);
        }
        this.clearLayout();
        this.doLayout();
    }

    public void showSyncMode() {
        this.mode = 0;
        for (int i = 0; i < this.playerList.size(); ++i) {
            PlayerLayoutModel plm = (PlayerLayoutModel)this.playerList.get(i);
            if (!plm.syncOnly) continue;
            this.viewerManager.addMediaPlayer(plm.player);
            if (plm.player.getVisualComponent() == null) continue;
            this.container.add(plm.player.getVisualComponent());
        }
        this.viewerManager.setMasterMediaPlayer(this.masterMediaPlayer);
        this.viewerManager.enableDisabledMediaPlayers();
        if (this.timeLineViewer != null) {
            this.viewerManager.disableViewer(this.timeLineViewer);
        }
        if (this.signalViewer != null) {
            this.viewerManager.disableViewer(this.signalViewer);
        }
        this.clearLayout();
        this.doLayout();
    }

    public int getMode() {
        return this.mode;
    }

    public void connectAllPlayers() {
        if (this.mode == 0) {
            this.syncManager.reconnect();
        }
    }

    private void clearLayout() {
        Component[] components = this.container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setBounds(0, 0, 0, 0);
        }
    }

    public void doLayout() {
        if (this.mode == 1) {
            this.doNormalLayout();
        } else if (this.mode == 0) {
            this.doSyncLayout();
        }
    }

    private void doSyncLayout() {
        int playerSelectionX;
        int containerWidth = this.container.getWidth();
        int containerHeight = this.container.getHeight();
        int containerMargin = 3;
        int componentMargin = 5;
        int controlsMargin = 20;
        int labelHeight = 20;
        if (this.playerList.size() > 0) {
            for (int i = 0; i < this.playerList.size(); ++i) {
                PlayerLayoutModel m = (PlayerLayoutModel)this.playerList.get(i);
                Dimension prefSize = this.syncManager.getPlayerLabel(m.player).getPreferredSize();
                if (prefSize.height <= labelHeight) continue;
                labelHeight = prefSize.height;
            }
        }
        int playerSelectionWidth = 130;
        int playerSelectionHeight = 70;
        Dimension playerSelectionSize = this.syncManager.getPlayerSelectionPanel().getPreferredSize();
        playerSelectionWidth = Math.max(playerSelectionWidth, playerSelectionSize.width);
        playerSelectionHeight = Math.max(playerSelectionHeight, playerSelectionSize.height);
        int controlsHeight = 2 * componentMargin + this.mediaPlayerController.getSliderPanel().getPreferredSize().height + playerSelectionHeight;
        int totalPlayerWidth = containerWidth - 2 * containerMargin;
        int totalPlayerHeight = containerHeight - containerMargin - controlsHeight;
        int[] colrow = this.getNumberOfColumnsAndRows(totalPlayerWidth, totalPlayerHeight, labelHeight, this.playerList.size());
        int mediaY = containerMargin;
        int mediaX = containerMargin;
        if (colrow[0] > 0 && colrow[1] > 0) {
            int maxMediaWidth = totalPlayerWidth / colrow[0] - componentMargin;
            int maxMediaHeight = totalPlayerHeight / colrow[1] - labelHeight - componentMargin;
            if (maxMediaWidth > 0 && maxMediaHeight > 0) {
                int playerIndex = 0;
                for (int i = 0; i < colrow[1]; ++i) {
                    mediaY += i * (maxMediaHeight + labelHeight);
                    for (int j = 0; j < colrow[0]; ++j) {
                        PlayerLayoutModel model = null;
                        ElanMediaPlayer player = null;
                        if (playerIndex < this.playerList.size()) {
                            model = (PlayerLayoutModel)this.playerList.get(playerIndex);
                            player = model.player;
                        }
                        JPanel label = this.syncManager.getPlayerLabel(player);
                        int curX = mediaX + j * (maxMediaWidth + componentMargin);
                        int curY = mediaY;
                        int curW = maxMediaWidth;
                        int curH = maxMediaHeight;
                        if (label != null) {
                            Dimension prefLabelSize = ((Component)label).getPreferredSize();
                            if (prefLabelSize.width <= maxMediaWidth) {
                                label.setBounds(curX, curY + curH, curW, labelHeight);
                            } else {
                                label.setBounds(0, 0, 0, 0);
                            }
                        }
                        Component videoComp = null;
                        float aspectRatio = 1.0f;
                        if (model.syncOnly) {
                            videoComp = model.player.getVisualComponent();
                            aspectRatio = model.player.getAspectRatio();
                        } else if (model.isVisual() && model.isAttached()) {
                            videoComp = model.visualComponent;
                            aspectRatio = model.player.getAspectRatio();
                        }
                        if (videoComp != null) {
                            curH = (int)((float)curW / aspectRatio);
                            if (curH > maxMediaHeight) {
                                curH = maxMediaHeight;
                                curW = (int)((float)curH * aspectRatio);
                                curX += (maxMediaWidth - curW) / 2;
                            }
                            videoComp.setBounds(curX, curY, curW, curH);
                        }
                        if (++playerIndex >= this.playerList.size()) break;
                    }
                    if (playerIndex < this.playerList.size()) continue;
                    mediaY += maxMediaHeight + labelHeight + componentMargin;
                    break;
                }
            }
        }
        int controlsY = mediaY;
        int sliderPanelX = 3 + controlsMargin;
        int sliderPanelY = controlsY;
        int sliderPanelWidth = 0;
        int sliderPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            sliderPanelWidth = containerWidth - 6 - 2 * controlsMargin;
            sliderPanelHeight = this.mediaPlayerController.getSliderPanel().getPreferredSize().height;
            this.mediaPlayerController.getSliderPanel().setBounds(sliderPanelX, sliderPanelY, sliderPanelWidth, sliderPanelHeight);
        }
        int timePanelX = 0;
        int timePanelY = sliderPanelY + sliderPanelHeight + componentMargin;
        int timePanelWidth = 0;
        int timePanelHeight = 0;
        if (this.mediaPlayerController != null && this.syncManager.connectedPlayers()) {
            if (!this.containsComponent(this.mediaPlayerController.getTimePanel())) {
                this.container.add(this.mediaPlayerController.getTimePanel());
            }
            timePanelX = containerWidth / 2 - this.mediaPlayerController.getTimePanel().getPreferredSize().width / 2;
            timePanelWidth = this.mediaPlayerController.getTimePanel().getPreferredSize().width;
            timePanelHeight = this.mediaPlayerController.getTimePanel().getPreferredSize().height;
            this.mediaPlayerController.getTimePanel().setBounds(timePanelX, timePanelY, timePanelWidth, timePanelHeight);
        }
        int playButtonsX = 0;
        int playButtonsY = timePanelY + 40;
        int playButtonsWidth = 0;
        int playButtonsHeight = 0;
        if (this.mediaPlayerController != null) {
            playButtonsX = containerWidth / 2 - this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().width / 2;
            playButtonsWidth = this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().width;
            playButtonsHeight = this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().height;
            if (playButtonsX < sliderPanelX + playerSelectionWidth + componentMargin) {
                playButtonsX = sliderPanelX + playerSelectionWidth + componentMargin;
                int adjTimePanelX = playButtonsX + (playButtonsWidth - timePanelWidth) / 2;
                this.mediaPlayerController.getTimePanel().setBounds(adjTimePanelX, timePanelY, timePanelWidth, timePanelHeight);
            }
            this.mediaPlayerController.getPlayButtonsPanel().setBounds(playButtonsX, playButtonsY, playButtonsWidth, playButtonsHeight);
        }
        if ((playerSelectionX = playButtonsX - playerSelectionWidth - componentMargin) < sliderPanelX) {
            playerSelectionX = sliderPanelX;
        }
        int playerSelectionY = timePanelY;
        this.syncManager.getPlayerSelectionPanel().setBounds(playerSelectionX, playerSelectionY, playerSelectionWidth, playerSelectionHeight);
        this.container.validate();
        this.container.repaint();
    }

    private void doNormalLayout() {
        int containerWidth = this.container.getWidth();
        int containerHeight = this.container.getHeight();
        int containerMargin = 3;
        int componentMargin = 5;
        PlayerLayoutModel[] visualPlayers = this.getAttachedVisualPlayers();
        int numVisualPlayers = visualPlayers.length;
        int visibleMediaX = containerMargin;
        int visibleMediaY = containerMargin;
        int visibleMediaWidth = 0;
        int visibleMediaHeight = this.mediaAreaHeight;
        int firstMediaWidth = visibleMediaWidth;
        if (this.oneRowForVisuals) {
            if (numVisualPlayers >= 1) {
                int maxPerMedia = (containerWidth - this.minTabWidth) / numVisualPlayers;
                int maxUsedHeight = 0;
                for (int i = 0; i < numVisualPlayers && i < 4; ++i) {
                    Component visComp = visualPlayers[i].visualComponent;
                    float aspectRatio = visualPlayers[i].player.getAspectRatio();
                    int curWidth = 0;
                    int curHeight = 0;
                    if ((float)this.mediaAreaHeight * aspectRatio > (float)maxPerMedia) {
                        curWidth = maxPerMedia;
                        curHeight = (int)((float)maxPerMedia / aspectRatio);
                        maxUsedHeight = curHeight > maxUsedHeight ? curHeight : maxUsedHeight;
                    } else {
                        curWidth = (int)((float)this.mediaAreaHeight * aspectRatio);
                        curHeight = this.mediaAreaHeight;
                    }
                    if (i == 0) {
                        visibleMediaWidth = visibleMediaX + curWidth + componentMargin;
                        if (this.mediaInCentre) {
                            visibleMediaX = (containerWidth - visibleMediaWidth * numVisualPlayers) / 2;
                        }
                        visComp.setBounds(visibleMediaX, visibleMediaY, curWidth, curHeight);
                        firstMediaWidth = curWidth;
                        continue;
                    }
                    visComp.setBounds(visibleMediaX + visibleMediaWidth, visibleMediaY, curWidth, curHeight);
                    visibleMediaWidth = visibleMediaWidth + curWidth + componentMargin;
                }
            }
        } else {
            float secondAR;
            Component secondVisualComp;
            float aspectRatio;
            if (numVisualPlayers >= 1) {
                Component firstVisualComp = visualPlayers[0].visualComponent;
                aspectRatio = visualPlayers[0].player.getAspectRatio();
                int firstMediaHeight = this.mediaAreaHeight;
                firstMediaWidth = 352;
                if (visualPlayers[0].player.getSourceWidth() > 704 && this.mediaAreaHeight == 250) {
                    firstMediaWidth = visualPlayers[0].player.getSourceWidth() / 2;
                    firstMediaHeight = (int)((float)firstMediaWidth / aspectRatio);
                } else {
                    firstMediaWidth = (int)((float)firstMediaHeight * aspectRatio);
                }
                visibleMediaWidth = firstMediaWidth + componentMargin;
                if (this.mediaInCentre && numVisualPlayers <= 2) {
                    visibleMediaX = (containerWidth - visibleMediaWidth * numVisualPlayers) / 2;
                }
                visibleMediaHeight = firstMediaHeight;
                firstVisualComp.setBounds(containerMargin + visibleMediaX, visibleMediaY, firstMediaWidth, firstMediaHeight);
            }
            if (numVisualPlayers == 2) {
                secondVisualComp = visualPlayers[1].visualComponent;
                aspectRatio = visualPlayers[1].player.getAspectRatio();
                int secondMediaWidth = (int)((float)visibleMediaHeight * aspectRatio);
                int secondMediaHeight = visibleMediaHeight;
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - (visibleMediaWidth + secondMediaWidth)) / 2;
                    visualPlayers[0].visualComponent.setBounds(containerMargin + visibleMediaX, visibleMediaY, firstMediaWidth, visibleMediaHeight);
                }
                if (visualPlayers[1].player.getSourceWidth() > 704 && visualPlayers[1].player.getSourceWidth() > visualPlayers[0].player.getSourceWidth() && (secondMediaHeight = (int)((float)(secondMediaWidth = visualPlayers[1].player.getSourceWidth() / 2) / aspectRatio)) > visibleMediaHeight) {
                    visibleMediaHeight = secondMediaHeight;
                }
                secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth, visibleMediaY, secondMediaWidth, secondMediaHeight);
                visibleMediaWidth += secondMediaWidth + componentMargin;
            } else if (numVisualPlayers == 3) {
                secondVisualComp = visualPlayers[1].visualComponent;
                secondAR = visualPlayers[1].player.getAspectRatio();
                Component thirdVisualComp = visualPlayers[2].visualComponent;
                float thirdAR = visualPlayers[2].player.getAspectRatio();
                int heightPerPlayer = (visibleMediaHeight - componentMargin) / 2;
                int secondWidth = (int)(secondAR * (float)heightPerPlayer);
                int thirdWidth = (int)(thirdAR * (float)heightPerPlayer);
                int widthPerPlayer = Math.max(secondWidth, thirdWidth);
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - (visibleMediaWidth + widthPerPlayer)) / 2;
                    visualPlayers[0].visualComponent.setBounds(visibleMediaX, visibleMediaY, firstMediaWidth, (int)((float)firstMediaWidth / visualPlayers[0].player.getAspectRatio()));
                }
                secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - secondWidth) / 2, visibleMediaY, secondWidth, heightPerPlayer);
                thirdVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - thirdWidth) / 2, visibleMediaY + heightPerPlayer + componentMargin, thirdWidth, heightPerPlayer);
                visibleMediaWidth += widthPerPlayer + componentMargin;
            } else if (numVisualPlayers >= 4) {
                secondVisualComp = visualPlayers[1].visualComponent;
                secondAR = visualPlayers[1].player.getAspectRatio();
                Component thirdVisualComp = visualPlayers[2].visualComponent;
                float thirdAR = visualPlayers[2].player.getAspectRatio();
                Component fourthVisualComp = visualPlayers[3].visualComponent;
                float fourthAR = visualPlayers[3].player.getAspectRatio();
                int heightPerPlayer = (visibleMediaHeight - 2 * componentMargin) / 3;
                int secondWidth = (int)(secondAR * (float)heightPerPlayer);
                int thirdWidth = (int)(thirdAR * (float)heightPerPlayer);
                int fourthWidth = (int)(fourthAR * (float)heightPerPlayer);
                int widthPerPlayer = Math.max(secondWidth, thirdWidth);
                widthPerPlayer = Math.max(widthPerPlayer, fourthWidth);
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - (visibleMediaWidth + widthPerPlayer)) / 2;
                    visualPlayers[0].visualComponent.setBounds(visibleMediaX, visibleMediaY, firstMediaWidth, (int)((float)firstMediaWidth / visualPlayers[0].player.getAspectRatio()));
                }
                secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - secondWidth) / 2, visibleMediaY, secondWidth, heightPerPlayer);
                thirdVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - thirdWidth) / 2, visibleMediaY + heightPerPlayer + componentMargin, thirdWidth, heightPerPlayer);
                fourthVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - fourthWidth) / 2, visibleMediaY + 2 * heightPerPlayer + 2 * componentMargin, fourthWidth, heightPerPlayer);
                visibleMediaWidth += widthPerPlayer + componentMargin;
            }
        }
        int tabPaneX = visibleMediaX + visibleMediaWidth;
        int tabPaneY = visibleMediaY;
        int tabPaneWidth = containerWidth - tabPaneX;
        int tabPaneHeight = visibleMediaHeight;
        if (this.mediaInCentre) {
            tabPaneX -= containerMargin;
        }
        if (this.mediaInCentre && numVisualPlayers > 0) {
            tabPaneWidth = visibleMediaX;
            this.getLeftTabPane().setBounds(containerMargin, containerMargin, tabPaneWidth, tabPaneHeight);
        } else {
            this.destroyLeftPane();
        }
        if (this.tabPane != null) {
            this.tabPane.setBounds(tabPaneX, tabPaneY, tabPaneWidth, tabPaneHeight);
            if (this.mediaPlayerController != null && this.controlPanel != null) {
                this.controlPanel.setSize(tabPaneWidth, tabPaneHeight);
            }
        }
        if (this.numOfPlayers != numVisualPlayers && this.numOfPlayers == 0) {
            this.preferenceChanged = true;
        }
        if (this.preferenceChanged || numVisualPlayers == 0) {
            this.reArrangeViewers();
            this.preferenceChanged = false;
        }
        int timePanelX = 0;
        int timePanelY = visibleMediaY + visibleMediaHeight + 2;
        int timePanelWidth = 0;
        int timePanelHeight = 0;
        if (this.mediaPlayerController != null) {
            timePanelWidth = this.mediaPlayerController.getTimePanel().getPreferredSize().width;
            timePanelHeight = this.mediaPlayerController.getTimePanel().getPreferredSize().height;
            timePanelX = numVisualPlayers == 0 ? containerMargin : (this.mediaInCentre ? visibleMediaX + firstMediaWidth / 2 - timePanelWidth / 2 : containerMargin + firstMediaWidth / 2 - timePanelWidth / 2);
            this.mediaPlayerController.getTimePanel().setBounds(timePanelX, timePanelY, timePanelWidth, timePanelHeight);
        }
        int playButtonsX = 3;
        int playButtonsY = timePanelY + timePanelHeight + 4;
        int playButtonsWidth = 0;
        int playButtonsHeight = 0;
        if (this.mediaPlayerController != null) {
            playButtonsWidth = this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().width;
            playButtonsHeight = this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().height;
            if (numVisualPlayers > 0) {
                if (this.mediaInCentre) {
                    playButtonsX = visibleMediaX;
                } else {
                    playButtonsX = containerMargin + firstMediaWidth / 2 - playButtonsWidth / 2;
                    if (playButtonsX < 3) {
                        playButtonsX = 3;
                    }
                }
            }
            this.mediaPlayerController.getPlayButtonsPanel().setBounds(playButtonsX, playButtonsY, playButtonsWidth, playButtonsHeight);
        }
        int selectionPanelX = playButtonsX + playButtonsWidth + 20;
        int selectionPanelY = visibleMediaY + visibleMediaHeight + 2;
        int selectionPanelWidth = 0;
        int selectionPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            selectionPanelWidth = 100 + this.mediaPlayerController.getSelectionPanel().getPreferredSize().width;
            selectionPanelHeight = this.mediaPlayerController.getSelectionPanel().getPreferredSize().height;
            this.mediaPlayerController.getSelectionPanel().setBounds(selectionPanelX, selectionPanelY, selectionPanelWidth, selectionPanelHeight);
        }
        int selectionButtonsX = selectionPanelX;
        int selectionButtonsY = selectionPanelY + selectionPanelHeight + 4;
        int selectionButtonsWidth = 0;
        int selectionButtonsHeight = 0;
        if (this.mediaPlayerController != null) {
            selectionButtonsWidth = this.mediaPlayerController.getSelectionButtonsPanel().getPreferredSize().width;
            selectionButtonsHeight = this.mediaPlayerController.getSelectionButtonsPanel().getPreferredSize().height;
            this.mediaPlayerController.getSelectionButtonsPanel().setBounds(selectionButtonsX, selectionButtonsY, selectionButtonsWidth, selectionButtonsHeight);
        }
        int annotationButtonsX = selectionButtonsX + selectionButtonsWidth + 15;
        int annotationButtonsY = selectionPanelY + selectionPanelHeight + 4;
        int annotationButtonsWidth = 0;
        int annotationButtonsHeight = 0;
        if (this.mediaPlayerController != null) {
            annotationButtonsWidth = this.mediaPlayerController.getAnnotationNavigationPanel().getPreferredSize().width;
            annotationButtonsHeight = this.mediaPlayerController.getAnnotationNavigationPanel().getPreferredSize().height;
            this.mediaPlayerController.getAnnotationNavigationPanel().setBounds(annotationButtonsX, annotationButtonsY, annotationButtonsWidth, annotationButtonsHeight);
        }
        int modePanelX = annotationButtonsX + annotationButtonsWidth + 10;
        int modePanelY = annotationButtonsY - 1;
        int modePanelWidth = 0;
        int modePanelHeight = 0;
        if (this.mediaPlayerController != null) {
            modePanelWidth = 300;
            modePanelHeight = this.mediaPlayerController.getModePanel().getPreferredSize().height;
            this.mediaPlayerController.getModePanel().setBounds(modePanelX, modePanelY, modePanelWidth, modePanelHeight);
        }
        if (modePanelX + modePanelWidth > containerWidth && this.mediaPlayerController != null) {
            timePanelX = numVisualPlayers == 0 ? containerMargin : containerMargin + firstMediaWidth / 2 - timePanelWidth / 2;
            this.mediaPlayerController.getTimePanel().setBounds(timePanelX, timePanelY, timePanelWidth, timePanelHeight);
            playButtonsX = containerMargin + firstMediaWidth / 2 - playButtonsWidth / 2;
            if (playButtonsX < 3) {
                playButtonsX = 3;
            }
            this.mediaPlayerController.getPlayButtonsPanel().setBounds(playButtonsX, playButtonsY, playButtonsWidth, playButtonsHeight);
            selectionPanelX = playButtonsX + playButtonsWidth + 20;
            this.mediaPlayerController.getSelectionPanel().setBounds(selectionPanelX, selectionPanelY, selectionPanelWidth, selectionPanelHeight);
            selectionButtonsX = selectionPanelX;
            this.mediaPlayerController.getSelectionButtonsPanel().setBounds(selectionButtonsX, selectionButtonsY, selectionButtonsWidth, selectionButtonsHeight);
            annotationButtonsX = selectionButtonsX + selectionButtonsWidth + 15;
            this.mediaPlayerController.getAnnotationNavigationPanel().setBounds(annotationButtonsX, annotationButtonsY, annotationButtonsWidth, annotationButtonsHeight);
            modePanelX = annotationButtonsX + annotationButtonsWidth + 10;
            this.mediaPlayerController.getModePanel().setBounds(modePanelX, modePanelY, modePanelWidth, modePanelHeight);
        }
        int divX = containerWidth - containerMargin - componentMargin - this.vertMediaResizer.getPreferredSize().width;
        int divY = annotationButtonsY + annotationButtonsHeight / 2 - this.vertMediaResizer.getPreferredSize().height / 2;
        this.vertMediaResizer.setBounds(divX, divY, this.vertMediaResizer.getPreferredSize().width, this.vertMediaResizer.getPreferredSize().height);
        int sliderPanelX = 3;
        int sliderPanelY = playButtonsY + playButtonsHeight;
        int sliderPanelWidth = 0;
        int sliderPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            sliderPanelWidth = containerWidth - 6;
            sliderPanelHeight = this.mediaPlayerController.getSliderPanel().getPreferredSize().height;
            this.mediaPlayerController.getSliderPanel().setBounds(sliderPanelX, sliderPanelY, sliderPanelWidth, sliderPanelHeight);
        }
        int densityPanelX = 3;
        int densityPanelY = sliderPanelY + componentMargin;
        int densityPanelWidth = sliderPanelWidth;
        int densityPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            densityPanelHeight = this.mediaPlayerController.getAnnotationDensityViewer().getPreferredSize().height;
            this.mediaPlayerController.getAnnotationDensityViewer().setBounds(densityPanelX, densityPanelY, densityPanelWidth, densityPanelHeight);
        }
        int timeLineSplitPaneX = 3;
        int timeLineSplitPaneY = densityPanelY + densityPanelHeight + 4;
        int timeLineSplitPaneWidth = 0;
        int timeLineSplitPaneHeight = 0;
        if (this.timeLineSplitPane != null) {
            timeLineSplitPaneWidth = containerWidth - 6;
            timeLineSplitPaneHeight = containerHeight - timeLineSplitPaneY;
            this.timeLineSplitPane.setBounds(timeLineSplitPaneX, timeLineSplitPaneY, timeLineSplitPaneWidth, timeLineSplitPaneHeight);
        }
        int multiTierControlX = 0;
        int multiTierControlY = 0;
        int multiTierControlWidth = 0;
        int multiTierControlHeight = 0;
        int timeLineX = 0;
        int timeLineY = 0;
        int timeLineWidth = 0;
        int timeLineHeight = 0;
        int interlinearX = 0;
        int interlinearY = 0;
        int interlinearWidth = 0;
        int interlinearHeight = 0;
        if (this.timeLineComponent != null) {
            int bottomHeight = this.timeLineSplitPane.getHeight() - this.timeLineSplitPane.getDividerLocation() - this.timeLineSplitPane.getDividerSize();
            multiTierControlWidth = this.multiTierControlPanelWidth;
            multiTierControlHeight = bottomHeight;
            this.multiTierControlPanel.setSize(multiTierControlWidth, multiTierControlHeight);
            this.multiTierControlPanel.setBounds(multiTierControlX, multiTierControlY, multiTierControlWidth, multiTierControlHeight);
            if (this.showTimeLineViewer) {
                timeLineX = multiTierControlWidth;
                timeLineWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth;
                timeLineHeight = bottomHeight;
            } else {
                interlinearX = multiTierControlWidth;
                interlinearWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth;
                interlinearHeight = bottomHeight;
            }
            if (this.timeLineViewer != null) {
                this.timeLineViewer.setBounds(timeLineX, timeLineY, timeLineWidth, timeLineHeight);
                this.timeLineViewer.setPreferredSize(new Dimension(timeLineWidth, timeLineHeight));
                this.timeLineViewer.componentResized(null);
            }
            if (this.interlinearViewer != null) {
                this.interlinearViewer.setBounds(interlinearX, interlinearY, interlinearWidth, interlinearHeight);
                this.interlinearViewer.setPreferredSize(new Dimension(interlinearWidth, interlinearHeight));
                this.interlinearViewer.componentResized(null);
            }
        }
        int signalX = multiTierControlWidth;
        int signalY = 0;
        int signalWidth = 0;
        int signalHeight = 0;
        if (this.wav_tsSplitPane != null && this.signalComponent != null && this.timeseriesComponent != null) {
            int topHeight = this.wav_tsSplitPane.getDividerLocation();
            int rMargin = 0;
            if (this.timeLineViewer != null) {
                rMargin = this.timeLineViewer.getRightMargin();
            }
            signalWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth - rMargin;
            signalHeight = this.wav_tsSplitPane.getHeight() - this.wav_tsSplitPane.getDividerSize() - topHeight;
            this.signalViewer.setBounds(signalX, signalY, signalWidth, signalHeight);
            this.signalComponent.setPreferredSize(new Dimension(signalWidth, signalHeight));
            int tsWidth = 0;
            this.timeseriesViewer.setRightMargin(rMargin);
            this.timeseriesViewer.setVerticalRulerWidth(multiTierControlWidth);
            tsWidth = this.timeLineSplitPane.getWidth();
            this.timeseriesViewer.setBounds(0, signalY, tsWidth, topHeight);
            this.timeseriesComponent.setPreferredSize(new Dimension(tsWidth, topHeight));
        } else if (this.signalComponent != null && this.signalViewer != null) {
            int rMargin = 0;
            if (this.timeLineViewer != null) {
                rMargin = this.timeLineViewer.getRightMargin();
            }
            signalWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth - rMargin;
            signalHeight = this.signalComponent.getHeight();
            this.signalViewer.setBounds(signalX, signalY, signalWidth, signalHeight);
            this.signalComponent.setPreferredSize(new Dimension(signalWidth, signalHeight));
        } else if (this.timeseriesComponent != null && this.timeseriesViewer != null) {
            int rMargin = 0;
            int tsWidth = 0;
            if (this.timeLineViewer != null) {
                rMargin = this.timeLineViewer.getRightMargin();
                this.timeseriesViewer.setRightMargin(rMargin);
            }
            this.timeseriesViewer.setVerticalRulerWidth(multiTierControlWidth);
            tsWidth = this.timeLineSplitPane.getWidth();
            signalHeight = this.timeseriesComponent.getHeight();
            this.timeseriesViewer.setBounds(0, signalY, tsWidth, signalHeight);
            this.timeseriesComponent.setPreferredSize(new Dimension(tsWidth, signalHeight));
        }
        if (this.timeLineSplitPane != null) {
            this.timeLineSplitPane.resetToPreferredSizes();
        }
        this.numOfPlayers = numVisualPlayers;
        this.container.validate();
    }

    private boolean containsComponent(Component component) {
        Component[] components = this.container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] != component) continue;
            return true;
        }
        return false;
    }

    private PlayerLayoutModel[] getAttachedVisualPlayers() {
        ArrayList<PlayerLayoutModel> plList = new ArrayList<PlayerLayoutModel>(this.playerList.size());
        PlayerLayoutModel model = null;
        for (int i = 0; i < this.playerList.size(); ++i) {
            model = (PlayerLayoutModel)this.playerList.get(i);
            if (!model.isVisual() || !model.isAttached()) continue;
            if (model.isDisplayedFirst()) {
                plList.add(0, model);
                continue;
            }
            plList.add(model);
        }
        return plList.toArray(new PlayerLayoutModel[0]);
    }

    private int[] getNumberOfColumnsAndRows(int availableWidth, int availableHeight, int labelHeight, int numPlayers) {
        float averageAspectRatio = 0.0f;
        int visualCount = 0;
        for (int i = 0; i < this.playerList.size(); ++i) {
            PlayerLayoutModel plModel = (PlayerLayoutModel)this.playerList.get(i);
            if (!plModel.isVisual()) continue;
            averageAspectRatio += plModel.player.getAspectRatio();
            ++visualCount;
        }
        averageAspectRatio = visualCount > 0 ? (averageAspectRatio /= (float)visualCount) : 1.3f;
        if (numPlayers == 0 || numPlayers == 1) {
            return new int[]{numPlayers, numPlayers};
        }
        if (availableWidth <= 0 || availableHeight <= 0 || availableHeight <= labelHeight) {
            return new int[]{0, 0};
        }
        int maxArea = 0;
        int maxWidth = 0;
        int maxHeight = 0;
        int numColumns = 0;
        int numRows = 0;
        for (int i = 1; i <= numPlayers; ++i) {
            for (int j = numPlayers; j >= 1 && i * j >= numPlayers; --j) {
                int area;
                maxHeight = (availableHeight - j * labelHeight) / j;
                maxWidth = availableWidth / i;
                if ((float)maxHeight > (float)maxWidth * (1.0f / averageAspectRatio)) {
                    maxHeight = (int)((float)maxWidth * (1.0f / averageAspectRatio));
                }
                if ((float)maxWidth > (float)maxHeight * averageAspectRatio) {
                    maxWidth = (int)((float)maxHeight * averageAspectRatio);
                }
                if (maxWidth <= 0 || maxHeight <= 0 || (area = maxWidth * maxHeight) <= maxArea) continue;
                maxArea = area;
                numColumns = i;
                numRows = j;
            }
        }
        return new int[]{numColumns, numRows};
    }

    private void checkUnequalOffsets() {
        if (this.playerList.size() < 2) {
            return;
        }
        StringBuffer mesBuf = null;
        block0: for (int i = 0; i < this.playerList.size(); ++i) {
            PlayerLayoutModel amodel = (PlayerLayoutModel)this.playerList.get(i);
            MediaDescriptor amd = amodel.player.getMediaDescriptor();
            if (amd == null || !amd.mimeType.equals("audio/x-wav")) continue;
            for (int j = 0; j < this.playerList.size(); ++j) {
                PlayerLayoutModel vmodel = (PlayerLayoutModel)this.playerList.get(j);
                MediaDescriptor vmd = vmodel.player.getMediaDescriptor();
                if (vmd == null || !MediaDescriptorUtil.isVideoType(vmd) || !vmd.mediaURL.equals(amd.extractedFrom) || j == 0 || vmd.timeOrigin == amd.timeOrigin) continue;
                if (mesBuf == null) {
                    mesBuf = new StringBuffer(ElanLocale.getString("LinkedFilesDialog.Message.OffsetNotEqual") + "\n\n");
                }
                mesBuf.append("- " + vmd.mediaURL + "\n");
                mesBuf.append("- " + amd.mediaURL + "\n\n");
                continue block0;
            }
        }
        if (mesBuf != null) {
            JOptionPane.showMessageDialog(this.container, mesBuf.toString(), ElanLocale.getString("Message.Warning"), 2);
        }
    }

    public List getVisualPlayers() {
        ArrayList<MediaDescriptor> visuals = new ArrayList<MediaDescriptor>(this.playerList.size());
        PlayerLayoutModel model = null;
        for (int i = 0; i < this.playerList.size(); ++i) {
            model = (PlayerLayoutModel)this.playerList.get(i);
            if (!model.isVisual()) continue;
            visuals.add(model.player.getMediaDescriptor());
        }
        return visuals;
    }

    public void cleanUpOnClose() {
        this.container.removeAll();
        if (this.timeLineComponent != null) {
            this.timeLineComponent.removeAll();
        }
        this.multiTierControlPanel = null;
        this.timeLineViewer = null;
        this.interlinearViewer = null;
        this.container = null;
        this.viewerManager = null;
        this.elanFrame = null;
    }

    public JFrame getElanFrame() {
        return this.elanFrame;
    }

    public ViewerManager2 getViewerManager() {
        return this.viewerManager;
    }

    public int getMediaAreaHeight() {
        return this.mediaAreaHeight;
    }

    public void setMediaAreaHeight(int mediaAreaHeight) {
        this.mediaAreaHeight = mediaAreaHeight >= 40 ? (mediaAreaHeight < this.container.getHeight() - 50 ? mediaAreaHeight : this.container.getHeight() - 50) : 40;
        this.setPreference("LayoutManager.MediaAreaHeight", new Integer(this.mediaAreaHeight), this.viewerManager.getTranscription());
        this.doLayout();
    }

    public int getMultiTierControlPanelWidth() {
        return this.multiTierControlPanelWidth;
    }

    public void setMultiTierControlPanelWidth(int multiTierControlPanelWidth) {
        this.multiTierControlPanelWidth = multiTierControlPanelWidth >= 40 ? (multiTierControlPanelWidth < this.container.getWidth() - 50 ? multiTierControlPanelWidth : this.container.getWidth() - 50) : 40;
        this.setPreference("LayoutManager.ControlPanelWidth", new Integer(this.multiTierControlPanelWidth), this.viewerManager.getTranscription());
        this.doLayout();
    }

    public void setPreference(String key, Object value, Object document) {
        if (document instanceof Transcription) {
            Preferences.set(key, value, (Transcription)document, false, false);
        } else {
            Preferences.set(key, value, null, false, false);
        }
    }

    public void preferencesChanged() {
        int i;
        Object val;
        Boolean sameSize;
        Boolean ttShown;
        Integer sigHeight;
        String conViewerName;
        Integer cpWidth;
        Integer selIndex = (Integer)Preferences.get("LayoutManager.SelectedTabIndex", this.viewerManager.getTranscription());
        if (selIndex != null) {
            int index = selIndex;
            if (index >= 0 && index < this.tabPane.getTabCount()) {
                this.tabPane.setSelectedIndex(index);
            } else {
                this.tabPane.setSelectedIndex(0);
            }
        }
        Rectangle wRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Integer medHeight = (Integer)Preferences.get("LayoutManager.MediaAreaHeight", this.viewerManager.getTranscription());
        if (medHeight != null && medHeight >= 40) {
            this.mediaAreaHeight = medHeight;
            if (this.mediaAreaHeight > wRect.height - 120) {
                this.mediaAreaHeight = wRect.height - 120;
            }
        }
        if ((cpWidth = (Integer)Preferences.get("LayoutManager.ControlPanelWidth", this.viewerManager.getTranscription())) != null && cpWidth >= 40) {
            this.multiTierControlPanelWidth = cpWidth;
        }
        if ((conViewerName = (String)Preferences.get("LayoutManager.VisibleMultiTierViewer", this.viewerManager.getTranscription())) != null && conViewerName.equals(TimeLineViewer.class.getName())) {
            if (this.timeLineViewer != null) {
                this.showTimeLineViewer();
                this.getMultiTierControlPanel().setViewer(this.timeLineViewer);
            }
        } else if (conViewerName != null && conViewerName.equals(InterlinearViewer.class.getName()) && this.interlinearViewer != null) {
            this.showInterlinearViewer();
            this.getMultiTierControlPanel().setViewer(this.interlinearViewer);
        }
        if ((sigHeight = (Integer)Preferences.get("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription())) != null && sigHeight > 70 && (this.signalViewer != null || this.timeseriesViewer != null) && this.timeLineSplitPane != null) {
            this.timeLineSplitPane.setDividerLocation(sigHeight);
        }
        if ((sigHeight = (Integer)Preferences.get("LayoutManager.TSWavSplitPaneDividerLocation", this.viewerManager.getTranscription())) != null && this.wav_tsSplitPane != null) {
            this.wav_tsSplitPane.setDividerLocation(sigHeight);
        }
        if (this.tabPane != null) {
            for (int i2 = 0; i2 < this.tabPane.getTabCount(); ++i2) {
                String tierName;
                SingleTierViewerPanel panel;
                JComponent comp = (JComponent)this.tabPane.getComponent(i2);
                if (comp instanceof SingleTierViewerPanel) {
                    String tierName2;
                    panel = (SingleTierViewerPanel)comp;
                    if (panel.getViewer() instanceof GridViewer) {
                        Boolean multiGrid = (Boolean)Preferences.get("GridViewer.MultiTierMode", this.viewerManager.getTranscription());
                        if (multiGrid != null) {
                            panel.setMultiTierMode(multiGrid);
                        }
                        if ((tierName = (String)Preferences.get("GridViewer.TierName", this.viewerManager.getTranscription())) == null) continue;
                        panel.selectTier(tierName);
                        continue;
                    }
                    if (!(panel.getViewer() instanceof TextViewer) || (tierName2 = (String)Preferences.get("TextViewer.TierName", this.viewerManager.getTranscription())) == null) continue;
                    panel.selectTier(tierName2);
                    continue;
                }
                if (comp != this.subtitlePanel) continue;
                Component[] subComps = comp.getComponents();
                int index = 0;
                for (int j = 0; j < subComps.length; ++j) {
                    if (!(subComps[j] instanceof SingleTierViewerPanel) || !((panel = (SingleTierViewerPanel)subComps[j]).getViewer() instanceof SubtitleViewer)) continue;
                    index = ((SubtitleViewer)panel.getViewer()).getViewerIndex();
                    tierName = (String)Preferences.get("SubTitleViewer.TierName-" + index, this.viewerManager.getTranscription());
                    if (tierName == null) continue;
                    panel.selectTier(tierName);
                }
            }
        }
        if ((ttShown = (Boolean)Preferences.get("UI.ToolTips.Enabled", null)) != null) {
            ToolTipManager.sharedInstance().setEnabled(ttShown);
        }
        if ((sameSize = (Boolean)Preferences.get("Media.VideosSameSize", null)) != null) {
            this.oneRowForVisuals = sameSize;
        }
        if ((val = Preferences.get("PreferencesDialog.Viewer.SortOrder", null)) instanceof List) {
            this.viewerSortOrder = (List)val;
        }
        if ((val = Preferences.get("Media.VideosCentre", null)) instanceof Boolean) {
            this.mediaInCentre = (Boolean)val;
        }
        if (this.mediaInCentre) {
            val = Preferences.get("PreferencesDialog.Viewer.Grid.Right", null);
            if (val instanceof Boolean) {
                boolean bl = this.gridViewerLeft = (Boolean)val == false;
            }
            if ((val = Preferences.get("PreferencesDialog.Viewer.Text.Right", null)) instanceof Boolean) {
                boolean bl = this.textViewerLeft = (Boolean)val == false;
            }
            if ((val = Preferences.get("PreferencesDialog.Viewer.Subtitle.Right", null)) instanceof Boolean) {
                boolean bl = this.subtitleViewerLeft = (Boolean)val == false;
            }
            if ((val = Preferences.get("PreferencesDialog.Viewer.Lexicon.Right", null)) instanceof Boolean) {
                boolean bl = this.lexiconViewerLeft = (Boolean)val == false;
            }
            if ((val = Preferences.get("PreferencesDialog.Viewer.Audio.Right", null)) instanceof Boolean) {
                boolean bl = this.audioRecognizerLeft = (Boolean)val == false;
            }
            if ((val = Preferences.get("PreferencesDialog.Viewer.Video.Right", null)) instanceof Boolean) {
                boolean bl = this.videoRecognizerLeft = (Boolean)val == false;
            }
            if ((val = Preferences.get("PreferencesDialog.Viewer.MetaData.Right", null)) instanceof Boolean) {
                this.metaDataLeft = (Boolean)val == false;
            }
        }
        ArrayList<String> newViewersList = new ArrayList<String>();
        ArrayList<String> removeViewersList = new ArrayList<String>();
        val = Preferences.get("Menu.View.Viewers.Grid", null);
        if (val instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                newViewersList.add("Menu.View.Viewers.Grid");
            } else {
                removeViewersList.add("Menu.View.Viewers.Grid");
            }
        }
        if ((val = Preferences.get("Menu.View.Viewers.Text", null)) instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                newViewersList.add("Menu.View.Viewers.Text");
            } else {
                removeViewersList.add("Menu.View.Viewers.Text");
            }
        }
        if ((val = Preferences.get("Menu.View.Viewers.Subtitles", null)) instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                newViewersList.add("Menu.View.Viewers.Subtitles");
            } else {
                removeViewersList.add("Menu.View.Viewers.Subtitles");
            }
        }
        if ((val = Preferences.get("LexiconEntryViewer.Lexicon", null)) instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                newViewersList.add("LexiconEntryViewer.Lexicon");
            } else {
                removeViewersList.add("LexiconEntryViewer.Lexicon");
            }
        }
        if ((val = Preferences.get("Menu.View.Viewers.Audio", null)) instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                newViewersList.add("Menu.View.Viewers.Audio");
            } else {
                removeViewersList.add("Menu.View.Viewers.Audio");
            }
        }
        if ((val = Preferences.get("Menu.View.Viewers.Video", null)) instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                newViewersList.add("Menu.View.Viewers.Video");
            } else {
                removeViewersList.add("Menu.View.Viewers.Video");
            }
        }
        if ((val = Preferences.get("Menu.View.Viewers.MetaData", null)) instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                newViewersList.add("Menu.View.Viewers.MetaData");
            } else {
                removeViewersList.add("Menu.View.Viewers.MetaData");
            }
        }
        if ((val = Preferences.get("Menu.View.Viewers.Signal", null)) instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                newViewersList.add("Menu.View.Viewers.Signal");
            } else {
                removeViewersList.add("Menu.View.Viewers.Signal");
            }
        }
        if ((val = Preferences.get("Menu.View.Viewers.InterLinear", null)) instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                newViewersList.add("Menu.View.Viewers.InterLinear");
            } else {
                removeViewersList.add("Menu.View.Viewers.InterLinear");
            }
        }
        for (i = 0; i < newViewersList.size(); ++i) {
            if (this.availableViewersList.contains(newViewersList.get(i))) continue;
            this.availableViewersList.add((String)newViewersList.get(i));
        }
        for (i = 0; i < removeViewersList.size(); ++i) {
            if (!this.availableViewersList.contains(removeViewersList.get(i))) continue;
            this.availableViewersList.remove(removeViewersList.get(i));
        }
        this.preferenceChanged = true;
        this.doLayout();
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.tabPane) {
            // empty if block
        }
        if (e.getSource() == this.leftTabPane) {
            // empty if block
        }
    }

    private class ViewerLayoutModel {
        final AbstractViewer viewer;
        private boolean attached;
        private DetachedFrame detachedFrame;

        ViewerLayoutModel(AbstractViewer viewer) {
            this.viewer = viewer;
            this.attached = true;
            this.detachedFrame = null;
        }

        boolean isAttached() {
            return this.attached;
        }

        void detach() {
            if (!this.attached) {
                return;
            }
            String title = this.viewer.getClass().getName();
            int index = title.lastIndexOf(46);
            if (index > 0) {
                title = title.substring(index + 1, title.length());
            }
            this.detachedFrame = new DetachedViewerFrame(ElanLayoutManager.this, this.viewer, title);
            this.detachedFrame.setSize(500, 300);
            this.detachedFrame.setVisible(true);
            this.viewer.preferencesChanged();
            this.attached = false;
        }

        void attach() {
            if (this.attached || this.detachedFrame == null) {
                return;
            }
            this.detachedFrame.getContentPane().remove(this.viewer);
            this.detachedFrame.setVisible(false);
            this.detachedFrame.dispose();
            this.detachedFrame = null;
            this.attached = true;
        }
    }

    private class PlayerLayoutModel {
        final ElanMediaPlayer player;
        private boolean attached;
        private DetachedFrame detachedFrame;
        Component visualComponent;
        private boolean displayedFirst;
        private boolean syncOnly = false;

        PlayerLayoutModel(ElanMediaPlayer player) {
            this.player = player;
            this.visualComponent = player.getVisualComponent();
            this.attached = true;
            this.detachedFrame = null;
            this.displayedFirst = false;
        }

        public void setDisplayedFirst(boolean first) {
            this.displayedFirst = first;
        }

        public boolean isDisplayedFirst() {
            return this.displayedFirst;
        }

        boolean isAttached() {
            return this.attached;
        }

        boolean isVisual() {
            if (this.player instanceof EmptyMediaPlayer) {
                return false;
            }
            return this.visualComponent != null;
        }

        void detach() {
            if (!this.attached || !this.isVisual()) {
                return;
            }
            if (this.player instanceof QTMediaPlayer) {
                this.visualComponent = ((QTMediaPlayer)this.player).createNewVisualComponent();
            }
            if (this.player instanceof CocoaQTMediaPlayer) {
                this.visualComponent = ((CocoaQTMediaPlayer)this.player).createNewVisualComponent();
            }
            this.detachedFrame = new DetachedFrame(ElanLayoutManager.this, this.visualComponent, this.player.getMediaDescriptor().mediaURL);
            this.detachedFrame.setAspectRatio(this.player.getAspectRatio());
            this.detachedFrame.setSize(400, 400);
            this.detachedFrame.setVisible(true);
            this.attached = false;
        }

        void attach() {
            if (this.attached || !this.isVisual() || this.detachedFrame == null) {
                return;
            }
            this.detachedFrame.getContentPane().remove(this.visualComponent);
            this.detachedFrame.setVisible(false);
            this.detachedFrame.dispose();
            this.detachedFrame = null;
            this.attached = true;
            if (this.player instanceof QTMediaPlayer) {
                this.visualComponent = ((QTMediaPlayer)this.player).createNewVisualComponent();
            }
            if (this.player instanceof CocoaQTMediaPlayer) {
                this.visualComponent = ((CocoaQTMediaPlayer)this.player).createNewVisualComponent();
            }
        }
    }

    private class SignalSplitPaneListener
    extends ComponentAdapter {
        private SignalSplitPaneListener() {
        }

        public void componentResized(ComponentEvent e) {
            if (e == null || e.getComponent() == null) {
                return;
            }
            JSplitPane splitPane = null;
            if (e.getComponent().getParent() instanceof JSplitPane) {
                splitPane = (JSplitPane)e.getComponent().getParent();
            }
            if (splitPane == null) {
                return;
            }
            if (splitPane != null) {
                Component bottom;
                Component top = splitPane.getTopComponent();
                if (top instanceof JSplitPane) {
                    top = ((JSplitPane)top).getBottomComponent();
                }
                if (top != null && top instanceof Container) {
                    int height = top.getHeight();
                    Component[] cc = ((Container)top).getComponents();
                    for (int i = 0; i < cc.length; ++i) {
                        if (cc[i].getHeight() == height) continue;
                        cc[i].setSize(cc[i].getWidth(), height);
                    }
                }
                if ((bottom = splitPane.getBottomComponent()) != null && bottom instanceof Container) {
                    int height = splitPane.getHeight() - splitPane.getDividerLocation() - splitPane.getDividerSize();
                    Component[] cc = ((Container)bottom).getComponents();
                    for (int i = 0; i < cc.length; ++i) {
                        if (cc[i].getHeight() == height) continue;
                        cc[i].setSize(cc[i].getWidth(), height);
                    }
                }
                if (splitPane == ElanLayoutManager.this.timeLineSplitPane) {
                    ElanLayoutManager.this.setPreference("LayoutManager.SplitPaneDividerLocation", new Integer(ElanLayoutManager.this.timeLineSplitPane.getDividerLocation()), ElanLayoutManager.this.viewerManager.getTranscription());
                } else if (splitPane == ElanLayoutManager.this.wav_tsSplitPane) {
                    ElanLayoutManager.this.setPreference("LayoutManager.TSWavSplitPaneDividerLocation", new Integer(ElanLayoutManager.this.wav_tsSplitPane.getDividerLocation()), ElanLayoutManager.this.viewerManager.getTranscription());
                }
            }
        }
    }

    private class ContainerComponentListener
    extends ComponentAdapter {
        private ContainerComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            ElanLayoutManager.this.doLayout();
        }
    }
}

