/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.AnnotationNavigationPanel;
import mpi.eudico.client.annotator.DurationPanel;
import mpi.eudico.client.annotator.MediaPlayerControlSlider;
import mpi.eudico.client.annotator.ModePanel;
import mpi.eudico.client.annotator.PlayButtonsPanel;
import mpi.eudico.client.annotator.SelectionButtonsPanel;
import mpi.eudico.client.annotator.SelectionPanel;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.gui.ElanSlider;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.AnnotationDensityViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StartEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;

public class ElanMediaPlayerController
extends AbstractViewer {
    private static final Dimension BUTTON_SIZE = new Dimension(30, 20);
    private long userTimeBetweenLoops = 500L;
    private ViewerManager2 vm;
    private ElanSlider rateslider;
    private ElanSlider volumeslider;
    private SelectionPanel selectionpanel;
    private DurationPanel durationPanel;
    private PlayButtonsPanel playButtonsPanel;
    private AnnotationNavigationPanel annotationPanel;
    private SelectionButtonsPanel selectionButtonsPanel;
    private ModePanel modePanel;
    private long stopTime = 0L;
    private boolean playingSelection = false;
    private boolean bLoopMode = false;
    private boolean bSelectionMode = false;
    private boolean bBeginBoundaryActive = false;
    private LoopThread loopThread;

    public ElanMediaPlayerController(ViewerManager2 theVM) {
        this.vm = theVM;
        this.rateslider = new ElanSlider("ELANSLIDERRATE", 0, 200, 100, this.vm);
        this.volumeslider = new ElanSlider("ELANSLIDERVOLUME", 0, 100, 100, this.vm);
        this.selectionpanel = new SelectionPanel(this.vm);
        this.durationPanel = new DurationPanel(this.vm.getMasterMediaPlayer().getMediaDuration());
        this.playButtonsPanel = new PlayButtonsPanel(this.getButtonSize(), this.vm);
        this.annotationPanel = new AnnotationNavigationPanel(this.getButtonSize(), this.vm);
        this.selectionButtonsPanel = new SelectionButtonsPanel(this.getButtonSize(), this.vm);
        this.modePanel = new ModePanel(this.vm, this);
    }

    public Dimension getButtonSize() {
        return BUTTON_SIZE;
    }

    public long getUserTimeBetweenLoops() {
        return this.userTimeBetweenLoops;
    }

    public void setUserTimeBetweenLoops(long loopTime) {
        this.userTimeBetweenLoops = loopTime;
    }

    public MediaPlayerControlSlider getSliderPanel() {
        return this.vm.getMediaPlayerControlSlider();
    }

    public AnnotationDensityViewer getAnnotationDensityViewer() {
        return this.vm.getAnnotationDensityViewer();
    }

    public JComponent getRatePanel() {
        return this.rateslider;
    }

    public void setRate(float rate) {
        super.setRate(rate);
        this.rateslider.setValue((int)(100.0f * rate));
    }

    public JComponent getVolumePanel() {
        return this.volumeslider;
    }

    public void setVolume(float volume) {
        super.setVolume(volume);
        this.volumeslider.setValue((int)(100.0f * volume));
    }

    public JPanel getModePanel() {
        return this.modePanel;
    }

    public SelectionButtonsPanel getSelectionButtonsPanel() {
        return this.selectionButtonsPanel;
    }

    public PlayButtonsPanel getPlayButtonsPanel() {
        return this.playButtonsPanel;
    }

    public AnnotationNavigationPanel getAnnotationNavigationPanel() {
        return this.annotationPanel;
    }

    public JComponent getDurationPanel() {
        return this.durationPanel;
    }

    public JComponent getTimePanel() {
        return this.vm.getTimePanel();
    }

    public JPanel getSelectionPanel() {
        return this.selectionpanel;
    }

    public void updateActiveAnnotation() {
    }

    public void updateLocale() {
    }

    public void updateSelection() {
    }

    private void adjustSelection() {
        long currTime = this.getMediaTime();
        long beginTime = this.getSelectionBeginTime();
        long endTime = this.getSelectionEndTime();
        if (this.bBeginBoundaryActive) {
            beginTime = currTime;
        } else {
            endTime = currTime;
        }
        if (beginTime > endTime) {
            this.setSelection(endTime, beginTime);
            this.toggleActiveSelectionBoundary();
        } else {
            this.setSelection(beginTime, endTime);
        }
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof StartEvent) {
            return;
        }
        if (event instanceof TimeEvent && System.currentTimeMillis() - this.stopTime < 700L) {
            return;
        }
        if (event instanceof StopEvent) {
            if (!this.bLoopMode) {
                this.playingSelection = false;
            }
            this.stopTime = System.currentTimeMillis();
            if (this.isBeginBoundaryActive() && this.getMediaTime() == this.getSelectionEndTime()) {
                this.toggleActiveSelectionBoundary();
            }
        }
        if (!this.playingSelection && this.bSelectionMode) {
            this.adjustSelection();
        }
    }

    public void setPlaySelectionMode(boolean b) {
        this.playingSelection = b;
    }

    public boolean isPlaySelectionMode() {
        return this.playingSelection;
    }

    public void setLoopMode(boolean b) {
        this.bLoopMode = b;
        this.modePanel.updateLoopMode(this.bLoopMode);
    }

    public boolean getLoopMode() {
        return this.bLoopMode;
    }

    public void doToggleLoopMode() {
        this.bLoopMode = !this.bLoopMode;
    }

    public boolean getSelectionMode() {
        return this.bSelectionMode;
    }

    public void doToggleSelectionMode() {
        this.bSelectionMode = !this.bSelectionMode;
        this.modePanel.updateSelectionMode(this.bSelectionMode);
        this.getModePanel().revalidate();
    }

    public void toggleActiveSelectionBoundary() {
        this.bBeginBoundaryActive = !this.bBeginBoundaryActive;
        if (!this.playerIsPlaying()) {
            this.setMediaTime(this.getMediaTime());
        }
    }

    public boolean isBeginBoundaryActive() {
        return this.bBeginBoundaryActive;
    }

    public void startLoop(long begin, long end) {
        if (this.loopThread != null && this.loopThread.isAlive()) {
            this.loopThread.stopLoop();
        }
        this.loopThread = new LoopThread(begin, end);
        this.loopThread.start();
    }

    public void stopLoop() {
        this.setPlaySelectionMode(false);
        if (this.loopThread != null && this.loopThread.isAlive()) {
            this.loopThread.stopLoop();
        }
    }

    public void preferencesChanged() {
        Float rate;
        Float volume = (Float)this.getPreference("MediaControlVolume", this.vm.getTranscription());
        if (volume != null) {
            this.setVolume(volume.floatValue());
        }
        if ((rate = (Float)this.getPreference("MediaControlRate", this.vm.getTranscription())) != null) {
            this.setRate(rate.floatValue());
        }
    }

    private class LoopThread
    extends Thread {
        private long beginTime;
        private long endTime;
        private boolean stopLoop = false;

        LoopThread(long begin, long end) {
            this.beginTime = begin;
            this.endTime = end;
        }

        public void stopLoop() {
            this.stopLoop = true;
        }

        public void run() {
            while (!this.stopLoop && ElanMediaPlayerController.this.getLoopMode()) {
                if (!ElanMediaPlayerController.this.playerIsPlaying()) {
                    ElanMediaPlayerController.this.playInterval(this.beginTime, this.endTime);
                }
                while (ElanMediaPlayerController.this.playerIsPlaying()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception ex) {}
                }
                try {
                    Thread.sleep(ElanMediaPlayerController.this.getUserTimeBetweenLoops());
                }
                catch (Exception exception) {}
            }
        }
    }
}

