/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.util.Vector;
import mpi.eudico.client.annotator.SelectionListener;
import mpi.eudico.server.corpora.clom.Annotation;

public class Selection {
    private Vector listeners = new Vector();
    private long selectionBeginTime = 0L;
    private long selectionEndTime = 0L;
    private long previousSelectionBeginTime = 0L;
    private long previousSelectionEndTime = 0L;

    public void setSelection(long beginTime, long endTime) {
        if (this.selectionBeginTime != beginTime | this.selectionEndTime != endTime) {
            this.previousSelectionBeginTime = this.selectionBeginTime;
            this.previousSelectionEndTime = this.selectionEndTime;
            this.selectionBeginTime = beginTime;
            this.selectionEndTime = endTime;
            this.notifyListeners();
        }
    }

    public void setSelection(Annotation annotation) {
        if (annotation != null) {
            this.setSelection(annotation.getBeginTimeBoundary(), annotation.getEndTimeBoundary());
        }
    }

    public void clear() {
        this.setSelection(0L, 0L);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((SelectionListener)this.listeners.elementAt(i)).updateSelection();
        }
    }

    public long getBeginTime() {
        return this.selectionBeginTime;
    }

    public long getEndTime() {
        return this.selectionEndTime;
    }

    public long getPreviousBeginTime() {
        return this.previousSelectionBeginTime;
    }

    public long getPreviousEndTime() {
        return this.previousSelectionEndTime;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
        listener.updateSelection();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }
}

