/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.MultiSourcePlayer;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.util.TimeFormatter;

public class SyncManager
implements ActionListener,
ItemListener {
    private ViewerManager2 viewerManager;
    private ElanLayoutManager layoutManager;
    private ElanMediaPlayer playerInFocus;
    private Hashtable nameForPlayer;
    private Hashtable playerForName;
    private Hashtable labelForPlayer;
    private Hashtable playerButtons;
    private ButtonGroup buttonGroup;
    private JRadioButton connectedButton;
    private JRadioButton absOffsetRB;
    private JRadioButton relOffsetRB;
    private JRadioButton allPlayersRB;
    private JPanel contentPanel;
    private JPanel playerPanel;
    private JPanel offsetPanel;
    private ButtonGroup playerGroup;
    private JButton applyButton;
    private boolean connected;
    private long minOffset;
    private boolean relative;

    public SyncManager(ViewerManager2 viewerManager, ElanLayoutManager layoutManager) {
        this.viewerManager = viewerManager;
        this.layoutManager = layoutManager;
        this.nameForPlayer = new Hashtable();
        this.playerForName = new Hashtable();
        this.labelForPlayer = new Hashtable();
        this.playerButtons = new Hashtable();
        this.buttonGroup = new ButtonGroup();
        this.contentPanel = new JPanel(new GridLayout(1, 2));
        this.playerPanel = new JPanel(new GridLayout(0, 1));
        this.offsetPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        this.absOffsetRB = new JRadioButton();
        this.absOffsetRB.setFont(Constants.SMALLFONT);
        this.absOffsetRB.setSelected(true);
        this.absOffsetRB.addItemListener(this);
        this.buttonGroup.add(this.absOffsetRB);
        this.offsetPanel.add((Component)this.absOffsetRB, gbc);
        this.connectedButton = this.absOffsetRB;
        gbc.gridy = 1;
        this.relOffsetRB = new JRadioButton();
        this.relOffsetRB.setFont(Constants.SMALLFONT);
        this.relOffsetRB.setSelected(false);
        this.relOffsetRB.addItemListener(this);
        this.buttonGroup.add(this.relOffsetRB);
        this.offsetPanel.add((Component)this.relOffsetRB, gbc);
        this.applyButton = new JButton();
        this.applyButton.setFont(Constants.SMALLFONT);
        this.applyButton.addActionListener(this);
        gbc.gridy = 2;
        this.offsetPanel.add((Component)this.applyButton, gbc);
        this.connected = true;
        this.playerGroup = new ButtonGroup();
        this.allPlayersRB = new JRadioButton();
        this.allPlayersRB.setFont(Constants.SMALLFONT);
        this.allPlayersRB.setSelected(true);
        this.allPlayersRB.addItemListener(this);
        this.playerGroup.add(this.allPlayersRB);
        this.playerPanel.add(this.allPlayersRB);
        this.contentPanel.add(this.offsetPanel);
        this.contentPanel.add(this.playerPanel);
        this.updateLocale();
    }

    public void add(ElanMediaPlayer player) {
        int size = 1;
        while (this.playerForName.containsKey(String.valueOf(size))) {
            ++size;
        }
        String name = String.valueOf(size);
        this.nameForPlayer.put(player, name);
        this.playerForName.put(name, player);
        this.labelForPlayer.put(player, this.createLabelPanel(player));
        JRadioButton button = new JRadioButton(ElanLocale.getString("SyncMode.Label.Player") + " " + name);
        button.setFont(Constants.SMALLFONT);
        button.addItemListener(this);
        this.playerButtons.put(player, button);
        this.playerGroup.add(button);
        this.playerPanel.add(button);
    }

    public void remove(ElanMediaPlayer player) {
        if (this.nameForPlayer.containsKey(player)) {
            this.playerForName.remove(this.nameForPlayer.get(player));
            this.nameForPlayer.remove(player);
            this.labelForPlayer.remove(player);
            ((JRadioButton)this.playerButtons.get(player)).removeItemListener(this);
            this.buttonGroup.remove((JRadioButton)this.playerButtons.get(player));
            this.playerPanel.remove((JRadioButton)this.playerButtons.get(player));
            this.playerButtons.remove(player);
        }
    }

    public JPanel getPlayerSelectionPanel() {
        return this.contentPanel;
    }

    public JPanel getPlayerLabel(ElanMediaPlayer player) {
        if (!this.nameForPlayer.containsKey(player)) {
            return null;
        }
        JPanel panel = (JPanel)this.labelForPlayer.get(player);
        if (panel == null) {
            panel = this.createLabelPanel(player);
            this.labelForPlayer.put(player, panel);
            return panel;
        }
        Container playPanel = (Container)panel.getComponent(0);
        Component nameComp = playPanel.getComponent(0);
        if (nameComp instanceof JLabel) {
            JLabel nameLabel = (JLabel)nameComp;
            String name = ElanLocale.getString("SyncMode.Label.Player") + " " + (String)this.nameForPlayer.get(player) + " " + ElanLocale.getString("SyncMode.Label.Offset") + ": ";
            nameLabel.setText(name);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridx = 1;
        gbc.anchor = 16;
        gbc.insets = new Insets(1, 1, 1, 1);
        if (playPanel.getComponentCount() > 1) {
            playPanel.remove(1);
        }
        if (player == this.playerInFocus) {
            playPanel.add((Component)this.viewerManager.getTimePanel(), gbc);
        } else {
            JLabel offsetLabel = new JLabel();
            offsetLabel.setText(TimeFormatter.toString(player.getOffset()));
            playPanel.add((Component)offsetLabel, gbc);
        }
        if (player instanceof MultiSourcePlayer) {
            JComboBox box = null;
            JLabel fileLabel = null;
            Component[] comps = panel.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof JComboBox) {
                    box = (JComboBox)comps[i];
                }
                if (!(comps[i] instanceof JLabel)) continue;
                fileLabel = (JLabel)comps[i];
            }
            String[] sources = ((MultiSourcePlayer)((Object)player)).getDescriptorStrings();
            if (box != null) {
                block1: for (int i = 0; i < sources.length; ++i) {
                    for (int j = 0; j < box.getItemCount(); ++j) {
                        if (box.getItemAt(j).equals(sources[i])) continue block1;
                    }
                    box.addItem(sources[i]);
                }
                block3: for (int j = 0; j < box.getItemCount(); ++j) {
                    for (int i = 0; i < sources.length; ++i) {
                        if (box.getItemAt(j).equals(sources[i])) continue block3;
                    }
                    box.removeItemAt(j);
                }
                if (fileLabel != null) {
                    fileLabel.setText((String)box.getSelectedItem());
                }
            }
        }
        return panel;
    }

    private JPanel createLabelPanel(ElanMediaPlayer player) {
        JPanel panel = new JPanel(new GridBagLayout());
        if (!this.nameForPlayer.containsKey(player)) {
            return panel;
        }
        JLabel nameLabel = new JLabel();
        JPanel playPanel = new JPanel(new GridBagLayout());
        String name = ElanLocale.getString("SyncMode.Label.Player") + " " + (String)this.nameForPlayer.get(player) + " " + ElanLocale.getString("SyncMode.Label.Offset") + ": ";
        nameLabel.setText(name);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 14;
        gbc.insets = new Insets(1, 1, 1, 1);
        playPanel.add((Component)nameLabel, gbc);
        gbc.gridx = 1;
        gbc.anchor = 16;
        if (player == this.playerInFocus) {
            playPanel.add((Component)this.viewerManager.getTimePanel(), gbc);
        } else {
            JLabel offsetLabel = new JLabel();
            offsetLabel.setText(TimeFormatter.toString(player.getOffset()));
            playPanel.add((Component)offsetLabel, gbc);
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        panel.add((Component)playPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 10;
        JLabel fileLabel = new JLabel();
        fileLabel.setFont(Constants.SMALLFONT);
        if (player.getMediaDescriptor() != null) {
            fileLabel.setText(FileUtility.fileNameFromPath(player.getMediaDescriptor().mediaURL));
        } else {
            fileLabel.setText("-");
        }
        panel.add((Component)fileLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 10;
        if (player instanceof MultiSourcePlayer) {
            JComboBox<String> box = new JComboBox<String>();
            String[] sources = ((MultiSourcePlayer)((Object)player)).getDescriptorStrings();
            for (int i = 0; i < sources.length; ++i) {
                box.addItem(sources[i]);
                if (i != 0) continue;
                fileLabel.setText(sources[i]);
            }
            box.addItemListener(this);
            panel.add(box, gbc);
        }
        return panel;
    }

    public boolean connectedPlayers() {
        return this.connected;
    }

    private void setOffset() {
        if (this.playerInFocus != null) {
            this.viewerManager.setOffset(this.playerInFocus, this.playerInFocus.getMediaTime());
        }
    }

    private void setRelativeOffsets() {
        ElanMediaPlayer player;
        this.minOffset = Long.MAX_VALUE;
        Enumeration en = this.playerForName.elements();
        while (en.hasMoreElements()) {
            player = (ElanMediaPlayer)en.nextElement();
            if (player.getOffset() >= this.minOffset) continue;
            this.minOffset = player.getOffset();
        }
        en = this.playerForName.elements();
        while (en.hasMoreElements()) {
            player = (ElanMediaPlayer)en.nextElement();
            long offset = player.getOffset();
            this.viewerManager.setOffset(player, offset - this.minOffset);
        }
        this.viewerManager.getMasterMediaPlayer().setMediaTime(this.minOffset);
        this.relative = true;
    }

    private void setAbsoluteOffsets() {
        Enumeration en = this.playerForName.elements();
        while (en.hasMoreElements()) {
            ElanMediaPlayer player = (ElanMediaPlayer)en.nextElement();
            long offset = player.getOffset();
            this.viewerManager.setOffset(player, offset);
        }
        this.viewerManager.getMasterMediaPlayer().setMediaTime(0L);
        this.relative = false;
    }

    public void reconnect() {
        this.setOffset();
        this.playerInFocus = null;
        if (this.layoutManager.getMasterMediaPlayer() != null) {
            this.viewerManager.setMasterMediaPlayer(this.layoutManager.getMasterMediaPlayer());
            this.viewerManager.enableDisabledMediaPlayers();
        }
        this.connected = true;
        this.allPlayersRB.removeItemListener(this);
        this.allPlayersRB.setSelected(true);
        this.allPlayersRB.addItemListener(this);
    }

    private void setFocussedPlayer(ElanMediaPlayer elanPlayer) {
        if (elanPlayer == null) {
            return;
        }
        this.setOffset();
        this.playerInFocus = elanPlayer;
        this.viewerManager.setMasterMediaPlayer(this.playerInFocus);
        this.viewerManager.disableSlaveMediaPlayers();
        long offset = this.playerInFocus.getOffset();
        this.playerInFocus.setOffset(0L);
        this.playerInFocus.setMediaTime(offset);
        this.connected = false;
        this.layoutManager.doLayout();
    }

    private void updateMultiPlayer(JComboBox sourceComponent) {
        Iterator playIt = this.labelForPlayer.keySet().iterator();
        Object playerObj = null;
        JPanel panel = null;
        block0: while (playIt.hasNext()) {
            playerObj = playIt.next();
            panel = (JPanel)this.labelForPlayer.get(playerObj);
            Component[] comps = panel.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] == sourceComponent) break block0;
            }
            panel = null;
            playerObj = null;
        }
        if (panel != null && playerObj instanceof MultiSourcePlayer) {
            MultiSourcePlayer player = playerObj;
            String source = (String)sourceComponent.getSelectedItem();
            if (source != null) {
                player.setCurrentSource(source);
                this.layoutManager.doLayout();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.applyButton) {
            this.allPlayersRB.setSelected(true);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() instanceof JComboBox) {
                this.updateMultiPlayer((JComboBox)e.getSource());
            } else if (e.getSource() == this.absOffsetRB) {
                this.relative = false;
                if (!this.allPlayersRB.isSelected()) {
                    this.allPlayersRB.setSelected(true);
                } else {
                    this.setAbsoluteOffsets();
                }
            } else if (e.getSource() == this.relOffsetRB) {
                this.relative = true;
                if (!this.allPlayersRB.isSelected()) {
                    this.allPlayersRB.setEnabled(true);
                } else {
                    this.setRelativeOffsets();
                }
            } else if (e.getSource() == this.allPlayersRB) {
                this.reconnect();
                if (this.relative) {
                    this.setRelativeOffsets();
                } else {
                    this.setAbsoluteOffsets();
                }
                this.layoutManager.doLayout();
            } else if (this.playerButtons.containsValue(e.getSource())) {
                Enumeration en = this.playerButtons.keys();
                while (en.hasMoreElements()) {
                    Object player = en.nextElement();
                    if (this.playerButtons.get(player) != e.getSource()) continue;
                    this.setFocussedPlayer((ElanMediaPlayer)player);
                    break;
                }
            }
        }
    }

    public void updateLocale() {
        this.offsetPanel.setBorder(new TitledBorder(ElanLocale.getString("SyncMode.Label.Offset")));
        this.absOffsetRB.setText(ElanLocale.getString("SyncMode.Label.Absolute"));
        this.relOffsetRB.setText(ElanLocale.getString("SyncMode.Label.Relative"));
        this.applyButton.setText(ElanLocale.getString("SyncMode.Button.Apply"));
        this.playerPanel.setBorder(new TitledBorder(ElanLocale.getString("SyncMode.Label.Player")));
        this.allPlayersRB.setText(ElanLocale.getString("SyncMode.Label.AllPlayers"));
        Enumeration en = this.nameForPlayer.keys();
        while (en.hasMoreElements()) {
            Object player = en.nextElement();
            JRadioButton b = (JRadioButton)this.playerButtons.get(player);
            b.setText(ElanLocale.getString("SyncMode.Label.Player") + " " + this.nameForPlayer.get(player));
            JPanel p = (JPanel)this.labelForPlayer.get(player);
            try {
                JLabel l = (JLabel)p.getComponent(0);
                String name = ElanLocale.getString("SyncMode.Label.Player") + " " + (String)this.nameForPlayer.get(player) + " " + ElanLocale.getString("SyncMode.Label.Offset") + ": ";
                l.setText(name);
            }
            catch (Exception e) {}
        }
    }
}

