/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.TimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsFromGapsCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private long mediaDuration;
    private String[] sourceTiers;
    private String destTierName;
    private String annValue;
    private String timeFormat;
    private boolean destTierCreated = false;
    private List<AnnotationDataRecord> createdAnnos;

    public AnnotationsFromGapsCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void redo() {
        if (this.transcription != null) {
            TierImpl dt = (TierImpl)this.transcription.getTierWithId(this.destTierName);
            if (dt == null) {
                dt = (TierImpl)this.transcription.getTierWithId(this.sourceTiers[0]);
                LinguisticType lType = dt.getLinguisticType();
                if (lType.getConstraints() != null) {
                    ClientLogger.LOG.severe("The source tier is not a root tier.");
                    return;
                }
                TierImpl dTier = new TierImpl(null, this.destTierName, dt.getParticipant(), this.transcription, lType);
                dTier.setAnnotator(dt.getAnnotator());
                dTier.setDefaultLocale(dt.getDefaultLocale());
                this.transcription.addTier(dTier);
                dt = dTier;
            }
            if (dt == null) {
                ClientLogger.LOG.severe("Could not find the destination tier for redo");
                return;
            }
            if (this.createdAnnos == null && this.createdAnnos.size() == 0) {
                ClientLogger.LOG.info("No annotations to restore");
                return;
            }
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.transcription.setNotifying(false);
            for (int i = 0; i < this.createdAnnos.size(); ++i) {
                AnnotationDataRecord record = this.createdAnnos.get(i);
                Annotation ann = dt.createAnnotation(record.getBeginTime(), record.getEndTime());
                if (ann == null || record.getValue() == null) continue;
                ann.setValue(record.getValue());
            }
            this.transcription.setNotifying(true);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    @Override
    public void undo() {
        if (this.transcription != null) {
            if (this.destTierCreated) {
                Tier dt = this.transcription.getTierWithId(this.destTierName);
                if (dt != null) {
                    this.transcription.removeTier(dt);
                }
            } else {
                TierImpl st = (TierImpl)this.transcription.getTierWithId(this.destTierName);
                if (st != null && this.createdAnnos != null && this.createdAnnos.size() > 0) {
                    this.transcription.setNotifying(false);
                    for (int i = 0; i < this.createdAnnos.size(); ++i) {
                        AnnotationDataRecord record = this.createdAnnos.get(i);
                        Annotation ann = st.getAnnotationAtTime((record.getBeginTime() + record.getEndTime()) / 2L);
                        if (ann == null) continue;
                        st.removeAnnotation(ann);
                    }
                    this.transcription.setNotifying(true);
                }
            }
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.sourceTiers = (String[])arguments[0];
        this.destTierName = (String)arguments[1];
        this.annValue = (String)arguments[2];
        this.timeFormat = (String)arguments[3];
        this.mediaDuration = (Long)arguments[4];
        if (this.timeFormat != null) {
            this.annValue = null;
        }
        this.createdAnnos = new ArrayList<AnnotationDataRecord>();
        this.createAnnotations();
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void createAnnotations() {
        ArrayList<TierImpl> tierList = new ArrayList<TierImpl>();
        for (int i = 0; i < this.sourceTiers.length; ++i) {
            TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.sourceTiers[i]);
            if (tier == null) {
                ClientLogger.LOG.severe("The source tier '" + this.sourceTiers[i] + "' was not found");
                return;
            }
            tierList.add(tier);
        }
        LinguisticType lType = null;
        for (int i = 0; i < tierList.size(); ++i) {
            lType = ((TierImpl)tierList.get(i)).getLinguisticType();
            if (lType.getConstraints() == null) continue;
            ClientLogger.LOG.severe("The source tier is not a root tier.");
            return;
        }
        TierImpl dTier = null;
        dTier = (TierImpl)this.transcription.getTierWithId(this.destTierName);
        if (dTier == null) {
            dTier = new TierImpl(null, this.destTierName, ((TierImpl)tierList.get(0)).getParticipant(), this.transcription, lType);
            dTier.setAnnotator(tierList.get(0).getAnnotator());
            dTier.setDefaultLocale(tierList.get(0).getDefaultLocale());
            this.transcription.addTier(dTier);
            this.destTierCreated = true;
        }
        int curPropMode = this.transcription.getTimeChangePropagationMode();
        this.transcription.setNotifying(false);
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        ArrayList<Gap> commonGaps = this.getCommonGaps(tierList);
        AlignableAnnotation aa = null;
        for (int i = 0; i < commonGaps.size(); ++i) {
            Gap gap = commonGaps.get(i);
            aa = (AlignableAnnotation)dTier.createAnnotation(gap.begin, gap.end);
            if (aa != null) {
                if (this.timeFormat != null) {
                    aa.setValue(this.getTimeString(gap.end - gap.begin));
                } else if (this.annValue != null) {
                    aa.setValue(this.annValue);
                }
                this.createdAnnos.add(new AnnotationDataRecord(aa));
                continue;
            }
            ClientLogger.LOG.warning("Annotation could not be created " + gap.begin + "-" + gap.end);
        }
        ClientLogger.LOG.info("Number of annotations created: " + commonGaps.size());
        if (this.transcription.getTimeChangePropagationMode() != curPropMode) {
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
        this.transcription.setNotifying(true);
    }

    private String getTimeString(long time) {
        if ("hh:mm:ss.ms".equals(this.timeFormat)) {
            return TimeFormatter.toString(time);
        }
        if ("ss.ms".equals(this.timeFormat)) {
            return TimeFormatter.toSSMSString(time);
        }
        return String.valueOf(time);
    }

    private ArrayList<Gap> getCommonGaps(ArrayList<TierImpl> tierList) {
        long beginTime;
        int i;
        ArrayList<Gap> gapList = new ArrayList<Gap>();
        if (tierList.size() <= 0) {
            return gapList;
        }
        TierImpl currentTier = tierList.get(0);
        Vector annotations = currentTier.getAnnotations();
        long timeSoFar = 0L;
        if (annotations.size() <= 0) {
            gapList.add(new Gap(0L, this.mediaDuration));
            return gapList;
        }
        for (i = 0; i < annotations.size(); ++i) {
            AbstractAnnotation abstrAnnotation = (AbstractAnnotation)annotations.get(i);
            beginTime = abstrAnnotation.getBeginTimeBoundary();
            if (beginTime > timeSoFar) {
                gapList.add(new Gap(timeSoFar, beginTime));
            }
            timeSoFar = abstrAnnotation.getEndTimeBoundary();
        }
        if (timeSoFar < this.mediaDuration) {
            gapList.add(new Gap(timeSoFar, this.mediaDuration));
        }
        for (i = 1; i < tierList.size() && gapList.size() > 0; ++i) {
            currentTier = tierList.get(i);
            annotations = currentTier.getAnnotations();
            for (int gapNr = 0; gapNr < gapList.size() && annotations.size() > 0; ++gapNr) {
                AbstractAnnotation abstrAnnotation = (AbstractAnnotation)annotations.get(0);
                beginTime = abstrAnnotation.getBeginTimeBoundary();
                long endTime = abstrAnnotation.getEndTimeBoundary();
                if (beginTime > gapList.get((int)gapNr).begin && endTime < gapList.get((int)gapNr).end) {
                    long temp = gapList.get((int)gapNr).end;
                    gapList.get((int)gapNr).end = beginTime;
                    gapList.add(gapNr + 1, new Gap(endTime, temp));
                    annotations.remove(0);
                    continue;
                }
                if (beginTime < gapList.get((int)gapNr).begin && endTime > gapList.get((int)gapNr).begin && endTime < gapList.get((int)gapNr).end) {
                    gapList.get((int)gapNr).begin = endTime;
                    annotations.remove(0);
                    --gapNr;
                    continue;
                }
                if (beginTime > gapList.get((int)gapNr).begin && beginTime < gapList.get((int)gapNr).end && endTime > gapList.get((int)gapNr).end) {
                    gapList.get((int)gapNr).end = beginTime;
                    continue;
                }
                if (beginTime > gapList.get((int)gapNr).end) continue;
                if (beginTime < gapList.get((int)gapNr).begin && endTime < gapList.get((int)gapNr).begin) {
                    annotations.remove(0);
                    --gapNr;
                    continue;
                }
                if (beginTime >= gapList.get((int)gapNr).begin || endTime <= gapList.get((int)gapNr).end) continue;
                gapList.remove(gapNr);
                --gapNr;
            }
        }
        return gapList;
    }

    private class Gap {
        public long begin;
        public long end;

        public Gap(long begin, long end) {
            this.begin = begin;
            this.end = end;
        }
    }
}

