/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.ControlledVocabulary;

public class ChangeCVCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private String oldCVName;
    private String oldCVDesc;
    private String cvName;
    private String description;
    private ControlledVocabulary conVoc;

    public ChangeCVCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        if (this.transcription != null && this.conVoc != null) {
            this.transcription.changeControlledVocabulary(this.conVoc, this.oldCVName, this.oldCVDesc);
        }
    }

    public void redo() {
        if (this.transcription != null && this.conVoc != null) {
            this.transcription.changeControlledVocabulary(this.conVoc, this.cvName, this.description);
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.oldCVName = (String)arguments[0];
        if (arguments[1] != null) {
            this.oldCVDesc = (String)arguments[1];
        }
        this.cvName = (String)arguments[2];
        if (arguments[3] != null) {
            this.description = (String)arguments[3];
        }
        this.conVoc = this.transcription.getControlledVocabulary(this.oldCVName);
        if (this.conVoc != null) {
            this.transcription.changeControlledVocabulary(this.conVoc, this.cvName, this.description);
        }
    }

    public String getName() {
        return this.commandName;
    }
}

