/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.Vector;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.linkedmedia.LinkedFileDescriptorUtil;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ChangeLinkedFilesCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private Vector oldDescriptors;
    private Vector newDescriptors;
    private boolean areMediaDesc = true;

    public ChangeLinkedFilesCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        if (this.transcription != null && this.oldDescriptors != null) {
            if (this.areMediaDesc) {
                this.updateMediaPlayers(this.transcription, this.oldDescriptors);
            } else {
                this.updateLinkedFiles(this.transcription, this.oldDescriptors);
            }
        }
    }

    public void redo() {
        if (this.transcription != null && this.newDescriptors != null) {
            if (this.areMediaDesc) {
                this.updateMediaPlayers(this.transcription, this.newDescriptors);
            } else {
                this.updateLinkedFiles(this.transcription, this.newDescriptors);
            }
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        if (arguments != null && arguments.length >= 1) {
            this.newDescriptors = (Vector)arguments[0];
            if (arguments.length > 1) {
                this.areMediaDesc = (Boolean)arguments[1];
            }
        }
        if (this.transcription != null) {
            if (this.areMediaDesc) {
                this.oldDescriptors = this.transcription.getMediaDescriptors();
                this.updateMediaPlayers(this.transcription, this.newDescriptors);
                ElanFrame2 ef2 = (ElanFrame2)ELANCommandFactory.getRootFrame(this.transcription);
                if (ef2 != null) {
                    ElanMediaPlayer master = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer();
                    ef2.setMenuEnabled(740, !master.isFrameRateAutoDetected());
                    ef2.updateMenu(610);
                }
            } else {
                this.oldDescriptors = this.transcription.getLinkedFileDescriptors();
                this.updateLinkedFiles(this.transcription, this.newDescriptors);
            }
        }
    }

    private void updateMediaPlayers(TranscriptionImpl transcription, Vector descriptors) {
        if (transcription == null || descriptors == null) {
            return;
        }
        MediaDescriptorUtil.updateMediaPlayers(transcription, descriptors);
    }

    private void updateLinkedFiles(TranscriptionImpl transcription, Vector descriptors) {
        if (transcription == null || descriptors == null) {
            return;
        }
        LinkedFileDescriptorUtil.updateLinkedFiles(transcription, descriptors);
    }

    public String getName() {
        return this.commandName;
    }
}

