/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.Vector;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.gui.IndeterminateProgressMonitor;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;

public class ChangeTypeCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private String oldTypeName;
    private Constraint oldConstraint;
    private String oldCVName;
    private boolean oldTimeAlignable;
    private boolean oldGraphicsAllowed;
    private String oldDcId;
    private LexiconQueryBundle2 oldQueryBundle;
    private String typeName;
    private Constraint constraint;
    private String cvName;
    private boolean timeAlignable;
    private boolean graphicsAllowed;
    private String dcId;
    private LexiconQueryBundle2 queryBundle;
    private LinguisticType linType;
    ArrayList storedGraphicsData;

    public ChangeTypeCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        if (this.linType != null) {
            Vector<Constraint> constraints = new Vector<Constraint>();
            constraints.add(this.oldConstraint);
            this.transcription.changeLinguisticType(this.linType, this.oldTypeName, constraints, this.oldCVName, this.oldTimeAlignable, this.oldGraphicsAllowed, this.oldDcId, this.oldQueryBundle);
            if (this.oldGraphicsAllowed != this.graphicsAllowed) {
                new ConversionThread(this.transcription, this.linType).start();
            }
        }
    }

    public void redo() {
        if (this.linType != null) {
            Vector<Constraint> constraints = new Vector<Constraint>();
            constraints.add(this.constraint);
            this.transcription.changeLinguisticType(this.linType, this.typeName, constraints, this.cvName, this.timeAlignable, this.graphicsAllowed, this.dcId, this.queryBundle);
            if (this.oldGraphicsAllowed != this.graphicsAllowed) {
                new ConversionThread(this.transcription, this.linType).start();
            }
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.typeName = (String)arguments[0];
        this.constraint = (Constraint)arguments[1];
        this.cvName = (String)arguments[2];
        this.timeAlignable = (Boolean)arguments[3];
        this.graphicsAllowed = (Boolean)arguments[4];
        this.linType = (LinguisticType)arguments[5];
        if (arguments.length >= 7) {
            this.dcId = (String)arguments[6];
        }
        if (arguments.length >= 8) {
            this.queryBundle = (LexiconQueryBundle2)arguments[7];
        }
        this.oldTypeName = this.linType.getLinguisticTypeName();
        this.oldConstraint = this.linType.getConstraints();
        this.oldCVName = this.linType.getControlledVocabylaryName();
        this.oldTimeAlignable = this.linType.isTimeAlignable();
        this.oldGraphicsAllowed = this.linType.hasGraphicReferences();
        this.oldDcId = this.linType.getDataCategory();
        this.oldQueryBundle = this.linType.getLexiconQueryBundle();
        Vector<Constraint> constraints = new Vector<Constraint>();
        constraints.add(this.constraint);
        this.transcription.changeLinguisticType(this.linType, this.typeName, constraints, this.cvName, this.timeAlignable, this.graphicsAllowed, this.dcId, this.queryBundle);
        if (this.oldGraphicsAllowed != this.graphicsAllowed) {
            if (this.oldGraphicsAllowed) {
                new ConversionThread(this.transcription, this.linType).start(true);
            } else {
                new ConversionThread(this.transcription, this.linType).start();
            }
        }
    }

    public String getName() {
        return this.commandName;
    }

    class ConversionThread
    extends Thread {
        TranscriptionImpl transcription;
        LinguisticType type;
        boolean storeGraphicsData = false;

        public ConversionThread(TranscriptionImpl transcription, LinguisticType type) {
            this.transcription = transcription;
            this.type = type;
        }

        public void start(boolean storeGraphicsData) {
            this.storeGraphicsData = storeGraphicsData;
            this.start();
        }

        public void run() {
            final IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor(ELANCommandFactory.getRootFrame(this.transcription), true, ElanLocale.getString("EditTypeDialog.Message.Convert"), false, null);
            new Thread(new Runnable(){

                public void run() {
                    monitor.show();
                }
            }).start();
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.transcription.setNotifying(false);
            if (this.storeGraphicsData) {
                ChangeTypeCommand.this.storedGraphicsData = AnnotationRecreator.storeGraphicsData((Transcription)this.transcription, this.type);
            }
            AnnotationRecreator.convertAnnotations((Transcription)this.transcription, this.type);
            if (ChangeTypeCommand.this.storedGraphicsData != null && this.type.hasGraphicReferences()) {
                AnnotationRecreator.restoreGraphicsData(this.transcription, ChangeTypeCommand.this.storedGraphicsData);
            }
            this.transcription.setNotifying(true);
            this.transcription.setTimeChangePropagationMode(curPropMode);
            monitor.close();
        }
    }
}

