/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.Vector;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.RedoCA;
import mpi.eudico.client.annotator.commands.UndoCA;
import mpi.eudico.client.annotator.commands.UndoableCommand;

public class CommandHistory {
    public static final int historySize = 25;
    private Vector history;
    private int currentCommand;
    private UndoCA undoCA;
    private RedoCA redoCA;

    public CommandHistory(int size) {
        if (size > 0) {
            this.history = new Vector(size);
            for (int i = 0; i < size; ++i) {
                this.history.add(null);
            }
        }
    }

    public void addCommand(Command theCommand) {
        if (this.currentCommand > 0) {
            for (Command c : this.history) {
                int index = this.history.indexOf(c);
                if (index > this.currentCommand - 1) {
                    this.history.setElementAt(c, index - (this.currentCommand - 1));
                }
                if (this.currentCommand == 1) continue;
                this.history.setElementAt(null, index);
            }
        } else if (this.currentCommand == 0) {
            for (int i = this.history.size() - 2; i >= 0; --i) {
                this.history.setElementAt(this.history.elementAt(i), i + 1);
            }
        }
        this.history.setElementAt(theCommand, 0);
        this.adjustCurrentCommand(0);
    }

    private void adjustCurrentCommand(int newIndex) {
        this.currentCommand = newIndex;
        if (this.currentCommand < this.history.size() && this.history.elementAt(this.currentCommand) != null) {
            String undoString = ElanLocale.getString("Menu.Edit.Undo");
            undoString = undoString + " ";
            undoString = undoString + ElanLocale.getString(((Command)this.history.elementAt(this.currentCommand)).getName());
            this.undoCA.putValue("Name", undoString);
            this.undoCA.setEnabled(true);
        } else {
            this.undoCA.putValue("Name", ElanLocale.getString("Menu.Edit.Undo"));
            this.undoCA.setEnabled(false);
        }
        if (this.currentCommand > 0) {
            String redoString = ElanLocale.getString("Menu.Edit.Redo");
            redoString = redoString + " ";
            redoString = redoString + ElanLocale.getString(((Command)this.history.elementAt(this.currentCommand - 1)).getName());
            this.redoCA.putValue("Name", redoString);
            this.redoCA.setEnabled(true);
        } else {
            this.redoCA.putValue("Name", ElanLocale.getString("Menu.Edit.Redo"));
            this.redoCA.setEnabled(false);
        }
    }

    public void undo() {
        if (this.history.elementAt(this.currentCommand) != null) {
            ((UndoableCommand)this.history.elementAt(this.currentCommand)).undo();
            ++this.currentCommand;
            this.adjustCurrentCommand(this.currentCommand);
        }
    }

    public void redo() {
        if (this.currentCommand > 0) {
            --this.currentCommand;
            ((UndoableCommand)this.history.elementAt(this.currentCommand)).redo();
            this.adjustCurrentCommand(this.currentCommand);
        }
    }

    public void setUndoCA(UndoCA theUndoCA) {
        this.undoCA = theUndoCA;
    }

    public void setRedoCA(RedoCA theRedoCA) {
        this.redoCA = theRedoCA;
    }

    public String toString() {
        String s = "\n";
        for (int i = 0; i < this.history.size(); ++i) {
            if (this.history.elementAt(i) == null) continue;
            s = i == this.currentCommand ? s + "-> " : s + "   ";
            s = s + ((Command)this.history.elementAt(i)).getName() + "\n";
        }
        return s;
    }
}

