/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class DeleteAnnotationCommand
implements UndoableCommand {
    private String commandName;
    private AbstractAnnotation annotation;
    private TierImpl tier;
    private DefaultMutableTreeNode annRootNode;
    private Transcription transcription;

    public DeleteAnnotationCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        if (this.tier != null && this.annRootNode != null) {
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.setWaitCursor(true);
            AnnotationRecreator.createAnnotationFromTree((TranscriptionImpl)this.tier.getParent(), this.annRootNode, true);
            this.setWaitCursor(false);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    public void redo() {
        if (this.tier != null && this.annRootNode != null) {
            this.setWaitCursor(true);
            AnnotationDataRecord annRecord = (AnnotationDataRecord)this.annRootNode.getUserObject();
            long begin = annRecord.getBeginTime();
            long end = annRecord.getEndTime();
            long mid = (begin + end) / 2L;
            Annotation aa = this.tier.getAnnotationAtTime(mid);
            if (aa != null) {
                this.tier.removeAnnotation(aa);
            }
            this.setWaitCursor(false);
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 vm = (ViewerManager2)arguments[0];
        this.transcription = vm.getTranscription();
        this.tier = (TierImpl)receiver;
        this.setWaitCursor(true);
        this.annotation = (AbstractAnnotation)arguments[1];
        if (vm.getActiveAnnotation().getAnnotation() == this.annotation) {
            vm.getActiveAnnotation().setAnnotation(null);
        }
        this.annRootNode = AnnotationRecreator.createTreeForAnnotation(this.annotation);
        this.tier.removeAnnotation(this.annotation);
        this.setWaitCursor(false);
    }

    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

