/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class DeleteAnnotationsCommand
implements UndoableCommand {
    private String commandName;
    private Transcription transcription;
    private String tierName;
    private List<String> rootTiers;
    private Long bt;
    private Long et;
    private List<DefaultMutableTreeNode> delAnnRecords;

    public DeleteAnnotationsCommand(String name) {
        this.commandName = name;
    }

    public void redo() {
        this.deleteAnnotations();
    }

    public void undo() {
        if (this.transcription != null && this.delAnnRecords != null) {
            if (this.tierName != null) {
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.tierName);
                if (tier == null) {
                    ClientLogger.LOG.warning("The tier could not be found: " + this.tierName);
                    return;
                }
                int curPropMode = 0;
                curPropMode = this.transcription.getTimeChangePropagationMode();
                if (curPropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(0);
                }
                ((TranscriptionImpl)this.transcription).setNotifying(false);
                this.setWaitCursor(true);
                if (!tier.hasParentTier()) {
                    for (DefaultMutableTreeNode n : this.delAnnRecords) {
                        AnnotationRecreator.createAnnotationFromTree(this.transcription, n, true);
                    }
                } else {
                    AnnotationRecreator.createAnnotationsSequentially(this.transcription, (ArrayList)this.delAnnRecords, true);
                }
                this.setWaitCursor(false);
                this.transcription.setTimeChangePropagationMode(curPropMode);
                ((TranscriptionImpl)this.transcription).setNotifying(true);
            } else if (this.rootTiers != null && this.rootTiers.size() > 0) {
                int curPropMode = 0;
                curPropMode = this.transcription.getTimeChangePropagationMode();
                if (curPropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(0);
                }
                ((TranscriptionImpl)this.transcription).setNotifying(false);
                this.setWaitCursor(true);
                for (DefaultMutableTreeNode n : this.delAnnRecords) {
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, n, true);
                }
                this.setWaitCursor(false);
                this.transcription.setTimeChangePropagationMode(curPropMode);
                ((TranscriptionImpl)this.transcription).setNotifying(true);
            }
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        if (arguments != null) {
            TierImpl tier = (TierImpl)arguments[0];
            if (tier != null) {
                this.tierName = tier.getName();
            } else {
                this.rootTiers = new ArrayList<String>();
                Vector allTiers = this.transcription.getTiers();
                TierImpl tier2 = null;
                for (int i = 0; i < allTiers.size(); ++i) {
                    tier2 = (TierImpl)allTiers.get(i);
                    if (tier2.getParentTier() != null || !tier2.isTimeAlignable()) continue;
                    this.rootTiers.add(tier2.getName());
                }
            }
            this.bt = (Long)arguments[1];
            this.et = (Long)arguments[2];
            this.delAnnRecords = new ArrayList<DefaultMutableTreeNode>();
            this.setWaitCursor(true);
            this.storeAnnotationTrees(tier, this.bt, this.et);
            this.deleteAnnotations();
            this.setWaitCursor(false);
        }
    }

    private void storeAnnotationTrees(TierImpl tier, long begin, long end) {
        block4: {
            block5: {
                if (tier == null) break block5;
                Vector annos = tier.getAnnotations();
                for (int i = 0; i < annos.size(); ++i) {
                    AbstractAnnotation annotation = (AbstractAnnotation)annos.get(i);
                    if (annotation.getEndTimeBoundary() < begin) continue;
                    if (annotation.getBeginTimeBoundary() < end) {
                        DefaultMutableTreeNode node;
                        if (annotation.getBeginTimeBoundary() < begin || annotation.getEndTimeBoundary() > end || (node = AnnotationRecreator.createTreeForAnnotation(annotation)) == null) continue;
                        this.delAnnRecords.add(node);
                        continue;
                    }
                    break block4;
                }
                break block4;
            }
            if (this.rootTiers == null || this.rootTiers.size() <= 0) break block4;
            TierImpl tier2 = null;
            block1: for (String tName : this.rootTiers) {
                tier2 = (TierImpl)this.transcription.getTierWithId(tName);
                if (tier2 == null) continue;
                Vector annos = tier2.getAnnotations();
                for (int i = 0; i < annos.size(); ++i) {
                    DefaultMutableTreeNode node;
                    AbstractAnnotation annotation = (AbstractAnnotation)annos.get(i);
                    if (annotation.getEndTimeBoundary() < begin) continue;
                    if (annotation.getBeginTimeBoundary() >= end) continue block1;
                    if (annotation.getBeginTimeBoundary() < begin || annotation.getEndTimeBoundary() > end || (node = AnnotationRecreator.createTreeForAnnotation(annotation)) == null) continue;
                    this.delAnnRecords.add(node);
                }
            }
        }
    }

    private void deleteAnnotations() {
        if (this.delAnnRecords != null && this.delAnnRecords.size() > 0) {
            AnnotationDataRecord record;
            TierImpl tier;
            ArrayList<AbstractAnnotation> toDelete = new ArrayList<AbstractAnnotation>(this.delAnnRecords.size());
            if (this.tierName != null) {
                tier = (TierImpl)this.transcription.getTierWithId(this.tierName);
                if (tier == null) {
                    ClientLogger.LOG.warning("The tier could not be found: " + this.tierName);
                    return;
                }
                for (DefaultMutableTreeNode n : this.delAnnRecords) {
                    record = (AnnotationDataRecord)n.getUserObject();
                    AbstractAnnotation abstractAnnotation = (AbstractAnnotation)tier.getAnnotationAtTime((record.getBeginTime() + record.getEndTime()) / 2L);
                    if (abstractAnnotation == null) continue;
                    toDelete.add(abstractAnnotation);
                }
            } else {
                tier = null;
                for (DefaultMutableTreeNode n : this.delAnnRecords) {
                    record = (AnnotationDataRecord)n.getUserObject();
                    tier = (TierImpl)this.transcription.getTierWithId(record.getTierName());
                    if (tier == null) {
                        ClientLogger.LOG.warning("The tier could not be found: " + record.getTierName());
                        continue;
                    }
                    AbstractAnnotation abstractAnnotation = (AbstractAnnotation)tier.getAnnotationAtTime((record.getBeginTime() + record.getEndTime()) / 2L);
                    if (abstractAnnotation == null) continue;
                    toDelete.add(abstractAnnotation);
                }
            }
            ((TranscriptionImpl)this.transcription).setNotifying(false);
            for (Annotation annotation : toDelete) {
                ((TierImpl)annotation.getTier()).removeAnnotation(annotation);
            }
            ((TranscriptionImpl)this.transcription).setNotifying(true);
        }
    }

    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

