/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.HashMap;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;

public class DeleteLexLinkCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private LexiconLink link;
    private HashMap<LinguisticType, LexiconQueryBundle2> effectedTypes;

    public DeleteLexLinkCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        if (this.transcription != null && this.link != null) {
            this.transcription.addLexiconLink(this.link);
            for (LinguisticType type : this.effectedTypes.keySet()) {
                type.setLexiconQueryBundle(this.effectedTypes.get(type));
            }
        }
    }

    public void redo() {
        if (this.transcription != null) {
            this.transcription.removeLexiconLink(this.link);
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.link = (LexiconLink)arguments[0];
        if (this.transcription != null) {
            this.effectedTypes = new HashMap();
            for (LinguisticType type : this.transcription.getLinguisticTypesWithLexLink(this.link.getName())) {
                this.effectedTypes.put(type, type.getLexiconQueryBundle());
            }
            this.transcription.removeLexiconLink(this.link);
        }
    }

    public String getName() {
        return this.commandName;
    }
}

