/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.AWTException;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.util.LogUtil;

public class ExportImageFromWindowCommand
implements Command {
    static final Logger LOG = Logger.getLogger(ExportImageFromWindowCommand.class.getName());
    private String commandName;

    public ExportImageFromWindowCommand(String theName) {
        this.commandName = theName;
    }

    public void execute(Object receiver, Object[] arguments) {
        TranscriptionImpl transcription = (TranscriptionImpl)arguments[0];
        JFrame frame = ELANCommandFactory.getRootFrame(transcription);
        String saveDir = (String)Preferences.get("MediaDir", null);
        if (saveDir == null) {
            saveDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser(saveDir);
        chooser.setFileFilter(ElanFileFilter.createFileFilter(10));
        int option = chooser.showSaveDialog(frame);
        if (option == 0) {
            File saveFile;
            String imageIOType = "jpg";
            File curDir = chooser.getCurrentDirectory();
            if (curDir != null) {
                Preferences.set("MediaDir", curDir.getAbsolutePath(), null);
            }
            if ((saveFile = chooser.getSelectedFile()) != null) {
                int answer;
                String fileName = saveFile.getAbsolutePath();
                String lowerFileName = fileName.toLowerCase();
                if (lowerFileName.endsWith("png")) {
                    imageIOType = "png";
                } else if (lowerFileName.endsWith("bmp")) {
                    imageIOType = "bmp";
                } else if (!lowerFileName.endsWith("jpg") && !lowerFileName.endsWith("jpeg")) {
                    fileName = fileName + ".jpg";
                }
                File newSaveFile = new File(fileName);
                if (newSaveFile.exists() && (answer = JOptionPane.showConfirmDialog(null, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0)) == 1) {
                    return;
                }
                new CaptureThread(frame, imageIOType, newSaveFile).start();
            }
        }
    }

    public String getName() {
        return this.commandName;
    }

    class CaptureThread
    extends Thread {
        private JFrame frame;
        private String imageType;
        private File saveFile;

        CaptureThread(JFrame frame, String imageType, File saveFile) {
            this.frame = frame;
            this.imageType = imageType;
            this.saveFile = saveFile;
        }

        public void run() {
            try {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Robot robot = new Robot();
                BufferedImage image = robot.createScreenCapture(this.frame.getBounds());
                ImageIO.write((RenderedImage)image, this.imageType, this.saveFile);
            }
            catch (AWTException ae) {
                LOG.warning(LogUtil.formatStackTrace((Throwable)ae));
            }
            catch (IOException ioe) {
                LOG.warning(LogUtil.formatStackTrace((Throwable)ioe));
            }
        }
    }
}

