/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Transcription;

public class ImportPrefsCommand
implements Command {
    private String commandName;
    private Transcription transcription;

    public ImportPrefsCommand(String name) {
        this.commandName = name;
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (Transcription)receiver;
        if (this.transcription == null) {
            return;
        }
        String filePath = this.promptForImportFile();
        if (filePath == null) {
            return;
        }
        Preferences.importPreferences(this.transcription, filePath);
    }

    public String getName() {
        return this.commandName;
    }

    private String promptForImportFile() {
        String prefDir = (String)Preferences.get("LastUsedExportDir", null);
        if (prefDir == null) {
            prefDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText(ElanLocale.getString("ImportDialog.Approve"));
        chooser.setCurrentDirectory(new File(prefDir));
        chooser.setDialogTitle(ElanLocale.getString("ImportDialog.Title.Select"));
        File prefFile = null;
        FileFilter filter = ElanFileFilter.createFileFilter(19);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filter);
        if (chooser.showOpenDialog(ELANCommandFactory.getRootFrame(this.transcription)) == 0) {
            File curDir = chooser.getCurrentDirectory();
            if (curDir != null) {
                Preferences.set("LastUsedExportDir", curDir.getAbsolutePath(), null);
            }
            if ((prefFile = chooser.getSelectedFile()) != null) {
                String name = prefFile.getAbsolutePath();
                if (!this.isValidFile(name)) {
                    JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("Message.InvalidFile"), ElanLocale.getString("Message.Error"), 0);
                    return null;
                }
                return name;
            }
        }
        return null;
    }

    private boolean isValidFile(String name) {
        if (name == null) {
            return false;
        }
        File f = new File(name);
        if (!f.exists()) {
            return false;
        }
        String lowerPathName = name.toLowerCase();
        String[] exts = FileExtension.ELAN_XML_PREFS_EXT;
        for (int i = 0; i < exts.length; ++i) {
            if (!lowerPathName.endsWith("." + exts[i])) continue;
            return true;
        }
        return false;
    }
}

