/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.svg.SVGAnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.MutableInt;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeAnnotationsCommand
implements UndoableCommand {
    private String commandName;
    private Transcription transcription;
    private AnnotationDataRecord activeAnnRecord;
    private AnnotationDataRecord mergeAnnRecord;
    private DefaultMutableTreeNode activeNode;
    private DefaultMutableTreeNode mergeAnnNode;
    private DefaultMutableTreeNode mergeAnnNodeComp;
    private boolean simpleMerge = false;
    private boolean mergeWithNext = false;

    public MergeAnnotationsCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void redo() {
        if (this.simpleMerge) {
            this.mergeSimple();
        } else {
            this.mergeComplex();
        }
    }

    @Override
    public void undo() {
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        ((TranscriptionImpl)this.transcription).setNotifying(false);
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        if (this.simpleMerge) {
            TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.activeAnnRecord.getTierName());
            if (tier != null) {
                AlignableAnnotation aa2;
                AlignableAnnotation aa = (AlignableAnnotation)tier.getAnnotationAtTime(this.activeAnnRecord.getBeginTime());
                if (aa != null) {
                    if (this.mergeWithNext) {
                        aa.updateTimeInterval(aa.getBeginTimeBoundary(), this.activeAnnRecord.getEndTime());
                        aa.setValue(this.activeAnnRecord.getValue());
                    } else {
                        aa.updateTimeInterval(this.activeAnnRecord.getBeginTime(), this.activeAnnRecord.getEndTime());
                        aa.setValue(this.activeAnnRecord.getValue());
                    }
                }
                if ((aa2 = (AlignableAnnotation)tier.createAnnotation(this.mergeAnnRecord.getBeginTime(), this.mergeAnnRecord.getEndTime())) != null) {
                    aa2.setValue(this.mergeAnnRecord.getValue());
                    aa2.setId(this.mergeAnnRecord.getId());
                    if (aa2 instanceof SVGAlignableAnnotation && this.mergeAnnRecord instanceof SVGAnnotationDataRecord) {
                        SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)this.mergeAnnRecord;
                        if (svgRec.getShape() != null) {
                            ((SVGAlignableAnnotation)aa2).setShape(svgRec.getShape());
                        }
                        if (svgRec.getSvgElementId() != null) {
                            ((SVGAlignableAnnotation)aa2).setSVGElementID(svgRec.getSvgElementId());
                        }
                    }
                    if (this.mergeAnnRecord.getExtRef() != null) {
                        aa2.setExtRef(this.mergeAnnRecord.getExtRef());
                    }
                }
            } else {
                ClientLogger.LOG.warning("Cannot undo annotation merge: tier not found");
            }
        } else {
            AnnotationDataRecord annData = (AnnotationDataRecord)this.activeNode.getUserObject();
            TierImpl rootTier = (TierImpl)this.transcription.getTierWithId(annData.getTierName());
            if (rootTier != null) {
                AlignableAnnotation aaAct = (AlignableAnnotation)rootTier.getAnnotationAtTime(annData.getBeginTime());
                if (aaAct != null) {
                    rootTier.removeAnnotation(aaAct);
                }
                AnnotationRecreator.createAnnotationFromTree(this.transcription, this.activeNode, true);
                AnnotationRecreator.createAnnotationFromTree(this.transcription, this.mergeAnnNode, true);
            }
        }
        ((TranscriptionImpl)this.transcription).setNotifying(true);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (Transcription)receiver;
        this.mergeWithNext = (Boolean)arguments[1];
        if (arguments.length > 0 && arguments[0] instanceof AlignableAnnotation) {
            AlignableAnnotation aa = (AlignableAnnotation)arguments[0];
            AlignableAnnotation mergeAnn = null;
            mergeAnn = this.mergeWithNext ? (AlignableAnnotation)((TierImpl)aa.getTier()).getAnnotationAfter(aa) : (AlignableAnnotation)((TierImpl)aa.getTier()).getAnnotationBefore(aa);
            if (mergeAnn != null) {
                if (aa.getParentListeners().size() == 0 && mergeAnn.getParentListeners().size() == 0) {
                    this.activeAnnRecord = new AnnotationDataRecord(aa);
                    this.mergeAnnRecord = mergeAnn instanceof SVGAlignableAnnotation ? new SVGAnnotationDataRecord((SVGAlignableAnnotation)mergeAnn) : new AnnotationDataRecord(mergeAnn);
                    this.simpleMerge = true;
                    this.mergeSimple();
                } else {
                    this.activeNode = AnnotationRecreator.createTreeForAnnotation(aa);
                    this.mergeAnnNode = AnnotationRecreator.createTreeForAnnotation(mergeAnn);
                    this.mergeAnnNodeComp = AnnotationRecreator.createTreeForAnnotation(mergeAnn);
                    this.recalculateSymbolicSubdivisions(this.activeNode, this.mergeAnnNodeComp, aa.getBeginTimeBoundary(), mergeAnn.getEndTimeBoundary());
                    this.mergeComplex();
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void mergeSimple() {
        AlignableAnnotation aa;
        TierImpl tier;
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        ((TranscriptionImpl)this.transcription).setNotifying(false);
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        if ((tier = (TierImpl)this.transcription.getTierWithId(this.activeAnnRecord.getTierName())) != null && (aa = (AlignableAnnotation)tier.getAnnotationAtTime(this.activeAnnRecord.getBeginTime())) != null) {
            if (this.mergeWithNext) {
                aa.updateTimeInterval(aa.getBeginTimeBoundary(), this.mergeAnnRecord.getEndTime());
                aa.setValue(aa.getValue() + " " + this.mergeAnnRecord.getValue());
            } else {
                aa.updateTimeInterval(this.mergeAnnRecord.getBeginTime(), aa.getEndTimeBoundary());
                aa.setValue(this.mergeAnnRecord.getValue() + " " + aa.getValue());
            }
        }
        ((TranscriptionImpl)this.transcription).setNotifying(true);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    private void mergeComplex() {
        AlignableAnnotation aaAct;
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        ((TranscriptionImpl)this.transcription).setNotifying(false);
        AnnotationDataRecord annData = (AnnotationDataRecord)this.activeNode.getUserObject();
        DefaultMutableTreeNode root = this.mergeAnnNodeComp;
        TierImpl rootTier = (TierImpl)this.transcription.getTierWithId(annData.getTierName());
        if (rootTier != null && (aaAct = (AlignableAnnotation)rootTier.getAnnotationAtTime(annData.getBeginTime())) != null) {
            long end;
            long begin;
            DefaultMutableTreeNode node;
            if (this.mergeWithNext) {
                aaAct.updateTimeInterval(aaAct.getBeginTimeBoundary(), ((AnnotationDataRecord)root.getUserObject()).getEndTime());
            } else {
                aaAct.updateTimeInterval(((AnnotationDataRecord)root.getUserObject()).getBeginTime(), aaAct.getEndTimeBoundary());
            }
            boolean includeID = false;
            AlignableAnnotation aa = null;
            RefAnnotation ra = null;
            Annotation an = null;
            Enumeration<TreeNode> en = root.breadthFirstEnumeration();
            TierImpl tier = null;
            int linStereoType = -1;
            while (en.hasMoreElements()) {
                AlignableAnnotation curLastChild;
                aa = null;
                node = (DefaultMutableTreeNode)en.nextElement();
                annData = (AnnotationDataRecord)node.getUserObject();
                if (node.isRoot()) {
                    if (this.mergeWithNext) {
                        aaAct.setValue(aaAct.getValue() + " " + annData.getValue());
                        continue;
                    }
                    aaAct.setValue(annData.getValue() + " " + aaAct.getValue());
                    continue;
                }
                tier = (TierImpl)this.transcription.getTierWithId(annData.getTierName());
                if (tier == null) {
                    ClientLogger.LOG.severe("Cannot recreate annotations: tier does not exist.");
                    continue;
                }
                if (!tier.isTimeAlignable() || !annData.isBeginTimeAligned()) continue;
                begin = annData.getBeginTime();
                end = annData.getEndTime();
                if (!annData.isEndTimeAligned() && end == begin) {
                    ++end;
                }
                if ((curLastChild = (AlignableAnnotation)tier.getAnnotationAtTime(aaAct.getEndTimeBoundary() - 1L)) != null && !curLastChild.getBegin().isTimeAligned()) {
                    AlignableAnnotation nlChild = (AlignableAnnotation)tier.createAnnotationAfter(curLastChild);
                    if (nlChild != null) {
                        nlChild.updateTimeInterval(begin, end);
                        aa = nlChild;
                    }
                } else {
                    aa = (AlignableAnnotation)tier.createAnnotation(begin, end);
                }
                if (aa != null) {
                    aa.setValue(annData.getValue());
                    if (annData.getExtRef() != null) {
                        aa.setExtRef(annData.getExtRef());
                    }
                    if (includeID) {
                        aa.setId(annData.getId());
                    }
                    if (!(aa instanceof SVGAlignableAnnotation) || !(annData instanceof SVGAnnotationDataRecord)) continue;
                    SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)annData;
                    if (svgRec.getShape() != null) {
                        ((SVGAlignableAnnotation)aa).setShape(svgRec.getShape());
                    }
                    if (svgRec.getSvgElementId() == null) continue;
                    ((SVGAlignableAnnotation)aa).setSVGElementID(svgRec.getSvgElementId());
                    continue;
                }
                ClientLogger.LOG.severe("Alignable annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime() + " et: " + annData.getEndTime());
            }
            en = root.breadthFirstEnumeration();
            en.nextElement();
            Annotation prevAnn = null;
            while (en.hasMoreElements()) {
                aa = null;
                an = null;
                ra = null;
                node = (DefaultMutableTreeNode)en.nextElement();
                annData = (AnnotationDataRecord)node.getUserObject();
                tier = (TierImpl)this.transcription.getTierWithId(annData.getTierName());
                if (tier == null) {
                    ClientLogger.LOG.severe("Cannot recreate annotations: tier does not exist.");
                    continue;
                }
                if (tier.isTimeAlignable()) {
                    if (!annData.isBeginTimeAligned()) {
                        if (!(prevAnn == null || prevAnn.getTier().getName().equals(annData.getTierName()) && prevAnn.getEndTimeBoundary() > annData.getBeginTime())) {
                            prevAnn = null;
                        }
                        if (prevAnn == null) {
                            begin = annData.getBeginTime();
                            end = annData.getEndTime();
                            an = tier.getAnnotationAtTime(begin);
                            if (an != null) {
                                aa = (AlignableAnnotation)tier.createAnnotationAfter(an);
                                prevAnn = aa;
                            } else {
                                aa = (AlignableAnnotation)tier.createAnnotation(begin, end);
                                prevAnn = aa;
                            }
                        } else {
                            aa = (AlignableAnnotation)tier.createAnnotationAfter(prevAnn);
                            prevAnn = aa;
                        }
                        if (aa != null) {
                            aa.setValue(annData.getValue());
                            if (annData.getExtRef() != null) {
                                aa.setExtRef(annData.getExtRef());
                            }
                            if (includeID) {
                                aa.setId(annData.getId());
                            }
                            if (!(aa instanceof SVGAlignableAnnotation) || !(annData instanceof SVGAnnotationDataRecord)) continue;
                            SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)annData;
                            if (svgRec.getShape() != null) {
                                ((SVGAlignableAnnotation)aa).setShape(svgRec.getShape());
                            }
                            if (svgRec.getSvgElementId() == null) continue;
                            ((SVGAlignableAnnotation)aa).setSVGElementID(svgRec.getSvgElementId());
                            continue;
                        }
                        ClientLogger.LOG.severe("Alignable annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                        continue;
                    }
                    prevAnn = null;
                    continue;
                }
                linStereoType = tier.getLinguisticType().getConstraints().getStereoType();
                if (linStereoType == 3) {
                    begin = annData.getBeginTime();
                    if (node.getParent() == root) {
                        begin = ((AnnotationDataRecord)root.getUserObject()).getEndTime() - 1L;
                    } else if (((TierImpl)tier.getParentTier()).getLinguisticType().getConstraints().getStereoType() == 4) {
                        begin = ((AnnotationDataRecord)((DefaultMutableTreeNode)node.getParent()).getUserObject()).getEndTime() - 1L;
                    }
                    if (prevAnn != null && !prevAnn.getTier().getName().equals(annData.getTierName())) {
                        prevAnn = null;
                    }
                    if (prevAnn != null && prevAnn.getEndTimeBoundary() < begin) {
                        prevAnn = null;
                    }
                    if (prevAnn == null) {
                        an = tier.getAnnotationAtTime(begin);
                        ra = an != null ? (an.getBeginTimeBoundary() == begin ? (RefAnnotation)tier.createAnnotationBefore(an) : (RefAnnotation)tier.createAnnotationAfter(an)) : (RefAnnotation)tier.createAnnotation(begin, begin);
                        prevAnn = ra;
                    } else {
                        ra = (RefAnnotation)tier.createAnnotationAfter(prevAnn);
                        prevAnn = ra;
                    }
                    if (ra != null) {
                        ra.setValue(annData.getValue());
                        if (annData.getExtRef() != null) {
                            ra.setExtRef(annData.getExtRef());
                        }
                        if (!includeID) continue;
                        ra.setId(annData.getId());
                        continue;
                    }
                    ClientLogger.LOG.severe("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                    continue;
                }
                if (linStereoType != 4) continue;
                begin = annData.getBeginTime();
                an = tier.getAnnotationAtTime(begin);
                if (tier.getParentTier() == rootTier) {
                    if (an != null) {
                        an.setValue(an.getValue() + " " + annData.getValue());
                        continue;
                    }
                    ra = (RefAnnotation)tier.createAnnotation(begin, begin);
                    if (ra == null) continue;
                    ra.setValue(annData.getValue());
                    if (annData.getExtRef() == null) continue;
                    ra.setExtRef(annData.getExtRef());
                    continue;
                }
                if (an == null) {
                    ra = (RefAnnotation)tier.createAnnotation(begin, begin);
                }
                if (ra != null) {
                    ra.setValue(annData.getValue());
                    if (annData.getExtRef() != null) {
                        ra.setExtRef(annData.getExtRef());
                    }
                    if (!includeID) continue;
                    ra.setId(annData.getId());
                    continue;
                }
                ClientLogger.LOG.severe("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
            }
        }
        ((TranscriptionImpl)this.transcription).setNotifying(true);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    private void recalculateSymbolicSubdivisions(DefaultMutableTreeNode node1, DefaultMutableTreeNode node2, long begin, long end) {
        int i;
        DefaultMutableTreeNode node = null;
        AnnotationDataRecord annData = null;
        TierImpl tier = null;
        HashMap<String, MutableInt> changedTiers = new HashMap<String, MutableInt>();
        for (i = 0; i < node2.getChildCount(); ++i) {
            node = (DefaultMutableTreeNode)node2.getChildAt(i);
            annData = (AnnotationDataRecord)node.getUserObject();
            tier = (TierImpl)this.transcription.getTierWithId(annData.getTierName());
            if (tier.getLinguisticType().getConstraints().getStereoType() == 3) {
                if (!changedTiers.containsKey(annData.getTierName())) {
                    changedTiers.put(annData.getTierName(), new MutableInt(1));
                    continue;
                }
                ++((MutableInt)changedTiers.get((Object)annData.getTierName())).intValue;
                continue;
            }
            this.checkChildNodes(node, changedTiers, true);
        }
        for (i = 0; i < node1.getChildCount(); ++i) {
            node = (DefaultMutableTreeNode)node1.getChildAt(i);
            annData = (AnnotationDataRecord)node.getUserObject();
            tier = (TierImpl)this.transcription.getTierWithId(annData.getTierName());
            if (tier.getLinguisticType().getConstraints().getStereoType() == 3) {
                if (!changedTiers.containsKey(annData.getTierName())) continue;
                ++((MutableInt)changedTiers.get((Object)annData.getTierName())).intValue;
                continue;
            }
            this.checkChildNodes(node, changedTiers, false);
        }
        if (changedTiers.size() == 0) {
            return;
        }
        Iterator tierIt = changedTiers.keySet().iterator();
        ArrayList<DefaultMutableTreeNode> curData = new ArrayList<DefaultMutableTreeNode>(10);
        String tierName = null;
        while (tierIt.hasNext()) {
            curData.clear();
            tierName = (String)tierIt.next();
            int totalCount = ((MutableInt)changedTiers.get((Object)tierName)).intValue;
            int perAnn = (int)Math.ceil((float)(end - begin) / (float)totalCount);
            Enumeration<TreeNode> nodeEnum = node2.breadthFirstEnumeration();
            while (nodeEnum.hasMoreElements()) {
                node = (DefaultMutableTreeNode)nodeEnum.nextElement();
                annData = (AnnotationDataRecord)node.getUserObject();
                if (!annData.getTierName().equals(tierName)) continue;
                curData.add(node);
            }
            int start = totalCount - curData.size();
            for (int i2 = 0; i2 < curData.size(); ++i2) {
                node = (DefaultMutableTreeNode)curData.get(i2);
                annData = (AnnotationDataRecord)node.getUserObject();
                annData.setBeginTime(begin + (long)(start * perAnn));
                if (i2 != curData.size() - 1) {
                    annData.setEndTime(begin + (long)((start + 1) * perAnn));
                }
                this.updateChildren(node);
                ++start;
            }
        }
    }

    private void checkChildNodes(DefaultMutableTreeNode node2, Map<String, MutableInt> changedTiers, boolean isInSecondNode) {
        DefaultMutableTreeNode node = null;
        AnnotationDataRecord annData = null;
        TierImpl tier = null;
        for (int i = 0; i < node2.getChildCount(); ++i) {
            node = (DefaultMutableTreeNode)node2.getChildAt(i);
            annData = (AnnotationDataRecord)node.getUserObject();
            tier = (TierImpl)this.transcription.getTierWithId(annData.getTierName());
            if (tier.getLinguisticType().getConstraints().getStereoType() == 3) {
                if (!changedTiers.containsKey(annData.getTierName())) {
                    if (!isInSecondNode) continue;
                    changedTiers.put(annData.getTierName(), new MutableInt(1));
                    continue;
                }
                ++changedTiers.get((Object)annData.getTierName()).intValue;
                continue;
            }
            this.checkChildNodes(node, changedTiers, isInSecondNode);
        }
    }

    private void updateChildren(DefaultMutableTreeNode node1) {
        DefaultMutableTreeNode node;
        AnnotationDataRecord annData = (AnnotationDataRecord)node1.getUserObject();
        long begin = annData.getBeginTime();
        long end = annData.getEndTime();
        TierImpl tier = null;
        HashMap<String, MutableInt> changedTiers = new HashMap<String, MutableInt>();
        for (int i = 0; i < node1.getChildCount(); ++i) {
            node = (DefaultMutableTreeNode)node1.getChildAt(i);
            annData = (AnnotationDataRecord)node.getUserObject();
            tier = (TierImpl)this.transcription.getTierWithId(annData.getTierName());
            if (tier.getLinguisticType().getConstraints() != null && tier.getLinguisticType().getConstraints().getStereoType() == 3) {
                if (!changedTiers.containsKey(annData.getTierName())) {
                    changedTiers.put(annData.getTierName(), new MutableInt(1));
                    continue;
                }
                ++((MutableInt)changedTiers.get((Object)annData.getTierName())).intValue;
                continue;
            }
            if (tier.getLinguisticType().getConstraints().getStereoType() != 4) continue;
            annData.setBeginTime(begin);
            annData.setEndTime(end);
        }
        if (changedTiers.size() == 0) {
            return;
        }
        Iterator tierIt = changedTiers.keySet().iterator();
        ArrayList<DefaultMutableTreeNode> curData = new ArrayList<DefaultMutableTreeNode>(10);
        String tierName = null;
        while (tierIt.hasNext()) {
            curData.clear();
            tierName = (String)tierIt.next();
            int totalCount = ((MutableInt)changedTiers.get((Object)tierName)).intValue;
            int perAnn = (int)Math.ceil((float)(end - begin) / (float)totalCount);
            for (int i = 0; i < node1.getChildCount(); ++i) {
                node = (DefaultMutableTreeNode)node1.getChildAt(i);
                annData = (AnnotationDataRecord)node.getUserObject();
                if (!annData.getTierName().equals(tierName)) continue;
                curData.add(node);
            }
            int start = totalCount - curData.size();
            for (int i = 0; i < curData.size(); ++i) {
                node = (DefaultMutableTreeNode)curData.get(i);
                annData = (AnnotationDataRecord)node.getUserObject();
                annData.setBeginTime(begin + (long)(start * perAnn));
                if (i != curData.size() - 1) {
                    annData.setEndTime(begin + (long)((start + 1) * perAnn));
                } else {
                    annData.setEndTime(end);
                }
                this.updateChildren(node);
                ++start;
            }
        }
    }
}

