/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collections;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataComparator;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationValuesRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.TimeFormatter;

public class MergeTiersCommand
implements UndoableCommand,
ClientLogger {
    private ArrayList listeners;
    private String commandName;
    private TranscriptionImpl transcription;
    private TierImpl sourceTier1;
    private TierImpl sourceTier2;
    private TierImpl destTier;
    private boolean concatenate = true;
    private int timeFormat = 0;
    private boolean matchingValuesOnly = false;
    private boolean specificValueOnly = false;
    private String specificValue;
    private ArrayList overlaps;
    private ArrayList annRecords;

    public MergeTiersCommand(String name) {
        this.commandName = name;
    }

    public void execute(Object receiver, Object[] arguments) {
        LinguisticType type;
        Integer tf;
        this.transcription = (TranscriptionImpl)receiver;
        String sourceName1 = (String)arguments[0];
        String sourceName2 = (String)arguments[1];
        String destName = (String)arguments[2];
        String typeName = (String)arguments[3];
        Boolean ac = (Boolean)arguments[4];
        if (ac != null) {
            this.concatenate = ac;
        }
        if (arguments.length > 5 && (tf = (Integer)arguments[5]) != null) {
            this.timeFormat = tf;
        }
        if (arguments.length > 5 && arguments[6] instanceof Boolean) {
            this.matchingValuesOnly = (Boolean)arguments[6];
            if (this.matchingValuesOnly && arguments.length > 7) {
                this.specificValueOnly = (Boolean)arguments[7];
                this.specificValue = (String)arguments[8];
                if (this.specificValue == null) {
                    this.specificValue = "";
                }
            }
        }
        this.sourceTier1 = (TierImpl)this.transcription.getTierWithId(sourceName1);
        this.sourceTier2 = (TierImpl)this.transcription.getTierWithId(sourceName2);
        if (this.sourceTier1 == null || this.sourceTier2 == null) {
            this.progressInterrupt("One of the sourcetiers could not be found");
            return;
        }
        if (destName == null) {
            destName = "Overlap";
            LOG.warning("Name of destination tier is null, changed to Overlap");
        }
        this.destTier = (TierImpl)this.transcription.getTierWithId(destName);
        if (this.destTier != null) {
            int count = 1;
            String cName = destName + "-";
            while (this.destTier != null) {
                cName = cName + count;
                this.destTier = (TierImpl)this.transcription.getTierWithId(cName);
                ++count;
            }
            LOG.warning("Tier " + destName + " already exists, changed name to " + cName);
            destName = cName;
        }
        if ((type = this.transcription.getLinguisticTypeByName(typeName)) == null) {
            for (int i = 0; i < this.transcription.getLinguisticTypes().size(); ++i) {
                LinguisticType countType = (LinguisticType)this.transcription.getLinguisticTypes().get(i);
                if (countType.getConstraints() != null) continue;
                LOG.warning("LinguisticType " + typeName + " could not be found, using " + countType.getLinguisticTypeName() + " instead.");
                type = countType;
                typeName = type.getLinguisticTypeName();
                break;
            }
        }
        this.destTier = new TierImpl(null, destName, null, this.transcription, type);
        this.transcription.addTier(this.destTier);
        this.overlaps = new ArrayList();
        this.progressUpdate(8, "Created tier: " + destName);
        MergeThread calcThread = new MergeThread(MergeTiersCommand.class.getName());
        try {
            calcThread.start();
        }
        catch (Exception exc) {
            this.transcription.setNotifying(true);
            LOG.severe("Exception in calculation of overlaps: " + exc.getMessage());
            this.progressInterrupt("An exception occurred: " + exc.getMessage());
        }
    }

    public void undo() {
        if (this.transcription != null && this.destTier != null) {
            this.setWaitCursor(true);
            this.transcription.removeTier(this.destTier);
            this.setWaitCursor(false);
        }
    }

    public void redo() {
        if (this.transcription != null && this.destTier != null) {
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.setWaitCursor(true);
            if (this.transcription.getTierWithId(this.destTier.getName()) == null) {
                this.transcription.addTier(this.destTier);
            }
            if (this.annRecords != null && this.annRecords.size() > 0) {
                this.transcription.setNotifying(false);
                for (int i = 0; i < this.annRecords.size(); ++i) {
                    AnnotationDataRecord record = (AnnotationDataRecord)this.annRecords.get(i);
                    Annotation ann = this.destTier.createAnnotation(record.getBeginTime(), record.getEndTime());
                    if (ann == null || record.getValue() == null) continue;
                    ann.setValue(record.getValue());
                }
                this.transcription.setNotifying(true);
            }
            this.setWaitCursor(false);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressInterrupted(this, message);
            }
        }
    }

    private class MergeThread
    extends Thread {
        public MergeThread() {
        }

        public MergeThread(String name) {
            super(name);
        }

        public void interrupt() {
            super.interrupt();
            MergeTiersCommand.this.progressInterrupt("Operation interrupted...");
        }

        public void run() {
            MergeTiersCommand.this.transcription.setNotifying(false);
            int curPropMode = 0;
            curPropMode = MergeTiersCommand.this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                MergeTiersCommand.this.transcription.setTimeChangePropagationMode(0);
            }
            float perAnn = 50.0f;
            ArrayList sourceAnns1 = new ArrayList(MergeTiersCommand.this.sourceTier1.getAnnotations());
            int numAnns1 = sourceAnns1.size();
            ArrayList sourceAnns2 = new ArrayList(MergeTiersCommand.this.sourceTier2.getAnnotations());
            int numAnns2 = sourceAnns2.size();
            AlignableAnnotation ann1 = null;
            AnnotationValuesRecord curRecord = null;
            MergeTiersCommand.this.progressUpdate(10, "Merging annotations...");
            if (MergeTiersCommand.this.matchingValuesOnly) {
                AlignableAnnotation ann2 = null;
                int j = 0;
                if (numAnns1 > 0) {
                    perAnn /= (float)numAnns1;
                }
                for (int i = 0; i < numAnns1; ++i) {
                    ann1 = (AlignableAnnotation)sourceAnns1.get(i);
                    long bt1 = ann1.getBeginTimeBoundary();
                    long et1 = ann1.getEndTimeBoundary();
                    while (j < numAnns2) {
                        ann2 = (AlignableAnnotation)sourceAnns2.get(j);
                        long bt2 = ann2.getBeginTimeBoundary();
                        long et2 = ann2.getEndTimeBoundary();
                        if (et2 > bt1) {
                            if (bt2 >= et1) {
                                if (j <= 0) break;
                                --j;
                                break;
                            }
                            long obt = bt1 <= bt2 ? bt1 : bt2;
                            long oet = et1 <= et2 ? et2 : et1;
                            if (!MergeTiersCommand.this.specificValueOnly) {
                                if (ann1.getValue() == null && ann2.getValue() == null || ann1.getValue() != null && ann2.getValue() != null && ann1.getValue().length() == 0 && ann2.getValue().length() == 0 || ann1.getValue().equals(ann2.getValue())) {
                                    MergeTiersCommand.this.overlaps.add(new AnnotationValuesRecord(MergeTiersCommand.this.sourceTier1.getName(), ann1.getValue(), obt, oet));
                                }
                            } else if (ann1.getValue() != null && ann2.getValue() != null && ann1.getValue().equals(MergeTiersCommand.this.specificValue) && ann2.getValue().equals(MergeTiersCommand.this.specificValue)) {
                                MergeTiersCommand.this.overlaps.add(new AnnotationValuesRecord(MergeTiersCommand.this.sourceTier1.getName(), MergeTiersCommand.this.specificValue, obt, oet));
                            }
                        }
                        ++j;
                    }
                    MergeTiersCommand.this.progressUpdate((int)(10.0f + (float)i * perAnn), null);
                }
                Collections.sort(MergeTiersCommand.this.overlaps, new AnnotationDataComparator());
                perAnn = 18.0f;
                if (MergeTiersCommand.this.overlaps.size() > 0) {
                    perAnn = 18.0f / (float)MergeTiersCommand.this.overlaps.size();
                }
                AnnotationValuesRecord prevRecord = null;
                for (int i = 0; i < MergeTiersCommand.this.overlaps.size(); ++i) {
                    curRecord = (AnnotationValuesRecord)MergeTiersCommand.this.overlaps.get(i);
                    if (prevRecord == null) {
                        prevRecord = curRecord;
                        continue;
                    }
                    if (curRecord.getBeginTime() < prevRecord.getEndTime()) {
                        if (prevRecord.getValue() != null && prevRecord.getValue().equals(prevRecord.getValue())) {
                            prevRecord.setEndTime(Math.max(prevRecord.getEndTime(), curRecord.getEndTime()));
                            MergeTiersCommand.this.overlaps.remove(i);
                            --i;
                        } else {
                            prevRecord.setEndTime(curRecord.getBeginTime());
                            if (prevRecord.getBeginTime() >= prevRecord.getEndTime()) {
                                MergeTiersCommand.this.overlaps.remove(prevRecord);
                                --i;
                            }
                            prevRecord = curRecord;
                        }
                    } else {
                        prevRecord = curRecord;
                    }
                    MergeTiersCommand.this.progressUpdate((int)(60.0f + (float)i * perAnn), null);
                }
            } else {
                int i;
                int annCount = 2 * (MergeTiersCommand.this.sourceTier1.getNumberOfAnnotations() + MergeTiersCommand.this.sourceTier2.getNumberOfAnnotations());
                if (annCount > 0) {
                    perAnn = 50.0f / (float)annCount;
                }
                int count = 0;
                for (i = 0; i < numAnns1; ++i) {
                    ann1 = (AlignableAnnotation)sourceAnns1.get(i);
                    curRecord = new AnnotationValuesRecord(ann1);
                    MergeTiersCommand.this.overlaps.add(curRecord);
                    MergeTiersCommand.this.progressUpdate((int)(10.0f + (float)count++ * perAnn), null);
                }
                for (i = 0; i < numAnns2; ++i) {
                    ann1 = (AlignableAnnotation)sourceAnns2.get(i);
                    curRecord = new AnnotationValuesRecord(ann1);
                    MergeTiersCommand.this.overlaps.add(curRecord);
                    MergeTiersCommand.this.progressUpdate((int)(10.0f + (float)count++ * perAnn), null);
                }
                Collections.sort(MergeTiersCommand.this.overlaps, new AnnotationDataComparator());
                perAnn = 18.0f;
                if (MergeTiersCommand.this.overlaps.size() > 0) {
                    perAnn = 18.0f / (float)MergeTiersCommand.this.overlaps.size();
                }
                AnnotationValuesRecord prevRecord = null;
                for (int i2 = 0; i2 < MergeTiersCommand.this.overlaps.size(); ++i2) {
                    curRecord = (AnnotationValuesRecord)MergeTiersCommand.this.overlaps.get(i2);
                    if (prevRecord == null) {
                        prevRecord = curRecord;
                        continue;
                    }
                    if (curRecord.getBeginTime() < prevRecord.getEndTime()) {
                        prevRecord.setEndTime(Math.max(prevRecord.getEndTime(), curRecord.getEndTime()));
                        if (prevRecord.getNewLabelValue() == null) {
                            prevRecord.setNewLabelValue(prevRecord.getValue() + " " + curRecord.getValue());
                        } else {
                            prevRecord.setNewLabelValue(prevRecord.getNewLabelValue() + " " + curRecord.getValue());
                        }
                        MergeTiersCommand.this.overlaps.remove(i2);
                        --i2;
                    } else {
                        prevRecord = curRecord;
                    }
                    MergeTiersCommand.this.progressUpdate((int)(60.0f + (float)i2 * perAnn), null);
                }
            }
            MergeTiersCommand.this.progressUpdate(78, "Creating annotations...");
            MergeTiersCommand.this.annRecords = new ArrayList(MergeTiersCommand.this.overlaps.size());
            for (int i = 0; i < MergeTiersCommand.this.overlaps.size(); ++i) {
                curRecord = (AnnotationValuesRecord)MergeTiersCommand.this.overlaps.get(i);
                Annotation ann = MergeTiersCommand.this.destTier.createAnnotation(curRecord.getBeginTime(), curRecord.getEndTime());
                if (ann != null) {
                    if (MergeTiersCommand.this.concatenate) {
                        ann.setValue(curRecord.getNewLabelValue() != null ? curRecord.getNewLabelValue() : curRecord.getValue());
                    } else {
                        switch (MergeTiersCommand.this.timeFormat) {
                            case 102: {
                                ann.setValue(String.valueOf(curRecord.getEndTime() - curRecord.getBeginTime()));
                                break;
                            }
                            case 101: {
                                ann.setValue(TimeFormatter.toSSMSString(curRecord.getEndTime() - curRecord.getBeginTime()));
                                break;
                            }
                            case 100: {
                                ann.setValue(TimeFormatter.toString(curRecord.getEndTime() - curRecord.getBeginTime()));
                            }
                        }
                    }
                    MergeTiersCommand.this.annRecords.add(new AnnotationDataRecord(ann));
                }
                MergeTiersCommand.this.progressUpdate((int)(78.0f + (float)i * perAnn), null);
            }
            MergeTiersCommand.this.transcription.setTimeChangePropagationMode(curPropMode);
            MergeTiersCommand.this.transcription.setNotifying(true);
            MergeTiersCommand.this.progressComplete("Operation complete...");
        }
    }
}

