/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceGroup;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class ModifyAnnotationCommand
implements UndoableCommand {
    private String commandName;
    private Transcription transcription;
    private AnnotationDataRecord annotationRecord;
    private String oldValue;
    private String newValue;
    private Object oldExtRef;
    private Object newExtRef;

    public ModifyAnnotationCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        TierImpl tier;
        Annotation annotation;
        if (this.annotationRecord != null && this.transcription != null && (annotation = (tier = (TierImpl)this.transcription.getTierWithId(this.annotationRecord.getTierName())).getAnnotationAtTime(this.annotationRecord.getBeginTime())) != null && annotation.getEndTimeBoundary() == this.annotationRecord.getEndTime()) {
            annotation.setValue(this.oldValue);
            ((AbstractAnnotation)annotation).setExtRef(this.oldExtRef);
        }
    }

    public void redo() {
        TierImpl tier;
        Annotation annotation;
        if (this.annotationRecord != null && this.transcription != null && (annotation = (tier = (TierImpl)this.transcription.getTierWithId(this.annotationRecord.getTierName())).getAnnotationAtTime(this.annotationRecord.getBeginTime())) != null && annotation.getEndTimeBoundary() == this.annotationRecord.getEndTime()) {
            annotation.setValue(this.newValue);
            ArrayList<Object> eriList = new ArrayList<Object>();
            eriList.add(this.newExtRef);
            for (int listIndex = 0; listIndex < eriList.size(); ++listIndex) {
                if (!(eriList.get(listIndex) instanceof ExternalReferenceGroup)) continue;
                eriList.addAll(((ExternalReferenceGroup)eriList.get(listIndex)).getAllReferences());
            }
            for (Object e : eriList) {
                if (!(e instanceof ExternalReferenceImpl)) continue;
                String value = ((AbstractAnnotation)annotation).getExtRefValue(((ExternalReferenceImpl)e).getReferenceType());
                ((AbstractAnnotation)annotation).removeExtRef(new ExternalReferenceImpl(value, ((ExternalReferenceImpl)e).getReferenceType()));
            }
            ((AbstractAnnotation)annotation).addExtRef((ExternalReferenceImpl)this.newExtRef);
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        AbstractAnnotation annotation = (AbstractAnnotation)receiver;
        if (annotation != null) {
            this.transcription = (Transcription)annotation.getTier().getParent();
        }
        this.annotationRecord = new AnnotationDataRecord(annotation);
        this.oldValue = (String)arguments[0];
        this.newValue = (String)arguments[1];
        annotation.setValue(this.newValue);
        if (arguments.length >= 3) {
            ExternalReferenceImpl eri = (ExternalReferenceImpl)arguments[2];
            try {
                if (annotation.getExtRef() instanceof ExternalReference) {
                    this.oldExtRef = ((ExternalReference)annotation.getExtRef()).clone();
                }
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            this.newExtRef = eri;
            ArrayList<ExternalReferenceImpl> eriList = new ArrayList<ExternalReferenceImpl>();
            eriList.add(eri);
            for (int listIndex = 0; listIndex < eriList.size(); ++listIndex) {
                if (!(eriList.get(listIndex) instanceof ExternalReferenceGroup)) continue;
                eriList.addAll(((ExternalReferenceGroup)eriList.get(listIndex)).getAllReferences());
            }
            for (Object e : eriList) {
                if (!(e instanceof ExternalReferenceImpl)) continue;
                String value = annotation.getExtRefValue(((ExternalReferenceImpl)e).getReferenceType());
                annotation.removeExtRef(new ExternalReferenceImpl(value, ((ExternalReferenceImpl)e).getReferenceType()));
            }
            annotation.addExtRef((ExternalReferenceImpl)this.newExtRef);
        }
    }

    public String getName() {
        return this.commandName;
    }
}

