/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.TimeShiftRecord;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ModifyAnnotationTimeCommand
implements UndoableCommand {
    private String commandName;
    private AlignableAnnotation annotation;
    private DefaultMutableTreeNode rootNode;
    private TranscriptionImpl transcription;
    private TierImpl tier;
    private TierImpl rootTier;
    private int timePropMode;
    private int leftOffset;
    private int rightOffset;
    private long oldBeginTime;
    private long oldEndTime;
    private long newBeginTime;
    private long newEndTime;
    private ArrayList removedAnnotations;
    private ArrayList changedAnnotations;

    public ModifyAnnotationTimeCommand(String name) {
        this.commandName = name;
    }

    public void execute(Object receiver, Object[] arguments) {
        if (!(receiver instanceof AlignableAnnotation)) {
            return;
        }
        this.annotation = (AlignableAnnotation)receiver;
        this.oldBeginTime = this.annotation.getBeginTimeBoundary();
        this.oldEndTime = this.annotation.getEndTimeBoundary();
        this.newBeginTime = (Long)arguments[0];
        this.newEndTime = (Long)arguments[1];
        this.leftOffset = (int)(this.newBeginTime - this.oldBeginTime);
        this.rightOffset = (int)(this.newEndTime - this.oldEndTime);
        if (this.oldBeginTime == this.newBeginTime && this.oldEndTime == this.newEndTime) {
            return;
        }
        this.tier = (TierImpl)this.annotation.getTier();
        if (this.tier.hasParentTier()) {
            this.rootTier = this.tier.getRootTier();
        }
        this.transcription = (TranscriptionImpl)this.tier.getParent();
        this.setWaitCursor(true);
        this.changedAnnotations = new ArrayList();
        this.removedAnnotations = new ArrayList();
        this.timePropMode = this.transcription.getTimeChangePropagationMode();
        switch (this.timePropMode) {
            case 0: {
                this.storeNormal();
                break;
            }
            case 1: {
                this.storeBulldozer();
                break;
            }
            case 2: {
                this.storeShift();
            }
        }
        this.annotation.updateTimeInterval(this.newBeginTime, this.newEndTime);
        Object pref = Preferences.get("ClearSelectionAfterCreation", null);
        if (pref instanceof Boolean && ((Boolean)pref).booleanValue()) {
            ViewerManager2 vm = ELANCommandFactory.getViewerManager(this.transcription);
            if (vm.getMediaPlayerController().getSelectionMode()) {
                vm.getSelection().setSelection(vm.getMediaPlayerController().getMediaTime(), vm.getMediaPlayerController().getMediaTime());
            } else {
                vm.getSelection().setSelection(0L, 0L);
            }
        }
        this.setWaitCursor(false);
    }

    public void undo() {
        if (this.oldBeginTime == this.newBeginTime && this.oldEndTime == this.newEndTime) {
            return;
        }
        this.transcription.setNotifying(false);
        this.setWaitCursor(true);
        switch (this.timePropMode) {
            case 0: {
                this.restoreNormal();
                break;
            }
            case 1: {
                this.restoreBulldozer();
                break;
            }
            case 2: {
                this.restoreShift();
            }
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    public void redo() {
        if (this.oldBeginTime == this.newBeginTime && this.oldEndTime == this.newEndTime) {
            return;
        }
        this.setWaitCursor(true);
        AlignableAnnotation annotation = (AlignableAnnotation)this.tier.getAnnotationAtTime(this.oldBeginTime);
        if (annotation != null) {
            annotation.updateTimeInterval(this.newBeginTime, this.newEndTime);
        }
        this.setWaitCursor(false);
    }

    private void storeNormal() {
        Vector v;
        if (this.rootTier != null) {
            AbstractAnnotation aa = (AbstractAnnotation)this.rootTier.getAnnotationAtTime(this.oldBeginTime);
            if (aa != null) {
                this.rootNode = AnnotationRecreator.createTreeForAnnotation(aa);
            }
            return;
        }
        if (this.leftOffset > 0 || this.rightOffset < 0) {
            this.rootNode = AnnotationRecreator.createTreeForAnnotation(this.annotation);
        }
        if (this.leftOffset < 0 && (v = this.tier.getOverlappingAnnotations(this.newBeginTime, this.oldBeginTime)).size() > 0) {
            AbstractAnnotation ann = (AbstractAnnotation)v.get(0);
            if (ann.getBeginTimeBoundary() < this.newBeginTime) {
                this.changedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ann));
            } else {
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ann));
            }
            for (int i = 1; i < v.size(); ++i) {
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation)v.get(i)));
            }
        }
        if (this.rightOffset > 0 && (v = this.tier.getOverlappingAnnotations(this.oldEndTime, this.newEndTime)).size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                if (i != v.size() - 1) {
                    this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation)v.get(i)));
                    continue;
                }
                AbstractAnnotation ann = (AbstractAnnotation)v.get(i);
                if (ann.getEndTimeBoundary() > this.newEndTime) {
                    this.changedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ann));
                    continue;
                }
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ann));
            }
        }
    }

    private void restoreNormal() {
        if (this.tier == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        if (this.rootTier != null) {
            AbstractAnnotation aa = (AbstractAnnotation)this.rootTier.getAnnotationAtTime(this.newBeginTime);
            if (aa != null) {
                this.rootTier.removeAnnotation(aa);
                AnnotationRecreator.createAnnotationFromTree(this.transcription, this.rootNode, true);
            }
        } else {
            DefaultMutableTreeNode node;
            int i;
            AlignableAnnotation actAnnotation = (AlignableAnnotation)this.tier.getAnnotationAtTime(this.newBeginTime);
            if (this.changedAnnotations.size() > 0) {
                for (i = 0; i < this.changedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.changedAnnotations.get(i);
                    AnnotationDataRecord dataRecord = (AnnotationDataRecord)node.getUserObject();
                    AbstractAnnotation aa = dataRecord.getBeginTime() < this.oldBeginTime ? (AbstractAnnotation)this.tier.getAnnotationAtTime(dataRecord.getBeginTime()) : (AbstractAnnotation)this.tier.getAnnotationAtTime(dataRecord.getEndTime() - 1L);
                    if (aa == null) continue;
                    this.tier.removeAnnotation(aa);
                }
            }
            if (this.leftOffset > 0 || this.rightOffset < 0) {
                if (actAnnotation != null) {
                    this.tier.removeAnnotation(actAnnotation);
                }
                AnnotationRecreator.createAnnotationFromTree(this.transcription, this.rootNode, true);
            } else if (actAnnotation != null) {
                actAnnotation.updateTimeInterval(this.oldBeginTime, this.oldEndTime);
            }
            if (this.changedAnnotations.size() > 0) {
                for (i = 0; i < this.changedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.changedAnnotations.get(i);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                }
            }
            if (this.removedAnnotations.size() > 0) {
                for (i = 0; i < this.removedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.removedAnnotations.get(i);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                }
            }
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    private void storeBulldozer() {
        int dist;
        int i;
        int gapBridged;
        int gapToBridge;
        int index;
        AbstractAnnotation cur;
        Vector annos;
        if (this.rootTier != null) {
            this.storeNormal();
            return;
        }
        if (this.leftOffset > 0 || this.rightOffset < 0) {
            this.rootNode = AnnotationRecreator.createTreeForAnnotation(this.annotation);
        }
        if ((annos = this.tier.getAnnotations()) == null) {
            return;
        }
        if (this.leftOffset < 0) {
            cur = this.annotation;
            index = annos.indexOf(this.annotation);
            gapToBridge = -this.leftOffset;
            gapBridged = 0;
            for (i = index - 1; i >= 0; --i) {
                AbstractAnnotation prev = (AbstractAnnotation)annos.get(i);
                dist = (int)(((AbstractAnnotation)cur).getBeginTimeBoundary() - prev.getEndTimeBoundary());
                if ((gapBridged += dist) >= gapToBridge) break;
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(prev));
                this.changedAnnotations.add(new TimeShiftRecord(prev.getBeginTimeBoundary(), prev.getEndTimeBoundary(), -(gapToBridge - gapBridged)));
                cur = prev;
            }
        }
        if (this.rightOffset > 0) {
            AbstractAnnotation next;
            cur = this.annotation;
            index = annos.indexOf(this.annotation);
            gapToBridge = this.rightOffset;
            gapBridged = 0;
            for (i = index + 1; i < annos.size() && (gapBridged += (dist = (int)((next = (AbstractAnnotation)annos.get(i)).getBeginTimeBoundary() - ((AbstractAnnotation)cur).getEndTimeBoundary()))) < gapToBridge; ++i) {
                this.changedAnnotations.add(new TimeShiftRecord(next.getBeginTimeBoundary(), next.getEndTimeBoundary(), gapToBridge - gapBridged));
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(next));
                cur = next;
            }
        }
    }

    private void restoreBulldozer() {
        if (this.tier == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        if (this.rootTier != null) {
            this.restoreNormal();
        } else {
            AlignableAnnotation actAnnotation = (AlignableAnnotation)this.tier.getAnnotationAtTime(this.newBeginTime);
            if (this.leftOffset > 0 || this.rightOffset < 0) {
                if (actAnnotation != null) {
                    this.tier.removeAnnotation(actAnnotation);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, this.rootNode, true);
                }
            } else if (actAnnotation != null) {
                actAnnotation.updateTimeInterval(this.oldBeginTime, this.oldEndTime);
            }
            if (this.changedAnnotations.size() > 0) {
                for (int i = 0; i < this.changedAnnotations.size(); ++i) {
                    TimeShiftRecord tsRecord = (TimeShiftRecord)this.changedAnnotations.get(i);
                    AlignableAnnotation aa = (AlignableAnnotation)this.tier.getAnnotationAtTime(tsRecord.newBegin);
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.removedAnnotations.get(i);
                    if (aa != null) {
                        this.tier.removeAnnotation(aa);
                    }
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                }
            }
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    private void storeShift() {
        Vector v;
        if (this.rootTier != null) {
            this.storeNormal();
            return;
        }
        if (this.leftOffset > 0 || this.rightOffset < 0) {
            this.rootNode = AnnotationRecreator.createTreeForAnnotation(this.annotation);
        }
        if (this.leftOffset < 0 && (v = this.tier.getOverlappingAnnotations(this.newBeginTime, this.oldBeginTime)).size() > 0) {
            AbstractAnnotation ann = (AbstractAnnotation)v.get(0);
            if (ann.getBeginTimeBoundary() < this.newBeginTime) {
                this.changedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ann));
            } else {
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ann));
            }
            for (int i = 1; i < v.size(); ++i) {
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation)v.get(i)));
            }
        }
    }

    private void restoreShift() {
        if (this.tier == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        if (this.rootTier != null) {
            this.restoreNormal();
        } else {
            DefaultMutableTreeNode node;
            int i;
            AlignableAnnotation actAnnotation = (AlignableAnnotation)this.tier.getAnnotationAtTime(this.newBeginTime);
            if (this.changedAnnotations.size() > 0) {
                for (i = 0; i < this.changedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.changedAnnotations.get(i);
                    AnnotationDataRecord dataRecord = (AnnotationDataRecord)node.getUserObject();
                    AbstractAnnotation aa = (AbstractAnnotation)this.tier.getAnnotationAtTime(dataRecord.getBeginTime());
                    if (aa == null) continue;
                    this.tier.removeAnnotation(aa);
                }
            }
            if ((this.leftOffset > 0 || this.rightOffset < 0) && actAnnotation != null) {
                this.tier.removeAnnotation(actAnnotation);
            }
            if (this.rightOffset > 0) {
                this.transcription.shiftBackward(this.oldEndTime, -this.rightOffset);
            }
            if (this.leftOffset > 0 || this.rightOffset < 0) {
                AnnotationRecreator.createAnnotationFromTree(this.transcription, this.rootNode, true);
            } else if (actAnnotation != null) {
                actAnnotation.updateTimeInterval(this.oldBeginTime, this.oldEndTime);
            }
            if (this.changedAnnotations.size() > 0) {
                for (i = 0; i < this.changedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.changedAnnotations.get(i);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                }
            }
            if (this.removedAnnotations.size() > 0) {
                for (i = 0; i < this.removedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.removedAnnotations.get(i);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                }
            }
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

