/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.Vector;
import mpi.eudico.client.annotator.commands.NewAnnotationCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class NewAnnotationRecursiveCommand
extends NewAnnotationCommand {
    private String value;
    private long begin;
    private long end;
    private TierImpl tier;

    public NewAnnotationRecursiveCommand(String name) {
        super(name);
    }

    public void execute(Object receiver, Object[] arguments) {
        super.execute(receiver, arguments);
        this.tier = (TierImpl)receiver;
        this.begin = (Long)arguments[0];
        this.end = (Long)arguments[1];
        this.createNewAnnotaionsRecursively();
    }

    private void createNewAnnotaionsRecursively() {
        Vector dependentTiers = this.tier.getDependentTiers();
        if (dependentTiers != null) {
            for (int i = 0; i < dependentTiers.size(); ++i) {
                TierImpl currentChildTier = (TierImpl)dependentTiers.elementAt(i);
                if (currentChildTier.isTimeAlignable()) {
                    currentChildTier.createAnnotation(this.begin, this.end);
                    continue;
                }
                long time = (this.begin + this.end) / 2L;
                currentChildTier.createAnnotation(time, time);
            }
            ((TranscriptionImpl)this.tier.getParent()).notifyListeners(this.tier, 3, this.tier.getAnnotationAtTime(this.begin));
        }
    }

    public void redo() {
        super.redo();
        this.createNewAnnotaionsRecursively();
    }

    public void undo() {
        super.undo();
    }

    public String getName() {
        return super.getName();
    }
}

