/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.ControlledVocabulary;

public class ReplaceCVCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private ControlledVocabulary conVoc;
    private ControlledVocabulary newConVoc;

    public ReplaceCVCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        if (this.transcription != null) {
            this.transcription.removeControlledVocabulary(this.newConVoc);
            this.transcription.addControlledVocabulary(this.conVoc);
        }
    }

    public void redo() {
        if (this.transcription != null) {
            this.transcription.removeControlledVocabulary(this.conVoc);
            this.transcription.addControlledVocabulary(this.newConVoc);
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.conVoc = (ControlledVocabulary)arguments[0];
        this.newConVoc = (ControlledVocabulary)arguments[1];
        if (this.transcription.getControlledVocabulary(this.conVoc.getName()) != null && this.newConVoc != null) {
            this.transcription.removeControlledVocabulary(this.conVoc);
            this.transcription.addControlledVocabulary(this.newConVoc);
        }
    }

    public String getName() {
        return this.commandName;
    }
}

