/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class SegmentsToTiersCommand
implements UndoableCommand {
    private ArrayList listeners;
    private String commandName;
    private TranscriptionImpl transcription;
    private Map resolvedMap;
    private String lingTypeName = "";
    private boolean newLTCreated = false;

    public SegmentsToTiersCommand(String commandName) {
        this.commandName = commandName;
    }

    public void redo() {
        this.createTiers();
    }

    public void undo() {
        LinguisticType lt;
        Iterator nameIt = this.resolvedMap.keySet().iterator();
        String name = null;
        TierImpl tier = null;
        while (nameIt.hasNext()) {
            name = (String)nameIt.next();
            tier = (TierImpl)this.transcription.getTierWithId(name);
            if (tier == null) continue;
            this.transcription.removeTier(tier);
        }
        if (this.newLTCreated && (lt = this.transcription.getLinguisticTypeByName(this.lingTypeName)) != null) {
            this.transcription.removeLinguisticType(lt);
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        TierImpl tier;
        this.transcription = (TranscriptionImpl)receiver;
        Map segMap = (Map)arguments[0];
        boolean changeNames = false;
        for (String name : segMap.keySet()) {
            tier = (TierImpl)this.transcription.getTierWithId(name);
            if (tier == null) continue;
            changeNames = true;
            break;
        }
        if (!changeNames) {
            this.resolvedMap = new HashMap(segMap);
        } else {
            this.resolvedMap = new HashMap(segMap.size());
            block3: for (String name : segMap.keySet()) {
                Object segments = segMap.get(name);
                tier = (TierImpl)this.transcription.getTierWithId(name);
                if (tier != null) {
                    for (int count = 1; count < 30; ++count) {
                        tier = (TierImpl)this.transcription.getTierWithId(name + "-" + count);
                        if (tier != null) continue;
                        this.resolvedMap.put(name + "-" + count, segments);
                        continue block3;
                    }
                    continue;
                }
                this.resolvedMap.put(name, segments);
            }
        }
        LinguisticType lt = this.transcription.getLinguisticTypeByName("default-lt");
        if (lt != null && lt.getConstraints() == null) {
            this.lingTypeName = "default-lt";
        } else {
            String ltName = "segmentation";
            lt = this.transcription.getLinguisticTypeByName(ltName);
            if (lt != null && lt.getConstraints() == null) {
                this.lingTypeName = ltName;
            } else if (lt == null) {
                this.lingTypeName = ltName;
                this.newLTCreated = true;
            } else {
                for (int count = 1; count < 30; ++count) {
                    lt = this.transcription.getLinguisticTypeByName(ltName + "-" + count);
                    if (lt != null) continue;
                    this.lingTypeName = ltName + "-" + count;
                    this.newLTCreated = true;
                    break;
                }
            }
        }
        ConvertThread ct = new ConvertThread();
        try {
            ct.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.transcription.setNotifying(true);
            this.progressInterrupt("An exception occurred: " + ex.getMessage());
        }
    }

    public String getName() {
        return this.commandName;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressInterrupted(this, message);
            }
        }
    }

    private void createTiers() {
        int numTiers;
        int curPropMode;
        LinguisticType lt = this.transcription.getLinguisticTypeByName(this.lingTypeName);
        if (this.newLTCreated || lt == null) {
            lt = new LinguisticType(this.lingTypeName);
            lt.setTimeAlignable(true);
            this.transcription.addLinguisticType(lt);
        }
        if ((curPropMode = this.transcription.getTimeChangePropagationMode()) != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        float progPerTier = (numTiers = this.resolvedMap.size()) == 0 ? 100.0f : (float)(100 / numTiers);
        Iterator nameIt = this.resolvedMap.keySet().iterator();
        String name = null;
        TierImpl tier = null;
        List segments = null;
        AlignableAnnotation aa = null;
        AnnotationDataRecord record = null;
        int curProg = 0;
        int curTierIndex = 0;
        while (nameIt.hasNext()) {
            name = (String)nameIt.next();
            ++curTierIndex;
            if (this.transcription.getTierWithId(name) != null) {
                curProg = (int)((float)curTierIndex * progPerTier);
                this.progressUpdate(curProg, "");
                continue;
            }
            tier = new TierImpl(name, null, this.transcription, lt);
            this.transcription.addTier(tier);
            this.transcription.setNotifying(false);
            segments = (List)this.resolvedMap.get(name);
            if (segments != null && segments.size() > 0) {
                float perSeg = progPerTier / (float)segments.size();
                for (int i = 0; i < segments.size(); ++i) {
                    record = (AnnotationDataRecord)segments.get(i);
                    if (record != null && (aa = (AlignableAnnotation)tier.createAnnotation(record.getBeginTime(), record.getEndTime())) != null && record.getValue() != null) {
                        aa.setValue(record.getValue());
                    }
                    this.progressUpdate((int)((float)curProg + (float)i * perSeg), "");
                }
            }
            this.transcription.setNotifying(true);
            curProg = (int)((float)curTierIndex * progPerTier);
            this.progressUpdate(curProg, "");
        }
        this.transcription.setNotifying(true);
        this.transcription.setTimeChangePropagationMode(curPropMode);
        this.progressComplete("");
    }

    private class ConvertThread
    extends Thread {
        private ConvertThread() {
        }

        public void run() {
            SegmentsToTiersCommand.this.createTiers();
        }

        public void interrupt() {
            super.interrupt();
            SegmentsToTiersCommand.this.progressInterrupt("Operation interrupted...");
        }
    }
}

