/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clom.Transcription;

public class SetAuthorCommand
implements UndoableCommand {
    private String name;
    private Transcription transcription;
    private String oldAuthor;
    private String nextAuthor;

    public SetAuthorCommand(String name) {
        this.name = name;
    }

    public void redo() {
        if (this.transcription != null) {
            this.transcription.setAuthor(this.oldAuthor);
        }
    }

    public void undo() {
        if (this.transcription != null) {
            this.transcription.setAuthor(this.oldAuthor);
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        if (receiver instanceof Transcription) {
            this.transcription = (Transcription)receiver;
        }
        if (this.transcription == null) {
            return;
        }
        this.oldAuthor = this.transcription.getAuthor();
        String input = (String)JOptionPane.showInputDialog(ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("Frame.ElanFrame.SetAuthorMessage"), ElanLocale.getString("Menu.Edit.Author"), -1, null, null, this.oldAuthor);
        if (input != null) {
            this.nextAuthor = input;
            this.transcription.setAuthor(this.nextAuthor);
            this.transcription.setChanged();
        }
    }

    public String getName() {
        return this.name;
    }
}

