/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.IllegalEditException;

public class ShiftAnnotationsCommand
implements UndoableCommand {
    String commandName;
    TranscriptionImpl transcription;
    private TierImpl tier;
    Long bt;
    Long et;
    Long shiftValue;

    public ShiftAnnotationsCommand(String name) {
        this.commandName = name;
    }

    public void redo() {
        this.shift(this.tier, this.shiftValue, this.bt, this.et);
    }

    public void undo() {
        this.shift(this.tier, -this.shiftValue.longValue(), this.bt == 0L ? this.bt : this.bt + this.shiftValue, this.et == Long.MAX_VALUE ? this.et : this.et + this.shiftValue);
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        if (arguments != null) {
            this.tier = (TierImpl)arguments[0];
            this.bt = (Long)arguments[1];
            this.et = (Long)arguments[2];
            this.shiftValue = (Long)arguments[3];
            this.shift(this.tier, this.shiftValue, this.bt, this.et);
        }
    }

    void shift(TierImpl tier, long shiftValue, long bt, long et) {
        if (tier != null) {
            try {
                tier.shiftAnnotations(shiftValue, bt, et);
            }
            catch (IllegalArgumentException iae) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("ShiftAllDialog.Warn5") + " " + iae.getMessage(), ElanLocale.getString("Message.Warning"), 2);
                iae.printStackTrace();
            }
            catch (IllegalEditException iee) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("ShiftAllDialog.Warn5") + " " + iee.getMessage(), ElanLocale.getString("Message.Warning"), 2);
                iee.printStackTrace();
            }
        }
    }

    public String getName() {
        return this.commandName;
    }
}

