/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class SplitAnnotationCommand
implements UndoableCommand {
    private String commandName;
    private AnnotationDataRecord annotationRecord;
    private Transcription transcription;
    long splitTime;

    public SplitAnnotationCommand(String name) {
        this.commandName = name;
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (Transcription)receiver;
        AlignableAnnotation annotation = null;
        if (arguments[0] instanceof AlignableAnnotation) {
            annotation = (AlignableAnnotation)arguments[0];
        }
        if (annotation != null) {
            long begin = annotation.getBeginTimeBoundary();
            long end = annotation.getEndTimeBoundary();
            this.splitTime = arguments.length > 1 && arguments[1] != null ? (Long)arguments[1] : (begin + end) / 2L;
        }
        this.splitAnnotation(annotation);
    }

    public void splitAnnotation(AlignableAnnotation annotation) {
        if (annotation != null) {
            long begin = annotation.getBeginTimeBoundary();
            long end = annotation.getEndTimeBoundary();
            TierImpl tier = (TierImpl)annotation.getTier();
            String value = annotation.getValue();
            this.annotationRecord = new AnnotationDataRecord(annotation);
            if (tier.isTimeAlignable()) {
                Annotation ann;
                if (!tier.hasParentTier()) {
                    annotation.updateTimeInterval(begin, this.splitTime);
                }
                if ((ann = tier.createAnnotation(this.splitTime, end)) != null) {
                    ann.setValue(value);
                }
            }
        }
    }

    public String getName() {
        return this.commandName;
    }

    public void undo() {
        TierImpl tier;
        AlignableAnnotation ann = null;
        if (this.annotationRecord != null && (tier = (TierImpl)this.transcription.getTierWithId(this.annotationRecord.getTierName())) != null) {
            tier.removeAnnotation(tier.getAnnotationAtTime(this.splitTime));
            ann = (AlignableAnnotation)tier.getAnnotationAtTime(this.annotationRecord.getBeginTime());
            if (ann != null) {
                ann.updateTimeInterval(this.annotationRecord.getBeginTime(), this.annotationRecord.getEndTime());
            }
        }
    }

    public void redo() {
        TierImpl tier;
        if (this.annotationRecord != null && (tier = (TierImpl)this.transcription.getTierWithId(this.annotationRecord.getTierName())) != null) {
            AlignableAnnotation ann = (AlignableAnnotation)tier.getAnnotationAtTime(this.annotationRecord.getBeginTime());
            this.splitAnnotation(ann);
        }
    }
}

