/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.BackupCA;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.svg.SVGParserAndStore;
import mpi.eudico.client.annotator.timeseries.io.TSConfigurationEncoder;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class StoreCommand
implements Command {
    private String commandName;

    public StoreCommand(String name) {
        this.commandName = name;
    }

    public void execute(Object receiver, Object[] arguments) {
        Transcription tr = (Transcription)receiver;
        TranscriptionStore eafTranscriptionStore = (TranscriptionStore)arguments[0];
        boolean saveAsTemplate = (Boolean)arguments[1];
        boolean saveNewCopy = (Boolean)arguments[2];
        Vector visibleTiers = arguments[3] != null ? (Vector)arguments[3] : ELANCommandFactory.getViewerManager(tr).getMultiTierControlPanel().getVisibleTiers();
        if (saveNewCopy) {
            String saveDir = (String)Preferences.get("LastUsedEAFDir", null);
            if (saveDir == null && (saveDir = new File(tr.getName()).getParent()) == null) {
                saveDir = System.getProperty("user.dir");
            }
            JFileChooser chooser = new JFileChooser(saveDir);
            if (saveAsTemplate) {
                chooser.setFileFilter(ElanFileFilter.createFileFilter(4));
                chooser.setDialogTitle(ElanLocale.getString("SaveDialog.Template.Title"));
            } else {
                chooser.setFileFilter(ElanFileFilter.createFileFilter(3));
                chooser.setDialogTitle(ElanLocale.getString("SaveDialog.Title"));
            }
            int option = chooser.showSaveDialog(ELANCommandFactory.getRootFrame(tr));
            if (option == 0) {
                File f;
                File curDir = chooser.getCurrentDirectory();
                if (curDir != null) {
                    Preferences.set("LastUsedEAFDir", curDir.getAbsolutePath(), null);
                }
                if ((f = chooser.getSelectedFile()) != null) {
                    int answer;
                    String pathName = f.getAbsolutePath();
                    String lowerPathName = pathName.toLowerCase();
                    if (!lowerPathName.endsWith(".eaf") && !lowerPathName.endsWith(".etf")) {
                        pathName = saveAsTemplate ? pathName + ".etf" : pathName + ".eaf";
                    }
                    if (new File(pathName).exists() && (answer = JOptionPane.showConfirmDialog(ELANCommandFactory.getRootFrame(tr), ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0)) == 1) {
                        return;
                    }
                    if (saveAsTemplate) {
                        try {
                            eafTranscriptionStore.storeTranscriptionAsTemplateIn(tr, visibleTiers, pathName);
                            String templatePrefPath = pathName.substring(0, pathName.length() - 3) + "pfsx";
                            Preferences.exportPreferences(tr, templatePrefPath);
                        }
                        catch (IOException ioe) {
                            JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(tr), "Unable to save the template file: (" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
                        }
                    } else {
                        String relUrl;
                        boolean saveSVG = false;
                        if (!saveSVG) {
                            Vector tiers = tr.getTiers();
                            for (int i = 0; i < tiers.size(); ++i) {
                                TierImpl tier = (TierImpl)tiers.get(i);
                                if (!tier.getLinguisticType().hasGraphicReferences()) continue;
                                saveSVG = true;
                                break;
                            }
                        }
                        if (!saveSVG) {
                            ((TranscriptionImpl)tr).setSVGFile(null);
                        } else {
                            int index = pathName.lastIndexOf(".eaf");
                            String svgFileName = pathName.substring(0, index) + ".svg";
                            ((TranscriptionImpl)tr).setSVGFile(svgFileName);
                        }
                        String name = pathName;
                        int lastSlashPos = name.lastIndexOf(System.getProperty("file.separator"));
                        if (lastSlashPos >= 0) {
                            name = name.substring(lastSlashPos + 1);
                        }
                        tr.setName(name);
                        if (tr instanceof TranscriptionImpl) {
                            ((TranscriptionImpl)tr).setPathName(pathName);
                            ELANCommandFactory.getRootFrame(tr).setTitle("ELAN - " + tr.getName());
                            FrameManager.getInstance().updateFrameTitle(ELANCommandFactory.getRootFrame(tr), pathName);
                        } else {
                            ELANCommandFactory.getRootFrame(tr).setTitle("ELAN - " + name);
                        }
                        Vector linkedFiles = tr.getLinkedFileDescriptors();
                        String svgExt = ".svg";
                        String confExt = "_tsconf.xml";
                        if (linkedFiles.size() > 0) {
                            for (int i = 0; i < linkedFiles.size(); ++i) {
                                String curExt = null;
                                LinkedFileDescriptor lfd = (LinkedFileDescriptor)linkedFiles.get(i);
                                if (lfd.linkURL.toLowerCase().endsWith(confExt)) {
                                    curExt = confExt;
                                } else if (lfd.linkURL.toLowerCase().endsWith(svgExt)) {
                                    curExt = svgExt;
                                }
                                if (curExt == null) continue;
                                String url = pathName.substring(0, pathName.length() - 4) + curExt;
                                System.out.println("New conf: " + url);
                                try {
                                    File source = null;
                                    File dest = null;
                                    source = lfd.linkURL.startsWith("file:") ? new File(lfd.linkURL.substring(5)) : new File(lfd.linkURL);
                                    dest = url.startsWith("file:") ? new File(url.substring(5)) : new File(url);
                                    if (source.exists() && source.compareTo(dest) != 0) {
                                        FileUtility.copyToFile(source, dest);
                                    } else {
                                        TSConfigurationEncoder enc = new TSConfigurationEncoder();
                                        enc.encodeAndSave((TranscriptionImpl)tr, ELANCommandFactory.getTrackManager(tr).getConfigs());
                                    }
                                }
                                catch (Exception ex) {
                                    System.out.println("Could not copy the configuration file.");
                                }
                                lfd.linkURL = FileUtility.pathToURLString(url);
                                tr.setChanged();
                            }
                        }
                        String fullEAFURL = FileUtility.pathToURLString(pathName);
                        Vector mediaDescriptors = tr.getMediaDescriptors();
                        for (int i = 0; i < mediaDescriptors.size(); ++i) {
                            MediaDescriptor md = (MediaDescriptor)mediaDescriptors.elementAt(i);
                            relUrl = FileUtility.getRelativePath(fullEAFURL, md.mediaURL);
                            md.relativeMediaURL = "file:/" + relUrl;
                        }
                        if (linkedFiles.size() > 0) {
                            for (int i = 0; i < linkedFiles.size(); ++i) {
                                LinkedFileDescriptor lfd = (LinkedFileDescriptor)linkedFiles.get(i);
                                relUrl = FileUtility.getRelativePath(fullEAFURL, lfd.linkURL);
                                lfd.relativeLinkURL = "file:/" + relUrl;
                            }
                        }
                        try {
                            eafTranscriptionStore.storeTranscriptionIn(tr, null, visibleTiers, pathName, 0);
                        }
                        catch (IOException ioe) {
                            JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(tr), "Unable to save the transcription file: (" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
                        }
                        tr.setUnchanged();
                        if (saveSVG) {
                            SVGParserAndStore.storeSVG(tr);
                        }
                        if (tr instanceof TranscriptionImpl) {
                            ((BackupCA)ELANCommandFactory.getCommandAction(tr, "CommandActions.Backup")).setFilePath(pathName);
                        }
                    }
                }
            }
        } else if (tr.isChanged()) {
            String relUrl;
            String svgFileName;
            boolean saveSVG = false;
            Vector tiers = tr.getTiers();
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl tier = (TierImpl)tiers.get(i);
                if (!tier.getLinguisticType().hasGraphicReferences()) continue;
                saveSVG = true;
                break;
            }
            if (!saveSVG) {
                ((TranscriptionImpl)tr).setSVGFile(null);
            }
            if ((svgFileName = ((TranscriptionImpl)tr).getSVGFile()) == null && saveSVG) {
                String pathName = ((TranscriptionImpl)tr).getPathName();
                int index = pathName.lastIndexOf(".eaf");
                String newSvgFileName = pathName.substring(0, index) + ".svg";
                ((TranscriptionImpl)tr).setSVGFile(newSvgFileName);
            }
            String fullEAFURL = FileUtility.pathToURLString(tr.getFullPath());
            Vector mediaDescriptors = tr.getMediaDescriptors();
            for (int i = 0; i < mediaDescriptors.size(); ++i) {
                MediaDescriptor md = (MediaDescriptor)mediaDescriptors.elementAt(i);
                relUrl = FileUtility.getRelativePath(fullEAFURL, md.mediaURL);
                md.relativeMediaURL = "file:/" + relUrl;
            }
            Vector linkedFiles = tr.getLinkedFileDescriptors();
            if (linkedFiles.size() > 0) {
                for (int i = 0; i < linkedFiles.size(); ++i) {
                    LinkedFileDescriptor lfd = (LinkedFileDescriptor)linkedFiles.get(i);
                    relUrl = FileUtility.getRelativePath(fullEAFURL, lfd.linkURL);
                    lfd.relativeLinkURL = "file:/" + relUrl;
                }
            }
            try {
                eafTranscriptionStore.storeTranscription(tr, null, visibleTiers, 0);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(tr), "Unable to save the transcription file: (" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
            }
            if (svgFileName != null || saveSVG) {
                SVGParserAndStore.storeSVG(tr);
            }
            tr.setUnchanged();
        }
    }

    public String getName() {
        return this.commandName;
    }
}

