/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.gui.IndeterminateProgressMonitor;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class TokenizeCommand
implements UndoableCommand {
    private String commandName;
    private static final Logger LOG = Logger.getLogger(TokenizeCommand.class.getName());
    private TranscriptionImpl transcription;
    private TierImpl sourceTier;
    private TierImpl destTier;
    private String delimiter;
    private boolean preserve;
    private boolean createEmpty;
    private ArrayList existAnnotations;
    private ArrayList newAnnotationsNodes;
    private ArrayList completedTokenizations;

    public TokenizeCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        if (this.transcription == null || this.sourceTier == null || this.destTier == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.transcription.setNotifying(false);
        this.setWaitCursor(true);
        if (this.completedTokenizations.size() > 0) {
            for (int i = 0; i < this.completedTokenizations.size(); ++i) {
                AnnotationDataRecord srcRecord = (AnnotationDataRecord)this.completedTokenizations.get(i);
                AbstractAnnotation srcAnn = (AbstractAnnotation)this.sourceTier.getAnnotationAtTime(srcRecord.getBeginTime());
                Vector childrenOnDest = srcAnn.getChildrenOnTier(this.destTier);
                for (int j = 0; j < childrenOnDest.size(); ++j) {
                    AbstractAnnotation destAnn = (AbstractAnnotation)childrenOnDest.get(j);
                    this.destTier.removeAnnotation(destAnn);
                }
            }
        }
        if (!this.preserve && this.existAnnotations.size() > 0) {
            AnnotationRecreator.createAnnotationsSequentially(this.transcription, this.existAnnotations);
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    public void redo() {
        if (this.transcription == null || this.sourceTier == null || this.destTier == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.transcription.setNotifying(false);
        this.setWaitCursor(true);
        if (this.completedTokenizations.size() > 0) {
            if (!this.preserve) {
                for (int i = 0; i < this.completedTokenizations.size(); ++i) {
                    AnnotationDataRecord srcRecord = (AnnotationDataRecord)this.completedTokenizations.get(i);
                    AbstractAnnotation srcAnn = (AbstractAnnotation)this.sourceTier.getAnnotationAtTime(srcRecord.getBeginTime());
                    Vector childrenOnDest = srcAnn.getChildrenOnTier(this.destTier);
                    for (int j = 0; j < childrenOnDest.size(); ++j) {
                        AbstractAnnotation destAnn = (AbstractAnnotation)childrenOnDest.get(j);
                        this.destTier.removeAnnotation(destAnn);
                    }
                }
            }
            if (this.newAnnotationsNodes.size() > 0) {
                AnnotationRecreator.createAnnotationsSequentiallyDepthless(this.transcription, this.newAnnotationsNodes);
            }
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        String sourceName = (String)arguments[0];
        String destName = (String)arguments[1];
        this.delimiter = (String)arguments[2];
        this.preserve = (Boolean)arguments[3];
        this.createEmpty = (Boolean)arguments[4];
        this.sourceTier = (TierImpl)this.transcription.getTierWithId(sourceName);
        this.destTier = (TierImpl)this.transcription.getTierWithId(destName);
        if (this.transcription == null || this.sourceTier == null || this.destTier == null) {
            LOG.severe("Error in retrieving the transcription or one of the tiers.");
            return;
        }
        this.existAnnotations = new ArrayList();
        this.newAnnotationsNodes = new ArrayList();
        this.completedTokenizations = new ArrayList();
        new TokenizeThread().start();
    }

    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    private class TokenizeThread
    extends Thread {
        TokenizeThread() {
        }

        public void run() {
            int curPropMode = 0;
            curPropMode = TokenizeCommand.this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                TokenizeCommand.this.transcription.setTimeChangePropagationMode(0);
            }
            final IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor(ELANCommandFactory.getRootFrame(TokenizeCommand.this.transcription), true, ElanLocale.getString("TokenizeDialog.Message.Tokenizing"), true, ElanLocale.getString("Button.Cancel"));
            new Thread(new Runnable(){

                public void run() {
                    monitor.show();
                }
            }).start();
            Vector sourceAnnos = TokenizeCommand.this.sourceTier.getAnnotations();
            if (sourceAnnos.size() <= 0) {
                monitor.close();
                return;
            }
            TokenizeCommand.this.transcription.setNotifying(false);
            int stereotype = TokenizeCommand.this.destTier.getLinguisticType().getConstraints().getStereoType();
            Iterator annIt = sourceAnnos.iterator();
            ArrayList<Annotation> newAnnos = new ArrayList<Annotation>();
            while (annIt.hasNext()) {
                block15: {
                    AbstractAnnotation srcAnn;
                    block17: {
                        StringTokenizer tokenizer;
                        block16: {
                            Annotation ann;
                            srcAnn = (AbstractAnnotation)annIt.next();
                            Vector childrenOnDest = srcAnn.getChildrenOnTier(TokenizeCommand.this.destTier);
                            if (childrenOnDest.size() > 0 && !TokenizeCommand.this.preserve) {
                                for (AbstractAnnotation destAnn : childrenOnDest) {
                                    TokenizeCommand.this.existAnnotations.add(AnnotationRecreator.createTreeForAnnotation(destAnn));
                                }
                                Iterator childIt = childrenOnDest.iterator();
                                while (childIt.hasNext()) {
                                    TokenizeCommand.this.destTier.removeAnnotation((AbstractAnnotation)childIt.next());
                                }
                            }
                            if (childrenOnDest.size() != 0 && TokenizeCommand.this.preserve) break block15;
                            String srcValue = srcAnn.getValue();
                            tokenizer = TokenizeCommand.this.delimiter != null ? new StringTokenizer(srcValue, TokenizeCommand.this.delimiter) : new StringTokenizer(srcValue);
                            newAnnos.clear();
                            if (tokenizer.countTokens() != 0) break block16;
                            if (!TokenizeCommand.this.createEmpty) break block17;
                            if (stereotype == 3) {
                                long time = (srcAnn.getBeginTimeBoundary() + srcAnn.getEndTimeBoundary()) / 2L;
                                ann = TokenizeCommand.this.destTier.createAnnotation(time, time);
                            } else {
                                ann = TokenizeCommand.this.destTier.createAnnotation(srcAnn.getBeginTimeBoundary(), srcAnn.getEndTimeBoundary());
                            }
                            if (ann == null) break block17;
                            newAnnos.add(ann);
                            break block17;
                        }
                        Annotation prevAnn = null;
                        while (tokenizer.hasMoreTokens()) {
                            String nextToken = tokenizer.nextToken();
                            if (prevAnn == null) {
                                if (stereotype == 3) {
                                    long time = (srcAnn.getBeginTimeBoundary() + srcAnn.getEndTimeBoundary()) / 2L;
                                    prevAnn = TokenizeCommand.this.destTier.createAnnotation(time, time);
                                } else {
                                    prevAnn = TokenizeCommand.this.destTier.createAnnotation(srcAnn.getBeginTimeBoundary(), srcAnn.getEndTimeBoundary());
                                }
                            } else {
                                prevAnn = TokenizeCommand.this.destTier.createAnnotationAfter(prevAnn);
                            }
                            prevAnn.setValue(nextToken);
                            newAnnos.add(prevAnn);
                        }
                    }
                    if (newAnnos.size() > 0) {
                        ArrayList<AnnotationDataRecord> siblings = new ArrayList<AnnotationDataRecord>(newAnnos.size());
                        for (int i = 0; i < newAnnos.size(); ++i) {
                            siblings.add(new AnnotationDataRecord((Annotation)newAnnos.get(i)));
                        }
                        TokenizeCommand.this.newAnnotationsNodes.add(siblings);
                    }
                    TokenizeCommand.this.completedTokenizations.add(new AnnotationDataRecord(srcAnn));
                }
                if (!monitor.isCancelled()) continue;
            }
            TokenizeCommand.this.transcription.setNotifying(true);
            TokenizeCommand.this.transcription.setTimeChangePropagationMode(curPropMode);
            monitor.close();
        }
    }
}

