/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.ImportFLExDialog;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.flex.FlexDecoderInfo;

public class ImportFlexMA
extends FrameMenuAction {
    public ImportFlexMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    public void actionPerformed(ActionEvent ae) {
        ImportFLExDialog dialog = new ImportFLExDialog(this.frame);
        FlexDecoderInfo value = dialog.getDecoderInfo();
        dialog.dispose();
        if (value == null) {
            return;
        }
        DecoderInfo decInfo = value;
        if (decInfo.getSourceFilePath() == null) {
            return;
        }
        try {
            int answer;
            String path = decInfo.getSourceFilePath();
            this.checkTimeInfoEAF((FlexDecoderInfo)decInfo);
            TranscriptionImpl transcription = new TranscriptionImpl(path, decInfo);
            transcription.setChanged();
            int lastSlash = path.lastIndexOf(47);
            String flexPath = path.substring(0, lastSlash);
            boolean validMedia = true;
            if (this.frame != null) {
                validMedia = this.frame.checkMedia(transcription, flexPath);
            }
            if (!validMedia && (answer = JOptionPane.showConfirmDialog(this.frame, ElanLocale.getString("Frame.ElanFrame.IncompleteMediaQuestion"), ElanLocale.getString("Frame.ElanFrame.IncompleteMediaAvailable"), 0)) != 0) {
                return;
            }
            FrameManager.getInstance().createFrame(transcription);
        }
        catch (Exception e) {
            ClientLogger.LOG.warning("Could not convert the FLEx file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void checkTimeInfoEAF(FlexDecoderInfo decInfo) {
        File eafFile = new File(decInfo.getSourceFilePath().substring(0, decInfo.getSourceFilePath().lastIndexOf(46)) + ".eaf");
        if (!eafFile.exists()) {
            eafFile = new File(decInfo.getSourceFilePath().substring(0, decInfo.getSourceFilePath().lastIndexOf(46)) + ".EAF");
        }
        if (!eafFile.exists()) {
            return;
        }
        try {
            AlignableAnnotation aa;
            Vector anns;
            TierImpl tier;
            int i;
            TranscriptionImpl trans = new TranscriptionImpl(eafFile.getAbsolutePath());
            HashMap<String, long[]> alignment = new HashMap<String, long[]>();
            int numToplevel = 0;
            ArrayList tiers = new ArrayList(trans.getTiers());
            for (i = 0; i < tiers.size(); ++i) {
                tier = (TierImpl)tiers.get(i);
                if (tier.getParentTier() != null) continue;
                ++numToplevel;
            }
            if (numToplevel == 1) {
                for (i = 0; i < tiers.size(); ++i) {
                    tier = (TierImpl)tiers.get(i);
                    if (tier.getParentTier() != null) continue;
                    anns = tier.getAnnotations();
                    if (anns.size() != 1) break;
                    aa = (AlignableAnnotation)anns.get(0);
                    if (aa.getId() != null && aa.getId().startsWith("a_")) {
                        alignment.put(aa.getId().substring("a_".length()), new long[]{aa.getBeginTimeBoundary(), aa.getEndTimeBoundary()});
                        break;
                    }
                    alignment.put("1", new long[]{aa.getBeginTimeBoundary(), aa.getEndTimeBoundary()});
                    break;
                }
            }
            for (i = 0; i < tiers.size(); ++i) {
                tier = (TierImpl)tiers.get(i);
                if (!tier.isTimeAlignable()) continue;
                anns = tier.getAnnotations();
                for (int j = 0; j < anns.size(); ++j) {
                    aa = (AlignableAnnotation)anns.get(j);
                    if (aa.getId() == null || !aa.getId().startsWith("a_")) continue;
                    alignment.put(aa.getId().substring("a_".length()), new long[]{aa.getBeginTimeBoundary(), aa.getEndTimeBoundary()});
                }
            }
            decInfo.setStoredAlignment(alignment);
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not load the existing eaf file: " + ex.getMessage());
        }
    }
}

