/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.commands.global.MenuAction;
import mpi.eudico.client.annotator.export.ShortCutPrinter;
import mpi.eudico.client.annotator.gui.ClosableFrame;
import mpi.eudico.client.util.SubHeaderTableCellRenderer;
import mpi.eudico.client.util.TableSubHeaderObject;

public class ShortcutsMA
extends MenuAction {
    private JFrame shortcutsFrame;
    private JTable tableShortcuts;
    private JButton printButton;
    private DefaultTableModel model;

    public ShortcutsMA(String name) {
        super(name);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.printButton) {
            new ShortCutPrinter(this.tableShortcuts).startPrint();
            return;
        }
        if (this.shortcutsFrame == null) {
            this.shortcutsFrame = new ClosableFrame("Shortcuts");
            this.shortcutsFrame.setDefaultCloseOperation(2);
            this.model = new DefaultTableModel(0, 2);
            this.tableShortcuts = new JTable(this.model);
            this.tableShortcuts.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.tableShortcuts.setPreferredScrollableViewportSize(new Dimension(500, 600));
            this.tableShortcuts.setShowVerticalLines(false);
            this.tableShortcuts.getTableHeader().setReorderingAllowed(false);
            this.tableShortcuts.setEnabled(false);
            this.tableShortcuts.getColumnModel().getColumn(0).setPreferredWidth(200);
            this.tableShortcuts.getColumnModel().getColumn(1).setPreferredWidth(300);
            this.tableShortcuts.setDefaultRenderer(Object.class, new SubHeaderTableCellRenderer());
            for (int i = 0; i < this.tableShortcuts.getRowCount(); ++i) {
                if (!(this.tableShortcuts.getValueAt(i, 0) instanceof TableSubHeaderObject)) continue;
                this.tableShortcuts.setRowHeight(i, this.tableShortcuts.getRowHeight() + 6);
            }
            JScrollPane listScrollPane = new JScrollPane(this.tableShortcuts);
            this.shortcutsFrame.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 4, 2);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.shortcutsFrame.getContentPane().add((Component)listScrollPane, gbc);
            this.printButton = new JButton();
            this.printButton.addActionListener(this);
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.anchor = 10;
            this.shortcutsFrame.getContentPane().add((Component)this.printButton, gbc);
            this.updateLocale();
            this.shortcutsFrame.pack();
            this.shortcutsFrame.setVisible(true);
            this.shortcutsFrame.addWindowListener(new CloseListener());
        } else {
            this.shortcutsFrame.setVisible(true);
            this.shortcutsFrame.setState(0);
            this.shortcutsFrame.toFront();
        }
    }

    public void updateLocale() {
        super.updateLocale();
        if (this.tableShortcuts != null) {
            this.tableShortcuts.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("Frame.ShortcutFrame.ColumnShortcut"));
            this.tableShortcuts.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("Frame.ShortcutFrame.ColumnDescription"));
            this.printButton.setText(ElanLocale.getString("Menu.File.Print"));
            this.model.setRowCount(0);
            Map<String, List<String>> curShorts = ShortcutsUtil.getInstance().getShortcuttableActions();
            Iterator<Map.Entry<String, List<String>>> csIt = curShorts.entrySet().iterator();
            while (csIt.hasNext()) {
                String key = csIt.next().getKey();
                this.model.addRow(new Object[]{new TableSubHeaderObject(ElanLocale.getString(key)), new TableSubHeaderObject(null)});
                List<String> ids = curShorts.get(key);
                for (int i = 0; i < ids.size(); ++i) {
                    String shortcutId = ids.get(i);
                    KeyStroke stroke = ShortcutsUtil.getInstance().getKeyStrokeForAction(shortcutId);
                    if (stroke == null) continue;
                    this.model.addRow(new Object[]{ShortcutsUtil.getInstance().getDescriptionForKeyStroke(stroke), ShortcutsUtil.getInstance().getDescriptionForAction(shortcutId)});
                }
            }
            if (this.shortcutsFrame != null) {
                this.shortcutsFrame.setTitle(ElanLocale.getString("Menu.View.ShortcutsDialog"));
                this.shortcutsFrame.repaint();
            }
        }
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        public void windowClosed(WindowEvent e) {
            ShortcutsMA.this.shortcutsFrame.removeWindowListener(this);
            ShortcutsMA.this.shortcutsFrame = null;
        }
    }
}

