/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.dcr;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.dcr.AnnotationDCPanel;
import mpi.eudico.client.annotator.dcr.ELANLocalDCRConnector;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;

public class AnnotationDCRDialog
extends ClosableDialog
implements ActionListener {
    private Transcription transcription;
    private AbstractAnnotation annotation;
    protected ResourceBundle bundle = null;
    protected String dcrName;
    protected String dcrLocation;
    protected JPanel titlePanel;
    protected JLabel titleLabel;
    protected JLabel subtitleLabel;
    protected JLabel subtitleLabel2;
    protected AnnotationDCPanel dcPanel;
    protected JPanel buttonPanel;
    protected JButton applyButton;
    protected JButton cancelButton;

    public AnnotationDCRDialog(Transcription transcription, AbstractAnnotation annotation) throws HeadlessException {
        super((Frame)null, true);
        this.transcription = transcription;
        this.annotation = annotation;
        this.initComponents();
    }

    public AnnotationDCRDialog(Frame owner, boolean modal, Transcription transcription, AbstractAnnotation annotation) throws HeadlessException {
        super(owner, modal);
        this.transcription = transcription;
        this.annotation = annotation;
        this.initComponents();
    }

    protected void initComponents() {
        this.bundle = ElanLocale.getResourceBundle();
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titlePanel = new JPanel(new GridBagLayout());
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        this.subtitleLabel = new JLabel();
        this.subtitleLabel.setFont(Constants.SMALLFONT);
        this.subtitleLabel.setHorizontalAlignment(0);
        this.subtitleLabel2 = new JLabel();
        this.subtitleLabel2.setFont(Constants.SMALLFONT);
        this.subtitleLabel2.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.titlePanel.add((Component)this.titleLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = insets;
        this.titlePanel.add((Component)this.subtitleLabel, gbc);
        gbc.gridy = 2;
        this.titlePanel.add((Component)this.subtitleLabel2, gbc);
        gbc.gridy = 0;
        this.getContentPane().add((Component)this.titlePanel, gbc);
        String annLabel = null;
        if (this.annotation != null) {
            annLabel = ElanLocale.getString("Menu.Tier") + ": " + this.annotation.getTier().getName() + " - " + ElanLocale.getString("Menu.Annotation") + ": " + this.annotation.getValue();
        }
        this.dcPanel = new AnnotationDCPanel(ELANLocalDCRConnector.getInstance(), this.bundle, annLabel);
        String dcId = null;
        if (this.annotation != null && this.annotation.getExtRef() != null) {
            dcId = this.annotation.getExtRefValue(2);
        }
        this.dcPanel.setAnnotationDCId(dcId);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 1;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.dcPanel, gbc);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.applyButton = new JButton();
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.applyButton);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.updateLocale();
    }

    protected void updateLocale() {
        this.titleLabel.setText(ElanLocale.getString("DCR.Label.LocalDCS"));
        this.subtitleLabel2.setText(ElanLocale.getString("DCR.Label.LocalDCSHelp"));
        this.applyButton.setText(ElanLocale.getString("Button.Apply"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton && this.annotation != null) {
            Command com = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.ModifyAnnotationDatCat");
            com.execute(this.annotation, new Object[]{this.dcPanel.getAnnotationDCId()});
        }
        this.setVisible(false);
        this.dispose();
    }
}

