/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.dcr;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import mpi.dcr.DCSmall;
import mpi.dcr.LocalDCRConnector;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.dcr.DCRCacheReaderWriter;
import mpi.eudico.client.annotator.util.ClientLogger;

public class ELANLocalDCRConnector
extends LocalDCRConnector {
    private static ELANLocalDCRConnector connector;
    String cacheName = Constants.ELAN_DATA_DIR + File.separator + "DCSelection.xml";
    private DCRCacheReaderWriter cacheRW;

    private ELANLocalDCRConnector() {
        this.name = "ELAN Local DCR Connector";
        try {
            this.cacheRW = new DCRCacheReaderWriter();
            this.cacheRW.setFilePath(this.cacheName);
            this.readDCS();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public static ELANLocalDCRConnector getInstance() {
        if (connector == null) {
            connector = new ELANLocalDCRConnector();
        }
        return connector;
    }

    protected void readDCS() {
        try {
            List storedDCS = this.cacheRW.read();
            if (storedDCS != null && storedDCS.size() != 0) {
                DCSmall small1 = null;
                for (int i = 0; i < storedDCS.size(); ++i) {
                    small1 = (DCSmall)storedDCS.get(i);
                    this.catList.add(small1);
                }
            }
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("No data categories found in the cache...: " + ex.getMessage());
        }
    }

    protected void saveDCS() {
        if (this.catList == null) {
            return;
        }
        if (this.cacheRW != null) {
            try {
                this.cacheRW.save(this.catList);
            }
            catch (ParserConfigurationException pce) {
                ClientLogger.LOG.warning("Could not save the DCR cache: " + pce.getMessage());
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Could not save the DCR cache: " + ioe.getMessage());
            }
        }
    }
}

