/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractTierExportDialog;
import mpi.eudico.server.corpora.clom.Transcription;

public abstract class AbstractExtTierExportDialog
extends AbstractTierExportDialog {
    protected JPanel tierButtonPanel;
    protected JButton downButton;
    protected JButton upButton;
    protected JButton allButton;
    protected JButton noneButton;

    public AbstractExtTierExportDialog(Frame parent, boolean modal, Transcription transcription, Selection selection) {
        super(parent, modal, transcription, selection);
    }

    protected void makeLayout() {
        super.makeLayout();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.allButton = new JButton();
        this.noneButton = new JButton();
        this.tierButtonPanel = new JPanel(new GridBagLayout());
        try {
            ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
            ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
            this.upButton.setIcon(upIcon);
            this.downButton.setIcon(downIcon);
        }
        catch (Exception ex) {
            this.upButton.setText("Up");
            this.downButton.setText("Down");
        }
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.allButton.addActionListener(this);
        this.noneButton.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.tierButtonPanel.add((Component)this.upButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.tierButtonPanel.add((Component)this.downButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.tierButtonPanel.add((Component)this.allButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = this.insets;
        this.tierButtonPanel.add((Component)this.noneButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.tierSelectionPanel.add((Component)this.tierButtonPanel, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.upButton) {
            this.moveUp();
        } else if (source == this.downButton) {
            this.moveDown();
        } else if (source == this.allButton) {
            this.selectAll();
        } else if (source == this.noneButton) {
            this.selectNone();
        } else {
            super.actionPerformed(ae);
        }
    }

    protected void updateLocale() {
        super.updateLocale();
        this.allButton.setText(ElanLocale.getString("Button.SelectAll"));
        this.noneButton.setText(ElanLocale.getString("Button.SelectNone"));
    }

    protected void moveDown() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierTable.getSelectedRows();
        for (int i = selected.length - 1; i >= 0; --i) {
            int row = selected[i];
            if (row >= this.model.getRowCount() - 1 || this.tierTable.isRowSelected(row + 1)) continue;
            this.model.moveRow(row, row, row + 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row + 1, 0, true, false);
        }
    }

    protected void moveUp() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierTable.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            int row = selected[i];
            if (row <= 0 || this.tierTable.isRowSelected(row - 1)) continue;
            this.model.moveRow(row, row, row - 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row - 1, 0, true, false);
        }
    }

    protected void selectAll() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 1) {
            return;
        }
        int includeCol = this.model.findColumn("export");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.model.setValueAt(Boolean.TRUE, i, includeCol);
        }
    }

    protected void selectNone() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 1) {
            return;
        }
        int includeCol = this.model.findColumn("export");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.model.setValueAt(Boolean.FALSE, i, includeCol);
        }
        this.tierTable.revalidate();
    }
}

