/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractBasicExportDialog;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.server.corpora.clom.Transcription;

public abstract class AbstractTierExportDialog
extends AbstractBasicExportDialog
implements ActionListener {
    protected final DefaultTableModel model = new TierExportTableModel();
    protected final JCheckBox restrictCheckBox = new JCheckBox();
    protected final JPanel tierSelectionPanel = new JPanel();
    protected final JTable tierTable = new JTable(this.model);
    protected final Selection selection;
    protected final String EXPORT_COLUMN = "export";
    protected final String TIER_NAME_COLUMN = "tier";

    public AbstractTierExportDialog(Frame parent, boolean modal, Transcription transcription, Selection selection) {
        super(parent, modal, transcription);
        this.selection = selection;
    }

    protected List getSelectedTiers() {
        int includeCol = this.model.findColumn("export");
        int nameCol = this.model.findColumn("tier");
        ArrayList<Object> selectedTiers = new ArrayList<Object>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Boolean include = (Boolean)this.model.getValueAt(i, includeCol);
            if (!include.booleanValue()) continue;
            selectedTiers.add(this.model.getValueAt(i, nameCol));
        }
        return selectedTiers;
    }

    protected void makeLayout() {
        super.makeLayout();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.getContentPane().add((Component)this.titleLabel, gridBagConstraints);
        this.tierSelectionPanel.setLayout(new GridBagLayout());
        Dimension tableDim = new Dimension(50, 100);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        tierScrollPane.setPreferredSize(tableDim);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tierSelectionPanel.add((Component)tierScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = this.insets;
        this.getContentPane().add((Component)this.tierSelectionPanel, gridBagConstraints);
        this.optionsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.getContentPane().add((Component)this.optionsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = this.insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
    }

    protected void updateLocale() {
        super.updateLocale();
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportDialog.Label.SelectTiers")));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportDialog.Label.Options")));
        this.restrictCheckBox.setText(ElanLocale.getString("ExportDialog.Restrict"));
    }

    protected void loadTierPreferences(ArrayList tierList) {
        if (tierList.size() > 0) {
            int includeCol = this.model.findColumn("export");
            int nameCol = this.model.findColumn("tier");
            block0: for (int i = 0; i < this.model.getRowCount(); ++i) {
                for (int x = 0; x < tierList.size(); ++x) {
                    if (((String)this.model.getValueAt(i, nameCol)).compareTo((String)tierList.get(x)) == 0) {
                        this.model.setValueAt(true, i, includeCol);
                        continue block0;
                    }
                    this.model.setValueAt(false, i, includeCol);
                }
            }
        }
    }
}

