/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.chat.CHATEncoderInfo;

public class CHATExportDlg
extends ClosableDialog
implements ActionListener {
    private final int NUM_OF_COLUMNS = 7;
    private final int NUM_OF_DEP_COLUMNS = 3;
    private final String MAIN_TIER = "Main Tier";
    private final String DEPENDENT_TIER = "Dependent Tier";
    private final String LABEL = "Label";
    private final String FULL_NAME = "Full Name";
    private final String ROLE = "Role";
    private final String ID = "ID";
    private final String LANGUAGE = "Language";
    private TranscriptionImpl transcription;
    private TranscriptionStore acmTranscriptionStore;
    private Vector visibleTiers;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JComponent[][] mainTierTable;
    private JComponent[][] dependentTierTable;
    private JPanel mainTiersPanel;
    private JPanel dependentTiersPanel;
    private JPanel optionsPanel;
    private JPanel buttonPanel;
    private JButton exportButton;
    private TitledBorder mainTiersBorder;
    private TitledBorder dependentTiersBorder;
    private TitledBorder optionsBorder;
    private JCheckBox correctTimesCB;
    private JCheckBox timesOnSeparateLineCB;
    private JCheckBox includeLanguageLineCB;

    public CHATExportDlg(JFrame frame, boolean modal, Transcription tr, TranscriptionStore acmTranscriptionStore, Vector visibleTiers) {
        super((Frame)frame, modal);
        this.transcription = (TranscriptionImpl)tr;
        this.acmTranscriptionStore = acmTranscriptionStore;
        this.visibleTiers = visibleTiers;
        Vector topTiers = this.transcription.getTopTiers();
        if (topTiers != null) {
            int numOfTiers = this.transcription.getTiers().size();
            this.mainTierTable = new JComponent[7][topTiers.size() + 1];
            this.dependentTierTable = new JComponent[3][numOfTiers - topTiers.size() + 1];
        }
        this.mainTiersPanel = new JPanel();
        this.dependentTiersPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.exportButton = new JButton();
        this.mainTiersBorder = new TitledBorder("Main tiers");
        this.dependentTiersBorder = new TitledBorder("Dependent tiers");
        this.createDialog();
        this.updateForLocale();
        this.setDefaultValues();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void createDialog() {
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(4, 6, 4, 6);
        this.titleLabel = new JLabel();
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new BorderLayout(0, 4));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        JPanel titleLabelPanel = new JPanel();
        titleLabelPanel.add(this.titleLabel);
        this.titlePanel.add((Component)titleLabelPanel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        this.mainTiersPanel.setLayout(new GridBagLayout());
        this.dependentTiersPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JComponent tableComponent = null;
        JPanel mtPanel = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(mtPanel);
        scrollPane.setBorder(null);
        this.mainTiersPanel.setBorder(this.mainTiersBorder);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = insets;
        mtPanel.add((Component)this.mainTiersPanel, c);
        c = new GridBagConstraints();
        tableComponent = new JLabel("Main Tier");
        this.mainTierTable[1][0] = tableComponent;
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.mainTiersPanel.add((Component)tableComponent, c);
        tableComponent = new JLabel("Label");
        this.mainTierTable[2][0] = tableComponent;
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.mainTiersPanel.add((Component)tableComponent, c);
        tableComponent = new JLabel("Full Name");
        this.mainTierTable[3][0] = tableComponent;
        c.gridx = 3;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.mainTiersPanel.add((Component)tableComponent, c);
        tableComponent = new JLabel("Role");
        this.mainTierTable[4][0] = tableComponent;
        c.gridx = 4;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.mainTiersPanel.add((Component)tableComponent, c);
        tableComponent = new JLabel("ID");
        this.mainTierTable[5][0] = tableComponent;
        c.gridx = 5;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.mainTiersPanel.add((Component)tableComponent, c);
        tableComponent = new JLabel("Language");
        this.mainTierTable[5][0] = tableComponent;
        c.gridx = 6;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.mainTiersPanel.add((Component)tableComponent, c);
        Vector topTiers = this.transcription.getTopTiers();
        if (topTiers != null) {
            for (int i = 0; i < topTiers.size(); ++i) {
                String tName = ((Tier)topTiers.elementAt(i)).getName();
                tableComponent = new JCheckBox();
                ((JCheckBox)tableComponent).setSelected(true);
                this.mainTierTable[0][i + 1] = tableComponent;
                c.gridx = 0;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JLabel(tName);
                this.mainTierTable[1][i + 1] = tableComponent;
                c.gridx = 1;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JTextField(3);
                String defaultName = "*";
                if (tName.startsWith("*") && tName.length() == 4) {
                    defaultName = tName;
                }
                ((JTextField)tableComponent).setText(defaultName);
                this.mainTierTable[2][i + 1] = tableComponent;
                c.gridx = 2;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JTextField(12);
                this.mainTierTable[3][i + 1] = tableComponent;
                c.gridx = 3;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JTextField(8);
                this.mainTierTable[4][i + 1] = tableComponent;
                c.gridx = 4;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JTextField(18);
                this.mainTierTable[5][i + 1] = tableComponent;
                c.gridx = 5;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JTextField(8);
                Locale defLoc = ((TierImpl)topTiers.elementAt(i)).getDefaultLocale();
                String language = null;
                if (defLoc != null) {
                    language = defLoc.getLanguage();
                }
                if (language != null && !language.equals("")) {
                    ((JTextField)tableComponent).setText(language);
                }
                this.mainTierTable[6][i + 1] = tableComponent;
                c.gridx = 6;
                c.gridy = i + 1;
                c.anchor = 17;
                c.insets = insets;
                this.mainTiersPanel.add((Component)tableComponent, c);
            }
        }
        c.gridx = 7;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.mainTiersPanel.add((Component)new JPanel(), c);
        this.dependentTiersPanel.setBorder(this.dependentTiersBorder);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = insets;
        c.weightx = 1.0;
        mtPanel.add((Component)this.dependentTiersPanel, c);
        tableComponent = new JLabel("Dependent Tier");
        this.dependentTierTable[1][0] = tableComponent;
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        c.insets = insets;
        this.dependentTiersPanel.add((Component)tableComponent, c);
        tableComponent = new JLabel("Label");
        this.dependentTierTable[1][0] = tableComponent;
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.dependentTiersPanel.add((Component)tableComponent, c);
        Vector tiers = null;
        int rowIndex = 1;
        tiers = this.transcription.getTiers();
        if (tiers != null) {
            for (int i = 0; i < tiers.size(); ++i) {
                int atInd;
                TierImpl t = (TierImpl)tiers.elementAt(i);
                if (!t.hasParentTier()) continue;
                tableComponent = new JCheckBox();
                ((JCheckBox)tableComponent).setSelected(true);
                this.dependentTierTable[0][rowIndex] = tableComponent;
                c.gridx = 0;
                c.gridy = rowIndex;
                c.anchor = 17;
                c.insets = insets;
                this.dependentTiersPanel.add((Component)tableComponent, c);
                tableComponent = new JLabel(t.getName());
                this.dependentTierTable[1][rowIndex] = tableComponent;
                c.gridx = 1;
                c.gridy = rowIndex;
                c.anchor = 17;
                c.insets = insets;
                this.dependentTiersPanel.add((Component)tableComponent, c);
                String defaultName = "%";
                if (t.getName().startsWith("%") && (atInd = t.getName().indexOf(64)) > 1 && atInd <= 8) {
                    defaultName = t.getName().substring(0, atInd);
                }
                tableComponent = new JTextField(7);
                ((JTextField)tableComponent).setText(defaultName);
                this.dependentTierTable[2][rowIndex] = tableComponent;
                c.gridx = 2;
                c.gridy = rowIndex++;
                c.anchor = 17;
                c.insets = insets;
                this.dependentTiersPanel.add((Component)tableComponent, c);
            }
        }
        c.gridx = 3;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.dependentTiersPanel.add((Component)new JPanel(), c);
        this.optionsPanel = new JPanel(new GridBagLayout());
        this.optionsBorder = new TitledBorder("");
        this.optionsPanel.setBorder(this.optionsBorder);
        this.correctTimesCB = new JCheckBox();
        this.correctTimesCB.setSelected(true);
        this.timesOnSeparateLineCB = new JCheckBox();
        this.includeLanguageLineCB = new JCheckBox();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insets;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.optionsPanel.add((Component)this.correctTimesCB, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = insets;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.optionsPanel.add((Component)this.timesOnSeparateLineCB, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.insets = insets;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.optionsPanel.add((Component)this.includeLanguageLineCB, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = insets;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 100.0;
        this.getContentPane().add((Component)scrollPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.anchor = 11;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 12, 2, 12);
        this.getContentPane().add((Component)this.optionsPanel, c);
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 0;
        c.anchor = 15;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, c);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 11;
        c.insets = insets;
        this.buttonPanel.add((Component)this.exportButton, c);
        this.setPreferredSetting();
    }

    private void setDefaultValues() {
    }

    private void updateForLocale() {
        this.setTitle(ElanLocale.getString("ExportCHATDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportCHATDialog.Title"));
        this.mainTiersBorder.setTitle(ElanLocale.getString("ExportCHATDialog.MainTiers"));
        this.dependentTiersBorder.setTitle(ElanLocale.getString("ExportCHATDialog.DependentTiers"));
        this.optionsBorder.setTitle(ElanLocale.getString("ExportDialog.Label.Options"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.timesOnSeparateLineCB.setText(ElanLocale.getString("ExportCHATDialog.SeparateLine"));
        this.includeLanguageLineCB.setText(ElanLocale.getString("ExportCHATDialog.LanguageLine"));
        this.exportButton.setText(ElanLocale.getString("ExportCHATDialog.Export"));
        this.exportButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.exportButton && this.fieldsOK()) {
            this.showDialogAndSave();
        }
    }

    private boolean fieldsOK() {
        String text;
        int i;
        boolean ok = true;
        this.savePreferences();
        for (i = 1; i < this.mainTierTable[2].length; ++i) {
            if (!((JCheckBox)this.mainTierTable[0][i]).isSelected() || (text = ((JTextField)this.mainTierTable[2][i]).getText()).length() == 4 && text.startsWith("*")) continue;
            ok = false;
            break;
        }
        for (i = 1; i < this.dependentTierTable[2].length; ++i) {
            if (!((JCheckBox)this.dependentTierTable[0][i]).isSelected() || (text = ((JTextField)this.dependentTierTable[2][i]).getText()).length() >= 2 && text.length() <= 8 && text.startsWith("%")) continue;
            ok = false;
            break;
        }
        if (!ok) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportCHATDlg.Message.WrongLabel"), ElanLocale.getString("Message.Error"), 0);
        }
        return ok;
    }

    private void showDialogAndSave() {
        String saveDir = (String)Preferences.get("LastUsedCHATDir", null);
        if (saveDir == null && (saveDir = new File(this.transcription.getName()).getParent()) == null) {
            saveDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser(saveDir);
        FileFilter filter = ElanFileFilter.createFileFilter(5);
        chooser.setFileFilter(filter);
        chooser.setDialogTitle(ElanLocale.getString("ExportCHATDialog.Title"));
        int option = chooser.showSaveDialog(this);
        if (option == 0) {
            File f;
            File curDir = chooser.getCurrentDirectory();
            if (curDir != null) {
                Preferences.set("LastUsedCHATDir", curDir.getAbsolutePath(), null);
            }
            if ((f = chooser.getSelectedFile()) != null) {
                Vector mediaDescriptors;
                int answer;
                String pathName = f.getAbsolutePath();
                String lowerPathName = pathName.toLowerCase();
                if (!lowerPathName.endsWith(".cha")) {
                    pathName = pathName + ".cha";
                }
                if (new File(pathName).exists() && (answer = JOptionPane.showConfirmDialog(null, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("ExportCHATDialog.Message.Title"), 0)) == 1) {
                    return;
                }
                String[][] mainTierInfo = new String[this.mainTierTable.length - 1][this.mainTierTable[0].length - 1];
                String[][] dependentTierInfo = new String[this.dependentTierTable.length - 1][this.dependentTierTable[0].length - 1];
                int index = 0;
                for (int i = 1; i < this.mainTierTable[1].length; ++i) {
                    if (!((JCheckBox)this.mainTierTable[0][i]).isSelected()) continue;
                    mainTierInfo[0][index] = ((JLabel)this.mainTierTable[1][i]).getText();
                    mainTierInfo[1][index] = ((JTextField)this.mainTierTable[2][i]).getText();
                    mainTierInfo[2][index] = ((JTextField)this.mainTierTable[3][i]).getText();
                    mainTierInfo[3][index] = ((JTextField)this.mainTierTable[4][i]).getText();
                    mainTierInfo[4][index] = ((JTextField)this.mainTierTable[5][i]).getText();
                    mainTierInfo[5][index] = ((JTextField)this.mainTierTable[6][i]).getText();
                    ++index;
                }
                index = 0;
                for (int j = 1; j < this.dependentTierTable[1].length; ++j) {
                    if (!((JCheckBox)this.dependentTierTable[0][j]).isSelected()) continue;
                    dependentTierInfo[0][index] = ((JLabel)this.dependentTierTable[1][j]).getText();
                    dependentTierInfo[1][index] = ((JTextField)this.dependentTierTable[2][j]).getText();
                    ++index;
                }
                CHATEncoderInfo encoderInfo = new CHATEncoderInfo(mainTierInfo, dependentTierInfo);
                encoderInfo.setCorrectAnnotationTimes(this.correctTimesCB.isSelected());
                encoderInfo.setTimesOnSeparateLine(this.timesOnSeparateLineCB.isSelected());
                encoderInfo.setIncludeLangLine(this.includeLanguageLineCB.isSelected());
                if (this.correctTimesCB.isSelected() && (mediaDescriptors = this.transcription.getMediaDescriptors()).size() > 0) {
                    encoderInfo.setMediaOffset(((MediaDescriptor)mediaDescriptors.get((int)0)).timeOrigin);
                }
                try {
                    this.acmTranscriptionStore.storeTranscriptionIn(this.transcription, encoderInfo, this.visibleTiers, pathName, 1);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error") + "\n" + "(" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
                }
            }
        }
    }

    private void setPreferredSetting() {
        Object useTyp = Preferences.get("ExportCHATDialog.correctTimesCB", null);
        if (useTyp != null) {
            this.correctTimesCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportCHATDialog.timesOnSeparateLineCB", null)) != null) {
            this.timesOnSeparateLineCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportCHATDialog.includeLanguageLineCB", null)) != null) {
            this.includeLanguageLineCB.setSelected((Boolean)useTyp);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportCHATDialog.correctTimesCB", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportCHATDialog.timesOnSeparateLineCB", this.timesOnSeparateLineCB.isSelected(), null);
        Preferences.set("ExportCHATDialog.includeLanguageLineCB", this.includeLanguageLineCB.isSelected(), null);
    }
}

