/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.praat.PraatTGEncoderInfo;
import mpi.eudico.server.corpora.clomimpl.praat.PraatTextGridEncoder;

public class ExportPraatDialog
extends AbstractExtTierExportDialog
implements ActionListener,
ItemListener,
ListSelectionListener {
    private JCheckBox rootTiersCB;
    private JCheckBox selectionCB;

    public ExportPraatDialog(Frame parent, boolean modal, Transcription transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        if (selection != null) {
            System.out.println("sb: " + selection.getBeginTime() + " se: " + selection.getEndTime());
        }
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
    }

    public void itemStateChanged(ItemEvent ie) {
        this.extractTiers();
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("export");
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    protected void extractTiers() {
        if (this.model != null) {
            Object useTyp;
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                Vector v = this.transcription.getTiers();
                boolean rootsOnly = this.rootTiersCB.isSelected();
                for (int i = 0; i < v.size(); ++i) {
                    TierImpl t = (TierImpl)v.get(i);
                    if (rootsOnly) {
                        if (t.getParentTier() != null) continue;
                        this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                        continue;
                    }
                    if (t.getParentTier() == null) {
                        this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                        continue;
                    }
                    this.model.addRow(new Object[]{Boolean.FALSE, t.getName()});
                }
            }
            if ((useTyp = Preferences.get("ExportPraatDialog.selectedTiers", this.transcription)) instanceof ArrayList) {
                this.loadTierPreferences((ArrayList)useTyp);
            }
            if (this.model.getRowCount() > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    protected void makeLayout() {
        super.makeLayout();
        this.rootTiersCB = new JCheckBox();
        this.selectionCB = new JCheckBox();
        this.rootTiersCB.setSelected(true);
        this.rootTiersCB.addItemListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.tierSelectionPanel.add((Component)this.rootTiersCB, gridBagConstraints);
        this.model.setColumnIdentifiers(new String[]{"export", "tier"});
        this.tierTable.getColumn("export").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("export").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("export").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.selectionCB, gridBagConstraints);
        this.setPreferredSetting();
        this.updateLocale();
    }

    protected boolean startExport() throws IOException {
        List selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        String[] encodings = new String[]{ElanLocale.getString("Button.Default"), "UTF-8", "UTF-16"};
        File exportFile = this.promptForFile(ElanLocale.getString("ExportPraatDialog.Title"), FileExtension.PRAAT_TEXTGRID_EXT, ElanFileFilter.createFileFilter(18), true, encodings);
        if (exportFile == null) {
            return false;
        }
        long begin = 0L;
        long end = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer().getMediaDuration();
        if (this.selectionCB.isSelected() && this.selection != null && this.selection.getBeginTime() < this.selection.getEndTime()) {
            begin = this.selection.getBeginTime();
            end = this.selection.getEndTime();
        }
        PraatTGEncoderInfo encInfo = new PraatTGEncoderInfo(begin, end);
        encInfo.setEncoding(this.encoding);
        PraatTextGridEncoder encoder = new PraatTextGridEncoder();
        encoder.encodeAndSave(this.transcription, encInfo, selectedTiers, exportFile.getAbsolutePath());
        return true;
    }

    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportPraatDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportPraatDialog.Title"));
        this.rootTiersCB.setText(ElanLocale.getString("ExportTradTranscript.Label.RootTiers"));
        this.selectionCB.setText(ElanLocale.getString("ExportDialog.Restrict"));
    }

    private void setPreferredSetting() {
        Object useTyp = Preferences.get("ExportPraatDialog.rootTiersCB", null);
        if (useTyp != null) {
            this.rootTiersCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportPraatDialog.selectionCB", null)) != null) {
            this.selectionCB.setSelected((Boolean)useTyp);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportPraatDialog.rootTiersCB", this.rootTiersCB.isSelected(), null);
        Preferences.set("ExportPraatDialog.selectionCB", this.selectionCB.isSelected(), null);
        Preferences.set("ExportPraatDialog.selectedTiers", this.getSelectedTiers(), this.transcription);
    }
}

